<?php

	# 		Astronomy events block
	# 		Namespace:		astroEvent
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	#		v2.0 - Nov 9, 2016
	#			- added support for German - thanks to Stefan
	#		v3.0 - Mar 30, 2017
	#			- added possibility to add block heading
	#		v3.1 - Apr 5, 2017
	#			- minor bug fixes
	#		v4.0 - Dec 30, 2019
	#			- added new events
	#			- design tweaks
	
	
	include("settings.php");
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$astroEvents = array();
	if($lang=="de"){
		$astroEventsFile = fopen("files/astroEventsDE.txt", "r");
	}
	else{
		$astroEventsFile = fopen("files/astroEvents.txt", "r");
	}
	while(!feof($astroEventsFile)) {
		$row = fgets($astroEventsFile);
		$rowData = explode(";",$row);
		if(time()<strtotime($rowData[0])){
			$event['date'] = strtotime($rowData[0]);
			$event['type'] = $rowData[1];
			$event['title'] = $rowData[2];
			$event['text'] = $rowData[3];
			$astroEvents[] = $event;
		}	
	}
	$output['astroEvents'] = $astroEvents;
	
	?>
	<?php
		if($astroEventsHeading){
	?>
			<h2><?php echo lang('astroEvents','c')?></h2>
	<?php
		}
	?>
	<table style="width:98%;margin:0 auto" cellpadding="4">
		<tr>
			<td style="text-align:left;width:150px">
				<?php echo date($dateFormat,$output['astroEvents'][0]['date'])?>
			</td>
			<td style="text-align:left">
				<span style="font-size:80%;font-weight:bold"><?php echo $output['astroEvents'][0]['title']?></span>
			</td>
		</tr>
	</table>
	<div id="astroEventsDetails" class="details">
	<table style="width:98%;margin:0 auto" cellpadding="4">
		<tr>
			<td style="text-align:justify;font-size:80%" colspan="2">
				<?php echo $output['astroEvents'][0]['text']?>
			</td>
		</tr>
		<?php
			for($i=1;$i<=$upcomingAstroEvents;$i++){
		?>
				<tr>
					<td style="text-align:left;width:150px">
						<?php echo date($dateFormat,$output['astroEvents'][$i]['date'])?>
					</td>
					<td style="text-align:left">
						<span style="font-size:80%;font-weight:bold"><?php echo $output['astroEvents'][$i]['title']?></span>
					</td>
				</tr>
		<?php
			}
		?>
	</table>
	</div>
	<span class="more" onclick="txt = $('#astroEventsDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#astroEventsDetails').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>
	<div style='width:98%;margin:0 auto;text-align:center;font-size:0.7em;font-variant:small-caps;padding-top:10px'>
		Adapted from: seasky.org
	</div>