<?php

	# 		Calculator
	# 		Namespace:		calculator
	#		Meteotemplate Block
	
	#		v2.0 - Nov 29, 2016
	#			- added some conversions
	#			- design clean up
	#			- block optimization
	# 		v3.0 - May 13, 2017
	# 			- added Kelvin conversions
	# 			- added Beaufort conversions
	# 			- conversion to SVG
	# 			- optimization
	
	$thisBlockVersion = "3.0";
	
	$time = microtime();
	$time = explode(' ', $time);
	$time = $time[1] + $time[0];
	$blockStartTime = $time;

	$errorLog[] = array("","%c Loading Block Calculator ".$thisBlockVersion."','font-weight:bold;color:green");
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	if($theme=="dark"){
		$color1Button = $color_schemes[$design2]['700'];
		$color2Button = $color_schemes[$design2]['900'];
	}
	else{
		$color1Button = $color_schemes[$design2]['100'];
		$color2Button = $color_schemes[$design2]['300'];
	}
?>
	<style>
		.keyCalculator{
			margin: 0 auto;
		}
		.keyCalculatorF, #keyCalculatorSQRT{
			background: #<?php echo $color1Button?>;
		}
		
		.keyCalculatorR{
			background: #<?php echo $color2Button?>;
		}
		.convertCalculator{
			font-size: 0.8em;
		}
		.calculatorIcon{
			font-size: 1.7em;
		}
	</style>
	<div id="calculator" style="position:relative">
	<table style="width:98%;margin: 0 auto">
		<tr>
			<td colspan="5" class="button" style="margin-bottom:10px;width:100%;padding:0px;height:60px">
				<div id="calculatorInput" style="width:98%;margin:0 auto;background:none;border:0px;height:30px;padding-top:1%;text-align:right;padding-right:5px"></div>
				<div id="calculatorResultDiv" style="width:98%;margin:0 auto;background:none;border:0px;height:30px;text-align:right;padding-right:5px"></div>
			</td>
		</tr>
		<tr>
			<td class="button keyCalculator" style="width:20%">7</td>
			<td class="button keyCalculator" style="width:20%">8</td>
			<td class="button keyCalculator" style="width:20%">9</td>
			<td class="button keyCalculatorF" style="width:20%">+</td>
			<td class="button" id="keyCalculatorSQRT" style="width:20%">&radic;</td>
		</tr>
		<tr>
			<td class="button keyCalculator">4</td>
			<td class="button keyCalculator">5</td>
			<td class="button keyCalculator">6</td>
			<td class="button keyCalculatorF">-</td>
			<td class="button keyCalculatorF" id="keyCalculatorXY">x<sup>y</sup></td>
		</tr>
		<tr>
			<td class="button keyCalculator">1</td>
			<td class="button keyCalculator">2</td>
			<td class="button keyCalculator">3</td>
			<td class="button keyCalculatorF">*</td>
			<td class="button keyCalculatorF" id="keyCalculatorCE">CE</td>
		</tr>
		<tr>
			<td class="button keyCalculator">0</td>
			<td class="button keyCalculator">.</td>
			<td class="button keyCalculator copyCalculator" data-clipboard-target="#calcResultHidden">
				<span class="fa fa-copy" style="font-size:1.3em"></span>
			</td>
			<td class="button keyCalculatorF">/</td>
			<td class="button keyCalculatorR" id="keyCalculatorResult">=</td>
			
		</tr>
	</table>
	<table style="width:98%;margin: 0 auto">
		<tr>
			<td class="button" style="width:50%" id="calcSci"><?php echo lang('scientific','c')?></td>
			<td class="button" style="width:50%" id="calcConv"><?php echo lang('conversions','c')?></td>
		</tr>
	</table>
	<div id="calcSciDiv">
		<table style="width:98%;margin: 0 auto">
			<tr>
				<td class="button keyCalculator" style="width:20%">(</td>
				<td class="button keyCalculator" style="width:20%">)</td>
				<td class="button keyCalculator" style="width:20%">[</td>
				<td class="button keyCalculator" style="width:20%">]</td>
				<td class="button" id="calculatorInv" style="width:20%">1/x</td>
			</tr>
			<tr>
				<td class="button" id="calculatorCos" style="width:20%">cos</td>
				<td class="button" id="calculatorSin" style="width:20%">sin</td>
				<td class="button" id="calculatorTan" style="width:20%">tan</td>
				<td class="button" id="calculatorPi" style="width:20%">&Pi;</td>
				<td class="button" id="calculatorE" style="width:20%">e</td>
			</tr>
			<tr>
				<td class="button" id="calculatorCosInv" style="width:20%">cos<sup>-1</sup></td>
				<td class="button" id="calculatorSinInv" style="width:20%">sin<sup>-1</sup></td>
				<td class="button" id="calculatorTanInv" style="width:20%">tan<sup>-1</sup></td>
				<td class="button" id="calculatorLog" style="width:20%">log</td>
				<td class="button" id="calculatorRand" style="width:20%">rand</td>
			</tr>
		</table>
	</div>
	<div id="calcConvDiv">
		<table style="width:98%;margin: 0 auto">
			<tr>
				<td colspan="4" style="text-align:center">
					<span class="mticon-temp calculatorIcon"></span>
				</td>
			</tr>
			<tr>
				<td class="button convertCalculator" id="convertCalculatorFC" style="width:25%">°F <span class="fa fa-arrow-right"></span> °C</td>
				<td class="button convertCalculator" id="convertCalculatorCF" style="width:25%">°C <span class="fa fa-arrow-right"></span> °F</td>
				<td class="button convertCalculator" id="convertCalculatorCK" style="width:25%">°C <span class="fa fa-arrow-right"></span> K</td>
				<td class="button convertCalculator" id="convertCalculatorFK" style="width:25%">°F <span class="fa fa-arrow-right"></span> K</td>
			</tr>
			<tr>
				<td colspan="4" style="text-align:center">
					<span class="mticon-pressure calculatorIcon"></span>
				</td>
			</tr>
			<tr>
				<td class="button convertCalculator" id="convertCalculatorInHpa" style="width:25%">inHg <span class="fa fa-arrow-right"></span> hPa</td>
				<td class="button convertCalculator" id="convertCalculatorHpaIn" style="width:25%">hPa <span class="fa fa-arrow-right"></span> inHg</td>
				<td class="button convertCalculator" id="convertCalculatorMMHpa" style="width:25%">mmHg <span class="fa fa-arrow-right"></span> hPa</td>
				<td class="button convertCalculator" id="convertCalculatorHpaMM" style="width:25%">hPa <span class="fa fa-arrow-right"></span> mmHg</td>
			</tr>
			<tr>
				<td colspan="4" style="text-align:center">
					<span class="mticon-wind calculatorIcon"></span>
				</td>
			</tr>
			<tr>
				<td class="button convertCalculator" id="convertCalculatorMphMs" style="width:25%">mph <span class="fa fa-arrow-right"></span> m/s</td>
				<td class="button convertCalculator" id="convertCalculatorMsMph" style="width:25%">m/s <span class="fa fa-arrow-right"></span> mph</td>
				<td class="button convertCalculator" id="convertCalculatorMphKmh" style="width:25%">mph <span class="fa fa-arrow-right"></span> km/h</td>
				<td class="button convertCalculator" id="convertCalculatorKmhMph" style="width:25%">km/h <span class="fa fa-arrow-right"></span> mph</td>
			</tr>
			<tr>
				<td class="button convertCalculator" id="convertCalculatorMphKt" style="width:25%">mph <span class="fa fa-arrow-right"></span> kt</td>
				<td class="button convertCalculator" id="convertCalculatorKtMph" style="width:25%">kt <span class="fa fa-arrow-right"></span> mph</td>
				<td class="button convertCalculator" id="convertCalculatorKmhKt" style="width:25%">km/h <span class="fa fa-arrow-right"></span> kt</td>
				<td class="button convertCalculator" id="convertCalculatorKtKmh" style="width:25%">kt <span class="fa fa-arrow-right"></span> km/h</td>
			</tr>
			<tr>
				<td class="button convertCalculator" id="convertCalculatorMphBft" style="width:25%">mph <span class="fa fa-arrow-right"></span> Bft</td>
				<td class="button convertCalculator" id="convertCalculatorKtBft" style="width:25%">kt <span class="fa fa-arrow-right"></span> Bft</td>
				<td class="button convertCalculator" id="convertCalculatorKmhBft" style="width:25%">km/h <span class="fa fa-arrow-right"></span> Bft</td>
				<td class="button convertCalculator" id="convertCalculatorMsBft" style="width:25%">m/s <span class="fa fa-arrow-right"></span> Bft</td>
			</tr>
			<tr>
				<td colspan="4" style="text-align:center">
					<span class="mticon-rain calculatorIcon"></span>
				</td>
			</tr>
			<tr>
				<td class="button convertCalculator" id="convertCalculatorMmIn" style="width:50%" colspan="2">mm <span class="fa fa-arrow-right"></span> in</td>
				<td class="button convertCalculator" id="convertCalculatorInMm" style="width:50%" colspan="2">in <span class="fa fa-arrow-right"></span> mm</td>
			</tr>
			<tr>
				<td colspan="4" style="text-align:center">
					<span class="mticon-visibility calculatorIcon"></span>
				</td>
			</tr>
			<tr>
				<td class="button convertCalculator" id="convertCalculatorKmMi" style="width:50%" colspan="2">km <span class="fa fa-arrow-right"></span> mi</td>
				<td class="button convertCalculator" id="convertCalculatorMiKm" style="width:50%" colspan="2">mi <span class="fa fa-arrow-right"></span> km</td>
			</tr>
		</table>
	</div>
	<input value="" id="calcResultHidden" style="background:none;border:0px;height:1px;position:absolute;top:20px;z-index:-10">
	</div>
	<script>
		$(document).ready(function(){
			$("#calcSciDiv").hide();
			$("#calcConvDiv").hide();
			$("#calcSci").click(function(){
				$("#calcSciDiv").slideToggle();
			});
			$("#calcConv").click(function(){
				$("#calcConvDiv").slideToggle();
			});
			$(".convertCalculator").click(function(){
				conversionType = $(this).attr('id');
				calculatorInput = $("#calculatorInput").html();
				try {
					result = eval(calculatorInput);
					if(conversionType=="convertCalculatorFC"){
						convertedResult = (result - 32) / 1.8;
						$("#calculatorResultDiv").html(result + " °F = " + convertedResult.toFixed(1) + " °C");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorCF"){
						convertedResult = (result * 1.8) + 32;
						$("#calculatorResultDiv").html(result + " °C = " + convertedResult.toFixed(1) + " °F");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorCK"){
						convertedResult = result + 273.15;
						$("#calculatorResultDiv").html(result + " °C = " + convertedResult.toFixed(1) + " K");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorFK"){
						convertedResult = (result + 459.67) * (5/9);
						$("#calculatorResultDiv").html(result + " °F = " + convertedResult.toFixed(1) + " K");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorInHpa"){
						convertedResult = result * 33.8639;
						$("#calculatorResultDiv").html(result + " inHg = " + convertedResult.toFixed(1) + " hPa");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorHpaIn"){
						convertedResult = result / 33.8639;
						$("#calculatorResultDiv").html(result + " hPa = " + convertedResult.toFixed(2) + " inHg");
						$("#calcResultHidden").val(convertedResult.toFixed(2));
					}
					if(conversionType=="convertCalculatorHpaMM"){
						convertedResult = result * 0.75006156130;
						$("#calculatorResultDiv").html(result + " hPa = " + convertedResult.toFixed(2) + " mmHg");
						$("#calcResultHidden").val(convertedResult.toFixed(2));
					}
					if(conversionType=="convertCalculatorMMHpa"){
						convertedResult = result / 0.75006156130;
						$("#calculatorResultDiv").html(result + " hPa = " + convertedResult.toFixed(2) + " mmHg");
						$("#calcResultHidden").val(convertedResult.toFixed(2));
					}
					if(conversionType=="convertCalculatorInMm"){
						convertedResult = result * 25.4;
						$("#calculatorResultDiv").html(result + " in = " + convertedResult.toFixed(1) + " mm");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorMmIn"){
						convertedResult = result / 25.4;
						$("#calculatorResultDiv").html(result + " mm = " + convertedResult.toFixed(2) + " in");
						$("#calcResultHidden").val(convertedResult.toFixed(2));
					}
					if(conversionType=="convertCalculatorMphMs"){
						convertedResult = result * 0.44704;
						$("#calculatorResultDiv").html(result + " mph = " + convertedResult.toFixed(1) + " m/s");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorMsMph"){
						convertedResult = result / 0.44704;
						$("#calculatorResultDiv").html(result + " m/s = " + convertedResult.toFixed(1) + " mph");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorMphKmh"){
						convertedResult = result * 1.60934;
						$("#calculatorResultDiv").html(result + " mph = " + convertedResult.toFixed(1) + " km/h");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorKmhMph"){
						convertedResult = result / 1.60934;
						$("#calculatorResultDiv").html(result + " km/h = " + convertedResult.toFixed(1) + " mph");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorMphKt"){
						convertedResult = result * 0.868976;
						$("#calculatorResultDiv").html(result + " mph = " + convertedResult.toFixed(1) + " kt");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorKtMph"){
						convertedResult = result / 0.868976;
						$("#calculatorResultDiv").html(result + " kt = " + convertedResult.toFixed(1) + " mph");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorKtKmh"){
						convertedResult = result * 1.852;
						$("#calculatorResultDiv").html(result + " kt = " + convertedResult.toFixed(1) + " km/h");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorKmhKt"){
						convertedResult = result / 1.852;
						$("#calculatorResultDiv").html(result + " km/h = " + convertedResult.toFixed(1) + " kt");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}

					if(conversionType=="convertCalculatorMphBft"){
						convertedResult = getBeaufourtCalc(result,"mph");
						$("#calculatorResultDiv").html(result + " mph = " + convertedResult.toFixed(0) + " Bft");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorKtBft"){
						convertedResult = getBeaufourtCalc(result,"kt");
						$("#calculatorResultDiv").html(result + " kt = " + convertedResult.toFixed(0) + " Bft");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorKmhBft"){
						convertedResult = getBeaufourtCalc(result,"kmh");
						$("#calculatorResultDiv").html(result + " km/h = " + convertedResult.toFixed(0) + " Bft");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorMsBft"){
						convertedResult = getBeaufourtCalc(result,"ms");
						$("#calculatorResultDiv").html(result + " m/s = " + convertedResult.toFixed(0) + " Bft");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}


					if(conversionType=="convertCalculatorKmMi"){
						convertedResult = result * 0.621371;
						$("#calculatorResultDiv").html(result + " km = " + convertedResult.toFixed(1) + " mi");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
					if(conversionType=="convertCalculatorMiKm"){
						convertedResult = result / 0.621371;
						$("#calculatorResultDiv").html(result + " mi = " + convertedResult.toFixed(1) + " km");
						$("#calcResultHidden").val(convertedResult.toFixed(1));
					}
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
					return false;
				}	
			});
			$(".keyCalculator").click(function(){
				calculatorNumber = $(this).html();
				$("#calculatorInput").html($("#calculatorInput").html() + calculatorNumber);
			});
			$(".keyCalculatorF").click(function(){
				calculatorNumber = $(this).html();
				$("#calculatorInput").html($("#calculatorInput").html() + " " + calculatorNumber + " ");
			});
			$("#keyCalculatorXY").click(function(){
				$("#calculatorInput").html($("#calculatorInput").html() + "^");
			});
			$("#keyCalculatorSQRT").click(function(){
				calculatorInput = $("#calculatorInput").html();
				calculatorInput = replacementCalculator(calculatorInput);
				try {
					result = eval(calculatorInput);
					resultSQRT = Math.sqrt(result);
					$("#calculatorResultDiv").html("&radic;"+result+" = "+resultSQRT);
					$("#calcResultHidden").val(resultSQRT);
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
				}
			});
			$("#keyCalculatorCE").click(function(){
				$("#calculatorInput").html("");
				$("#calculatorResultDiv").html("");
			});
			$("#keyCalculatorResult").click(function(){
				calculatorInput = $("#calculatorInput").html();
				calculatorInput = replacementCalculator(calculatorInput);
				try {
					result = eval(calculatorInput);
					$("#calculatorResultDiv").html("= "+result);
					$("#calcResultHidden").val(result);
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
				}
			});
			$("#calculatorCos").click(function(){
				calculatorInput = $("#calculatorInput").html();
				calculatorInput = replacementCalculator(calculatorInput);
				try {
					result = eval(calculatorInput);
					resultFinal = Math.cos(result);
					$("#calculatorResultDiv").html("cos "+result+" = "+resultFinal);
					$("#calcResultHidden").val(resultFinal);
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
				}
			});
			$("#calculatorSin").click(function(){
				calculatorInput = $("#calculatorInput").html();
				calculatorInput = replacementCalculator(calculatorInput);
				try {
					result = eval(calculatorInput);
					resultFinal = Math.sin(result);
					$("#calculatorResultDiv").html("sin "+result+" = "+resultFinal);
					$("#calcResultHidden").val(resultFinal);
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
				}
			});
			$("#calculatorTan").click(function(){
				calculatorInput = $("#calculatorInput").html();
				calculatorInput = replacementCalculator(calculatorInput);
				try {
					result = eval(calculatorInput);
					resultFinal = Math.tan(result);
					$("#calculatorResultDiv").html("tan "+result+" = "+resultFinal);
					$("#calcResultHidden").val(resultFinal);
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
				}
			});
			$("#calculatorCosInv").click(function(){
				calculatorInput = $("#calculatorInput").html();
				calculatorInput = replacementCalculator(calculatorInput);
				try {
					result = eval(calculatorInput);
					resultFinal = Math.acos(result);
					$("#calculatorResultDiv").html("cos<sup>-1</sup>"+result+" = "+resultFinal);
					$("#calcResultHidden").val(resultFinal);
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
				}
			});
			$("#calculatorSinInv").click(function(){
				calculatorInput = $("#calculatorInput").html();
				calculatorInput = replacementCalculator(calculatorInput);
				try {
					result = eval(calculatorInput);
					resultFinal = Math.asin(result);
					$("#calculatorResultDiv").html("sin<sup>-1</sup>"+result+" = "+resultFinal);
					$("#calcResultHidden").val(resultFinal);
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
				}
			});
			$("#calculatorTanInv").click(function(){
				calculatorInput = $("#calculatorInput").html();
				calculatorInput = replacementCalculator(calculatorInput);
				try {
					result = eval(calculatorInput);
					resultFinal = Math.atan(result);
					$("#calculatorResultDiv").html("tan<sup>-1</sup>"+result+" = "+resultFinal);
					$("#calcResultHidden").val(resultFinal);
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
				}
			});
			$("#calculatorLog").click(function(){
				calculatorInput = $("#calculatorInput").html();
				calculatorInput = replacementCalculator(calculatorInput);
				try {
					result = eval(calculatorInput);
					resultFinal = Math.log(result);
					$("#calculatorResultDiv").html("log "+result+" = "+resultFinal);
					$("#calcResultHidden").val(resultFinal);
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
				}
			});
			$("#calculatorInv").click(function(){
				calculatorInput = $("#calculatorInput").html();
				calculatorInput = replacementCalculator(calculatorInput);
				try {
					result = eval(calculatorInput);
					resultFinal = 1/(result);
					$("#calculatorResultDiv").html(" = "+resultFinal);
					$("#calcResultHidden").val(resultFinal);
				}
				catch(err){
					$("#calculatorResultDiv").html("<?php echo lang('invalid input','l')?>");
				}
			});
			$("#calculatorPi").click(function(){
				$("#calculatorInput").html($("#calculatorInput").html() + "&Pi;");
			});
			$("#calculatorRand").click(function(){
				range = prompt("<?php echo lang('random number between','c')?>","0,10");
				range = range.split(",");
				randomGenerated = Math.round(Math.random() * (eval(range[1]) - eval(range[0])) + eval(range[0]));
				$("#calculatorInput").html($("#calculatorInput").html() + " " + randomGenerated);
			});
			$("#calculatorE").click(function(){
				$("#calculatorInput").html($("#calculatorInput").html() + "e");
			});
		});
		
		function replacementCalculator(input){
			input = input.replace(" ","");
			input = input.replace("&Pi;",Math.PI);
			input = input.replace("Π",Math.PI);
			input = input.replace("e",2.718281828459045);
			return input;
		}

		function getBeaufourtCalc(val,unit){
			if(unit=="mph"){
				conv = val * 1.609;
			}
			else if(unit=="kmh"){
				conv = val;
			}
			else if(unit=="ms"){
				conv = val * 3.6;
			}
			else if(unit=="kt"){
				conv = val * 1.852;
			}
			else{
				conv = val;
			}

			if(conv<1){
				Bft = 0;
			}
			else if(conv>=1 && conv<6){
				Bft = 1;
			}
			else if(conv>=6 && conv<12){
				Bft = 2;
			}
			else if(conv>=12 && conv<20){
				Bft = 3;
			}
			else if(conv>=20 && conv<29){
				Bft = 4;
			}
			else if(conv>=29 && conv<39){
				Bft = 5;
			}
			else if(conv>=39 && conv<50){
				Bft = 6;
			}
			else if(conv>=50 && conv<62){
				Bft = 7;
			}
			else if(conv>=62 && conv<75){
				Bft = 8;
			}
			else if(conv>=75 && conv<89){
				Bft = 9;
			}
			else if(conv>=89 && conv<103){
				Bft = 10;
			}
			else if(conv>=103 && conv<118){
				Bft = 11;
			}
			else{
				Bft = 12;
			}
			return Bft;
		}
		
		!function(t){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=t();else if("function"==typeof define&&define.amd)define([],t);else{var e;e="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,e.Clipboard=t()}}(function(){var t,e,n;return function t(e,n,r){function o(a,s){if(!n[a]){if(!e[a]){var c="function"==typeof require&&require;if(!s&&c)return c(a,!0);if(i)return i(a,!0);var u=new Error("Cannot find module '"+a+"'");throw u.code="MODULE_NOT_FOUND",u}var l=n[a]={exports:{}};e[a][0].call(l.exports,function(t){var n=e[a][1][t];return o(n?n:t)},l,l.exports,t,e,n,r)}return n[a].exports}for(var i="function"==typeof require&&require,a=0;a<r.length;a++)o(r[a]);return o}({1:[function(t,e,n){var r=t("matches-selector");e.exports=function(t,e,n){for(var o=n?t:t.parentNode;o&&o!==document;){if(r(o,e))return o;o=o.parentNode}}},{"matches-selector":5}],2:[function(t,e,n){function r(t,e,n,r,i){var a=o.apply(this,arguments);return t.addEventListener(n,a,i),{destroy:function(){t.removeEventListener(n,a,i)}}}function o(t,e,n,r){return function(n){n.delegateTarget=i(n.target,e,!0),n.delegateTarget&&r.call(t,n)}}var i=t("closest");e.exports=r},{closest:1}],3:[function(t,e,n){n.node=function(t){return void 0!==t&&t instanceof HTMLElement&&1===t.nodeType},n.nodeList=function(t){var e=Object.prototype.toString.call(t);return void 0!==t&&("[object NodeList]"===e||"[object HTMLCollection]"===e)&&"length"in t&&(0===t.length||n.node(t[0]))},n.string=function(t){return"string"==typeof t||t instanceof String},n.fn=function(t){var e=Object.prototype.toString.call(t);return"[object Function]"===e}},{}],4:[function(t,e,n){function r(t,e,n){if(!t&&!e&&!n)throw new Error("Missing required arguments");if(!s.string(e))throw new TypeError("Second argument must be a String");if(!s.fn(n))throw new TypeError("Third argument must be a Function");if(s.node(t))return o(t,e,n);if(s.nodeList(t))return i(t,e,n);if(s.string(t))return a(t,e,n);throw new TypeError("First argument must be a String, HTMLElement, HTMLCollection, or NodeList")}function o(t,e,n){return t.addEventListener(e,n),{destroy:function(){t.removeEventListener(e,n)}}}function i(t,e,n){return Array.prototype.forEach.call(t,function(t){t.addEventListener(e,n)}),{destroy:function(){Array.prototype.forEach.call(t,function(t){t.removeEventListener(e,n)})}}}function a(t,e,n){return c(document.body,t,e,n)}var s=t("./is"),c=t("delegate");e.exports=r},{"./is":3,delegate:2}],5:[function(t,e,n){function r(t,e){if(i)return i.call(t,e);for(var n=t.parentNode.querySelectorAll(e),r=0;r<n.length;++r)if(n[r]==t)return!0;return!1}var o=Element.prototype,i=o.matchesSelector||o.webkitMatchesSelector||o.mozMatchesSelector||o.msMatchesSelector||o.oMatchesSelector;e.exports=r},{}],6:[function(t,e,n){function r(t){var e;if("INPUT"===t.nodeName||"TEXTAREA"===t.nodeName)t.focus(),t.setSelectionRange(0,t.value.length),e=t.value;else{t.hasAttribute("contenteditable")&&t.focus();var n=window.getSelection(),r=document.createRange();r.selectNodeContents(t),n.removeAllRanges(),n.addRange(r),e=n.toString()}return e}e.exports=r},{}],7:[function(t,e,n){function r(){}r.prototype={on:function(t,e,n){var r=this.e||(this.e={});return(r[t]||(r[t]=[])).push({fn:e,ctx:n}),this},once:function(t,e,n){function r(){o.off(t,r),e.apply(n,arguments)}var o=this;return r._=e,this.on(t,r,n)},emit:function(t){var e=[].slice.call(arguments,1),n=((this.e||(this.e={}))[t]||[]).slice(),r=0,o=n.length;for(r;o>r;r++)n[r].fn.apply(n[r].ctx,e);return this},off:function(t,e){var n=this.e||(this.e={}),r=n[t],o=[];if(r&&e)for(var i=0,a=r.length;a>i;i++)r[i].fn!==e&&r[i].fn._!==e&&o.push(r[i]);return o.length?n[t]=o:delete n[t],this}},e.exports=r},{}],8:[function(t,e,n){"use strict";function r(t){return t&&t.__esModule?t:{"default":t}}function o(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}n.__esModule=!0;var i=function(){function t(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}return function(e,n,r){return n&&t(e.prototype,n),r&&t(e,r),e}}(),a=t("select"),s=r(a),c=function(){function t(e){o(this,t),this.resolveOptions(e),this.initSelection()}return t.prototype.resolveOptions=function t(){var e=arguments.length<=0||void 0===arguments[0]?{}:arguments[0];this.action=e.action,this.emitter=e.emitter,this.target=e.target,this.text=e.text,this.trigger=e.trigger,this.selectedText=""},t.prototype.initSelection=function t(){if(this.text&&this.target)throw new Error('Multiple attributes declared, use either "target" or "text"');if(this.text)this.selectFake();else{if(!this.target)throw new Error('Missing required attributes, use either "target" or "text"');this.selectTarget()}},t.prototype.selectFake=function t(){var e=this,n="rtl"==document.documentElement.getAttribute("dir");this.removeFake(),this.fakeHandler=document.body.addEventListener("click",function(){return e.removeFake()}),this.fakeElem=document.createElement("textarea"),this.fakeElem.style.fontSize="12pt",this.fakeElem.style.padding="0",this.fakeElem.style.margin="0",this.fakeElem.style.position="absolute",this.fakeElem.style[n?"right":"left"]="-9999px",this.fakeElem.style.top=(window.pageYOffset||document.documentElement.scrollTop)+"px",this.fakeElem.setAttribute("readonly",""),this.fakeElem.value=this.text,document.body.appendChild(this.fakeElem),this.selectedText=s.default(this.fakeElem),this.copyText()},t.prototype.removeFake=function t(){this.fakeHandler&&(document.body.removeEventListener("click"),this.fakeHandler=null),this.fakeElem&&(document.body.removeChild(this.fakeElem),this.fakeElem=null)},t.prototype.selectTarget=function t(){this.selectedText=s.default(this.target),this.copyText()},t.prototype.copyText=function t(){var e=void 0;try{e=document.execCommand(this.action)}catch(n){e=!1}this.handleResult(e)},t.prototype.handleResult=function t(e){e?this.emitter.emit("success",{action:this.action,text:this.selectedText,trigger:this.trigger,clearSelection:this.clearSelection.bind(this)}):this.emitter.emit("error",{action:this.action,trigger:this.trigger,clearSelection:this.clearSelection.bind(this)})},t.prototype.clearSelection=function t(){this.target&&this.target.blur(),window.getSelection().removeAllRanges()},t.prototype.destroy=function t(){this.removeFake()},i(t,[{key:"action",set:function t(){var e=arguments.length<=0||void 0===arguments[0]?"copy":arguments[0];if(this._action=e,"copy"!==this._action&&"cut"!==this._action)throw new Error('Invalid "action" value, use either "copy" or "cut"')},get:function t(){return this._action}},{key:"target",set:function t(e){if(void 0!==e){if(!e||"object"!=typeof e||1!==e.nodeType)throw new Error('Invalid "target" value, use a valid Element');this._target=e}},get:function t(){return this._target}}]),t}();n.default=c,e.exports=n.default},{select:6}],9:[function(t,e,n){"use strict";function r(t){return t&&t.__esModule?t:{"default":t}}function o(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}function i(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function, not "+typeof e);t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}}),e&&(Object.setPrototypeOf?Object.setPrototypeOf(t,e):t.__proto__=e)}function a(t,e){var n="data-clipboard-"+t;if(e.hasAttribute(n))return e.getAttribute(n)}n.__esModule=!0;var s=t("./clipboard-action"),c=r(s),u=t("tiny-emitter"),l=r(u),f=t("good-listener"),d=r(f),h=function(t){function e(n,r){o(this,e),t.call(this),this.resolveOptions(r),this.listenClick(n)}return i(e,t),e.prototype.resolveOptions=function t(){var e=arguments.length<=0||void 0===arguments[0]?{}:arguments[0];this.action="function"==typeof e.action?e.action:this.defaultAction,this.target="function"==typeof e.target?e.target:this.defaultTarget,this.text="function"==typeof e.text?e.text:this.defaultText},e.prototype.listenClick=function t(e){var n=this;this.listener=d.default(e,"click",function(t){return n.onClick(t)})},e.prototype.onClick=function t(e){var n=e.delegateTarget||e.currentTarget;this.clipboardAction&&(this.clipboardAction=null),this.clipboardAction=new c.default({action:this.action(n),target:this.target(n),text:this.text(n),trigger:n,emitter:this})},e.prototype.defaultAction=function t(e){return a("action",e)},e.prototype.defaultTarget=function t(e){var n=a("target",e);return n?document.querySelector(n):void 0},e.prototype.defaultText=function t(e){return a("text",e)},e.prototype.destroy=function t(){this.listener.destroy(),this.clipboardAction&&(this.clipboardAction.destroy(),this.clipboardAction=null)},e}(l.default);n.default=h,e.exports=n.default},{"./clipboard-action":8,"good-listener":4,"tiny-emitter":7}]},{},[9])(9)});
		new Clipboard('.copyCalculator');
	</script>
	
	<?php 
		$time = microtime();
		$time = explode(' ', $time);
		$time = $time[1] + $time[0];
		$blockEndTime = $time;
		$blockLoadTime = $blockEndTime - $blockStartTime;
		$blockLoadTime = round($blockLoadTime,4);
		$errorLog[] = array("","Block loaded in ".$blockLoadTime." s.");
		showLog($errorLog);
	?>
