<?php
	# 		Calendar
	# 		Namespace:		calendar
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	#		v1.2 - Jul 11, 2016 
	#			- added missing icons in dark theme
	#		v2.0 - Aug 2, 2016
	#			- added possibility to use either astronomical or meteorological seasons
	# 		v3.0 - May 15, 2017
	# 			- conversion to SVG
	# 			- optimization (80% size reduction)
	# 		v3.1 - Jul 22, 2017
	# 			- design tweaks
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}
	
	if($dateTypes!="meteorological"){
		$stationTimezone = new DateTimeZone($stationTZ);
		$stationOffset  = $stationTimezone->getOffset(new DateTime)/3600;

		$seasonsFile = fopen("files/seasons.txt", "r");
		while(!feof($seasonsFile)) {
			$currentSeasonDate = strtotime(fgets($seasonsFile));
			if($stationLat>=0){
				if($currentSeasonDate>=time()){
					if(date('m',$currentSeasonDate)==3){
						$springEquinoxArr[] = $currentSeasonDate + $stationOffset*3600;
					}
					if(date('m',$currentSeasonDate)==6){
						$summerSolsticeArr[] = $currentSeasonDate + $stationOffset*3600;
					}
					if(date('m',$currentSeasonDate)==9){
						$fallEquinoxArr[] = $currentSeasonDate + $stationOffset*3600;
					}
					if(date('m',$currentSeasonDate)==12){
						$winterSolsticeArr[] = $currentSeasonDate + $stationOffset*3600;
					}
				}
			}
			else{
				if($currentSeasonDate>=time()){
					if(date('m',$currentSeasonDate)==9){
						$springEquinoxArr[] = $currentSeasonDate + $stationOffset*3600;
					}
					if(date('m',$currentSeasonDate)==12){
						$summerSolsticeArr[] = $currentSeasonDate + $stationOffset*3600;
					}
					if(date('m',$currentSeasonDate)==3){
						$fallEquinoxArr[] = $currentSeasonDate + $stationOffset*3600;
					}
					if(date('m',$currentSeasonDate)==6){
						$winterSolsticeArr[] = $currentSeasonDate + $stationOffset*3600;
					}
				}
			}
			// get current season
			if($currentSeasonDate<time()){		
				if($stationLat>=0){
					if(date("m",$currentSeasonDate)==3){
						$currentSeason = 1;
					}
					if(date("m",$currentSeasonDate)==6){
						$currentSeason = 2;
					}
					if(date("m",$currentSeasonDate)==9){
						$currentSeason = 3;
					}
					if(date("m",$currentSeasonDate)==12){
						$currentSeason = 4;
					}
				}
				else{
					if(date("m",$currentSeasonDate)==3){
						$currentSeason = 3;
					}
					if(date("m",$currentSeasonDate)==6){
						$currentSeason = 4;
					}
					if(date("m",$currentSeasonDate)==9){
						$currentSeason = 1;
					}
					if(date("m",$currentSeasonDate)==12){
						$currentSeason = 2;
					}
				}
			}
			if(date("Ymd",$currentSeasonDate) == date("Ymd")){ // check if it is today
				$seasonToday = $currentSeasonDate;
			}	
		}
		fclose($seasonsFile);
		
		$output['springEquinoxArr'] = $springEquinoxArr;
		$output['summerSolsticeArr'] = $summerSolsticeArr;
		$output['fallEquinoxArr'] = $fallEquinoxArr;
		$output['winterSolsticeArr'] = $winterSolsticeArr;
		$output['currentSeason'] = $currentSeason;
	}
	else{ // use meteorological seasons
		// first get current season
		if(date('m')==12 || date('m')==1 || date('m')==2){
			if($stationLat>=0){
				$output['currentSeason'] = 4;
			}
			else{
				$output['currentSeason'] = 2;
			}
		}
		if(date('m')==3 || date('m')==4 || date('m')==5){
			if($stationLat>=0){
				$output['currentSeason'] = 1;
			}
			else{
				$output['currentSeason'] = 3;
			}
		}
		if(date('m')==6 || date('m')==7 || date('m')==8){
			if($stationLat>=0){
				$output['currentSeason'] = 2;
			}
			else{
				$output['currentSeason'] = 4;
			}
		}
		if(date('m')==9 || date('m')==10 || date('m')==11){
			if($stationLat>=0){
				$output['currentSeason'] = 3;
			}
			else{
				$output['currentSeason'] = 1;
			}
		}
		if($stationLat>=0){
			$output['springEquinoxArr'][] = getDateNextMonth(3);
			$output['summerSolsticeArr'][] = getDateNextMonth(6);
			$output['fallEquinoxArr'][] = getDateNextMonth(9);
			$output['winterSolsticeArr'][] = getDateNextMonth(12);
		}
		else{
			$output['springEquinoxArr'][] = getDateNextMonth(9);
			$output['summerSolsticeArr'][] = getDateNextMonth(12);
			$output['fallEquinoxArr'][] = getDateNextMonth(3);
			$output['winterSolsticeArr'][] = getDateNextMonth(6);
		}
	}
	// get the upcoming 1st day of specified month, if in the past, use next year
	function getDateNextMonth($month){
		$firstDay = strtotime(date('Y')."-".$month."-1");
		if($firstDay<time()){
			$firstDay = strtotime((date('Y')+1)."-".$month."-1 00:00");
		}
		return $firstDay;
	}
	function dateDiff($time1, $time2, $precision = 6) {
		if (!is_int($time1)) {
		  $time1 = strtotime($time1);
		}
		if (!is_int($time2)) {
		  $time2 = strtotime($time2);
		}
		if ($time1 > $time2) {
		  $ttime = $time1;
		  $time1 = $time2;
		  $time2 = $ttime;
		}
		$intervals = array('year','month','day','hour','minute','second');
		$diffs = array();
		foreach ($intervals as $interval) {
		  $ttime = strtotime('+1 ' . $interval, $time1);
		  $add = 1;
		  $looped = 0;
		  while ($time2 >= $ttime) {
			$add++;
			$ttime = strtotime("+" . $add . " " . $interval, $time1);
			$looped++;
		  }
		  $time1 = strtotime("+" . $looped . " " . $interval, $time1);
		  $diffs[$interval] = $looped;
		}
		$count = 0;
		$times = array();
		foreach ($diffs as $interval => $value) {
		  if ($count >= $precision) {
			break;
		  }
		  if ($value > 0) {
			$times[] = $value . " " . $interval;
			$count++;
		  }
		}
		$result = implode(" ", $times);
		$result = str_replace("year","y",$result);
		$result = str_replace("month","m",$result);
		$result = str_replace("day","d",$result);
		$result = str_replace("hour",lang('hAbbr','l'),$result);
		$result = str_replace("minute",lang('minAbbr','l'),$result);
		$result = str_replace("second","s",$result);
		return $result;
	}
		  
	
	?>
	<style>
		.calendarIcon{
			font-size: 1.8em;
		}
	</style>
	<table style="width:100%;table-layout:fixed">
		<tr>
			<td>
				<span class="calendarIcon mticon-calendar-year tooltip" alt='' title="<?php echo lang("year",'c')?>"></span>
			</td>
			<td>
				<span class="calendarIcon mticon-calendar-month tooltip" alt='' title="<?php echo lang("month",'c')?>"></span>
			</td>
			<td>
				<span class="calendarIcon mticon-calendar-day tooltip" alt='' title="<?php echo lang("day",'c')?>"></span>
			</td>
			<td>
				<span class="calendarIcon mticon-week tooltip" alt='' title="<?php echo lang("week",'c')?>"></span>
			</td>
			<td>
				<span class="calendarIcon mticon-12m tooltip" alt='' title="<?php echo lang("day",'c')." / ".lang("year",'c')?>"></span>
			</td>
		</tr>
		<tr>
			<td>
				<?php echo date("Y")?>
			</td>
			<td>
				<?php echo date("n")?>
			</td>
			<td>
				<?php echo date("j")?>
			</td>
			<td>
				<?php echo date("W")?>
			</td>
			<td>
				<?php echo (date("z")+1)?>
			</td>
		</tr>
	</table>
	<div id="calendarDetails" class="details">
		<br>
		<table style="width:96%;margin:0 auto" class="table">
			<tr>
				<td>
					<?php echo (date("Y")+1)?>							
				</td>
				<td style="text-align:right">
					<?php 
						echo dateDiff((date("Y")+1)."-01-01 00:00", time());
					?>
				</td>
			</tr>
			<?php 
				if($output['currentSeason']==1){
					echo "<tr><td><span class='calendarIcon mticon-summer tooltip' alt='' title='".lang('summer','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['summerSolsticeArr'][0])."</strong><br>".dateDiff($output['summerSolsticeArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-autumn tooltip' alt='' title='".lang('autumn','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['fallEquinoxArr'][0])."</strong><br>".dateDiff($output['fallEquinoxArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-snow tooltip' alt='' title='".lang('winter','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['winterSolsticeArr'][0])."</strong><br>".dateDiff($output['winterSolsticeArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-spring tooltip' alt='' title='".lang('spring','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['springEquinoxArr'][0])."</strong><br>".dateDiff($output['springEquinoxArr'][0], time())."</td></tr>";
				}
				if($output['currentSeason']==2){
					echo "<tr><td><span class='calendarIcon mticon-autumn tooltip' alt='' title='".lang('autumn','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['fallEquinoxArr'][0])."</strong><br>".dateDiff($output['fallEquinoxArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-snow tooltip' alt='' title='".lang('winter','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['winterSolsticeArr'][0])."</strong><br>".dateDiff($output['winterSolsticeArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-spring tooltip' alt='' title='".lang('spring','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['springEquinoxArr'][0])."</strong><br>".dateDiff($output['springEquinoxArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-summer tooltip' alt='' title='".lang('summer','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['summerSolsticeArr'][0])."</strong><br>".dateDiff($output['summerSolsticeArr'][0], time())."</td></tr>";
				}
				if($output['currentSeason']==3){
					echo "<tr><td><span class='calendarIcon mticon-snow tooltip' alt='' title='".lang('winter','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['winterSolsticeArr'][0])."</strong><br>".dateDiff($output['winterSolsticeArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-spring tooltip' alt='' title='".lang('spring','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['springEquinoxArr'][0])."</strong><br>".dateDiff($output['springEquinoxArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-summer tooltip' alt='' title='".lang('summer','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['summerSolsticeArr'][0])."</strong><br>".dateDiff($output['summerSolsticeArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-autumn tooltip' alt='' title='".lang('autumn','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['fallEquinoxArr'][0])."</strong><br>".dateDiff($output['fallEquinoxArr'][0], time())."</td></tr>";
				}
				if($output['currentSeason']==4){
					echo "<tr><td><span class='calendarIcon mticon-spring tooltip' alt='' title='".lang('spring','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['springEquinoxArr'][0])."</strong><br>".dateDiff($output['springEquinoxArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-summer tooltip' alt='' title='".lang('summer','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['summerSolsticeArr'][0])."</strong><br>".dateDiff($output['summerSolsticeArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-autumn tooltip' alt='' title='".lang('autumn','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['fallEquinoxArr'][0])."</strong><br>".dateDiff($output['fallEquinoxArr'][0], time())."</td></tr>";
					echo "<tr><td><span class='calendarIcon mticon-snow tooltip' alt='' title='".lang('winter','c')."'></span></td>";
					echo "<td style='text-align:right'><strong>".date($dateTimeFormat,$output['winterSolsticeArr'][0])."</strong><br>".dateDiff($output['winterSolsticeArr'][0], time())."</td></tr>";
				}
			?>
		</table>
	</div>
	<span class="more" onclick="txt = $('#calendarDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#calendarDetails').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>