<?php

	# 		Month Calendar
	# 		Namespace:		calendarMonth
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	#		v2.0 - Aug 03, 2016
	#			- added possibility to view previous and next months
	#		v2.1 - Oct 14, 2016
	#			- bug fixes
	#		v2.2 - Mar 3, 2017
	#			- bug fixes
	
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}	
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$loadedMonth = date('m');
	$loadedYear = date('Y');
	$todayDate = date('d');
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$monthsArray=array(lang('january','c'),lang('february','c'),lang('march','c'),lang('april','c'),lang('may','c'),lang('june','c'),lang('july','c'),lang('august','c'),lang('september','c'),lang('october','c'),lang('november','c'),lang('december','c'));
	
	// this month
	
	$calendarString = "";
	
	if($firstWeekday == 1){
		$erster=date('w',mktime(0,0,0,$loadedMonth,1,$loadedYear));
		$calendarTotal=date('t',mktime(0,0,0,$loadedMonth,1,$loadedYear));
		if ($erster==0) $erster=7;
		$calendarString .=  '<table style="text-align:center;font-size:80%;width:98%;margin:0 auto">';
		$calendarString .=  '<th colspan=7 style="text-align:center;font-size:140%; color:#'.$color_schemes[$design2]['200'].';">'.$monthsArray[$loadedMonth-1].' '.$loadedYear.'</th>';
		$calendarString .=  '<tr><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('mondayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('tuesdayAbbr','c').'</b></td>';
		$calendarString .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('wednesdayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('thursdayAbbr','c').'</b></td>';
		$calendarString .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('fridayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('saturdayAbbr','c').'</b></td>';
		$calendarString .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('sundayAbbr','c').'</b></td></tr>';
		$calendarString .=  '<tr>';
		$i=1;
		while ($i<$erster) {
			$calendarString .=  '<td> </td>';
			$i++;
		}
		$i=1;
		while ($i<=$calendarTotal) {
			$rest=($i+$erster-1)%7;
			if($i==$todayDate){
				$calendarString .=  '<td style="font-size:90%; color:black;font-weight:bold;text-align:center;width:14.3%;background:#'.$color_schemes[$design2]['200'].'">';	
				$calendarString .=  $i;
			}
			else{
				$calendarString .=  '<td style="font-size:90%; text-align:center;width:14.3%">';
				if ($rest==6) {
					$calendarString .=  '<span style="color:#'.$color_schemes[$design2]['200'].'">'.$i.'</span>';
				} else if ($rest==0) {
					$calendarString .=  '<span style="color:#'.$color_schemes[$design2]['300'].'">'.$i.'</span>';
				} else {
					$calendarString .=  $i;
				}
			}
			$calendarString .=  "</td>\n";
			if ($rest==0) $calendarString .=  "</tr>\n<tr>\n";
			$i++;
		}
		$calendarString .=  '</tr>';
		$calendarString .=  '</table>';
	}
	
	else{
		$erster=date('w',mktime(0,0,0,$loadedMonth,1,$loadedYear));
		$calendarTotal=date('t',mktime(0,0,0,$loadedMonth,1,$loadedYear));
		$calendarString .=  '<table style="text-align:center;font-size:80%;margin:0 auto;width:98%">';
		$calendarString .=  '<th colspan=7 style="text-align:center;font-size:140%; color:#'.$color_schemes[$design2]['300'].';">'.$monthsArray[$loadedMonth-1].' '.$loadedYear.'</th>';
		$calendarString .=  '<tr><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('sundayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('mondayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('tuesdayAbbr','c').'</b></td>';
		$calendarString .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('wednesdayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('thursdayAbbr','c').'</b></td>';
		$calendarString .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('fridayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('saturdayAbbr','c').'</b></td>';
		$calendarString .=  '</tr>';
		$calendarString .=  '<tr>';
		$i=0;
		while ($i<$erster) {
			$calendarString .=  '<td> </td>';
			$i++;
		}
		$i=1;
		while ($i<=$calendarTotal) {
			$rest=($i+$erster)%7;	
			if($i==$todayDate){
				$calendarString .=  '<td style="font-size:90%; color:black;font-weight:bold;text-align:center;width:14.3%;background:#'.$color_schemes[$design2]['200'].'">';	
				$calendarString .=  $i;
			}
			else{
				$calendarString .=  '<td style="font-size:90%; text-align:center;width:14.3%">';			
				if ($rest==0) {
					$calendarString .=  '<span style="color:#'.$color_schemes[$design2]['300'].'">'.$i.'</span>';
				} else if ($rest==1) {
					$calendarString .=  '<span style="color:#'.$color_schemes[$design2]['200'].'">'.$i.'</span>';
				} else {
					$calendarString .=  $i;
				}
			}
			$calendarString .=  "</td>\n";
			if ($rest==0) $calendarString .=  "</tr>\n<tr>\n";
			$i++;
		}
		$calendarString .=  '</tr>';
		$calendarString .=  '</table>';
	}
	
	// previous months
	
	for($g=1;$g<=$previousNumber;$g++){
		
		$nextMonth = date('m',strtotime('-'.$g.' months'));
		$nextYear = date('Y',strtotime('-'.$g.' months'));
		$nextDate = 35; // dummy day
	
		${"calendarStringPrevious".$g} = "";
		
		if($firstWeekday == 1){
			$erster=date('w',mktime(0,0,0,$nextMonth,1,$nextYear));
			$calendarTotal=date('t',mktime(0,0,0,$nextMonth,1,$nextYear));
			if ($erster==0) $erster=7;
			${"calendarStringPrevious".$g} .=  '<table style="text-align:center;font-size:80%;width:98%;margin:0 auto">';
			${"calendarStringPrevious".$g} .=  '<th colspan=7 style="text-align:center;font-size:140%; color:#'.$color_schemes[$design2]['200'].';">'.$monthsArray[$nextMonth-1].' '.$nextYear.'</th>';
			${"calendarStringPrevious".$g} .=  '<tr><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('mondayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('tuesdayAbbr','c').'</b></td>';
			${"calendarStringPrevious".$g} .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('wednesdayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('thursdayAbbr','c').'</b></td>';
			${"calendarStringPrevious".$g} .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('fridayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('saturdayAbbr','c').'</b></td>';
			${"calendarStringPrevious".$g} .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('sundayAbbr','c').'</b></td></tr>';
			${"calendarStringPrevious".$g} .=  '<tr>';
			$i=1;
			while ($i<$erster) {
				${"calendarStringPrevious".$g} .=  '<td> </td>';
				$i++;
			}
			$i=1;
			while ($i<=$calendarTotal) {
				$rest=($i+$erster-1)%7;
				if($i==$nextDate){
					${"calendarStringPrevious".$g} .=  '<td style="font-size:90%; color:black;font-weight:bold;text-align:center;width:14.3%;background:#'.$color_schemes[$design2]['200'].'">';	
					${"calendarStringPrevious".$g} .=  $i;
				}
				else{
					${"calendarStringPrevious".$g} .=  '<td style="font-size:90%; text-align:center;width:14.3%">';
					if ($rest==6) {
						${"calendarStringPrevious".$g} .=  '<span style="color:#'.$color_schemes[$design2]['200'].'">'.$i.'</span>';
					} else if ($rest==0) {
						${"calendarStringPrevious".$g} .=  '<span style="color:#'.$color_schemes[$design2]['300'].'">'.$i.'</span>';
					} else {
						${"calendarStringPrevious".$g} .=  $i;
					}
				}
				${"calendarStringPrevious".$g} .=  "</td>\n";
				if ($rest==0) ${"calendarStringPrevious".$g} .=  "</tr>\n<tr>\n";
				$i++;
			}
			${"calendarStringPrevious".$g} .=  '</tr>';
			${"calendarStringPrevious".$g} .=  '</table>';
		}
		
		else{
			$erster=date('w',mktime(0,0,0,$nextMonth,1,$nextYear));
			$calendarTotal=date('t',mktime(0,0,0,$nextMonth,1,$nextYear));
			${"calendarStringPrevious".$g} .=  '<table style="text-align:center;font-size:80%;margin:0 auto;width:98%">';
			${"calendarStringPrevious".$g} .=  '<th colspan=7 style="text-align:center;font-size:140%; color:#'.$color_schemes[$design2]['300'].';">'.$monthsArray[$nextMonth-1].' '.$loadedYear.'</th>';
			${"calendarStringPrevious".$g} .=  '<tr><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('sundayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('mondayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('tuesdayAbbr','c').'</b></td>';
			${"calendarStringPrevious".$g} .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('wednesdayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('thursdayAbbr','c').'</b></td>';
			${"calendarStringPrevious".$g} .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('fridayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('saturdayAbbr','c').'</b></td>';
			${"calendarStringPrevious".$g} .=  '</tr>';
			${"calendarStringPrevious".$g} .=  '<tr>';
			$i=0;
			while ($i<$erster) {
				${"calendarStringPrevious".$g} .=  '<td> </td>';
				$i++;
			}
			$i=1;
			while ($i<=$calendarTotal) {
				$rest=($i+$erster)%7;	
				if($i==$nextDate){
					${"calendarStringPrevious".$g} .=  '<td style="font-size:90%; color:black;font-weight:bold;text-align:center;width:14.3%;background:#'.$color_schemes[$design2]['200'].'">';	
					${"calendarStringPrevious".$g} .=  $i;
				}
				else{
					${"calendarStringPrevious".$g} .=  '<td style="font-size:90%; text-align:center;width:14.3%">';			
					if ($rest==0) {
						${"calendarStringPrevious".$g} .=  '<span style="color:#'.$color_schemes[$design2]['300'].'">'.$i.'</span>';
					} else if ($rest==1) {
						${"calendarStringPrevious".$g} .=  '<span style="color:#'.$color_schemes[$design2]['200'].'">'.$i.'</span>';
					} else {
						${"calendarStringPrevious".$g} .=  $i;
					}
				}
				${"calendarStringPrevious".$g} .=  "</td>\n";
				if ($rest==0) ${"calendarStringPrevious".$g} .=  "</tr>\n<tr>\n";
				$i++;
			}
			${"calendarStringPrevious".$g} .=  '</tr>';
			${"calendarStringPrevious".$g} .=  '</table>';
		}
	}
	
	// next months
	
	for($g=1;$g<=$nextNumber;$g++){
		
		$nextMonth = date('m',strtotime('+'.$g.' months'));
		$nextYear = date('Y',strtotime('+'.$g.' months'));
		$nextDate = 35; // dummy day
	
		${"calendarStringNext".$g} = "";
		
		if($firstWeekday == 1){
			$erster=date('w',mktime(0,0,0,$nextMonth,1,$nextYear));
			$calendarTotal=date('t',mktime(0,0,0,$nextMonth,1,$nextYear));
			if ($erster==0) $erster=7;
			${"calendarStringNext".$g} .=  '<table style="text-align:center;font-size:80%;width:98%;margin:0 auto">';
			${"calendarStringNext".$g} .=  '<th colspan=7 style="text-align:center;font-size:140%; color:#'.$color_schemes[$design2]['200'].';">'.$monthsArray[$nextMonth-1].' '.$nextYear.'</th>';
			${"calendarStringNext".$g} .=  '<tr><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('mondayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('tuesdayAbbr','c').'</b></td>';
			${"calendarStringNext".$g} .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('wednesdayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('thursdayAbbr','c').'</b></td>';
			${"calendarStringNext".$g} .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('fridayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('saturdayAbbr','c').'</b></td>';
			${"calendarStringNext".$g} .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('sundayAbbr','c').'</b></td></tr>';
			${"calendarStringNext".$g} .=  '<tr>';
			$i=1;
			while ($i<$erster) {
				${"calendarStringNext".$g} .=  '<td> </td>';
				$i++;
			}
			$i=1;
			while ($i<=$calendarTotal) {
				$rest=($i+$erster-1)%7;
				if($i==$nextDate){
					${"calendarStringNext".$g} .=  '<td style="font-size:90%; color:black;font-weight:bold;text-align:center;width:14.3%;background:#'.$color_schemes[$design2]['200'].'">';	
					${"calendarStringNext".$g} .=  $i;
				}
				else{
					${"calendarStringNext".$g} .=  '<td style="font-size:90%; text-align:center;width:14.3%">';
					if ($rest==6) {
						${"calendarStringNext".$g} .=  '<span style="color:#'.$color_schemes[$design2]['200'].'">'.$i.'</span>';
					} else if ($rest==0) {
						${"calendarStringNext".$g} .=  '<span style="color:#'.$color_schemes[$design2]['300'].'">'.$i.'</span>';
					} else {
						${"calendarStringNext".$g} .=  $i;
					}
				}
				${"calendarStringNext".$g} .=  "</td>\n";
				if ($rest==0) ${"calendarStringNext".$g} .=  "</tr>\n<tr>\n";
				$i++;
			}
			${"calendarStringNext".$g} .=  '</tr>';
			${"calendarStringNext".$g} .=  '</table>';
		}
		
		else{
			$erster=date('w',mktime(0,0,0,$nextMonth,1,$nextYear));
			$calendarTotal=date('t',mktime(0,0,0,$nextMonth,1,$nextYear));
			${"calendarStringNext".$g} .=  '<table style="text-align:center;font-size:80%;margin:0 auto;width:98%">';
			${"calendarStringNext".$g} .=  '<th colspan=7 style="text-align:center;font-size:140%; color:#'.$color_schemes[$design2]['300'].';">'.$monthsArray[$nextMonth-1].' '.$loadedYear.'</th>';
			${"calendarStringNext".$g} .=  '<tr><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('sundayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('mondayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('tuesdayAbbr','c').'</b></td>';
			${"calendarStringNext".$g} .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('wednesdayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('thursdayAbbr','c').'</b></td>';
			${"calendarStringNext".$g} .=  '<td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('fridayAbbr','c').'</b></td><td style="color:#'.$color_schemes[$design2]['300'].'"><b>'.lang('saturdayAbbr','c').'</b></td>';
			${"calendarStringNext".$g} .=  '</tr>';
			${"calendarStringNext".$g} .=  '<tr>';
			$i=0;
			while ($i<$erster) {
				${"calendarStringNext".$g} .=  '<td> </td>';
				$i++;
			}
			$i=1;
			while ($i<=$calendarTotal) {
				$rest=($i+$erster)%7;	
				if($i==$nextDate){
					${"calendarStringNext".$g} .=  '<td style="font-size:90%; color:black;font-weight:bold;text-align:center;width:14.3%;background:#'.$color_schemes[$design2]['200'].'">';	
					${"calendarStringNext".$g} .=  $i;
				}
				else{
					${"calendarStringNext".$g} .=  '<td style="font-size:90%; text-align:center;width:14.3%">';			
					if ($rest==0) {
						${"calendarStringNext".$g} .=  '<span style="color:#'.$color_schemes[$design2]['300'].'">'.$i.'</span>';
					} else if ($rest==1) {
						${"calendarStringNext".$g} .=  '<span style="color:#'.$color_schemes[$design2]['200'].'">'.$i.'</span>';
					} else {
						${"calendarStringNext".$g} .=  $i;
					}
				}
				${"calendarStringNext".$g} .=  "</td>\n";
				if ($rest==0) ${"calendarStringNext".$g} .=  "</tr>\n<tr>\n";
				$i++;
			}
			${"calendarStringNext".$g} .=  '</tr>';
			${"calendarStringNext".$g} .=  '</table>';
		}
	}
?>
	<style>

	</style>
	<html>
	<body>
	<?php
		if($previousNumber>0){
			echo "<br>";
	?>
			<div style="width:100%" class="calendarMonthMore details">
				<?php
					for($g=$previousNumber;$g>=1;$g--){
						echo ${"calendarStringPrevious".$g};
						echo "<br>";
					}
				?>
			</div>
	<?php
		}
	?>
	<?php
		echo $calendarString;
	?>
	<?php
		if($nextNumber>0 || $previousNumber>0){
			echo "<br>";
	?>
			<div style="width:100%" class="calendarMonthMore details">
				<?php
					for($g=1;$g<=$nextNumber;$g++){
						echo ${"calendarStringNext".$g};
						echo "<br>";
					}
				?>
			</div>
			<span class="more" onclick="txt = $('.calendarMonthMore').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('.calendarMonthMore').slideToggle(800);$(this).text(txt)">
					<?php echo lang('more','l')?>
			</span>
	<?php
		}
	?>
	</body>
	</html>