<?php

	# 		Clock
	# 		Namespace:		clock
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	# 		v2.0 - Aug 03, 2016
	#			- complete redesign, new clock faces
	# 		v2.1 - Oct 05, 2016
	#			- bug fixes	
	# 		v2.2 - Nov 2, 2016
	#			- CSS optimization
	# 		v3.0 - Jun 12, 2017
	# 			- added possibility to show timezone
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}
	
	if($designNumber>0 && $designNumber<25){}
	else{
		$designNumber = 5;
	}
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$dateTimeZone = new DateTimeZone($stationTZ);
	$dateTime = new DateTime("now", $dateTimeZone);
	$offset = $dateTimeZone->getOffset($dateTime);
	$offset = $offset/3600;
	
	if($offset>0){
		$offsetClean = "UTC+".$offset;
	}
	else if($offset==0){
		$offsetCLean = "UTC";
	}
	else{
		$offsetClean = "UTC".$offset;
	}		
	
?>
	
	<script src="homepage/blocks/clock/js/jquery.rotate.js"></script>
	<script src="homepage/blocks/clock/js/jClocksGMT.js"></script>
	<link rel="stylesheet" href="homepage/blocks/clock/css/jClocksGMT.css">
	<style>
		
	</style>
	
	<div id="clockBlockDiv" style="margin:0 auto"></div>
	<?php 
		if($showTZ){
	?>
			<div style="font-size:0.7em;font-weight:bold"><?php echo $offsetClean?></div>
	<?php 
		}
	?>
	
	<script>
		$('#clockBlockDiv').jClocksGMT({ 
			title: '', 
			offset: '<?php echo $offset?>', 
			dst: false,
			digital: false,
			analog: true,
			timeformat: 'hh:mm A',
			date: false,
			dateformat: 'MM/DD/YYYY',
			skin: <?php echo $designNumber?>
		});
	</script>