/***************************************************************************************************************************************************************
 * NAME: jClocksGMT.js
 * VERSION: 2.0.2
 * LAST UPDATE: 2016.04.26

 * Plugin Website: http://www.github.com/mcmastermind/jClocksGMT
 * Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php
 *
 *
 
 * Modified for Meteotemplate, Jachym 2016
 **************************************************************************************************************************************************************/

 (function($) {

    $.fn.extend({
        
        jClocksGMT: function( options ) 
        {
            // plugin default options
            var defaults = 
            {
                title: 'Greenwich, England',
                offset: '0',
                dst: true,
                digital: true,
                analog: true,
                timeformat: 'hh:mm A',
                date: false,
                dateformat: 'MM/DD/YYYY',
                angleSec: 0,
                angleMin: 0,
                angleHour: 0,
                skin: 1,
                imgpath: ''
            }          
            // merge user options with defaults
            var options = $.extend(defaults, options);           
            return this.each(function()
            {
                var offset = parseFloat(options.offset);
                var id = $(this).attr('id');
                $(this).addClass('jcgmt-container');
                $("<div />", { text: options.title, class: "jcgmt-lbl" }).appendTo("#" + id);

                if( options.analog )
                {
                    $("<div />", { class: "jcgmt-clockHolder" }).appendTo("#" + id);
                    $("<div />", { class: "jcgmt-rotatingWrapper" }).append($("<img />", { class: "jcgmt-hour", src: options.imgpath + "homepage/blocks/clock/images/jcgmt-" + options.skin + "-clock_hour.png" })).appendTo("#" + id + ' .jcgmt-clockHolder');
                    $("<div />", { class: "jcgmt-rotatingWrapper" }).append($("<img />", { class: "jcgmt-min", src: options.imgpath + "homepage/blocks/clock/images/jcgmt-" + options.skin + "-clock_min.png" })).appendTo("#" + id + ' .jcgmt-clockHolder');
                    $("<div />", { class: "jcgmt-rotatingWrapper" }).append($("<img />", { class: "jcgmt-sec", src: options.imgpath + "homepage/blocks/clock/images/jcgmt-" + options.skin + "-clock_sec.png" })).appendTo("#" + id + ' .jcgmt-clockHolder');
                    $("<img />", { class: "jcgmt-clock", src: options.imgpath + 'homepage/blocks/clock/images/jcgmt-' + options.skin + '-clock_face.png' }).appendTo("#" + id + ' .jcgmt-clockHolder');
                }
                $("<div />", { class: "jcgmt-digital" }).appendTo("#" + id);
                $("<div />", { class: "jcgmt-date" }).appendTo("#" + id);
                $('#' + id + ' .jcgmt-sec').rotate( options.angleSec );
                $('#' + id + ' .jcgmt-min').rotate( options.angleMin );
                $('#' + id + ' .jcgmt-hour').rotate( options.angleHour );
                Date.prototype.getTimezoneByOffset = function( offset, y, m, d ) 
                {
                    var date = new Date; 
                    if( y )
                    {
                        date = new Date( y, m, d );
                    }
                    var utc = date.getTime() + ( date.getTimezoneOffset() * 60000 );
                    var dateGMT = new Date( utc + ( 3600000 * offset ) );
                    return dateGMT;
                }
                Date.prototype.stdTimezoneOffset = function(){
                    var jan = this.getTimezoneByOffset( offset, this.getFullYear(), 0, 1 );

                    var jul = this.getTimezoneByOffset( offset, this.getFullYear(), 6, 1 );

                    return Math.max( jan.getTimezoneOffset(), jul.getTimezoneOffset() );
                }
                Date.prototype.isDST = function(){
                    var date = this.getTimezoneByOffset(offset);
                    return date.getTimezoneOffset() < this.stdTimezoneOffset();
                }
                Date.prototype.format = function( format ){
                    var D = "Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday".split(","),
                        M = "January,February,March,April,May,June,July,August,September,October,November,December".split(",");

                    var self = this;
                    return format.replace(/a|A|Z|S(SS)?|ss?|mm?|HH?|hh?|D{1,4}|M{1,4}|YY(YY)?|'([^']|'')*'/g, function(str) {
                      var c1 = str.charAt(0),
                          ret = str.charAt(0) == "'"
                          ? (c1=0) || str.slice(1, -1).replace(/''/g, "'")
                          : str == "a"
                            ? (self.getHours() < 12 ? "am" : "pm")
                            : str == "A"
                              ? (self.getHours() < 12 ? "AM" : "PM")
                              : str == "Z"
                                ? (("+" + -self.getTimezoneOffset() / 60).replace(/^\D?(\D)/, "$1").replace(/^(.)(.)$/, "$10$2") + "00")
                                : c1 == "S"
                                  ? self.getMilliseconds()
                                  : c1 == "s"
                                    ? self.getSeconds()
                                    : c1 == "H"
                                      ? self.getHours()
                                      : c1 == "h"
                                        ? (self.getHours() % 12) || 12
                                        : (c1 == "D" && str.length > 2)
                                          ? D[self.getDay()].slice(0, str.length > 3 ? 9 : 3)
                                          : c1 == "D"
                                            ? self.getDate()
                                            : (c1 == "M" && str.length > 2)
                                              ? M[self.getMonth()].slice(0, str.length > 3 ? 9 : 3)
                                              : c1 == "m"
                                                ? self.getMinutes()
                                                : c1 == "M"
                                                  ? self.getMonth() + 1
                                                  : ("" + self.getFullYear()).slice(-str.length);
                      return c1 && str.length < 4 && ("" + ret).length < str.length
                        ? ("00" + ret).slice(-str.length)
                        : ret;
                    });
                  }
                var dateCheck = new Date().getTimezoneByOffset( offset );
                if( options.dst && dateCheck.isDST() ) 
                {
                   offset = offset + 1;
                }
                setInterval(function () 
                {
                    var nd = new Date().getTimezoneByOffset( offset ); 
                    var timeStr = nd.format( options.timeformat );
                    if( options.analog ){
                        $('#' + id + ' .jcgmt-sec').rotate( nd.getSeconds() * 6 );
                        $('#' + id + ' .jcgmt-min').rotate( nd.getMinutes() * 6 ) ;
                        $('#' + id + ' .jcgmt-hour').rotate( ( nd.getHours() * 5 + nd.getMinutes() / 12 ) * 6 );
                        $('#' + id + ' .jcgmt-clockHolder').attr( 'title', timeStr );
                    }
                    if( options.digital ){
                        $('#' + id + ' .jcgmt-digital').html( timeStr );
                        $('#' + id + ' .jcgmt-digital').attr( 'title', timeStr );
                    }
                    if( options.date ){
                        var dateStamp = nd.format( options.dateformat );
                        $('#' + id + ' .jcgmt-date').html( dateStamp );
                        $('#' + id + ' .jcgmt-date').attr( 'title', dateStamp );
                    }

                }, 1000);

            });

        }

    });

})(jQuery);
