<?php

	# 		Digital Clock
	# 		Namespace:		clockDigital
	#		Meteotemplate Block
	
	# 		v1.1 - Oct 05, 2016
	#			- bug fixes
	# 		v2.0 - Feb 4, 2017
	#			- added possibility to show UTC offset
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}	
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$dateTimeZone = new DateTimeZone($stationTZ);
	$dateTime = new DateTime("now", $dateTimeZone);
	$offset = $dateTimeZone->getOffset($dateTime);
	$offset = $offset/3600;

	if($offset>0){
		$offsetClean = "UTC+".$offset;
	}
	else if($offset==0){
		$offsetCLean = "UTC";
	}
	else{
		$offsetClean = "UTC".$offset;
	}
	
?>
	<style>
		#digitalClockDiv {
			font-family: <?php echo $fontType?>, Arial, Helvetica, sans-serif;
			font-size: 1.4em;
			text-align: center;
			<?php
				if($textBold){
					echo "font-weight:bold;";
				}
				if($textItalics){
					echo "font-style: italic;";
				}
				if($theme=="dark"){
					echo "color: ".$darkThemeColor.";";
				}
				if($theme=="light"){
					echo "color: ".$lightThemeColor.";";
				}
			?>
		}

	</style>
	<div id="digitalClockDiv">
	<?php 
		if($showDate){
	?>	
		<div id="digitalClockDivDate"></div>
	<?php
		}
	?>
		<div id="digitalClockDivTime"></div>
		<?php 
			if($showTZ){
		?>
				<div style="font-size:0.7em;font-weight:bold"><?php echo $offsetClean?></div>
		<?php 
			}
		?>
	</div>
	<script type="text/javascript">
		$(document).ready(function() {
			now = new Date;
			var current = now.getTime();
			tz = now.getTimezoneOffset()/60;
			current = current + (60*60*1000)*(<?php echo $offset?>+tz);
			var newDate = new Date();
			newDate.setTime(current);
			$('#digitalClockDivDate').html(newDate.toLocaleDateString());
			$('#digitalClockDivTime').html(newDate.toLocaleTimeString());
			setInterval( function() {
				now = new Date;
				var current = now.getTime();
				current = current + (60*60*1000)*(<?php echo $offset?>+tz);
				var newDate = new Date();
				newDate.setTime(current);
				$('#digitalClockDivDate').html(newDate.toLocaleDateString());
				$('#digitalClockDivTime').html(newDate.toLocaleTimeString());
			},1000);
		});
	</script>
	
