<?php

	# 		Cloud Temperature
	# 		Namespace:		cloudTemp
	#		Meteotemplate Block
	
	# 		Version 1.1 - Jan 29, 2016
	#		- added responsiveness
	
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}
	
	$result = mysqli_query($con,"
		SELECT T, D
		FROM alldata 
		ORDER BY DateTime DESC
		LIMIT 1
		"
	);
	while($row = mysqli_fetch_array($result)){
		$T = $row['T'];
		$D = $row['D'];
	}
	
	$spread = abs($T-$D);
	if($dataTempUnits=="C"){
		$feetHeight = $spread / 2.5 * 1000;		
		$tempC = $T;
	}
	if($dataTempUnits=="F"){
		$feetHeight = $spread / 4.4 * 1000;
		$tempC = ($T-32)/1.8;
	}
	$mHeight = $feetHeight * 0.3048;
	
	$cloudTempC = $tempC - ($mHeight * 0.00984) ;
	$cloudTempF = ($cloudTempC*1.8) + 32;
	
?>
	<style>
		
	</style>
	<div style="width:98%;margin: 0 auto;">
		<?php
			if($cloudTempHeading){
		?>
				<h2><?php echo lang('cloud temperature','c')?></h2>
		<?php
			}
		?>
		<table style="width:100%">
			<tr>
				<td style="text-align:left;width:33.3%">
					<img src="homepage/blocks/cloudTemp/icons/<?php echo $theme?>/cloudTemp.png" style="padding-left: 10%;max-width:25px;width:100%">
				</td>
				<td style="text-align:center;width:33.3%">
					<?php echo number_format($cloudTempC,1,".","")?> °C
				</td>
				<td style="text-align:center;width:33.3%">
					<?php echo number_format($cloudTempF,1,".","")?> °F
				</td>
			</tr>
		</table>
		<div style="width:98%;text-align:justify;font-size:0.9em;margin:0 auto" class="details" id="cloudTempDetails">
			<p>
				The cloud temperature is estimated from the current temperature and dew point, assuming that the air temperature drops 9.84&deg;C per 1000 m of altitude. First the cloud height is estimated from current air temperature and dew point. The obtained height is converted from feet to meters, then multiplied by the factor of 0.00984, which is the decrease in temperature per 1m height and finally the difference is subtracted from the air temperature to get the cloud temperature estimate.
			</p>
			<p>
				<div style="margin:0 auto;text-align:center">
					<i>Ct = T - (((T - D) / 2.5) * 1000 * 0.3048 * 0.00984)</i>
				</div>
				<span style="font-size:0.8em">Ct - cloud temperature [&deg;C]</span><br />
				<span style="font-size:0.8em">T - air temperature [&deg;C]</span><br />
				<span style="font-size:0.8em">D - dew point [&deg;C]</span><br />
			</p>

		</div>
		<span class="more" onclick="txt = $('#cloudTempDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#cloudTempDetails').slideToggle(800);$(this).text(txt)">
			<?php echo lang('more','l')?>
		</span>
	</div>
	
