<?php
	
	# 		CO2 block
	# 		Namespace:		co2
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	#		v2.0 - Aug 05, 2016
	#			- added table with past values
	#			- added percentage differences
	#		v2.1 - Mar 25, 2017
	#			- translation improvements
	#		v2.2 - Jun 21, 2017
	#			- changes due to changed data source
	#		v2.3 - Jun 22, 2017
	#			- changes due to changed data source
	#		v3.0 - Oct 10, 2017
	#			- optimization
	# 			- CSS tweaks
	
	$co2Cache = 60 * 24;
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	createCacheDir();

	if(file_exists("cache/co2.txt")){
		if (time()-filemtime("cache/co2.txt") > 60 * $co2Cache) {
			unlink("cache/co2.txt");
		}
	}

	if(file_exists("cache/co2.txt")){
		$co2Data = file_get_contents("cache/co2.txt");
	}
	else { 
		$url = "ftp://aftp.cmdl.noaa.gov/products/trends/co2/co2_weekly_mlo.txt";
		$co2Data = loadContent($url,10);
		if($co2Data==""){
		}
		else{
			$cached = fopen("cache/co2.txt", "w");
			fwrite($cached, $co2Data);
			fclose($cached);
		}
	}
		
	// read weekly data formatted
	$co2Data = fopen("cache/co2.txt", "r");
	while(!feof($co2Data)) {
		$row = fgets($co2Data);
		if($row[0]!="#" && strlen($row)>1){
			$co2DataClean [] = preg_split('/\s+/', trim($row));
			$temporaryRow = preg_split('/\s+/', trim($row));
			if($temporaryRow[4]!=-999.99){
				$levels[$temporaryRow[0]] = $temporaryRow[4];
			}
		}
	}
	fclose($co2Data);
	
	unset($levels[1974]); // delete the first one which is not a complete yr of data
		
	array_walk_recursive($co2DataClean, 'removeUnknown');
	
	$output['currentCO2'] = $co2DataClean[(count($co2DataClean)-1)][4];
	$output['yrAgoCO2'] = $co2DataClean[(count($co2DataClean)-1)][6];
	$output['yr10AgoCO2'] = $co2DataClean[(count($co2DataClean)-1)][7];
	$output['increase1800CO2'] = $co2DataClean[(count($co2DataClean)-1)][8];
	
	function removeUnknown(&$item, $key){
		if($item<0){
			$item = "";
		}
	}
	
?>					
	<table style="width:98%;margin:0 auto; font-variant:small-caps"> 
		<tr>
			<td style="width:30%">
				<span style="font-size:3em" alt='' class="mticon-co2 tooltip" title="CO2">
			</td>
			<td style="width:20%" id="currentCO2TD">
				<?php
					if($theme=="dark"){
				?>
						<div style="font-weight:bold;font-size:130%;color:#<?php echo $color_schemes[$design2]['200']?>">
							<?php echo $output['currentCO2']?><br>ppm
						</div>
				<?php
					}
				?>
				<?php
					if($theme=="light"){
				?>
						<div style="font-weight:bold;font-size:130%;color:#<?php echo $color_schemes[$design2]['700']?>">
							<?php echo $output['currentCO2']?><br>ppm
						</div>
				<?php
					}
				?>
			</td>
			<td style="width:25%">
				<span style="font-weight:bold;font-size:110%"><?php echo $output['yrAgoCO2']?></span><br><span style="font-weight:bold;font-size:75%"><?php echo round((($output['yrAgoCO2']-$output['currentCO2'])/$output['currentCO2'])*100,2)?> %</span><br><?php echo lang('year ago','l')?>
			</td>
			<td style="width:25%">
				<span style="font-weight:bold;font-size:110%"><?php echo $output['yr10AgoCO2']?></span><br><span style="font-weight:bold;font-size:75%"><?php echo round((($output['yr10AgoCO2']-$output['currentCO2'])/$output['currentCO2'])*100,2)?> %</span><br><?php echo lang('10 years ago','l')?>
			</td>
		</tr>
	</table>
	<div style="width:100%" class="details" id="co2BlockMore">
		<br>
		<table style="width:98%;margin:0 auto" class="table">
			<thead>
				<tr>
					<th style='width:30%;padding-left:7px!important'>
						<?php echo lang('year','c')?>
					</th>
					<th style='width:35%' colspan="2">
						<?php echo str_replace("2","<sub>2</sub>",lang('CO2','c'))?>*<br>ppm
					</th>
				</tr>
			</thead>
			<tbody>
				<?php
					foreach($levels as $year=>$level){
						if(($year%5==0 || $year>2010)&& $year!=date('Y')){
				?>
							<tr>
								<td>
									<?php echo $year?>
								</td>
								<td>
									<?php echo ($level)?>
								</td>
								<td style="text-align:right">
									<?php 
										$diff = number_format((($level-$output['currentCO2'])/$output['currentCO2'])*100,2,".","")." %";
										echo $diff;
									?>
								</td>
							</tr>
				<?php
						}
					}
				?>
			</tbody>
		</table>
		<div style="text-align:left;padding-left:10px;font-size:0.7em;padding-top:2px">* 31 <?php echo lang('december','c')?></div>
	</div>
	<span class="more" onclick="txt = $('#co2BlockMore').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#co2BlockMore').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>