<?php

	# 		UK - Current Conditions
	# 		Namespace:		currentUK
	#		Meteotemplate Block

	# 		v1.0 - Jan 9, 2016
	#			- initial release
	# 		v2.0 - Nov 3, 2017
	#			- optimization
	# 			- CSS tweaks

	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "First you need to go to your admin panel and use the blocks settings section to create the settings file.";
		die;
	}

	// MetOffice Weather Codes
	// http://www.metoffice.gov.uk/datapoint/support/documentation/code-definitions

	$weatherCode['NA'] = "N/A";
	$weatherCode[0] = "Clear night";
	$weatherCode[1] = "Sunny day";
	$weatherCode[2] = "Partly cloudy day";
	$weatherCode[3] = "Partly cloudy night";
	$weatherCode[4] = "N/A";
	$weatherCode[5] = "Mist";
	$weatherCode[6] = "Fog";
	$weatherCode[7] = "Cloudy";
	$weatherCode[8] = "Overcast";
	$weatherCode[9] = "Light rain shower (night)";
	$weatherCode[10] = "Light rain shower (day)";
	$weatherCode[11] = "Drizzle";
	$weatherCode[12] = "Light rain";
	$weatherCode[13] = "Heavy rain shower (night)";
	$weatherCode[14] = "Heavy rain shower (day)";
	$weatherCode[15] = "Heavy rain";
	$weatherCode[16] = "Sleet shower (night)";
	$weatherCode[17] = "Sleet shower (day)";
	$weatherCode[18] = "Sleet";
	$weatherCode[19] = "Hail shower (night)";
	$weatherCode[20] = "Hail shower (day)";
	$weatherCode[21] = "Hail";
	$weatherCode[22] = "Light snow shower (night)";
	$weatherCode[23] = "Light snow shower (day)";
	$weatherCode[24] = "Light snow";
	$weatherCode[25] = "Heavy snow shower (night)";
	$weatherCode[26] = "Heavy snow shower (day)";
	$weatherCode[27] = "Heavy snow shower";
	$weatherCode[28] = "Thunder shower (night)";
	$weatherCode[29] = "Thunder shower (day)";
	$weatherCode[30] = "Thunder";

	createCacheDir();

	if(file_exists("cache/currentUKCache.txt")){
		if (time()-filemtime("cache/currentUKCache.txt") > 60 * 60) {
			unlink("cache/currentUKCache.txt");
		}
	}
	if(file_exists("cache/currentUKCache.txt")){
		$dataRaw = file_get_contents("cache/currentUKCache.txt");
	}
	else {
		$dataURL = "http://datapoint.metoffice.gov.uk/public/data/val/wxobs/all/json/all?res=hourly&key=".$metOfficeAPI;
		$dataRaw = file_get_contents($dataURL);
		if($dataRaw==""){
			$dataRaw = curlMain($dataURL,5);
		}
		if($dataRaw!=""){
			file_put_contents("cache/currentUKCache.txt",$dataRaw);
		}
	}

	$dataJSON = json_decode($dataRaw,true);

	// load parameters
	if(isset($dataJSON['SiteRep']['Wx']['Param'])){
		foreach($dataJSON['SiteRep']['Wx']['Param'] as $oneParameter){
			$parameters[] = $oneParameter;
		}
	}

	// load most recent data
	if(isset($dataJSON['SiteRep']['DV']['Location'])){
		foreach($dataJSON['SiteRep']['DV']['Location'] as $oneStation){
			$stationsData[] = $oneStation;
		}
	}

	function sorter($a, $b) {
	  return $a['name'] > $b['name'];
	}

	if(isset($stationsData)){
		usort($stationsData, "sorter");
	}

?>
	<link rel="stylesheet" href="homepage/blocks/currentUK/leaflet.css" />
	<script src="homepage/blocks/currentUK/leaflet.js"></script>
	<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/jquery.tablesorter.js"></script>

	<style>
		.sort{
			width: 15px;
			cursor: pointer;
			opacity: 0.8;
		}
		.sort:hover{
			opacity: 1;
		}
		.currentUKTH{
			font-size: 1.4em;
			vertical-align:top;
		}
		.currentUKTD{
			width:5%;
		}
		.currentUKLocation{
			display: inline-block;
			padding: 5px;
			width: 100px;
			vertical-align: top;
		}
		#currentUKMap{
			z-index: 10;
		}
		<?php
			if($theme=="light"){
		?>
				#currentUKTable th{
					background: #<?php echo $color_schemes[$design2]['800']?>;
				}
				#currentUKMap{
					border: 1px solid #<?php echo $color_schemes[$design2]['800']?>;
				}
		<?php
			}
		?>
		<?php
			if($theme=="dark"){
		?>
				#currentUKMap{
					border: 1px solid #<?php echo $color_schemes[$design2]['200']?>;
				}
		<?php
			}
		?>
	</style>
	<img src="<?php echo $pageURL.$path?>imgs/<?php echo $flagIconShape?>/big/gb.png" style="width:50px">
	<h2><?php echo lang('current conditions','c')?></h2>
	<?php
		if(isset($stationsData)){
	?>
			<div id="currentUKMap" style="width: 98%; height: <?php echo $ukMapHeight?>px; margin: 0 auto"></div>
			<div id="currentUKDetails" style="width:98%;margin:0 auto" class="details">
				<br />
				<table style="width:98%;margin: 0 auto" class="table" id="currentUKTable">
					<thead>
						<tr>
							<th>

							</th>
							<th>
								<span class="mticon-time currentUKTH"></span>
							</th>
							<th>
								<span class="mticon-temp currentUKTH"></span><br />&deg;C
							</th>
							<th>
								<span class="mticon-humidity currentUKTH"></span><br />%
							</th>
							<th>
								<span class="mticon-pressure currentUKTH"></span><br />hPa
							</th>
							<th>
								<span class="mticon-wind currentUKTH"></span><br />mph
							</th>
							<th>
								<span class="mticon-gust currentUKTH"></span><br />mph
							</th>
							<th>
								<span class="mticon-compass currentUKTH"></span>
							</th>
							<th>
								<span class="mticon-dewpoint currentUKTH"></span><br />&deg;C
							</th>
							<th>
								<span class="mticon-weather currentUKTH"></span>
							</th>
							<th>
								<span class="mticon-elevation currentUKTH"></span><br />m
							</th>
						</tr>
						<tr>
							<th style="text-align:center">
								<span class="fa fa-sort sort"></span>
							</th>
							<th>
								<span class="fa fa-sort sort"></span>
							</th>
							<th>
								<span class="fa fa-sort sort"></span>
							</th>
							<th>
								<span class="fa fa-sort sort"></span>
							</th>
							<th>
								<span class="fa fa-sort sort"></span>
							</th>
							<th>
								<span class="fa fa-sort sort"></span>
							</th>
							<th>
								<span class="fa fa-sort sort"></span>
							</th>
							<th>
								<span class="fa fa-sort sort"></span>
							</th>
							<th>
								<span class="fa fa-sort sort"></span>
							</th>
							<th>
								<span class="fa fa-sort sort"></span>
							</th>
							<th>
								<span class="fa fa-sort sort"></span>
							</th>
						</tr>
					</thead>
					<tbody>
					<?php
						foreach($stationsData as $station){
							$latestDay = strtotime($station['Period'][(count($station['Period'])-1)]['value']);
							if(date("Ymd",$latestDay)==date("Ymd",strtotime("today")) || date("Ymd",$latestDay)==date("Ymd",strtotime("yesterday"))){
								$latestObs = $station['Period'][(count($station['Period'])-1)]['Rep'][(count($station['Period'][(count($station['Period'])-1)]['Rep'])-1)];
							}
					?>
							<tr>
								<td style="text-align:left;font-weight:bold">
									<?php echo ucwords(strtolower($station['name'])).", ".ucwords(strtolower($station['country']))?>
								</td>
								<td style="font-size:0.8em">
									<?php
										$obsTime = $latestDay + $latestObs['$']*60;
										echo date($dateTimeFormat,$obsTime);
									?>
								</td>
								<td class="currentUKTD">
									<?php if(isset($latestObs['T'])){ echo $latestObs['T']; }?>
								</td>
								<td class="currentUKTD">
									<?php echo $latestObs['H']?>
								</td>
								<td class="currentUKTD">
									<?php echo $latestObs['P']?>
								</td>
								<td class="currentUKTD">
									<?php echo $latestObs['S']?>
								</td>
								<td class="currentUKTD">
									<?php echo $latestObs['G']?>
								</td>
								<td class="currentUKTD">
									<?php echo $latestObs['D']?>
								</td>
								<td class="currentUKTD">
									<?php echo $latestObs['Dp']?>
								</td>
								<td style="font-size:0.8em">
									<?php echo $weatherCode[$latestObs['W']]?>
								</td>
								<td class="currentUKTD">
									<?php echo $station['elevation']?>
								</td>
							</tr>
					<?php
						}
					?>
					</tbody>
				</table>
			</div>
			<span class="more" onclick="txt = $('#currentUKDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#currentUKDetails').slideToggle(800);$(this).text(txt)">
				<?php echo lang('more','l')?>
			</span>
	<?php
		}
		else{
			echo lang("data currently not available",'c');
		}
	?>

	<div style="width:90%;margin:0 auto;font-size:0.8em;font-variant:small-caps;text-align:center">
		<?php echo lang('data source','c')?>: MetOffice
	</div>
	<script>
		$(function(){
			$("#currentUKTable").tablesorter();
			var mymap = L.map('currentUKMap').setView([54, -4], 5);
			L.tileLayer('http://{s}.tiles.wmflabs.org/bw-mapnik/{z}/{x}/{y}.png', {
			    attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>',
				maxZoom: 18
			}).addTo(mymap);
			<?php
				$i = 0;
				foreach($stationsData as $station){
					$latestDay = strtotime($station['Period'][(count($station['Period'])-1)]['value']);
					if(date("Ymd",$latestDay)==date("Ymd",strtotime("today")) || date("Ymd",$latestDay)==date("Ymd",strtotime("yesterday"))){
						$latestObs = $station['Period'][(count($station['Period'])-1)]['Rep'][(count($station['Period'][(count($station['Period'])-1)]['Rep'])-1)];
					}
			?>
			var icon = L.icon({
				iconUrl: '<?php echo $pageURL.$path?>homepage/blocks/currentUK/imgs/marker.png',
				//shadowUrl: '',
				iconSize:     [10, 10],
				//shadowSize:   [50, 64],
				iconAnchor:   [0, 0],
				//shadowAnchor: [4, 62],
				popupAnchor:  [0, -5]
			});
					var marker<?php echo $i?> = L.marker(
						[<?php echo $station['lat']?>, <?php echo $station['lon']?>],
						{
							icon: icon
						}
					).addTo(mymap);
					marker<?php echo $i?>.bindPopup("<?php echo ucwords(strtolower($station['name']))."<br />"."<span class='mticon-temp'></span>: ".$latestObs['T']."&deg;C<br />"."<span class='mticon-humidity'></span>: ".$latestObs['H']."%<br />"."<span class='mticon-pressure'></span>: ".$latestObs['P']."hPa<br />"."<span class='mticon-wind'></span>: ".$latestObs['S']."mph<br />"."<span class='mticon-gust'></span>: ".$latestObs['G']."mph<br />"."<span class='mticon-dewpoint'></span>: ".$latestObs['Dp']."&deg;C<br />"."<span class='mticon-elevation'></span>: ".$station['elevation']." m"?>");
			<?php
					$i++;
				}
			?>
		});
	</script>
