<?php

	# 		Day/night block
	# 		Namespace:		dayNight
	#			Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#				- added responsiveness
	#				- bug fixes
	# 		v2.0 - Nov 28, 2017
	#				- translation tweaks
	# 			- optimization
	
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$stationTimezone = new DateTimeZone($stationTZ);
	$stationOffset  = $stationTimezone->getOffset(new DateTime)/3600;
	
	$sunRiseTS = date_sunrise((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,($stationOffset));
	$sunSetTS = date_sunset((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,($stationOffset));
	
	if(time()<$sunRiseTS){
		$icon = "sunrise";
		$timeNext = $sunRiseTS;
	}
	if(time()>=$sunRiseTS && time()<=$sunSetTS){
		$icon = "sunset";
		$timeNext = $sunSetTS;
	}
	if(time()>$sunSetTS){
		$icon = "sunrise";
		$timeNext = date_sunrise((strtotime('tomorrow')+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,($stationOffset));
	}
	
	$remaining = dateDiff(time(),$timeNext);
	
	function dateDiff($time1, $time2, $precision = 6) {
		if (!is_int($time1)) {
		  $time1 = strtotime($time1);
		}
		if (!is_int($time2)) {
		  $time2 = strtotime($time2);
		}
		if ($time1 > $time2) {
		  $ttime = $time1;
		  $time1 = $time2;
		  $time2 = $ttime;
		}
		$intervals = array('year','month','day','hour','minute','second');
		$diffs = array();
		foreach ($intervals as $interval) {
		  $ttime = strtotime('+1 ' . $interval, $time1);
		  $add = 1;
		  $looped = 0;
		  while ($time2 >= $ttime) {
			$add++;
			$ttime = strtotime("+" . $add . " " . $interval, $time1);
			$looped++;
		  }
		  $time1 = strtotime("+" . $looped . " " . $interval, $time1);
		  $diffs[$interval] = $looped;
		}
		$count = 0;
		$times = array();
		foreach ($diffs as $interval => $value) {
		  if ($count >= $precision) {
			break;
		  }
		  if ($value > 0) {
			$times[] = $value . " " . $interval;
			$count++;
		  }
		}
		$result = implode(" ", $times);
		$result = str_replace("year","y",$result);
		$result = str_replace("month","m",$result);
		$result = str_replace("day","d",$result);
		$result = str_replace("hour",lang('hAbbr','l'),$result);
		$result = str_replace("minute",lang('minAbbr','l'),$result);
		$result = str_replace("second","s",$result);
		return $result;
	}
?>
	<style>
		.dayNightIcon{
			margin-top: 5px;
			font-size: 3em;
		}
	</style>
	
	<table style="width:80%;margin:0 auto">
		<tr>
			<td style="width:50%;text-align:center" rowspan="2">
				<span class="mticon-<?php echo $icon?> dayNightIcon">
			</td>
			<td style="width:50%;text-align:center">
				<span style="font-weight:bold;font-size:120%"><?php echo date($timeFormat,$timeNext)?></span>
			</td>
		</tr>
		<tr>
			<td style="width:50%;text-align:center" rowspan="2">
				<?php echo $remaining?>
			</td>
		</tr>
	</table>
	
