<?php

	# 		Database Information
	# 		Namespace:		dbInfo
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	# 		v2.0 - Mar 23, 2017
	# 			- added last record date
	#    		- major optimization
	#  			- CSS tweaks
	# 		v3.0 - Jul 20, 2017
	# 			- redesign
	# 			- added logged parameters
	# 			- implementation of extra alldata table
	# 		v3.1 - Jul 27, 2017
	# 			- improved extra sensor data checking
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$result = mysqli_query($con, "
			SELECT DateTime
			FROM  alldata
			ORDER BY DateTime
			LIMIT 1
			"
	);
	while ($row = mysqli_fetch_array($result)) {
		$firstRecord = strtotime($row['DateTime']);
	}
	$result = mysqli_query($con, "
			SELECT DateTime
			FROM  alldata
			ORDER BY DateTime DESC
			LIMIT 1
			"
	);
	while ($row = mysqli_fetch_array($result)) {
		$lastRecord = strtotime($row['DateTime']);
	}
	$result = mysqli_query($con, "
			SELECT Count(DateTime)
			FROM  alldata
			ORDER BY DateTime			
			"
	);
	while ($row = mysqli_fetch_array($result)) {
		$records = $row['Count(DateTime)'];
	}

		// check extra table
	$result = mysqli_query($con, "SHOW TABLES LIKE 'alldataExtra'");
	$tableExists = mysqli_num_rows($result) > 0;

	$extraCols = array();

	if($tableExists){
		$result = mysqli_query($con, "SHOW COLUMNS FROM alldataExtra");
		while ($row = mysqli_fetch_array($result)) {
			$extraCols[] = $row['Field'];
		}
	}

	function dateDiff($time1, $time2, $precision = 6) {
		if (!is_int($time1)) {
		  $time1 = strtotime($time1);
		}
		if (!is_int($time2)) {
		  $time2 = strtotime($time2);
		}
		if ($time1 > $time2) {
		  $ttime = $time1;
		  $time1 = $time2;
		  $time2 = $ttime;
		}
		$intervals = array('year','month','day','hour','minute','second');
		$diffs = array();
		foreach ($intervals as $interval) {
		  $ttime = strtotime('+1 ' . $interval, $time1);
		  $add = 1;
		  $looped = 0;
		  while ($time2 >= $ttime) {
			$add++;
			$ttime = strtotime("+" . $add . " " . $interval, $time1);
			$looped++;
		  }
		  $time1 = strtotime("+" . $looped . " " . $interval, $time1);
		  $diffs[$interval] = $looped;
		}
		$count = 0;
		$times = array();
		foreach ($diffs as $interval => $value) {
		  if ($count >= $precision) {
			break;
		  }
		  if ($value > 0) {
			$times[] = $value . " " . $interval;
			$count++;
		  }
		}
		$result = implode(" ", $times);
		$result = str_replace("year","y",$result);
		$result = str_replace("month","m",$result);
		$result = str_replace("day","d",$result);
		$result = str_replace("hour",lang('hAbbr','l'),$result);
		$result = str_replace("minute",lang('minAbbr','l'),$result);
		$result = str_replace("second","s",$result);
		return $result;
	}


	
?>
	<style>
		.dbInfoIcon{
			font-size: 2em;
			padding: 2px;
		}
	</style>
	<h2><?php echo lang('database','c')?></h2>
	<table style="width:100%;padding:7%">
		<tr>
			<td style="text-align:left;padding-left:5px">
				<span class="fa fa-hourglass-start" style="font-size:1.5em"></span>
			</td>
			<td style="text-align:right;padding-right:5px">
				<?php echo date($dateTimeFormat,$firstRecord)?>
			</td>
		</tr>
		<tr>
			<td style="text-align:left;padding-left:5px">
				<span class="fa fa-hourglass-end" style="font-size:1.5em"></span>
			</td>
			<td style="text-align:right;padding-right:5px">
				<?php echo date($dateTimeFormat,$lastRecord)?>
			</td>
		</tr>
		<tr>
			<td style="text-align:left;padding-left:5px">
				<span class="fa fa-clock-o" style="font-size:1.5em"></span>
			</td>
			<td style="text-align:right;padding-right:5px">
				<?php echo dateDiff($firstRecord, $lastRecord)?>
			</td>
		</tr>
		<tr>
			<td style="text-align:left;padding-left:5px">
				<span class="fa fa-database" style="font-size:1.5em"></span>
			</td>
			<td style="text-align:right;padding-right:5px">
				<?php echo $records?> <?php echo lang('measurements','l')?>
			</td>
		</tr>
	</table>
	<div id="dbInfoDetails" class="details" style="width:98%;margin:0 auto">
		<h2 style="padding-left: 10px;text-align:left;padding-bottom:10px"><?php echo lang('database','c')?></h2>
		<table class="table" style="width:98%;margin:0 auto; font-size: 0.8em">
			<tr>
				<td>
					<span class="mticon-temp dbInfoIcon"></span>
				</td>
				<td style="text-align:left">
					<?php echo lang('temperature','c')?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-humidity dbInfoIcon"></span>
				</td>
				<td style="text-align:left">
					<?php echo lang('relative humidity','c')?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-pressure dbInfoIcon"></span>
				</td>
				<td style="text-align:left">
					<?php echo lang('pressure','c')?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-wind dbInfoIcon"></span>
				</td>
				<td style="text-align:left">
					<?php echo lang('wind speed','c')?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-gust dbInfoIcon"></span>
				</td>
				<td style="text-align:left">
					<?php echo lang('wind gust','c')?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-winddirection dbInfoIcon"></span>
				</td>
				<td style="text-align:left">
					<?php echo lang('wind direction','c')?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-rain dbInfoIcon"></span>
				</td>
				<td style="text-align:left">
					<?php echo lang('precipitation','c')?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-rain dbInfoIcon"></span>
				</td>
				<td style="text-align:left">
					<?php echo lang('rain rate','c')?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-dewpoint dbInfoIcon"></span>
				</td>
				<td style="text-align:left">
					<?php echo lang('dew point','c')?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-apparent dbInfoIcon"></span>
				</td>
				<td style="text-align:left">
					<?php echo lang('apparent temperature','c')?>
				</td>
			</tr>
			<?php 
				if($solarSensor){
			?>
					<tr>
						<td>
							<span class="mticon-sun dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('solar radiation','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				if(in_array("UV", $extraCols)){
			?>
					<tr>
						<td>
							<span class="mticon-uv dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							UV
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				if(in_array("TIN", $extraCols)){
			?>
					<tr>
						<td>
							<span class="mticon-indoortemp dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('indoor temperature','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				if(in_array("HIN", $extraCols)){
			?>
					<tr>
						<td>
							<span class="mticon-indoorhumidity dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('indoor humidity','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				if(in_array("SS", $extraCols)){
			?>
					<tr>
						<td>
							<span class="mticon-sun dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('sunshine hours','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				if(in_array("SN", $extraCols)){
			?>
					<tr>
						<td>
							<span class="mticon-snowfall dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('snowfall','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				if(in_array("SD", $extraCols)){
			?>
					<tr>
						<td>
							<span class="mticon-snowdepth dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('snow depth','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				if(in_array("NL", $extraCols)){
			?>
					<tr>
						<td>
							<span class="fa fa-volume-up dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('noise level','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				$sensor['TS'] = false;
				for($i=1;$i<=8;$i++){
					if(in_array("TS".$i, $extraCols)){
						$sensor['TS'] = true;
					}
				}
				if($sensor['TS']){
			?>
					<tr>
						<td>
							<span class="mticon-soiltemperature dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('soil temperature','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				$sensor['SM'] = false;
				for($i=1;$i<=8;$i++){
					if(in_array("SM".$i, $extraCols)){
						$sensor['SM'] = true;
					}
				}
				if($sensor['SM']){
			?>
					<tr>
						<td>
							<span class="mticon-soilmoisture dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('soil moisture','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				$sensor['LT'] = false;
				for($i=1;$i<=8;$i++){
					if(in_array("LT".$i, $extraCols)){
						$sensor['LT'] = true;
					}
				}
				if($sensor['LT']){
			?>
					<tr>
						<td>
							<span class="mticon-temp dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('leaf temperature','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				$sensor['LW'] = false;
				for($i=1;$i<=8;$i++){
					if(in_array("LW".$i, $extraCols)){
						$sensor['LW'] = true;
					}
				}
				if($sensor['LW']){
			?>
					<tr>
						<td>
							<span class="mticon-leafwetness dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							<?php echo lang('leaf wetness','c')?>
						</td>
					</tr>
			<?php
				}
			?>
			<?php 
				$sensor['CO2'] = false;
				for($i=1;$i<=8;$i++){
					if(in_array("CO2_".$i, $extraCols)){
						$sensor['CO2'] = true;
					}
				}
				if($sensor['CO2']){
			?>
					<tr>
						<td>
							<span class="mticon-co2 dbInfoIcon"></span>
						</td>
						<td style="text-align:left">
							CO<sub>2</sub>
						</td>
					</tr>
			<?php
				}
			?>
		</table>
	</div>
	<span class="more" onclick="txt = $('#dbInfoDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#dbInfoDetails').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>

