<?php

	# 		Dynamic Image
	# 		Namespace:		dynamicImage
	#		Meteotemplate Block
	
	#		v2.0	2016-11-15
	#			- better cache handling
	#			- bug fixes
	#		v3.0	2016-11-16
	#			- added possibility to click to zoom
	# 		v4.0 	2017-01-21
	# 			- added support for multiple images
	
	$thisBlockVersion = "4.0";
	
	$time = microtime();
	$time = explode(' ', $time);
	$time = $time[1] + $time[0];
	$blockStartTime = $time;
	
	$errorLog[] = array("","%c Loading Block Dynamic Image ".$thisBlockVersion."','font-weight:bold;color:green");
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "First you need to go to your admin panel and use the blocks settings section to create the settings file.";
		die;
	}
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");

	$splitURLs = explode(";",$dynamicImageURLs);
	$dynamicImageTitle = explode(";",$dynamicImageTitles);
	$dynamicImageUpdateInterval = explode(";",$dynamicImageUpdateIntervals);

	foreach($splitURLs as $dynamicImageURL){
		$errorLog[] = array("","Loading image from URL: ".$dynamicImageURL);
		$errorLog[] = array("","Image title: ".$dynamicImageTitle);
		$errorLog[] = array("","Update interval se to: ".$dynamicImageUpdateInterval." s");
		
		if (strpos($dynamicImageURL, '?') !== false) {
			$finalDynamicImageURLs[] = $dynamicImageURL."&".date("U");
			$errorLog[] = array("","Image URL already includes some parameters, add timestamp to those.");
			$errorLog[] = array("","Added timestamp ".date('U')." to prevent caching.");
		}
		else{
			$finalDynamicImageURLs[] = $dynamicImageURL."?timestamp=".date("U");
			$errorLog[] = array("","Image URL does not include any parameters, add timestamp as first parameter.");
			$errorLog[] = array("","Added timestamp ".date('U')." to prevent caching.");
		}
	}
?>
	<style>
		.dynamicImageCSS{
			width:95%;
			margin:0 auto;
			border-radius:10px;
			border: 1px solid #<?php echo $color_schemes[$design]['500']?>;
			margin-bottom: 10px;
			opacity: 0.85;
			cursor: pointer;
		}
		.dynamicImageCSS:hover{
			opacity: 1;
		}
	</style>
	
	<?php 
		for($i=0;$i<count($finalDynamicImageURLs);$i++){
	?>
			<span style="font-size:1.3em;font-weight:bold;font-variant:small-caps">
				<?php echo $dynamicImageTitle[$i]?>
			</span><br>
			<img id="dynamicImageDiv<?php echo $i?>" src="<?php echo $finalDynamicImageURLs[$i]?>" class="dynamicImageCSS tooltip" alt='' title="<?php echo $dynamicImageTitle[$i]?>">
			<div id="dynamicImageFull<?php echo $i?>" title="<?php echo $dynamicImageTitle[$i]?>"></div>
			<script>
				setInterval(function(){ dynamicImageUpdater<?php echo $i?>(); }, (<?php echo $dynamicImageUpdateInterval[$i]?>*1000));
				function dynamicImageUpdater<?php echo $i?>(){
					$.ajax({
					url: 'homepage/blocks/dynamicImage/dynamicImageLoader.php?image=<?php echo $i?>',
					cache: false,
					success: function(data) {
						$('#dynamicImageDiv<?php echo $i?>').attr('src', data);
					}
					});
				}
				
				dialogHeight = screen.height*0.9;
				dialogWidth = screen.width*0.9;
				$("#dynamicImageFull<?php echo $i?>").dialog({
					modal: true,
					autoOpen: false,
					height: dialogHeight,
					width: dialogWidth
				});
				
				$("#dynamicImageDiv<?php echo $i?>").click(function(){
					src = $(this).attr("src");
					popupImage<?php echo $i?>(src);
				});
				
				function popupImage<?php echo $i?>(src){
					$("#dynamicImageFull<?php echo $i?>").html("<div style='height:98%;margin:0 auto;text-align:center;'><img src='"+src+"' style='height:100%'></div>");
					$("#dynamicImageFull<?php echo $i?>").dialog('open');		
				}
			</script>
	<?php 
		}
	?>
	<?php 
		$time = microtime();
		$time = explode(' ', $time);
		$time = $time[1] + $time[0];
		$blockEndTime = $time;
		$blockLoadTime = $blockEndTime - $blockStartTime;
		$blockLoadTime = round($blockLoadTime,4);
		$errorLog[] = array("","Block loaded in ".$blockLoadTime." s.");
		showLog($errorLog);
	?>