<?php 

	include("../../../config.php");
	include($baseURL."css/design.php");
	include($baseURL."header.php");
	
	if(file_exists("text.txt")){
		$saved = file_get_contents("text.txt");
	}
	else{
		$file = file_put_contents("text.txt","");
		$saved = "";
	}

?>
<!DOCTYPE html>
<html>
	<head>
		<title>Add Text</title>
		<?php metaHeader()?>
		<script type="text/javascript" src="scripts/tinyeditor.js"></script>
		<style>
			#tinyeditor {border:none; margin:0; padding:0}
			.tinyeditor {border:0px solid #bbb; padding:0 1px 1px; margin: 0 auto;border-radius:10px}
			.tinyeditor iframe {border:none; overflow-x:hidden;margin: 0 auto;background:white;text-align:center}
			.tinyeditor-header {height:31px; border-bottom:0px solid #bbb; background:url(images/header-bg.gif) repeat-x; padding-top:1px;padding-left:5px;border-radius: 10px 10px 0px 0px}
			.tinyeditor-header select {float:left; margin-top:5px}
			.tinyeditor-font {margin-left:12px}
			.tinyeditor-size {margin:0 3px}
			.tinyeditor-style {margin-right:12px}
			.tinyeditor-divider {float:left; width:1px; height:30px; background:#ccc}
			.tinyeditor-control {float:left; width:34px; height:30px; cursor:pointer; background-image:url(images/icons.png)}
			.tinyeditor-control:hover {background-color:#fff; background-position:30px 0}
			.tinyeditor-footer {height:32px; border-top:0px solid #bbb; background:#f5f5f5;border-radius: 0px 0px 10px 10px}
			.toggle {float:left; background:url(images/icons.png) -34px 2px no-repeat; padding:9px 13px 0 31px; height:23px; border-right:1px solid #ccc; cursor:pointer; color:#666}
			.toggle:hover {background-color:#fff}
			.resize {float:right; height:32px; width:32px; background:url(images/resize.gif) 15px 15px no-repeat; cursor:s-resize}
			#editor {cursor:text; margin:10px}
			select.tinyeditor-color option[value="black"] {color:#000000;font-weight:bold}
			select.tinyeditor-color option[value="blue"] {color:#0000ff;font-weight:bold}
			select.tinyeditor-color option[value="red"] {color:red;font-weight:bold}
			select.tinyeditor-color option[value="green"] {color:green;font-weight:bold}
		</style>
	</head>
	<body>
		<div id="main_top">
			<?php bodyHeader()?>
			<?php include($baseURL."menu.php")?>
		</div>
		<div id="main" style="text-align:center">
			<div style="width:99%;margin:0 auto;text-align:center">
				<br><br>
				<form onsubmit="editor.post();" action="save.php" method="post">
					<textarea id="tinyeditor" style="width: 600px; height: 200px;margin: 0 auto;" name="text">
						<?php echo $saved?>
					</textarea>
					<br>
					Admin password: <input class="button" name="pass">
					<br>
					<input type="submit" class="button" value="Save">
				</form>
				<br>
			</div>
		</div>
		<?php include($baseURL."footer.php")?>
	<script>
		var editor = new TINY.editor.edit('editor', {
			id: 'tinyeditor',
			width: (screen.width*0.5),
			height: 450,
			cssclass: 'tinyeditor',
			controlclass: 'tinyeditor-control',
			rowclass: 'tinyeditor-header',
			dividerclass: 'tinyeditor-divider',
			controls: ['bold', 'italic', 'underline', 'strikethrough', '|', 'subscript', 'superscript', '|',
				'orderedlist', 'unorderedlist', '|', 'outdent', 'indent', '|', 'leftalign',
				'centeralign', 'rightalign', 'blockjustify', '|', 'unformat', '|', 'undo', 'redo',
				'size', 'style', 'color','|', 'image', 'hr'],
			footer: true,
			//fonts: ['<?php echo $designFont?>','Arial','Georgia','Trebuchet MS'],
			xhtml: true,
			//cssfile: 'custom.css',
			//bodyid: 'editor',
			footerclass: 'tinyeditor-footer',
			//toggle: {text: 'HTML', activetext: 'Text', cssclass: 'Toggle'},
			resize: {cssclass: 'resize'}
		});
	</script>
	</body>
</html>