<?php

	# 		Dynamic Text
	# 		Namespace:		dynamicText
	#		Meteotemplate Block

	# 		v2.0 - Feb 26, 2017
	# 			- complete redesign
	# 		v2.1 - Feb 27, 2017
	# 			- bug fixes
	# 		v2.2 - Mar 7, 2017
	# 			- bug fixes
	# 		v2.3 - Mar 13, 2017
	# 			- minor bug fixes
	# 		v2.4 - Mar 18, 2017
	# 			- minor bug fixes
	# 		v2.5 - Dec 14, 2017
	# 			- minor bug fixes
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");

	// error_reporting(E_ALL);
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if(file_exists("settings.txt")){
		$variables = json_decode(file_get_contents("settings.txt"),true);
	}
	else{
		echo "First you need to go to your admin panel and use the blocks settings section to create the settings file.";
		die;
	}

	if($displayRainUnits=="mm"){
		$decimalsR = 1;
	}
	else{
		$decimalsR = 2;
	}

	foreach($variables as $key=>$value){
		if($value=="true"){
			${$key} = true;
		}
		else if($value=="false"){
			${$key} = false;
		}
		else{
			${$key} = $value;
		}
	}

	$result = mysqli_query($con, "
			SELECT T, R, P, H, S, A, D
			FROM  alldata
			ORDER BY DateTime DESC
			LIMIT 1
			"
	);
	while ($row = mysqli_fetch_array($result)) {
		$conditionsNow['T'] = $row['T'];
		$conditionsNow['R'] = round($row['R'],$decimalsR);
		$conditionsNow['P'] = $row['P'];
		$conditionsNow['H'] = $row['H'];
		$conditionsNow['S'] = $row['S'];
		$conditionsNow['D'] = $row['D'];
		$conditionsNow['A'] = $row['A'];
	}

	$stationOffline = true;
	$result = mysqli_query($con,"
		SELECT  T, R, P, G
		FROM  alldata
		WHERE DateTime >= now() - interval 1 hour
		ORDER BY DateTime
		"
	);
	while($row = mysqli_fetch_array($result)){
		$stationOffline = false;
		if(!isset($conditionsHourAgo['T'])){
			$conditionsHourAgo['T'] = $row['T'];
		}
		if(!isset($conditionsHourAgo['P'])){
			$conditionsHourAgo['P'] = $row['P'];
		}
		$conditionsHourAgo['R'][] = $row['R'];
		$conditionsHourAgo['G'][] = $row['G'];
	}

	// station status 
	if($dynamicTextStationOffline){
		if($stationOffline){
			$textArray['station'][] = array($dynamicTextStationOfflineText,"fa fa-times-circle");
		}
	}

	// temperature
	if($dynamicTextTAbove==true){
		if($conditionsNow['T']>$dynamicTextTAboveValue){
			$dynamicTextTAboveText = str_replace("%T",$conditionsNow['T'],$dynamicTextTAboveText);
			$textArray['T'][] = array($dynamicTextTAboveText,"mticon-temp");
		}
	}
	if($dynamicTextTBelow){
		if($conditionsNow['T']<$dynamicTextTBelowValue){
			$dynamicTextTBelowText = str_replace("%T",$conditionsNow['T'],$dynamicTextTBelowText);
			$textArray['T'][] = array($dynamicTextTBelowText,"mticon-temp");
		}
	}
	if($dynamicTextTChange){
		$diff = abs($conditionsNow['T']-$conditionsHourAgo['T']);
		if($diff>=$dynamicTextTChangeValue){
			$dynamicTextTChangeText = str_replace("%now",$conditionsNow['T'],$dynamicTextTChangeText);
			$dynamicTextTChangeText = str_replace("%ago",$conditionsHourAgo['T'],$dynamicTextTChangeText);
			$textArray['T'][] = array($dynamicTextTBelowText,"mticon-temp");
		}
	}

	// precipitation
	if($dynamicTextRAbove){
		if($conditionsNow['R']>$dynamicTextRAboveValue){
			$dynamicTextRAboveText = str_replace("%R",$conditionsNow['R'],$dynamicTextRAboveText);
			$textArray['R'][] = array($dynamicTextRAboveText,"mticon-rain");
		}
	}
	if($dynamicTextRRAbove){
		// make sure we take into account the zeroing at midnight when calculating rain last hour
		$initial = $conditionsHourAgo['R'][0];
		$totalRHour = 0;
		for($i=0;$i<count($conditionsHourAgo['R']);$i++){
			$diff = $conditionsHourAgo['R'][$i] - $initial;
			if($diff<0){
				$diff = 0;
			}
			$totalRHour += $diff;
			$initial = $conditionsHourAgo['R'][$i];
		}
		if($totalRHour>=$dynamicTextRRAboveValue){
			$dynamicTextRRAboveText = str_replace("%R",$totalRHour,$dynamicTextRRAboveText);
			$textArray['R'][] = array($dynamicTextRRAboveText,"mticon-rain");
		}
	}

	// pressure
	if($dynamicTextPIncrease){
		$diff = $conditionsNow['P'] - $conditionsHourAgo['P'];
		if($diff>$dynamicTextPIncreaseValue){
			$dynamicTextPIncreaseText = str_replace("%now",$conditionsNow['P'],$dynamicTextPIncreaseText);
			$dynamicTextPIncreaseText = str_replace("%ago",$conditionsHourAgo['P'],$dynamicTextPIncreaseText);
			$textArray['P'][] = array($dynamicTextPIncreaseText,"mticon-pressure");
		}
	}
	if($dynamicTextPDecrease){
		$diff = $conditionsNow['P'] - $conditionsHourAgo['P'];
		if($diff<($dynamicTextPDecreaseValue*-1)){
			$dynamicTextPDecreaseText = str_replace("%now",$conditionsNow['P'],$dynamicTextPDecreaseText);
			$dynamicTextPDecreaseText = str_replace("%ago",$conditionsHourAgo['P'],$dynamicTextPDecreaseText);
			$textArray['P'][] = array($dynamicTextPDecreaseText,"mticon-pressure");
		}
	}

	// humidity
	if($dynamicTextHAbove){
		if($conditionsNow['H']>$dynamicTextHAboveValue){
			$dynamicTextHAboveText = str_replace("%H",$conditionsNow['H'],$dynamicTextHAboveText);
			$textArray['H'][] = array($dynamicTextHAboveText,"mticon-humidity");
		}
	}
	if($dynamicTextHBelow){
		if($conditionsNow['H']<$dynamicTextHBelowValue){
			$dynamicTextTBelowText = str_replace("%H",$conditionsNow['H'],$dynamicTextHBelowText);
			$textArray['H'][] = array($dynamicTextTBelowText,"mticon-humidity");
		}
	}

	// solar radiation
	if($dynamicTextSAbove){
		if($conditionsNow['S']>$dynamicTextSAboveValue){
			$dynamicTextSAboveText = str_replace("%S",$conditionsNow['S'],$dynamicTextSAboveText);
			$textArray['S'][] = array($dynamicTextSAboveText,"mticon-sun");
		}
	}

	// wind gust 
	if($dynamicTextGAbove){
		if(max($conditionsHourAgo['G'])>$dynamicTextGAboveValue){
			$dynamicTextGAboveText = str_replace("%G",max($conditionsHourAgo['G']),$dynamicTextGAboveText);
			$textArray['G'][] = array($dynamicTextGAboveText,"mticon-gust");
		}
	}

	// feels like
	if($dynamicTextAAbove){
		if($conditionsNow['A']>$dynamicTextAAboveValue){
			$dynamicTextAAboveText = str_replace("%A",$conditionsNow['A'],$dynamicTextAAboveText);
			$textArray['A'][] = array($dynamicTextAAboveText,"mticon-apparent");
		}
	}
	if($dynamicTextABelow){
		if($conditionsNow['A']<$dynamicTextABelowValue){
			$dynamicTextABelowText = str_replace("%A",$conditionsNow['A'],$dynamicTextABelowText);
			$textArray['A'][] = array($dynamicTextABelowText,"mticon-apparent");
		}
	}

	// dew point
	if($dynamicTextDAbove){
		if($conditionsNow['D']>$dynamicTextDAboveValue){
			$dynamicTextDAboveText = str_replace("%D",$conditionsNow['D'],$dynamicTextDAboveText);
			$textArray['D'][] = array($dynamicTextDAboveText,"mticon-dewpoint");
		}
	}
	if($dynamicTextDBelow){
		if($conditionsNow['D']<$dynamicTextDBelowValue){
			$dynamicTextDBelowText = str_replace("%D",$conditionsNow['D'],$dynamicTextDBelowText);
			$textArray['D'][] = array($dynamicTextDBelowText,"mticon-dewpoint");
		}
	}

	$stationTimezone = new DateTimeZone($stationTZ);
	$stationOffset  = $stationTimezone->getOffset(new DateTime)/3600;

	$sunRiseTS = date_sunrise((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,($stationOffset));
	$sunSetTS = date_sunset((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,($stationOffset));

	// sunrise
	if($dynamicTextSunriseBefore){
		$limit = $sunRiseTS - $dynamicTextSunriseBeforeValue*60;
		if(time()>$limit && time()<$sunRiseTS){
			$timeInterval = ($sunRiseTS-time());
			$dynamicTextSunriseBeforeText = str_replace("%min",floor($timeInterval/60),$dynamicTextSunriseBeforeText);
			$textArray['sunrise'][] = array($dynamicTextSunriseBeforeText,"mticon-sunrise");
		}
	}
	if($dynamicTextSunriseAfter){
		$limit = $dynamicTextSunriseAfterValue*60 + $sunRiseTS;
		if(time()<$limit && time()>$sunRiseTS){
			$timeInterval = (time()-$sunRiseTS);
			$dynamicTextSunriseAfterText = str_replace("%min",floor($timeInterval/60),$dynamicTextSunriseAfterText);
			$textArray['sunrise'][] = array($dynamicTextSunriseAfterText,"mticon-sunrise");
		}
	}

	// sunset 
	if($dynamicTextSunsetBefore){
		$limit = $sunSetTS - $dynamicTextSunsetBeforeValue*60;
		if(time()>$limit && time()<$sunSetTS){
			$timeInterval = ($sunSetTS-time());
			$dynamicTextSunsetBeforeText = str_replace("%min",floor($timeInterval/60),$dynamicTextSunsetBeforeText);
			$textArray['sunset'][] = array($dynamicTextSunsetBeforeText,"mticon-sunset");
		}
	}
	if($dynamicTextSunsetAfter){
		$limit = $dynamicTextSunsetAfterValue*60 + $sunSetTS;
		if(time()<$limit && time()>$sunSetTS){
			$timeInterval = (time()-$sunSetTS);
			$dynamicTextSunsetAfterText = str_replace("%min",floor($timeInterval/60),$dynamicTextSunsetAfterText);
			$textArray['sunset'][] = array($dynamicTextSunsetAfterText,"mticon-sunset");
		}
	}

	// time of day 
	if(trim($dynamicTextTimeOfDay)!=""){
		$timesOfDay = explode("\r\n",$dynamicTextTimeOfDay);
		for($i=0;$i<count($timesOfDay);$i++){
			$exploded = explode(";;;",$timesOfDay[$i]);
			$hours = explode("-",$exploded[0]);
			if(date("H")>=$hours[0] && date("H")<$hours[1]){
				$textArray['timeOfDay'][] = array($exploded[1],$exploded[2]);
			}
		}
	}

	// days
	if(trim($dynamicTextDay)!=""){
		$days = explode("\r\n",$dynamicTextDay);
		for($i=0;$i<count($days);$i++){
			$exploded = explode(";;;",$days[$i]);
			$date = explode("-",$exploded[0]);
			if($date[0]=="*"){
				$date[0] = date("Y"); // any year - set to current to activate
			}
			if($date[0]==date("Y") && $date[1]==date("m") && $date[2]==date("d")){
				$textArray['days'][] = array($exploded[1],$exploded[2]);
			}
		}
	}

	$outputStrings = array();

	// lets go through the order
	$thisOrder = explode(",",$dynamicTextOrder);
	for($i=0;$i<count($thisOrder);$i++){
		$key = trim($thisOrder[$i]);
		if(isset($textArray[$key])){
			foreach($textArray[$key] as $string){
				$outputStrings[] = $string;
			}
		}
	}
?>
	<?php 
		if(count($outputStrings)==0){
	?>
			<script>
				$("#dynamicTextBlock").hide();
			</script>
	<?php
		}
	?>
	<style>
		
	</style>
	<?php 
		if($dynamicTextHeading!=""){
	?>
			<h2><?php echo $dynamicTextHeading?></h2>
	<?php
		}
	?>
	<div style="width:98%;margin:0 auto">
		<table style="width:98%;margin:0 auto">
			<?php
				for($i=0;$i<count($outputStrings);$i++){
			?>
					<tr>
						<td style="font-size:2em;text-align:left">
							<span class="<?php echo $outputStrings[$i][1]?>"></span>
						</td>
						<td style="text-align:left;padding-left:10px">
							<?php echo $outputStrings[$i][0]?>
						</td>
					</tr>
			<?php 
				}
			?>
		</table>
	</div>
	
