<?php

	// check acces authorization
	session_start();
	if($_SESSION['user']!="admin"){
		echo "Unauthorized access.";
		die();
	}
	
	// load core files
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../header.php");
	
	// check if settings already exists and if so, load it, otherwise set parameters to default values
	if(file_exists("settings.txt")){
		$variables = json_decode(file_get_contents("settings.txt"),true);
	}

	foreach($variables as $key=>$value){
		${$key} = $value;
	}



	if(!isset($dynamicTextStationOffline)){
		$dynamicTextStationOffline = "true";
	}
	if(!isset($dynamicTextStationOfflineText)){
		$dynamicTextStationOfflineText = "The station was hit by an asteroid and is therefore currently offline.";
	}

	if(!isset($dynamicTextTAbove)){
		$dynamicTextTAbove = false;
	}
	if(!isset($dynamicTextTAboveValue)){
		$dynamicTextTAboveValue = 30;
	}
	if(!isset($dynamicTextTAboveText)){
		$dynamicTextTAboveText = "The temperature is currently %T, you could try frying eggs on your car hood.";
	}
	if(!isset($dynamicTextTBelow)){
		$dynamicTextTBelow = "false";
	}
	if(!isset($dynamicTextTBelowValue)){
		$dynamicTextTBelowValue = 0;
	}
	if(!isset($dynamicTextTBelowText)){
		$dynamicTextTBelowText = "It is currently %T&deg;C. Temperatures in Oymyakon, Russia can drop down to almost -70&deg;C (-90&deg;F) - just in case you thought it was cold.";
	}
	if(!isset($dynamicTextTChange)){
		$dynamicTextTChange = "false";
	}
	if(!isset($dynamicTextTChangeValue)){
		$dynamicTextTChangeValue = 5;
	}
	if(!isset($dynamicTextTChangeText)){
		$dynamicTextTChangeText = "The temperature is like crazy. An hour ago it was %ago and now it is %now.";
	}

	if(!isset($dynamicTextRAbove)){
		$dynamicTextRAbove = "false";
	}
	if(!isset($dynamicTextRAboveValue)){
		$dynamicTextRAboveValue = 25;
	}
	if(!isset($dynamicTextRAboveText)){
		$dynamicTextRAboveText = "Leave your car at home today and get a boat instead. It has rained %R mm since midnight.";
	}
	if(!isset($dynamicTextRRAbove)){
		$dynamicTextRRAbove = "false";
	}
	if(!isset($dynamicTextRRAboveValue)){
		$dynamicTextRRAboveValue = 20;
	}
	if(!isset($dynamicTextRRAboveText)){
		$dynamicTextRRAboveText = "If this continues, the station will soon be submerged under water... Only in the last hour it has rained over %R mm!";
	}

	if(!isset($dynamicTextPIncrease)){
		$dynamicTextPIncrease = "false";
	}
	if(!isset($dynamicTextPIncreaseValue)){
		$dynamicTextPIncreaseValue = 1.5;
	}
	if(!isset($dynamicTextPIncreaseText)){
		$dynamicTextPIncreaseText = "In the last hour, the pressure has increased from %ago to %now, do you also have a headache?";
	}

	if(!isset($dynamicTextPDecrease)){
		$dynamicTextPDecrease = "false";
	}
	if(!isset($dynamicTextPDecreaseValue)){
		$dynamicTextPDecreaseValue = 1.5;
	}
	if(!isset($dynamicTextPDecreaseText)){
		$dynamicTextPDecreaseText = "In the last hour, the pressure has fallen from %ago to %now, let's just hope it doesn't fall to 0 because that would be the end of us.";
	}

	if(!isset($dynamicTextHAbove)){
		$dynamicTextHAbove = "false";
	}
	if(!isset($dynamicTextHAboveValue)){
		$dynamicTextHAboveValue = 98;
	}
	if(!isset($dynamicTextHAboveText)){
		$dynamicTextHAboveText = "The current relative humidity is above 98%, \"relatively\" humid...!";
	}
	if(!isset($dynamicTextHBelow)){
		$dynamicTextHBelow = "false";
	}
	if(!isset($dynamicTextHBelowValue)){
		$dynamicTextHBelowValue = 40;
	}
	if(!isset($dynamicTextHBelowText)){
		$dynamicTextHBelowText = "Humidity is only %H%, time for a drink.";
	}

	if(!isset($dynamicTextSAbove)){
		$dynamicTextSAbove = "false";
	}
	if(!isset($dynamicTextSAboveValue)){
		$dynamicTextSAboveValue = 800;
	}
	if(!isset($dynamicTextSAboveText)){
		$dynamicTextSAboveText = "Come on, the weather outside is so nice and you are sitting at home staring at a computer? Go out!";
	}

	if(!isset($dynamicTextGAbove)){
		$dynamicTextGAbove = "false";
	}
	if(!isset($dynamicTextGAboveValue)){
		$dynamicTextGAboveValue = 35;
	}
	if(!isset($dynamicTextGAboveText)){
		$dynamicTextGAboveText = "Wind speeds exceeding 35 km/h... try walking against the wind, might be a lot of fun.";
	}
	
	if(!isset($dynamicTextAAbove)){
		$dynamicTextAAbove = "false";
	}
	if(!isset($dynamicTextAAboveValue)){
		$dynamicTextAAboveValue = 30;
	}
	if(!isset($dynamicTextAAboveText)){
		$dynamicTextAAboveText = "The current feels like temperature is %A&deg;C, stay at home!";
	}
	if(!isset($dynamicTextABelow)){
		$dynamicTextABelow = "false";
	}
	if(!isset($dynamicTextABelowValue)){
		$dynamicTextABelowValue = 0;
	}
	if(!isset($dynamicTextABelowText)){
		$dynamicTextABelowText = "Don't go outside now, the feels like temperature is %A&degC;, you will freeze to death!";
	}

	if(!isset($dynamicTextDAbove)){
		$dynamicTextDAbove = "false";
	}
	if(!isset($dynamicTextDAboveValue)){
		$dynamicTextDAboveValue = 20;
	}
	if(!isset($dynamicTextDAboveText)){
		$dynamicTextDAboveText = "The dew point is now really high, trust me.";
	}
	if(!isset($dynamicTextDBelow)){
		$dynamicTextDBelow = "false";
	}
	if(!isset($dynamicTextDBelowValue)){
		$dynamicTextDBelowValue = 0;
	}
	if(!isset($dynamicTextDBelowText)){
		$dynamicTextDBelowText = "The dew point is currently below 0&deg;C, if you don't know what dew point is then just remember you should wear sufficient clothes.";
	}

	if(!isset($dynamicTextTimeOfDay)){
		$dynamicTextTimeOfDay = "";
	}

	if(!isset($dynamicTextDay)){
		$dynamicTextDay = "";
	}

	if(!isset($dynamicTextSunriseBefore)){
		$dynamicTextSunriseBefore = "false";
	}
	if(!isset($dynamicTextSunriseBeforeValue)){
		$dynamicTextSunriseBeforeValue = 30;
	}
	if(!isset($dynamicTextSunriseBeforeText)){
		$dynamicTextSunriseBeforeText = "Want to take some really nice pictures of a sunrise? Hurry up, you only have %min minutes.";
	}
	if(!isset($dynamicTextSunriseAfter)){
		$dynamicTextSunriseAfter = "false";
	}
	if(!isset($dynamicTextSunriseAfterValue)){
		$dynamicTextSunriseAfterValue = 30;
	}
	if(!isset($dynamicTextSunriseAfterText)){
		$dynamicTextSunriseAfterText = "Still at home? Well in that case you missed it... sunrise was %min minutes ago.";
	}

	if(!isset($dynamicTextSunsetBefore)){
		$dynamicTextSunsetBefore = "false";
	}
	if(!isset($dynamicTextSunsetBeforeValue)){
		$dynamicTextSunsetBeforeValue = 30;
	}
	if(!isset($dynamicTextSunsetBeforeText)){
		$dynamicTextSunsetBeforeText = "Sun is about to set (in %min minutes). Daytime is over. Time flies when you are enjoying yourself doesn't it.";
	}
	if(!isset($dynamicTextSunsetAfter)){
		$dynamicTextSunsetAfter = "false";
	}
	if(!isset($dynamicTextSunsetAfterValue)){
		$dynamicTextSunsetAfterValue = 30;
	}
	if(!isset($dynamicTextSunsetAfterText)){
		$dynamicTextSunsetAfterText = "Desperately looking for the Sun? Too bad, it has gone below the horizon %min ago.";
	}
	
	if(!isset($dynamicTextOrder)){
		$dynamicTextOrder = "station,timeOfDay,days,sunrise,sunset,T,R,W,H,P,A,D,S";
	}

	if(!isset($dynamicTextHeading)){
		$dynamicTextHeading = "Dynamic Text";
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<title><?php echo $pageName?></title>
		<?php metaHeader()?>
		<style>
			.dynamicTextSetupTable td{
				vertical-align: top;
			}
			.button2{
				cursor: auto;
			}
		</style>
	</head>
	<body>
		<div id="main_top">
			<?php bodyHeader()?>
			<?php include($baseURL."menu.php");?>
		</div>
		<div id="main" style="text-align:justify">
			<h1>Dynamic Text - Setup</h1>
			<div style="width:98%;margin:0 auto">
				<p>
					In this setup you can enable/disable various triggers. If a trigger is enabled, you also specify some threshold condition which will activate the trigger. If a parameter is enabled and trigger activated, the specified message will appear on the page. In addition, at the bottom you can also specify particular text to display during a specified time of the day or day in a year or exact date. For each you can also define an icon and last you give the order in which the messages should appear.
				</p>
				<p>
					One more important thing! If there are no messages to display at all, the block will completely DISAPPEAR from the homepage, so you will never see a blank block.
				</p>
			</div>
			<form method="POST" action="saveSettings.php" target="_blank">
				<div style="width:98%;margin:0 auto">
					<h3>Block heading</h3>
					<br>
					<div style="width:100%;margin:0 auto;text-align:left">
						<input name="dynamicTextHeading" value="<?php echo $dynamicTextHeading?>" class="button2"> Leave blank if you want no heading
					</div>
					<br><br>
					<h3><?php echo lang('weather station','c')?></h3>
					<table style="width:95%" class="dynamicTextSetupTable">
						<tr>
							<td style="text-align:left;width:300px">
								Station is offline (no data in the last hour)
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextStationOffline" class="button2">
									<option value="true" <?php if($dynamicTextStationOffline=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextStationOffline!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextStationOfflineText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextStationOfflineText?></textarea>
								<br><br>
							</td>
						</tr>
					</table>
					<h3><?php echo lang('temperature','c')?></h3>
					<table style="width:95%" class="dynamicTextSetupTable">
						<tr>
							<td style="text-align:left;width:300px">
								Current temperature above
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextTAbove" class="button2">
									<option value="true" <?php if($dynamicTextTAbove=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextTAbove!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextTAboveValue" class="button2" size="4" value="<?php echo $dynamicTextTAboveValue?>"> <?php echo unitFormatter($dataTempUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextTAboveText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextTAboveText?></textarea>
								<br>
								Possible tags: %T (current temperature in <?php echo unitFormatter($dataTempUnits)?>)
								<br><br>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
								Current temperature below
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextTBelow" class="button2">
									<option value="true" <?php if($dynamicTextTBelow=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextTBelow!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextTBelowValue" class="button2" size="4" value="<?php echo $dynamicTextTBelowValue?>"> <?php echo unitFormatter($dataTempUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextTBelowText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextTBelowText?></textarea>
								<br>
								Possible tags: %T (current temperature in <?php echo unitFormatter($dataTempUnits)?>)
								<br><br>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
								Temperature change
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextTChange" class="button2">
									<option value="true" <?php if($dynamicTextTChange=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextTChange!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextTChangeValue" class="button2" size="4" value="<?php echo $dynamicTextTChangeValue?>"> <?php echo unitFormatter($dataTempUnits)."/".lang('hAbbr','l')?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextTChangeText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextTChangeText?></textarea><br>
								Possible tags: %ago (temperature hour ago) and %now (current temperature), both in <?php echo unitFormatter($dataTempUnits)?>
								<br><br>
							</td>
						</tr>
					</table>
					<h3><?php echo lang('precipitation','c')?></h3>
					<table style="width:95%" class="dynamicTextSetupTable">
						<tr>
							<td style="text-align:left;width:300px">
								Daily cumulative rain above
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextRAbove" class="button2">
									<option value="true" <?php if($dynamicTextRAbove=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextRAbove!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextRAboveValue" class="button2" size="4" value="<?php echo $dynamicTextRAboveValue?>"> <?php echo unitFormatter($dataRainUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextRAboveText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextRAboveText?></textarea>
								<br>
								Possible tags: %R (current cumulative daily rain in <?php echo unitFormatter($dataRainUnits)?>)
								<br><br>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
								Precipitation amount in last hour
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextRRAbove" class="button2">
									<option value="true" <?php if($dynamicTextRRAbove=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextRRAbove!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextRRAboveValue" class="button2" size="4" value="<?php echo $dynamicTextRRAboveValue?>"> <?php echo unitFormatter($dataRainUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextRRAboveText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextRRAboveText?></textarea>
								<br>
								Possible tags: %R (precipitation amount in the last 60 minutes <?php echo unitFormatter($dataRainUnits)?>)
								<br><br>
							</td>
						</tr>
					</table>
					<h3><?php echo lang('pressure','c')?></h3>
					<table style="width:95%" class="dynamicTextSetupTable">
						<tr>
							<td style="text-align:left;width:300px">
								Pressure increase in last hour
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextPIncrease" class="button2">
									<option value="true" <?php if($dynamicTextPIncrease=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextPIncrease!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextPIncreaseValue" class="button2" size="4" value="<?php echo $dynamicTextPIncreaseValue?>"> <?php echo unitFormatter($dataPressUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextPIncreaseText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextPIncreaseText?></textarea>
								<br>
								Possible tags: %ago (pressure hour ago) and %now (current pressure), both in <?php echo unitFormatter($dataPressUnits)?>
								<br><br>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
								Pressure decrease in last hour
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextPDecrease" class="button2">
									<option value="true" <?php if($dynamicTextPDecrease=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextPDecrease!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextPDecreaseValue" class="button2" size="4" value="<?php echo $dynamicTextPDecreaseValue?>"> <?php echo unitFormatter($dataPressUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextPDecreaseText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextPDecreaseText?></textarea>
								<br>
								Possible tags: %ago (pressure hour ago) and %now (current pressure), both in <?php echo unitFormatter($dataPressUnits)?>
								<br><br>
							</td>
						</tr>
					</table>
					<h3><?php echo lang('humidity','c')?></h3>
					<table style="width:95%" class="dynamicTextSetupTable">
						<tr>
							<td style="text-align:left;width:300px">
								Current humidity above
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextHAbove" class="button2">
									<option value="true" <?php if($dynamicTextHAbove=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextHAbove!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextHAboveValue" class="button2" size="4" value="<?php echo $dynamicTextHAboveValue?>"> %
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextHAboveText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextHAboveText?></textarea>
								<br>
								Possible tags: %H (current humidity in %)
								<br><br>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
								Current humidity below
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextHBelow" class="button2">
									<option value="true" <?php if($dynamicTextHBelow=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextHBelow!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextHBelowValue" class="button2" size="4" value="<?php echo $dynamicTextHBelowValue?>"> %
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextHBelowText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextHBelowText?></textarea>
								<br>
								Possible tags: %H (current humidity in %)
								<br><br>
							</td>
						</tr>
					</table>
					<h3><?php echo lang('solar radiation','c')?></h3>
					<table style="width:95%" class="dynamicTextSetupTable">
						<tr>
							<td style="text-align:left;width:300px">
								Current solar radiation above
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextSAbove" class="button2">
									<option value="true" <?php if($dynamicTextSAbove=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextSAbove!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextSAboveValue" class="button2" size="4" value="<?php echo $dynamicTextSAboveValue?>"> W/m2
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextSAboveText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextSAboveText?></textarea>
								<br>
								Possible tags: %S (current solar radiation in W/m2)
								<br><br>
							</td>
						</tr>
					</table>
					<h3><?php echo lang('wind gust','c')?></h3>
					<table style="width:95%" class="dynamicTextSetupTable">
						<tr>
							<td style="text-align:left;width:300px">
								Maximum wind gust in the last hour above
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextGAbove" class="button2">
									<option value="true" <?php if($dynamicTextGAbove=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextGAbove!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextGAboveValue" class="button2" size="4" value="<?php echo $dynamicTextGAboveValue?>"> <?php echo unitFormatter($dataWindUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextGAboveText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextGAboveText?></textarea>
								<br>
								Possible tags: %G (maxium wind gust in the last hour in <?php echo unitFormatter($dataWindUnits)?>)
								<br><br>
							</td>
						</tr>
					</table>
					<h3><?php echo lang('apparent temperature','c')?></h3>
					<table style="width:95%" class="dynamicTextSetupTable">
						<tr>
							<td style="text-align:left;width:300px">
								Current feels like above
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextAAbove" class="button2">
									<option value="true" <?php if($dynamicTextAAbove=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextAAbove!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextAAboveValue" class="button2" size="4" value="<?php echo $dynamicTextAAboveValue?>"> <?php echo unitFormatter($dataTempUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextAAboveText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextAAboveText?></textarea>
								<br>
								Possible tags: %A (current feels like in <?php echo unitFormatter($dataTempUnits)?>)
								<br><br>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
								Current feels like below
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextABelow" class="button2">
									<option value="true" <?php if($dynamicTextABelow=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextABelow!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextABelowValue" class="button2" size="4" value="<?php echo $dynamicTextABelowValue?>"> <?php echo unitFormatter($dataTempUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextABelowText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextABelowText?></textarea>
								<br>
								Possible tags: %A (current feels like in <?php echo unitFormatter($dataTempUnits)?>)
								<br><br>
							</td>
						</tr>
					</table>
					<h3><?php echo lang('dew point','c')?></h3>
					<table style="width:95%" class="dynamicTextSetupTable">
						<tr>
							<td style="text-align:left;width:300px">
								Current dew point above
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextDAbove" class="button2">
									<option value="true" <?php if($dynamicTextDAbove=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextDAbove!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextDAboveValue" class="button2" size="4" value="<?php echo $dynamicTextDAboveValue?>"> <?php echo unitFormatter($dataTempUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextDAboveText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextDAboveText?></textarea>
								<br>
								Possible tags: %D (current dew point in <?php echo unitFormatter($dataTempUnits)?>)
								<br><br>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
								Current dew point below
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextDBelow" class="button2">
									<option value="true" <?php if($dynamicTextDBelow=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextDBelow!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextDBelowValue" class="button2" size="4" value="<?php echo $dynamicTextDBelowValue?>"> <?php echo unitFormatter($dataTempUnits)?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextDBelowText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextDBelowText?></textarea>
								<br>
								Possible tags: %D (dew point like in <?php echo unitFormatter($dataTempUnits)?>)
								<br><br>
							</td>
						</tr>
					</table>
					<h3>Time of the Day</h3>
					<div style="width:100%;text-align:justify">
						<p>
							Here you can specify particular times of the day when something is displayed. If you do not wish to use this, just leave the textarea below empty. If you want to use it you have to provide the time span in hours. This will be used every day so whatever you specify here will be shown every day at the time chosen.
						</p>
						<p>
							The syntax is as follows:
							<br>
							<ul>
								<li>
									each trigger on a new line
								</li>
								<li>
									first is the time span - this must be given in the 24 hour format. Example: 2-4 -> this would show up between 2 and 4 AM. 15-16 -> this would be displayed between 3 and 4 in the afternoon. 
								</li>
								<li>
									the time span is delimited from the actual message with three semi-colons (;;;).
								</li>
								<li>
									last part of the string is the icon (use the icons just like in the menu, using the same syntax, i.e. mticon-XXXX or fa fa-XXXXX), again delimited with three semi-colons (;;;)
								</li>
							</ul>
							Examples:<br>
							<ul>
								<li>
									<i>0-4;;;Busy working on Meteotemplate.;;;mticon-logo</i>
								</li>
								<li>
									<i>4-5;;;Jachym goes to bed.;;;fa fa-hotel</i>
								</li>
								<li>
									<i>17-18;;;Lunch time.;;;fa fa-coffee</i>
								</li>
							</ul>
							<br>
							<textarea name="dynamicTextTimeOfDay" class="button2" style="width:80%;text-align:left;cursor:auto" rows="8"><?php echo $dynamicTextTimeOfDay?></textarea>
						</p>
					</div>
					<h3>Day</h3>
					<div style="width:100%;text-align:justify">
						<p>
							Here you can specify a particular day and your message will be displayed on that day.
						</p>
						<p>
							The syntax is as follows:
							<ul>
								<li>
									each day on a new line
								</li>
								<li>
									day has to be provided in the format YYYY-MM-DD (year-month-day)
								</li>
								<li>
									if you want something to display every year on that day use the * symbol for the year
								</li>
								<li>
									date is delimited from the text with three semi-colons (;;;)
								</li>
								<li>
									last part of the string is the icon (use the icons just like in the menu, using the same syntax, i.e. mticon-XXXX or fa fa-XXXXX), again delimited with three semi-colons (;;;)
								</li>
							</ul>
							Examples:<br>
							<ul>
								<li>
									<i>*-02-20;;;It is my birthday :);;;fa fa-birthday-cake</i><br>will appear every year on 20th February
								</li>
								<li>
									<i>*-12-26;;;No need to cry! Just 364 more days and Christmas is back.;;;fa fa-tree</i><br>will appear every year on 26th December
								</li>
								<li>
									<i>2017-02-31;;;This text will never appear :(;;;fa fa-minus-circle</i><br>this text would technically speaking appear on 31st February 2017 ;)
								</li>
								<li>
									<i>1111-11-11;;;What a nice date!;;;fa fa-smile-o</i><br>this text would have appeared on 11th November 1111
								</li>
							</ul>
							<br>
							<textarea name="dynamicTextDay" class="button2" style="width:80%;text-align:left;cursor:auto" rows="8"><?php echo $dynamicTextDay?></textarea>
						</p>
					</div>
					<h3>Sunrise / Sunset</h3>
					<table style="width:95%" class="dynamicTextSetupTable">
						<tr>
							<td style="text-align:left;width:300px">
								Minutes before sunrise
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextSunriseBefore" class="button2">
									<option value="true" <?php if($dynamicTextSunriseBefore=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextSunriseBefore!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextSunriseBeforeValue" class="button2" size="4" value="<?php echo $dynamicTextSunriseBeforeValue?>"> <?php echo lang('minAbbr','l')?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextSunriseBeforeText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextSunriseBeforeText?></textarea>
								<br>
								Possible tags: %min (minutes until sunrise)
								<br><br>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
								Minutes after sunrise
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextSunriseAfter" class="button2">
									<option value="true" <?php if($dynamicTextSunriseAfter=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextSunriseAfter!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextSunriseAfterValue" class="button2" size="4" value="<?php echo $dynamicTextSunriseAfterValue?>"> <?php echo lang('minAbbr','l')?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextSunriseAfterText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextSunriseAfterText?></textarea>
								<br>
								Possible tags: %min (minutes after sunrise)
								<br><br>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
								Minutes before sunset
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextSunsetBefore" class="button2">
									<option value="true" <?php if($dynamicTextSunsetBefore=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextSunsetBefore!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextSunsetBeforeValue" class="button2" size="4" value="<?php echo $dynamicTextSunsetBeforeValue?>"> <?php echo lang('minAbbr','l')?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextSunsetBeforeText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextSunsetBeforeText?></textarea>
								<br>
								Possible tags: %min (minutes until sunset)
								<br><br>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
								Minutes after sunset
							</td>
							<td style="text-align:left;width:200px">
								<select name="dynamicTextSunsetAfter" class="button2">
									<option value="true" <?php if($dynamicTextSunsetAfter=="true"){echo "selected";}?>>Enable</option>
									<option value="false" <?php if($dynamicTextSunsetAfter!="true"){echo "selected";}?>>Disable</option>
								</select>
							</td>
							<td style="text-align:left">
								<input name="dynamicTextSunsetAfterValue" class="button2" size="4" value="<?php echo $dynamicTextSunsetAfterValue?>"> <?php echo lang('minAbbr','l')?>
							</td>
						</tr>
						<tr>
							<td style="text-align:left;width:300px">
							</td>
							<td style="text-align:left">
							</td>
							<td style="text-align:left">
								<textarea name="dynamicTextSunsetAfterText" class="button2" style="width:80%;text-align:left" rows="4"><?php echo $dynamicTextSunsetAfterText?></textarea>
								<br>
								Possible tags: %min (minutes after sunset)
								<br><br>
							</td>
						</tr>
					</table>
					<h3>Order</h3>
					<div style="width:100%;text-align:justify">
						<p>
							Last thing you need to specify is the display order. What this means? This simply tells the block in which order you want the strings to appear in case more triggers are activated. The block will look at this order and if it detects more than one active trigger, it will look which one is before/after the other one and show it in the corresponding oder.
						</p>
						<p>
							The order should be provided using abbreviations specified below and delimited with a comma (,).
						</p>
						<ul>	
							<li>
								<strong>station</strong> - station status
							</li>
							<li>
								<strong>T</strong> - temperature related triggers
							</li>
							<li>
								<strong>R</strong> - precipitation related triggers
							</li>
							<li>
								<strong>H</strong> - humidity related triggers
							</li>
							<li>
								<strong>P</strong> - pressure related triggers
							</li>
							<li>
								<strong>G</strong> - wind speed related triggers
							</li>
							<li>
								<strong>S</strong> - solar radiation related triggers
							</li>
							<li>
								<strong>A</strong> - feels like related triggers
							</li>
							<li>
								<strong>D</strong> - dew point related triggers
							</li>
							<li>
								<strong>sunrise</strong> - sunrise related triggers
							</li>
							<li>
								<strong>sunset</strong> - sunset related triggers
							</li>
							<li>
								<strong>timeOfDay</strong> - time of day triggers (particular hours during the day)
							</li>
							<li>
								<strong>days</strong> - particular dates
							</li>
						</ul>
						<br>
						<input name="dynamicTextOrder" class="button2" value="<?php echo $dynamicTextOrder?>" style="width:98%;text-align:left">
					</div>
					<br><br>
					<div style="width:50%;text-align:center;margin:0 auto">
						<input type="submit" value="Save" class="button2">
					</div>
					<br><br>
				</div>
			</form>
		</div>
		<?php include($baseURL."footer.php");?>
	</body>
</html>