<?php

	# 		Earthquakes block
	# 		Namespace:		earthquakes
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	#		v1.2 - Sep 16, 2016 
	#			- translation fixes
	# 		v2.0 - Mar 22, 2017
	# 			- added text when no EQ
	# 			- change to https
	# 			- optimization 
	# 		v3.0 - Jun 29, 2017
	# 			- optimization - size reduction by 80%
	# 			- conversion to SVG
	# 			- improved data retrieval method
	
	include("settings.php");
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");

	$closeEQ = array();
	$significantEQ = array();
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	createCacheDir();

	// get all in vicinity
	if(file_exists("cache/eq.txt")){ 
		if (time()-filemtime("cache/eq.txt") > 60 * $eqCacheClose) {
			unlink("cache/eq.txt");
		}
	}
	if(file_exists("cache/eq.txt")){
		$output['earthquakes'] = json_decode(file_get_contents("cache/eq.txt"),true);
	}
	else { 
		$urlEQ = "https://earthquake.usgs.gov/earthquakes/feed/v1.0/summary/all_week.geojson";
		$jsonEQClose = loadContent($urlEQ,3);
		if($jsonEQClose==""){
			$jsonEQClose = file_get_contents($urlEQ);
		}
		if($jsonEQClose==""){
		}
		else{
			$dataEQClose = json_decode($jsonEQClose);
			foreach($dataEQClose->features as $features){
				$magnitudeEQClose = $features->properties->mag;
				$timeEQClose = $features->properties->time;
				$timeEQClose = date($dateTimeFormat,($timeEQClose/1000));
				$importanceEQClose = $features->properties->sig;
				$alertEQClose = $features->properties->alert;
				$placeEQClose = $features->properties->place;
				$latEQClose = $features->geometry->coordinates[1];
				$lonEQClose = $features->geometry->coordinates[0];
				$resultsEQClose['time'] = $timeEQClose;
				$resultsEQClose['magnitude'] = $magnitudeEQClose;
				$resultsEQClose['place'] = $placeEQClose;
				$resultsEQClose['alert'] = $alertEQClose;
				$resultsEQClose['importance'] = $importanceEQClose;
				$resultsEQClose['lat'] = $latEQClose;
				$resultsEQClose['lon'] = $lonEQClose;
				$distanceEQClose = round(distance($latEQClose,$lonEQClose,$stationLat,$stationLon,$unitsEQ));
				$resultsEQClose['distance'] = $distanceEQClose;
				if($distanceEQClose<=$vicinity){
					$closeEQ[] = $resultsEQClose;
				}
				
			}
			
			usort($closeEQ, function($a, $b) {
				return $a['distance'] - $b['distance'];
			});
		}
		$urlEQSignificant = "https://earthquake.usgs.gov/earthquakes/feed/v1.0/summary/significant_week.geojson";
		$jsonEQSignificant = loadContent($urlEQSignificant,3);
		if($jsonEQSignificant==""){
			$jsonEQSignificant = file_get_contents($urlEQSignificant);
		}
		if($jsonEQSignificant==""){
		}
		else{
			$significantEQok = true;
			$templateLog[] = array(microtime(true),"Significant earthquake data OK.", "info");
			$dataEQSignificant = json_decode($jsonEQSignificant);
			foreach($dataEQSignificant->features as $features){
				$magnitudeEQSignificant = $features->properties->mag;
				$timeEQSignificant = $features->properties->time;
				$timeEQSignificant = date($dateTimeFormat,($timeEQSignificant/1000));
				$importanceEQSignificant = $features->properties->sig;
				$alertEQSignificant = $features->properties->alert;
				$placeEQSignificant = $features->properties->place;
				$latEQSignificant = $features->geometry->coordinates[1];
				$lonEQSignificant = $features->geometry->coordinates[0];
				$resultsEQSignificant['time'] = $timeEQSignificant;
				$resultsEQSignificant['magnitude'] = $magnitudeEQSignificant;
				$resultsEQSignificant['place'] = $placeEQSignificant;
				$resultsEQSignificant['alert'] = $alertEQSignificant;
				$resultsEQSignificant['importance'] = $importanceEQSignificant;
				$resultsEQSignificant['lat'] = $latEQSignificant;
				$resultsEQSignificant['lon'] = $lonEQSignificant;
				$distanceEQSignificant = round(distance($latEQSignificant,$lonEQSignificant,$stationLat,$stationLon,$unitsEQ));
				$resultsEQSignificant['distance'] = $distanceEQSignificant;
				$significantEQ [] = $resultsEQSignificant;
			}
			usort($significantEQ, function($a, $b) {
				return $b['magnitude'] - $a['magnitude'];
			});
		}
		$earthquakes['close'] = $closeEQ;
		$earthquakes['significant'] = $significantEQ;
		
		$output['earthquakes'] = $earthquakes;
			$save = file_put_contents("cache/eq.txt",json_encode($earthquakes));
	}
	
	function distance($lat1, $lon1, $lat2, $lon2, $unit) {
		  $theta = $lon1 - $lon2;
		  $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
		  $dist = acos($dist);
		  $dist = rad2deg($dist);
		  $miles = $dist * 60 * 1.1515;
		  $unit = strtoupper($unit);

		if ($unit == "km") {
			return ($miles * 1.609344);
		} 
		else {
			return $miles;
		}
	}

?>
	<script src="homepage/blocks/earthquakes/scripts/mapit.js"></script>
	<style>
		.eqMap, .map{
			max-width: 30px;
			width: 100%;
			opacity: 0.7;
			cursor: pointer;
		}
		.eqMap:hover, .map:hover{
			opacity: 1;
		}
	</style>
	<table style="width:98%;margin:0 auto">
		<tr>
			<td style="width:20%">
				<span class="mticon-earthquake" style="font-size:2.5em"></span>
			</td>
			<td style="width:60%;text-align:center">
				<span style="font-size:150%;font-variant:small-caps;font-weight:bold">
					<?php echo lang('earthquakes','c')?>
				</span>
				<br>
				<span style="font-size:120%;font-variant:small-caps;font-weight:bold">
					<?php echo lang('nearby','c')?>
				</span>
			</td>
			<td></td>
		</tr>
	</table>
	<table style="width:98%;margin:0 auto; font-variant:small-caps">
		<?php
			if(count($output['earthquakes']['close'])==0){
		?>
				<tr>
					<td>
						<?php echo lang('no earthquakes nearby','c')?> (<?php echo $vicinity." ".$unitsEQ?>)
					</td>
				</tr>
		<?php
			}
			else{
				for($i=0;$i<$maximumCloseEq;$i++){
					if(array_key_exists($i,$output['earthquakes']['close'])){
		?>
						<tr>
							<td colspan="4" style="text-align:left">
								<?php echo $output['earthquakes']['close'][$i]['time']?>
							</td>
						</tr>
						<tr>
							<td>
								<?php echo $output['earthquakes']['close'][$i]['distance']." ".$unitsEQ?>
							</td>
							<td>
								<?php echo $output['earthquakes']['close'][$i]['place']?>
							</td>
							<td>
								<span style="font-weight: bold">
									<?php echo number_format($output['earthquakes']['close'][$i]['magnitude'],1,".","")?>
								</span>
							</td>
							<td>
								<span class="mticon-globe eqMap" style="font-size:1.6em"  style="font-size:1.6em" data-latlng="<?php echo $output['earthquakes']['close'][$i]['lat']?>,<?php echo $output['earthquakes']['close'][$i]['lon']?>" alt=''></span>
							</td>
							
						</tr>
		<?php
					}
				}
			}
		?>
	</table>
	<br><br>
	<span style="font-size:120%;font-variant:small-caps;font-weight:bold">
		<?php echo lang('significant','c')?>
	</span>
	<table style="width:98%;margin:0 auto; font-variant:small-caps">
		<?php
			if(count($output['earthquakes']['significant'])==0){
		?>
				<tr>
					<td>
						<?php echo lang('no significant earthquakes','c')?>
					</td>
				</tr>
		<?php
			}
			for($i=0;$i<$maximumSignificantEq;$i++){
				if(array_key_exists($i,$output['earthquakes']['significant'])){
		?>
					<tr>
						<td colspan="3" style="text-align:left">
							<?php echo $output['earthquakes']['significant'][$i]['time']?>
						</td>
					</tr>
					<tr>
						<td style="text-align:left">
							<?php echo $output['earthquakes']['significant'][$i]['place']?>
						</td>
						<td>
							<span style="font-weight: bold">
								<?php echo number_format($output['earthquakes']['significant'][$i]['magnitude'],1,".","")?>
							</span>
						</td>
						<td>
							<span class="mticon-globe eqMap" style="font-size:1.6em" data-latlng="<?php echo $output['earthquakes']['significant'][$i]['lat']?>,<?php echo $output['earthquakes']['significant'][$i]['lon']?>"></span>
						</td>
					</tr>
		<?php
				}
			}
		?>
	</table>
	<script>
	$('.eqMap').mapit({
		mapOptions: {
			zoom: <?php echo $mapZoom?>, 
			mapType: '<?php echo $mapType?>',
		},
	});	
	</script>