<?php

	# 		Extremes
	# 		Namespace:		extremes
	#		Meteotemplate Block

	# 		v1.1 - Mar 12, 2017
	# 			- compatibility fixes
	# 		v1.2 - Mar 18, 2017
	# 			- bug fixes
	# 		v2.0 - Oct 2, 2017
	# 			- added solar radiation
	
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
?>
	<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/jquery.tooltipster.js"></script>
	<style>
		.spinnerSmall {
			position: relative;
			color: #<?php echo $color_schemes[$design2]['300']?>;
			display: inline-block;
			width:  1em; 
			height: 1em; 
			font-size: 20px; 
			border-bottom: 3px solid; 
			vertical-align: middle;
			overflow: hidden;  
			text-indent: 100%;
			-webkit-animation: 0.9s spinnerSmall linear infinite;
			   -moz-animation: 0.9s spinnerSmall linear infinite;
					animation: 0.9s spinnerSmall linear infinite;
			&,
			&:after {
				border-radius: 100%;
			}       
			&:after {
				content: "";
				position: absolute;
				top:    0;
				right:  0;
				bottom: 0;
				left:   0;
				border: 1px solid; 
				opacity: 0.5;
			}
		}
		@-webkit-keyframes spinnerSmall {
			to {
				-webkit-transform: rotate(360deg);
			}
		}
		@-moz-keyframes spinnerSmall {
			to {
				-moz-transform: rotate(360deg);
			}
		}
		@keyframes spinnerSmall {

			to {
				transform: rotate(360deg);
			}
		}
		.spinnerSmall, .spinnerSmall:after {
		  border-radius: 100%;
		}
	</style>
	<h2 style="margin-bottom:10px"><?php echo lang('extremes','c')?></h2>
	<select id="recordsSelectorExtremes" class="button2 tooltip" title="<?php echo lang('parameter','c')?>">
		<option value="Tavg"><?php echo lang('average','c')." ".lang('temperature','l')?></option>
		<option value="Tabs"><?php echo lang('absolute','c')." ".lang('temperature','l')?></option>
		<option value="Trange"><?php echo lang('temperature','c')." ".lang('range','l')?></option>
		<option value="Havg"><?php echo lang('average','c')." ".lang('humidity','l')?></option>
		<option value="Habs"><?php echo lang('absolute','c')." ".lang('humidity','l')?></option>
		<option value="Hrange"><?php echo lang('humidity','c')." ".lang('range','l')?></option>
		<option value="Pavg"><?php echo lang('average','c')." ".lang('pressure','l')?></option>
		<option value="Pabs"><?php echo lang('absolute','c')." ".lang('pressure','l')?></option>
		<option value="Prange"><?php echo lang('pressure','c')." ".lang('range','l')?></option>
		<option value="Wavg"><?php echo lang('average','c')." ".lang('wind speed','l')?></option>
		<option value="Wabs"><?php echo lang('absolute','c')." ".lang('wind speed','l')?></option>
		<option value="Gavg"><?php echo lang('average','c')." ".lang('wind gust','l')?></option>
		<option value="Gabs"><?php echo lang('absolute','c')." ".lang('wind gust','l')?></option>
		<option value="Aavg"><?php echo lang('average','c')." ".lang('apparent temperature','l')?></option>
		<option value="Aabs"><?php echo lang('absolute','c')." ".lang('apparent temperature','l')?></option>
		<option value="Arange"><?php echo lang('apparent temperature','c')." ".lang('range','l')?></option>
		<option value="Davg"><?php echo lang('average','c')." ".lang('dew point','l')?></option>
		<option value="Dabs"><?php echo lang('absolute','c')." ".lang('dew point','l')?></option>
		<?php 
			if($solarSensor){
		?>
			<option value="Savg"><?php echo lang('average','c')." ".lang('solar radiation','l')?></option>
			<option value="Sabs"><?php echo lang('absolute','c')." ".lang('solar radiation','l')?></option>
		<?php 
			}
		?>
		<option value="Drange"><?php echo lang('dew point','c')." ".lang('range','l')?></option>
		<option value="R"><?php echo lang('precipitation','c')?></option>
	</select>
	<select id="recordGroupingSelector" class="button2 tooltip" title="<?php echo lang('grouping','c')?>">
		<option value="d"><?php echo lang('day','c')?></option>
		<option value="m"><?php echo lang('month','c')?></option>
		<option value="y"><?php echo lang('year','c')?></option>
	<input id="recordsNumber" value="10" class="button2 tooltip" size="3" title="<?php echo lang('number of items','c')?>">
	<input type="button" class="button2" id="recordsSubmit" value="<?php echo lang('ok','u')?>"><br>
	<div id="recordsSpinnerDiv" style="width:100%;text-align:center;height:20px;padding-bottom:10px"></div>
	<div id="extremesBlockDiv"></div>
	<script>
		$("#recordsSubmit").click(function(){
			idExtreme = $("#recordsSelectorExtremes").val();
			number = $("#recordsNumber").val();
			grouping = $("#recordGroupingSelector").val();
			if(number<1 || number>99){
				$("#extremesBlockDiv").html("<br><strong>Number of days must be a number between 1 and 99.</strong>");
				return false;
			}
			$("#recordsSpinnerDiv").html('<span class="spinnerSmall">Loading…</span>');
			$("#extremesBlockDiv").load("homepage/blocks/extremes/loadData.php?id="+idExtreme+"&number="+number+"&grouping="+grouping);
		});
		$('.tooltip').tooltipster({
			delay: 2
		});
	</script>
