<?php
	include("../../../config.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$ID = $_GET['id'];
	$number = $_GET['number'];
	$grouping = $_GET['grouping'];
	
	if($number<1 || $number>99){
		$number = 10;
	}
	
	if($grouping=="d"){
		$grouping = "YEAR(DATETIME), MONTH(DATETIME), DAY(DATETIME)";
		$outputDateFormat = $dateFormat;
	}
	if($grouping=="m"){
		$grouping = "YEAR(DATETIME), MONTH(DATETIME)";
		$outputDateFormat = "Y-m";
	}
	if($grouping=="y"){
		$grouping = "YEAR(DATETIME)";
		$outputDateFormat = "Y";
	}
	
	if($ID=="Tavg"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(T) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(T) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$units = "°".$displayTempUnits;
		$decimals = 2;
	}
	if($ID=="Havg"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(H) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(H) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),($row['DayAvg']));
		}
		$units = "%";
		$decimals = 2;
	}
	if($ID=="Pavg"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(P) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertP($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(P) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertP($row['DayAvg']));
		}
		$units = $displayPressUnits;
		if($units=="inhg"){
			$units = "inHg";
			$decimals = 3;
		}
		else{
			$decimals = 2;
		}
		if($units == "hpa"){
			$units = "hPa";
		}
	}
	if($ID=="Wavg"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(W) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertW($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(W) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertW($row['DayAvg']));
		}
		$units = $displayWindUnits;
		$decimals = 2;
		if($units=="kmh"){
			$units = "km/h";
		}
		if($units=="ms"){
			$units = "m/s";
		}
	}
	if($ID=="Gavg"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(G) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertW($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(G) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertW($row['DayAvg']));
		}
		$units = $displayWindUnits;
		$decimals = 2;
		if($units=="kmh"){
			$units = "km/h";
		}
		if($units=="ms"){
			$units = "m/s";
		}
	}
	if($ID=="Aavg"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(A) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(A) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$units = "°".$displayTempUnits;
		$decimals = 2;
	}
	if($ID=="Davg"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(D) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(D) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$units = "°".$displayTempUnits;
		$decimals = 2;
	}
	if($ID=="Savg"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(S) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, AVG(S) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),($row['DayAvg']));
		}
		$units = "W/m2";
		$decimals = 1;
	}
	if($ID=="Tabs"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MIN(Tmin) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MAX(Tmax) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$units = "°".$displayTempUnits;
		$decimals = 1;
	}
	if($ID=="Habs"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MIN(H) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MAX(H) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$units = "%";
		$decimals = 1;
	}
	if($ID=="Pabs"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MIN(P) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertP($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MAX(P) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertP($row['DayAvg']));
		}
		$units = $displayPressUnits;
		if($units=="inhg"){
			$units = "inHg";
			$decimals = 3;
		}
		else{
			$decimals = 2;
		}
		if($units == "hpa"){
			$units = "hPa";
		}
	}
	if($ID=="Wabs"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MIN(W) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertW($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MAX(W) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertW($row['DayAvg']));
		}
		$units = $displayWindUnits;
		$decimals = 1;
		if($units=="kmh"){
			$units = "km/h";
		}
		if($units=="ms"){
			$units = "m/s";
		}
	}
	if($ID=="Gabs"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MIN(G) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertW($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MAX(G) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertW($row['DayAvg']));
		}
		$units = $displayWindUnits;
		$decimals = 1;
		if($units=="kmh"){
			$units = "km/h";
		}
		if($units=="ms"){
			$units = "m/s";
		}
	}
	if($ID=="Aabs"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MIN(A) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MAX(A) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$units = "°".$displayTempUnits;
		$decimals = 1;
	}
	if($ID=="Dabs"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MIN(D) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MAX(D) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertT($row['DayAvg']));
		}
		$units = "°".$displayTempUnits;
		$decimals = 1;
	}
	if($ID=="Sabs"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MIN(S) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),($row['DayAvg']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME
			FROM (
				SELECT DATETIME, MAX(S) AS DayAvg
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),($row['DayAvg']));
		}
		$units = "W/m2";
		$decimals = 0;
	}
	if($ID=="R"){
		if($_GET['grouping']=="d"){
			$result = mysqli_query($con,
				"
				SELECT DATETIME, MAX(R) AS Rval
				FROM alldata
				GROUP BY YEAR(DATETIME), MONTH(DATETIME), DAY(DATETIME)
				ORDER BY Rval
				LIMIT $number
				"
			);
		}
		if($_GET['grouping']=="m"){
			$result = mysqli_query($con,
				"
				SELECT SUM(DayAvg) As Rval, DATETIME
				FROM (
					SELECT DATETIME, MAX(R) AS DayAvg
					FROM alldata
					GROUP BY YEAR(DATETIME), MONTH(DATETIME), DAY(DATETIME)
					ORDER BY DATETIME
				) AS DailyMaxTable
				GROUP BY YEAR(DATETIME), MONTH(DATETIME)
				ORDER BY Rval
				LIMIT $number
				"
			);
		}
		if($_GET['grouping']=="y"){
			$result = mysqli_query($con,
				"
				SELECT SUM(DayAvg) As Rval, DATETIME
				FROM (
					SELECT DATETIME, MAX(R) AS DayAvg
					FROM alldata
					GROUP BY YEAR(DATETIME), MONTH(DATETIME), DAY(DATETIME)
					ORDER BY DATETIME
				) AS DailyMaxTable
				GROUP BY YEAR(DATETIME)
				ORDER BY Rval
				LIMIT $number
				"
			);
		}
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),convertR($row['Rval']));
		}
		if($_GET['grouping']=="d"){
			$result = mysqli_query($con,
				"
				SELECT DATETIME, MAX(R) AS Rval
				FROM alldata
				GROUP BY YEAR(DATETIME), MONTH(DATETIME), DAY(DATETIME)
				ORDER BY Rval DESC
				LIMIT $number
				"
			);
		}
		if($_GET['grouping']=="m"){
			$result = mysqli_query($con,
				"
				SELECT SUM(DayAvg) As Rval, DATETIME
				FROM (
					SELECT DATETIME, MAX(R) AS DayAvg
					FROM alldata
					GROUP BY YEAR(DATETIME), MONTH(DATETIME), DAY(DATETIME)
					ORDER BY DATETIME
				) AS DailyMaxTable
				GROUP BY YEAR(DATETIME), MONTH(DATETIME)
				ORDER BY Rval DESC
				LIMIT $number
				"
			);
		}
		if($_GET['grouping']=="y"){
			$result = mysqli_query($con,
				"
				SELECT SUM(DayAvg) As Rval, DATETIME
				FROM (
					SELECT DATETIME, MAX(R) AS DayAvg
					FROM alldata
					GROUP BY YEAR(DATETIME), MONTH(DATETIME), DAY(DATETIME)
					ORDER BY DATETIME
				) AS DailyMaxTable
				GROUP BY YEAR(DATETIME)
				ORDER BY Rval DESC
				LIMIT $number
				"
			);
		}
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),convertR($row['Rval']));
		}
		$units = $displayRainUnits;
		if($units=="in"){
			$decimals = 3;
		}
		else{
			$decimals = 1;
		}
	}
	if($ID=="Trange"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME, Tmax, Tmin
			FROM (
				SELECT DATETIME, (Max(Tmax)-Min(Tmin)) AS DayAvg, Max(Tmax) AS Tmax, Min(Tmin) as Tmin
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),(convertT($row['Tmax']) - convertT($row['Tmin'])), convertT($row['Tmin']), convertT($row['Tmax']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME, Tmax, Tmin
			FROM (
				SELECT DATETIME, (Max(Tmax)-Min(Tmin)) AS DayAvg, Max(Tmax) AS Tmax, Min(Tmin) as Tmin
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),(convertT($row['Tmax']) - convertT($row['Tmin'])), convertT($row['Tmin']), convertT($row['Tmax']));
		}
		$units = "°".$displayTempUnits;
		$decimals = 1;
	}
	if($ID=="Hrange"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME, Hmax, Hmin
			FROM (
				SELECT DATETIME, (Max(H)-Min(H)) AS DayAvg, Max(H) AS Hmax, Min(H) as Hmin
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),($row['DayAvg']), ($row['Hmin']), ($row['Hmax']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME, Hmax, Hmin
			FROM (
				SELECT DATETIME, (Max(H)-Min(H)) AS DayAvg, Max(H) AS Hmax, Min(H) as Hmin
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),($row['DayAvg']), ($row['Hmin']), ($row['Hmax']));
		}
		$units = "%";
		$decimals = 1;
	}
	if($ID=="Prange"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME, Pmax, Pmin
			FROM (
				SELECT DATETIME, (Max(P)-Min(P)) AS DayAvg, Max(P) AS Pmax, Min(P) as Pmin
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),(convertP($row['Pmax']) - convertP($row['Pmin'])), convertP($row['Pmin']), convertP($row['Pmax']));	
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME, Pmax, Pmin
			FROM (
				SELECT DATETIME, (Max(P)-Min(P)) AS DayAvg, Max(P) AS Pmax, Min(P) as Pmin
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),(convertP($row['Pmax']) - convertP($row['Pmin'])), convertP($row['Pmin']), convertP($row['Pmax']));
		}
		$units = $displayPressUnits;
		if($units=="inhg"){
			$units = "inHg";
			$decimals = 2;
		}
		else{
			$decimals = 1;
		}
		if($units == "hpa"){
			$units = "hPa";
		}
	}
	if($ID=="Drange"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME, Dmax, Dmin
			FROM (
				SELECT DATETIME, (Max(D)-Min(D)) AS DayAvg, Max(D) AS Dmax, Min(D) as Dmin
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),(convertT($row['Dmax']) - convertT($row['Dmin'])), convertT($row['Dmin']), convertT($row['Dmax']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME, Dmax, Dmin
			FROM (
				SELECT DATETIME, (Max(Tmax)-Min(Tmin)) AS DayAvg, Max(D) AS Dmax, Min(D) as Dmin
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),(convertT($row['Dmax']) - convertT($row['Dmin'])), convertT($row['Dmin']), convertT($row['Dmax']));
		}
		$units = "°".$displayTempUnits;
		$decimals = 1;
	}
	if($ID=="Arange"){
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME, Amax, Amin
			FROM (
				SELECT DATETIME, (Max(A)-Min(A)) AS DayAvg, Max(A) AS Amax, Min(A) as Amin
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMin[] = array(strtotime($row["DATETIME"]),(convertT($row['Amax']) - convertT($row['Amin'])), convertT($row['Amin']), convertT($row['Amax']));
		}
		$result = mysqli_query($con,
			"
			SELECT DayAvg, DATETIME, Amax, Amin
			FROM (
				SELECT DATETIME, (Max(A)-Min(A)) AS DayAvg, Max(A) AS Amax, Min(A) as Amin
				FROM alldata
				GROUP BY $grouping
				ORDER BY DATETIME
			) AS DailyMaxTable
			ORDER BY DayAvg DESC
			LIMIT $number
			"
		);
		while($row = mysqli_fetch_array($result)){
			$valuesMax[] = array(strtotime($row["DATETIME"]),(convertT($row['Amax']) - convertT($row['Amin'])), convertT($row['Amin']), convertT($row['Amax']));
		}
		$units = "°".$displayTempUnits;
		$decimals = 1;
	}
	
?>
	<div id="recordsBlockTable">
	<?php
		if($ID=="Trange" || $ID=="Hrange" || $ID=="Prange" || $ID=="Drange" || $ID=="Arange"){
	?>
			<h3 style="text-align:center;padding-bottom:5px"><?php echo lang('minimumAbbr','c')?></h3>
			<table class="table" style="width:98%;margin:0 auto"> 
				<thead>
					<tr>
						<th style="text-align:center;padding:4px">
							<?php echo lang('date','c')?>
						</th>
						<th>
							<?php echo lang('range','c')."<br>".$units?>
						</th>
						<th>
							<?php echo lang('minimumAbbr','c')."<br>".$units?>
						</th>
						<th>
							<?php echo lang('maximumAbbr','c')."<br>".$units?>
						</th>
					</tr>
				</thead>
				<tbody>
					<?php
						for($i=0;$i<count($valuesMin);$i++){
					?>
							<tr>
								<td style="padding:7px">
									<?php echo date($outputDateFormat,$valuesMin[$i][0]);?>
								</td>
								<td style="padding:7px;text-align:center">
									<?php echo number_format($valuesMin[$i][1],$decimals,".","");?>
								</td>
								<td style="padding:7px;text-align:center">
									<?php echo number_format($valuesMin[$i][2],$decimals,".","");?>
								</td>
								<td style="padding:7px;text-align:center">
									<?php echo number_format($valuesMin[$i][3],$decimals,".","");?>
								</td>
							</tr>
					<?php
						}
					?>
				</tbody>
			</table>
			<h3 style="text-align:center;padding-top:5px;padding-bottom:5px"><?php echo lang('maximumAbbr','c')?></h3>
			<table class="table" style="width:98%;margin:0 auto"> 
				<thead>
					<tr>
						<th style="text-align:center;padding:4px">
							<?php echo lang('date','c')?>
						</th>
						<th>
							<?php echo lang('range','c')."<br>".$units?>
						</th>
						<th>
							<?php echo lang('minimumAbbr','c')."<br>".$units?>
						</th>
						<th>
							<?php echo lang('maximumAbbr','c')."<br>".$units?>
						</th>
					</tr>
				</thead>
				<tbody>
					<?php
						for($i=0;$i<count($valuesMax);$i++){
					?>
							<tr>
								<td style="padding:7px">
									<?php echo date($outputDateFormat,$valuesMax[$i][0]);?>
								</td>
								<td style="padding:7px;text-align:center">
									<?php echo number_format($valuesMax[$i][1],$decimals,".","");?>
								</td>
								<td style="padding:7px;text-align:center">
									<?php echo number_format($valuesMax[$i][2],$decimals,".","");?>
								</td>
								<td style="padding:7px;text-align:center">
									<?php echo number_format($valuesMax[$i][3],$decimals,".","");?>
								</td>
							</tr>
					<?php
						}
					?>
				</tbody>
			</table>
	<?php
		}
		else{
	?>
			<table style="width:100%">
				<tr>
					<td style="width:50%;text-align:center">
						<h3 style="text-align:center"><?php echo lang('minimumAbbr','c')?></h3>
						<table class="table" style="width:98%;margin:0 auto"> 
							<thead>
								<tr>
									<th style="text-align:center;padding:4px">
										<?php echo lang('date','c')?>
									</th>
									<th>
										<?php echo $units;?>
									</th>
								</tr>
							</thead>
							<tbody>
								<?php
									for($i=0;$i<count($valuesMin);$i++){
								?>
										<tr>
											<td style="padding:7px">
												<?php echo date($outputDateFormat,$valuesMin[$i][0]);?>
											</td>
											<td style="padding:7px;text-align:right">
												<?php 
													echo number_format($valuesMin[$i][1],$decimals,".","");
												?>
											</td>
										</tr>
								<?php
									}
								?>
							</tbody>
						</table>
					</td>
					<td style="width:50%;text-align:center">
						<h3 style="text-align:center"><?php echo lang('maximumAbbr','c')?></h3>
						<table class="table" style="width:98%;margin:0 auto"> 
							<thead>
								<tr>
									<th style="text-align:center;padding:4px">
										<?php echo lang('date','c')?>
									</th>
									<th>
										<?php echo $units;?>
									</th>
								</tr>
							</thead>
							<tbody>
								<?php
									for($i=0;$i<count($valuesMax);$i++){
								?>
										<tr>
											<td style="padding:7px">
												<?php 
													echo date($outputDateFormat,$valuesMax[$i][0]);?>
											</td>
											<td style="padding:7px;text-align:right">
												<?php 
													echo number_format($valuesMax[$i][1],$decimals,".","");
												?>
											</td>
										</tr>
								<?php
									}
								?>
							</tbody>
						</table>
					</td>
				</tr>
			</table>
	<?php
		}
	?>
	<div style="width:100%;text-align:center" id="recordsBlockLink">
		<span class="more">
			<?php echo lang("close",'l')?>
		</span>
	</div>
	</div>
	<script>
		$("#recordsBlockLink").click(function(){
			$("#recordsBlockTable").hide(0);
		});
		$("#recordsSpinnerDiv").html('');
	</script>
	