<?php

	# 		Fire Danger Index
	# 		Namespace:		fireDanger
	#		Meteotemplate Block

	# 		v1.1 - Jan 29, 2016
	#				- added responsiveness
	#				- bug fixes
	# 		v2.0 - Feb 23, 2017
	#				- redesign
	# 				- added descriptions
	# 		v2.1 - Feb 26, 2017
	#				- minor bug fixes


	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$a = mysqli_query($con,"
		SELECT *
		FROM alldata
		ORDER BY DateTime
		DESC LIMIT 1
	");

	while($row = mysqli_fetch_array($a)){
		$T = convertT($row['T']);
		$H = $row['H'];
	}

	if($displayTempUnits=="F"){
		$TC = (($T-32)/1.8);
	}
	else{
		$TC = $T;
	}

	$CBI = (((110 - 1.373*$H) - 0.54 * (10.20 - $TC)) * (124 * pow(10,(-0.0142*$H))))/60;

	if($CBI<0){
		$CBI=0;
	}

	if($CBI<50){
		$severity = 0;
		$severityText = lang('low','c');
		$severityBg = "#ffe8e8";
		$severityColor = "black";
	}
	else if($CBI>=50 && $CBI<75){
		$severity = 1;
		$severityText = lang('moderate','c');
		$severityBg = "#ffb5b5";
		$severityColor = "black";
	}
	else if($CBI>=75 && $CBI<90){
		$severity = 2;
		$severityText = lang('high','c');
		$severityBg = "#ff7c7c";
		$severityColor = "black";
	}
	else if($CBI>=90 && $CBI<97.5){
		$severity = 3;
		$severityText = lang('very high','c');
		$severityBg = "#d82d2d";
		$severityColor = "white";
	}
	else{
		$severity = 4;
		$severityText = lang('extreme','c');
		$severityBg = "#a00606";
		$severityColor = "white";
	}
	$CBI = round($CBI);

	$color1 = $theme=="dark" ? "white" : "black";
?>
	<style>
		.fireDangerIcon{
			font-size:0.7em;
		}
	</style>
	<h2><?php echo lang('fire danger index','c')?></h2>
	
	<div style="width:98%;margin:0 auto">
		<table style="border-radius:3px;border:1px solid <?php echo $color1?>;background:<?php echo $severityBg?>;margin:0 auto;font-weight:bold;font-size:1.8em;color:<?php echo $severityColor?>">
			<tr>
				<td>
					<?php 
						for($i=0;$i<($severity+1);$i++){
					?>
							<span class="mticon-fire"></span>
					<?php
						}
					?>
				</td>
			</tr>
		</table>
		<div style="width:98%;margin:0 auto;font-variant:small-caps;font-weight:bold;font-size:1.2em">
			<?php echo $severityText?>
		</div>
		<div id="fireDangerDetails" class="details" style="width:100%;text-align:justify">
			<span style="font-size:0.8em;font-weight:bold">The Fire Danger Index is derived from the Chandler Burning Index (CBI), which uses the air temperature and relative humidity to calculate a numerical index of fire danger. That number is then equated to the Fire Danger severity of either extreme, very high, high, moderate, or low. It's based solely on weather conditions, with no adjustment for fuel moisture.</span>
			<br><br>
			<div style="width:98%;margin:0 auto">
				<table>
					<tr>
						<td>
								<table style="border-radius:3px;border:1px solid <?php echo $color1?>;background:#ffe8e8;font-weight:bold;font-size:1.5em;color:black">
									<tr>
										<td class="fireDangerIcon">
											<span class="mticon-fire"></span>
										</td>
									</tr>
								</table>
						</td>
						<td style="padding-left:5px;vertical-align:bottom">
							<div style="font-variant:small-caps;font-weight:bold;font-size:1.2em">
								<?php echo lang('low','c')?>
							</div>
						</td>
					</tr>
				</table>
				<p style="font-size:0.8em">
					Fuels do not ignite readily from small firebrands although a more intense heat source, such as lightning, may start fires in duff or punky wood. Fires in open cured grasslands may burn freely a few hours after rain, but woods fires spread slowly by creeping or smoldering, and burn in irregular fingers. There is little danger of spotting.
				</p>
				<table>
					<tr>
						<td>
								<table style="border-radius:3px;border:1px solid <?php echo $color1?>;background:#ffb5b5;font-weight:bold;font-size:1.5em;color:black">
									<tr>
										<td class="fireDangerIcon">
											<span class="mticon-fire"></span><span class="mticon-fire"></span>
										</td>
									</tr>
								</table>
						</td>
						<td style="padding-left:5px;vertical-align:bottom">
							<div style="font-variant:small-caps;font-weight:bold;font-size:1.2em">
								<?php echo lang('moderate','c')?>
							</div>
						</td>
					</tr>
				</table>
				<p style="font-size:0.8em">
					Fires can start from most accidental causes but, with the exception of lightning fires in some areas, the number of starts is generally low. Fires in open cured grasslands will burn briskly and spread rapidly on windy days. Timber fires spread slowly to moderately fast. The average fire is of moderate intensity, although heavy concentrations of fuel, especially draped fuel, may burn hot. Short-distance spotting may occur, but is not persistent. Fires are not likely to become serious and control is relatively easy.
				</p>
				<table>
					<tr>
						<td>
								<table style="border-radius:3px;border:1px solid <?php echo $color1?>;background:#ff7c7c;font-weight:bold;font-size:1.5em;color:black">
									<tr>
										<td class="fireDangerIcon">
											<span class="mticon-fire"></span><span class="mticon-fire"></span><span class="mticon-fire"></span>
										</td>
									</tr>
								</table>
						</td>
						<td style="padding-left:5px;vertical-align:bottom">
							<div style="font-variant:small-caps;font-weight:bold;font-size:1.2em">
								<?php echo lang('high','c')?>
							</div>
						</td>
					</tr>
				</table>
				<p style="font-size:0.8em">
					All fine dead fuels ignite readily and fires start easily from most causes. Unattended brush and campfires are likely to escape. Fires spread rapidly and short-distance spotting is common. High-intensity burning may develop on slopes or in concentrations of fine fuels. Fires may become serious and their control difficult unless they are attacked successfully while small.
				</p>
				<table>
					<tr>
						<td>
								<table style="border-radius:3px;border:1px solid <?php echo $color1?>;background:#d82d2d;font-weight:bold;font-size:1.5em;color:white">
									<tr>
										<td class="fireDangerIcon">
											<span class="mticon-fire"></span><span class="mticon-fire"></span><span class="mticon-fire"></span><span class="mticon-fire"></span>
										</td>
									</tr>
								</table>
						</td>
						<td style="padding-left:5px;vertical-align:bottom">
							<div style="font-variant:small-caps;font-weight:bold;font-size:1.2em">
								<?php echo lang('very high','c')?>
							</div>
						</td>
					</tr>
				</table>
				<p style="font-size:0.8em">
					Fires start easily from all causes and, immediately after ignition, spread rapidly and increase quickly in intensity. Spot fires are a constant danger. Fires burning in light fuels may quickly develop high intensity characteristics such as long-distance spotting and fire whirlwinds when they burn into heavier fuels.
				</p>
				<table>
					<tr>
						<td>
								<table style="border-radius:3px;border:1px solid <?php echo $color1?>;background:#a00606;font-weight:bold;font-size:1.5em;color:white">
									<tr>
										<td class="fireDangerIcon">
											<span class="mticon-fire"></span><span class="mticon-fire"></span><span class="mticon-fire"></span><span class="mticon-fire"></span><span class="mticon-fire"></span>
										</td>
									</tr>
								</table>
						</td>
						<td style="padding-left:5px;vertical-align:bottom">
							<div style="font-variant:small-caps;font-weight:bold;font-size:1.2em">
								<?php echo lang('extreme','c')?>
							</div>
						</td>
					</tr>
				</table>
				<p style="font-size:0.8em">
					Fires start quickly, spread furiously, and burn intensely. All fires are potentially serious. Development into high intensity burning will usually be faster and occur from smaller fires than in the very high fire danger class. Direct attack is rarely possible and may be dangerous except immediately after ignition. Fires that develop headway in heavy slash or in conifer stands may be unmanageable while the extreme burning condition lasts. Under these conditions the only effective and safe control action is on the flanks until the weather changes or the fuel supply lessens.
				</p>
			</div>
		</div>
		<span class="more" onclick="txt = $('#fireDangerDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#fireDangerDetails').slideToggle(800);$(this).text(txt)">
			<?php echo lang('more','l')?>
		</span>
	</div>
