<?php
	
	# 		Glossary Block
	# 		Namespace:		glossary
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	# 		v1.2 - Feb 20, 2017
	#			- CSS tweaks
	# 			- localization
	# 		v2.0 - Feb 27, 2017
	#			- added option to show/hide title
	# 			- added option to auto-open
	
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");
	include("../../../css/design.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}

	$color1 = $theme=="dark" ? $color_schemes[$design2]['200'] : $color_schemes[$design2]['800'];

	if(!$autoOpenGlossary){
		$textInitial = lang('more','c');
	}
	else{
		$textInitial = lang('hide','c');
	}

?>
	<style>
	#refreshGlossary{
		position:absolute;
		top:2%;
		right:2%;
		max-width:20px;
		width:100%;
		opacity: 0.7;
		cursor: pointer;
	}
	#refreshGlossary:hover{
		opacity: 1;
	}
	</style>
	<img src="homepage/blocks/glossary/icons/<?php echo $theme?>/refresh.png" id="refreshGlossary" onclick="updateGlossary()" alt='' class="tooltip" title="New">
	<?php 
		if($showGlossaryTitle){
	?>
			<h2>
				<?php echo lang('glossary','c')?>
			</h2>
	<?php 
		}
	?>
	<br>
	<div id="glossaryTerm" style="font-size:1.3em;font-weight:bold;font-variant:small-caps;width:98%;margin:0 auto;text-align:center;color:#<?php echo $color1?>"></div>
	<div id="glossaryDefinition" class="details" style="font-size:0.9em;text-align:justify;width:98%;margin:0 auto"></div>
	<span class="more" onclick="txt = $('#glossaryDefinition').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#glossaryDefinition').slideToggle(800);$(this).text(txt)"><?php echo $textInitial?></span>
	
	<script>	
		function updateGlossary(){
			<?php
				if(!$autoOpenGlossary){
			?>
					$("#glossaryDefinition").hide();
			<?php 
				}
			?>
			$.ajax({
			url : 'homepage/blocks/glossary/wordsInfo.php',
			dataType : 'json',
			success : function (json) {
				$("#glossaryTerm").html(json[0]);	
				$("#glossaryDefinition").html(json[1]);						
			},
			});	
		}
		updateGlossary();
		<?php
			if($autoOpenGlossary){
		?>

				$('#glossaryDefinition').show();
		<?php
			}
		?>
	</script>