<?php

	# 		History
	# 		Namespace:		history
	#		Meteotemplate Block
	
	# 		v1.1 - Apr 29, 2016
	#			- close button added
	#			- bug fixes
	#		v2.0 - Nov 7, 2016 
	#			- added auto-open possibility
	# 		v3.0 - Aug 6, 2017
	# 			- major optimization (>90% size reduction)
	# 			- improved units formatting
	# 		v4.0 - Nov 7, 2017
	# 			- added difference from current
	# 			- CSS tweaks
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}	
	
	$decimalsR = $displayRainUnits=="in" ? 2 : 1;
	$decimalsP = $displayRainUnits=="inhg" ? 2 : 1;
	
	$yearsData = array();
	
	$yearInitial = 2;
	$oneYear = array();
	
	//current
	$result = mysqli_query($con,"
		SELECT  *
		FROM  alldata
		ORDER BY DateTime DESC
		LIMIT 1
		"
	);
	while($row = mysqli_fetch_array($result)){
		$currentT = convertT($row['T']);
		$currentH = $row['H'];
		$currentP = convertP($row['P']);
		$currentW = convertW($row['W']);
		$currentG = convertW($row['G']);
		$currentA = convertT($row['A']);
		$currentD = convertT($row['D']);
		$currentR = convertR($row['R']);
		$currentS = $row['S'];
	}
	// hour ago
	$result = mysqli_query($con,"
		SELECT  *
		FROM  alldata
		WHERE DateTime <= now() - interval 1 hour
		ORDER BY DateTime DESC
		LIMIT 1
		"
	);
	while($row = mysqli_fetch_array($result)){
		$hourT = convertT($row['T']);
		$hourH = $row['H'];
		$hourP = convertP($row['P']);
		$hourW = convertW($row['W']);
		$hourG = convertW($row['G']);
		$hourA = convertT($row['A']);
		$hourD = convertT($row['D']);
		$hourR = convertR($row['R']);
		$hourS = $row['S'];
	}
	// day ago
	$result = mysqli_query($con,"
		SELECT  *
		FROM  alldata
		WHERE DateTime <= now() - interval 1 day
		ORDER BY DateTime DESC
		LIMIT 1
		"
	);
	while($row = mysqli_fetch_array($result)){
		$yesterdayT = convertT($row['T']);
		$yesterdayH = $row['H'];
		$yesterdayP = convertP($row['P']);
		$yesterdayW = convertW($row['W']);
		$yesterdayG = convertW($row['G']);
		$yesterdayA = convertT($row['A']);
		$yesterdayD = convertT($row['D']);
		$yesterdayR = convertR($row['R']);
		$yesterdayS = $row['S'];
	}
	// week ago
	$result = mysqli_query($con,"
		SELECT  *
		FROM  alldata
		WHERE DateTime <= now() - interval 1 week
		ORDER BY DateTime DESC
		LIMIT 1
		"
	);
	while($row = mysqli_fetch_array($result)){
		$weekT = convertT($row['T']);
		$weekH = $row['H'];
		$weekP = convertP($row['P']);
		$weekW = convertW($row['W']);
		$weekG = convertW($row['G']);
		$weekA = convertT($row['A']);
		$weekD = convertT($row['D']);
		$weekR = convertR($row['R']);
		$weekS = $row['S'];
	}
	// month ago
	$result = mysqli_query($con,"
		SELECT  *
		FROM  alldata
		WHERE DateTime <= now() - interval 1 month
		ORDER BY DateTime DESC
		LIMIT 1
		"
	);
	while($row = mysqli_fetch_array($result)){
		$monthT = convertT($row['T']);
		$monthH = $row['H'];
		$monthP = convertP($row['P']);
		$monthW = convertW($row['W']);
		$monthG = convertW($row['G']);
		$monthA = convertT($row['A']);
		$monthD = convertT($row['D']);
		$monthR = convertR($row['R']);
		$monthS = $row['S'];
	}
	// year ago
	$result = mysqli_query($con,"
		SELECT  *
		FROM  alldata
		WHERE DateTime <= now() - interval 1 year
		ORDER BY DateTime DESC
		LIMIT 1
		"
	);
	while($row = mysqli_fetch_array($result)){
		$yearT = convertT($row['T']);
		$yearH = $row['H'];
		$yearP = convertP($row['P']);
		$yearW = convertW($row['W']);
		$yearG = convertW($row['G']);
		$yearA = convertT($row['A']);
		$yearD = convertT($row['D']);
		$yearR = convertR($row['R']);
		$yearS = $row['S'];
	}
			
	$yearsData = array();
	$oneYear = array();
	
	// get first date in db and number of years
	$result = mysqli_query($con,"
		SELECT  DateTime, Year(DateTime)
		FROM  alldata
		ORDER BY DateTime 
		LIMIT 1
		"
	);
	while($row = mysqli_fetch_array($result)){
		$firstDate = strtotime($row['DateTime']);
		$firstYear = $row['Year(DateTime)'];
	}
	
	$yearsNumber = date('Y')-$firstYear;
	
	// get data for each year
	for($i=2;$i<=$yearsNumber;$i++){
		$result = mysqli_query($con,"
			SELECT  *
			FROM  alldata
			WHERE DateTime <= now() - interval ".$i." year
			ORDER BY DateTime DESC
			LIMIT 1
			"
		);
		while($row = mysqli_fetch_array($result)){	
			$oneYear['T'] = convertT($row['T']);
			$oneYear['H'] = $row['H'];
			$oneYear['P'] = convertP($row['P']);
			$oneYear['W'] = convertW($row['W']);
			$oneYear['G'] = convertW($row['G']);
			$oneYear['A'] = convertT($row['A']);
			$oneYear['D'] = convertT($row['D']);
			$oneYear['R'] = convertR($row['R']);
			$oneYear['S'] = $row['S'];
			array_push($yearsData,$oneYear);
		}
	}

	function getDiff($now,$compare,$dp,$units){
		if($now > $compare){
			$icon = "<span class='fa fa-caret-up'></span> ";
			$diff = number_format($now-$compare,$dp,".","").$units;
			return "(" . $icon . $diff . ")";
		}
		else if($now == $compare){
			$icon = "";
			$diff = "";
			return "";
		}
		else{
			$icon = "<span class='fa fa-caret-down'></span> ";
			$diff = number_format(abs($now-$compare),$dp,".","").$units;
			return "(" . $icon . $diff . ")";
		}
	}
	
?>
	<style>
		.historyBlockIcon{
			font-size: 1.7em;
			opacity: 0.8;
			cursor: pointer;
			padding: 3px;
		}
		.historyBlockIcon:hover{
			opacity: 1;
		}
	</style>
	<h2 style="padding-bottom:5px"><?php echo lang('history','c')?></h2>
	<span class="mticon-temp historyBlockIcon" id="showHistoryBlockT"></span>
	<span class="mticon-humidity historyBlockIcon" id="showHistoryBlockH"></span>
	<span class="mticon-pressure historyBlockIcon" id="showHistoryBlockP"></span>
	<span class="mticon-wind historyBlockIcon" id="showHistoryBlockW"></span>
	<span class="mticon-gust historyBlockIcon" id="showHistoryBlockG"></span>
	<span class="mticon-dewpoint historyBlockIcon" id="showHistoryBlockD"></span>
	<span class="mticon-apparent historyBlockIcon" id="showHistoryBlockA"></span>
	<span class="mticon-rain historyBlockIcon" id="showHistoryBlockR"></span>
	<?php if($solarSensor){?>
		<span class="mticon-sun historyBlockIcon" id="showHistoryBlockS"></span>
	<?php } ?>
	<div style="width:100%;height:5px"></div>
	<table class="table historyHidden" style="width:98%;margin:0 auto;cell-spacing:2px" id="historyTTable">
		<tr>
			<td style="padding:5px;text-align:left">
				<strong><?php echo lang('current','c')?></strong>
			</td>
			<td style="padding:5px;text-align:right">
				<strong><?php echo number_format($currentT,1)?> <?php echo unitFormatter($displayTempUnits)?></strong>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("hour ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($hourT,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($hourT,$currentT,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("yesterday",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yesterdayT,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($yesterdayT,$currentT,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("week ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($weekT,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($weekT,$currentT,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("month ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($monthT,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($monthT,$currentT,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("year ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yearT,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($yearT,$currentT,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<?php 
			for($i=0;$i<count($yearsData);$i++){
		?>	
				<tr>
					<td style="padding:5px;text-align:left">
						<?php echo ($i+2)?> <?php echo lang("years ago",'l')?>
					</td>
					<td style="padding:5px;text-align:right">
						<?php echo number_format($yearsData[$i]['T'],1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($yearsData[$i]['T'],$currentT,1,unitFormatter($displayTempUnits))?>
					</td>
				</tr>
		<?php
			}
		?>
	</table>
	<table class="table historyHidden" style="width:98%;margin:0 auto;cell-spacing:2px" id="historyHTable">
		<tr>
			<td style="padding:5px;text-align:left">
				<strong><?php echo lang('current','c')?></strong>
			</td>
			<td style="padding:5px;text-align:right">
				<strong><?php echo number_format($currentH,1)?> %</strong>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("hour ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($hourH,1)?> % <?php echo getDiff($hourH,$currentH,1,"%")?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("yesterday",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yesterdayH,1)?> % <?php echo getDiff($yesterdayH,$currentH,1,"%")?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("week ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($weekH,1)?> % <?php echo getDiff($weekH,$currentH,1,"%")?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("month ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($monthH,1)?> % <?php echo getDiff($monthH,$currentH,1,"%")?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("year ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yearH,1)?> % <?php echo getDiff($yearH,$currentH,1,"%")?>
			</td>
		</tr>
		<?php 
			for($i=0;$i<count($yearsData);$i++){
		?>	
				<tr>
					<td style="padding:5px;text-align:left">
						<?php echo ($i+2)?> <?php echo lang("years ago",'l')?>
					</td>
					<td style="padding:5px;text-align:right">
						<?php echo number_format($yearsData[$i]['H'],1)?> % <?php echo getDiff($yearsData[$i]['H'],$currentH,1,"%")?>
					</td>
				</tr>
		<?php
			}
		?>
	</table>
	<table class="table historyHidden" style="width:98%;margin:0 auto;cell-spacing:2px" id="historyPTable">
		<tr>
			<td style="padding:5px;text-align:left">
				<strong><?php echo lang('current','c')?></strong>
			</td>
			<td style="padding:5px;text-align:right">
				<strong><?php echo number_format($currentP,$decimalsP,".","")?> <?php echo unitFormatter($displayPressUnits)?></strong>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("hour ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($hourP,$decimalsP,".","")?> <?php echo unitFormatter($displayPressUnits)?> <?php echo getDiff($hourP,$currentP,$decimalsP,unitFormatter($displayPressUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("yesterday",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yesterdayP,$decimalsP,".","")?> <?php echo unitFormatter($displayPressUnits)?> <?php echo getDiff($yesterdayP,$currentP,$decimalsP,unitFormatter($displayPressUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("week ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($weekP,$decimalsP,".","")?> <?php echo unitFormatter($displayPressUnits)?> <?php echo getDiff($weekP,$currentP,$decimalsP,unitFormatter($displayPressUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("month ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($monthP,$decimalsP,".","")?> <?php echo unitFormatter($displayPressUnits)?> <?php echo getDiff($monthP,$currentP,$decimalsP,unitFormatter($displayPressUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("year ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yearP,$decimalsP,".","")?> <?php echo unitFormatter($displayPressUnits)?> <?php echo getDiff($yearP,$currentP,$decimalsP,unitFormatter($displayPressUnits))?>
			</td>
		</tr>
		<?php 
			for($i=0;$i<count($yearsData);$i++){
		?>	
				<tr>
					<td style="padding:5px;text-align:left">
						<?php echo ($i+2)?> <?php echo lang("years ago",'l')?>
					</td>
					<td style="padding:5px;text-align:right">
						<?php echo number_format($yearsData[$i]['P'],$decimalsP,".","")?> <?php echo unitFormatter($displayPressUnits)?> <?php echo getDiff($yearsData[$i]['P'],$currentP,$decimalsP,unitFormatter($displayPressUnits))?>
					</td>
				</tr>
		<?php
			}
		?>
	</table>
	<table class="table historyHidden" style="width:98%;margin:0 auto;cell-spacing:2px" id="historyWTable">
		<tr>
			<td style="padding:5px;text-align:left">
				<strong><?php echo lang('current','c')?></strong>
			</td>
			<td style="padding:5px;text-align:right">
				<strong><?php echo number_format($currentW,1)?> <?php echo unitFormatter($displayWindUnits)?></strong>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("hour ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($hourW,1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($hourW,$currentW,1,unitFormatter($displayWindUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("yesterday",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yesterdayW,1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($yesterdayW,$currentW,1,unitFormatter($displayWindUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("week ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($weekW,1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($weekW,$currentW,1,unitFormatter($displayWindUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("month ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($monthW,1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($monthW,$currentW,1,unitFormatter($displayWindUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("year ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yearW,1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($yearW,$currentW,1,unitFormatter($displayWindUnits))?>
			</td>
		</tr>
		<?php 
			for($i=0;$i<count($yearsData);$i++){
		?>	
				<tr>
					<td style="padding:5px;text-align:left">
						<?php echo ($i+2)?> <?php echo lang("years ago",'l')?>
					</td>
					<td style="padding:5px;text-align:right">
						<?php echo number_format($yearsData[$i]['W'],1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($yearsData[$i]['W'],$currentW,1,unitFormatter($displayWindUnits))?>
					</td>
				</tr>
		<?php
			}
		?>
	</table>
	<table class="table historyHidden" style="width:98%;margin:0 auto;cell-spacing:2px" id="historyGTable">
		<tr>
			<td style="padding:5px;text-align:left">
				<strong><?php echo lang('current','c')?></strong>
			</td>
			<td style="padding:5px;text-align:right">
				<strong><?php echo number_format($currentG,1)?> <?php echo unitFormatter($displayWindUnits)?></strong>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("hour ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($hourG,1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($hourG,$currentG,1,unitFormatter($displayWindUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("yesterday",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yesterdayG,1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($yesterdayG,$currentG,1,unitFormatter($displayWindUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("week ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($weekG,1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($weekG,$currentG,1,unitFormatter($displayWindUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("month ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($monthG,1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($monthG,$currentG,1,unitFormatter($displayWindUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("year ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yearG,1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($yearG,$currentG,1,unitFormatter($displayWindUnits))?>
			</td>
		</tr>
		<?php 
			for($i=0;$i<count($yearsData);$i++){
		?>	
				<tr>
					<td style="padding:5px;text-align:left">
						<?php echo ($i+2)?> <?php echo lang("years ago",'l')?>
					</td>
					<td style="padding:5px;text-align:right">
						<?php echo number_format($yearsData[$i]['G'],1)?> <?php echo unitFormatter($displayWindUnits)?> <?php echo getDiff($yearsData[$i]['G'],$currentG,1,unitFormatter($displayWindUnits))?>
					</td>
				</tr>
		<?php
			}
		?>
	</table>
	<table class="table historyHidden" style="width:98%;margin:0 auto;cell-spacing:2px" id="historyDTable">
		<tr>
			<td style="padding:5px;text-align:left">
				<strong><?php echo lang('current','c')?></strong>
			</td>
			<td style="padding:5px;text-align:right">
				<strong><?php echo number_format($currentD,1)?> <?php echo unitFormatter($displayTempUnits)?></strong>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("hour ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($hourD,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($hourD,$currentD,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("yesterday",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yesterdayD,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($yesterdayD,$currentD,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("week ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($weekD,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($weekD,$currentD,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("month ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($monthD,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($monthD,$currentD,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("year ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yearD,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($yearD,$currentD,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<?php 
			for($i=0;$i<count($yearsData);$i++){
		?>	
				<tr>
					<td style="padding:5px;text-align:left">
						<?php echo ($i+2)?> <?php echo lang("years ago",'l')?>
					</td>
					<td style="padding:5px;text-align:right">
						<?php echo number_format($yearsData[$i]['D'],1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($yearsData[$i]['D'],$currentD,1,unitFormatter($displayTempUnits))?>
					</td>
				</tr>
		<?php
			}
		?>
	</table>
	<table class="table historyHidden" style="width:98%;margin:0 auto;cell-spacing:2px" id="historyATable">
		<tr>
			<td style="padding:5px;text-align:left">
				<strong><?php echo lang('current','c')?></strong>
			</td>
			<td style="padding:5px;text-align:right">
				<strong><?php echo number_format($currentA,1)?> <?php echo unitFormatter($displayTempUnits)?></strong>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("hour ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($hourA,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($hourA,$currentA,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("yesterday",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yesterdayA,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($yesterdayA,$currentA,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("week ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($weekA,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($weekA,$currentA,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("month ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($monthA,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($monthA,$currentA,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("year ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yearA,1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($yearA,$currentA,1,unitFormatter($displayTempUnits))?>
			</td>
		</tr>
		<?php 
			for($i=0;$i<count($yearsData);$i++){
		?>	
				<tr>
					<td style="padding:5px;text-align:left">
						<?php echo ($i+2)?> <?php echo lang("years ago",'l')?>
					</td>
					<td style="padding:5px;text-align:right">
						<?php echo number_format($yearsData[$i]['A'],1)?> <?php echo unitFormatter($displayTempUnits)?> <?php echo getDiff($yearsData[$i]['A'],$currentA,1,unitFormatter($displayTempUnits))?>
					</td>
				</tr>
		<?php
			}
		?>
	</table>
	<table class="table historyHidden" style="width:98%;margin:0 auto;cell-spacing:2px" id="historyRTable">
		<tr>
			<td style="padding:5px;text-align:left">
				<strong><?php echo lang('current','c')?></strong>
			</td>
			<td style="padding:5px;text-align:right">
				<strong><?php echo number_format($currentR,$decimalsR)?> <?php echo unitFormatter($displayRainUnits)?></strong>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("hour ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($hourR,$decimalsR)?> <?php echo unitFormatter($displayRainUnits)?> <?php echo getDiff($hourR,$currentR,$decimalsR,unitFormatter($displayRainUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("yesterday",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yesterdayR,$decimalsR)?> <?php echo unitFormatter($displayRainUnits)?> <?php echo getDiff($yesterdayR,$currentR,$decimalsR,unitFormatter($displayRainUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("week ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($weekR,$decimalsR)?> <?php echo unitFormatter($displayRainUnits)?> <?php echo getDiff($weekR,$currentR,$decimalsR,unitFormatter($displayRainUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("month ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($monthR,$decimalsR)?> <?php echo unitFormatter($displayRainUnits)?> <?php echo getDiff($monthR,$currentR,$decimalsR,unitFormatter($displayRainUnits))?>
			</td>
		</tr>
		<tr>
			<td style="padding:5px;text-align:left">
				<?php echo lang("year ago",'c')?>
			</td>
			<td style="padding:5px;text-align:right">
				<?php echo number_format($yearR,$decimalsR)?> <?php echo unitFormatter($displayRainUnits)?> <?php echo getDiff($yearR,$currentR,$decimalsR,unitFormatter($displayRainUnits))?>
			</td>
		</tr>
		<?php 
			for($i=0;$i<count($yearsData);$i++){
		?>	
				<tr>
					<td style="padding:5px;text-align:left">
						<?php echo ($i+2)?> <?php echo lang("years ago",'l')?>
					</td>
					<td style="padding:5px;text-align:right">
						<?php echo number_format($yearsData[$i]['R'],$decimalsR)?> <?php echo unitFormatter($displayRainUnits)?> <?php echo getDiff($yearsData[$i]['R'],$currentR,$decimalsR,unitFormatter($displayRainUnits))?>
					</td>
				</tr>
		<?php
			}
		?>
	</table>
	<?php
		if($solarSensor){
	?>
		<table class="table historyHidden" style="width:98%;margin:0 auto;cell-spacing:2px" id="historySTable">
			<tr>
				<td style="padding:5px;text-align:left">
					<strong><?php echo lang('current','c')?></strong>
				</td>
				<td style="padding:5px;text-align:right">
					<strong><?php echo number_format($currentS,0)?> W/m<sup>2</sup></strong>
				</td>
			</tr>
			<tr>
				<td style="padding:5px;text-align:left">
					<?php echo lang("hour ago",'c')?>
				</td>
				<td style="padding:5px;text-align:right">
					<?php echo number_format($hourS,0)?> W/m<sup>2</sup> <?php echo getDiff($hourS,$currentS,1,"W/m<sup>2</sup>")?>
				</td>
			</tr>
			<tr>
				<td style="padding:5px;text-align:left">
					<?php echo lang("yesterday",'c')?>
				</td>
				<td style="padding:5px;text-align:right">
					<?php echo number_format($yesterdayS,0)?> W/m<sup>2</sup> <?php echo getDiff($yesterdayS,$currentS,1,"W/m<sup>2</sup>")?>
				</td>
			</tr>
			<tr>
				<td style="padding:5px;text-align:left">
					<?php echo lang("week ago",'c')?>
				</td>
				<td style="padding:5px;text-align:right">
					<?php echo number_format($weekS,0)?> W/m<sup>2</sup> <?php echo getDiff($weekS,$currentS,1,"W/m<sup>2</sup>")?>
				</td>
			</tr>
			<tr>
				<td style="padding:5px;text-align:left">
					<?php echo lang("month ago",'c')?>
				</td>
				<td style="padding:5px;text-align:right">
					<?php echo number_format($monthS,0)?> W/m<sup>2</sup> <?php echo getDiff($monthS,$currentS,1,"W/m<sup>2</sup>")?>
				</td>
			</tr>
			<tr>
				<td style="padding:5px;text-align:left">
					<?php echo lang("year ago",'c')?>
				</td>
				<td style="padding:5px;text-align:right">
					<?php echo number_format($yearS,0)?> W/m<sup>2</sup> <?php echo getDiff($yearS,$currentS,1,"W/m<sup>2</sup>")?>
				</td>
			</tr>
			<?php 
				for($i=0;$i<count($yearsData);$i++){
			?>	
					<tr>
						<td style="padding:5px;text-align:left">
							<?php echo ($i+2)?> <?php echo lang("years ago",'l')?>
						</td>
						<td style="padding:5px;text-align:right">
							<?php echo number_format($yearsData[$i]['S'],0)?> W/m<sup>2</sup> <?php echo getDiff($yearsData[$i]['S'],$currentS,1,"W/m<sup>2</sup>")?>
						</td>
					</tr>
			<?php
				}
			?>
		</table>
	<?php
		}
	?>
	<div style="width:100%;text-align:center" id="historyMoreLink">
		<span class="more">
			<?php echo lang("close",'l')?>
		</span>
	</div>
	<script>
		$(".historyHidden").hide();
		$("#historyMoreLink").hide();
		<?php 
			if($autoOpenHistory){
		?>
				$("#historyTTable").show(0);
				$("#historyMoreLink").show(0);
		<?php 
			}
		?>
		$("#showHistoryBlockT").click(function(){
			$(".historyHidden").hide(0);
			$("#historyTTable").show(0);
			$("#historyMoreLink").show(0);
		});
		$("#showHistoryBlockH").click(function(){
			$(".historyHidden").hide(0);
			$("#historyHTable").show(0);
			$("#historyMoreLink").show(0);
		});
		$("#showHistoryBlockP").click(function(){
			$(".historyHidden").hide(0);
			$("#historyPTable").show(0);
			$("#historyMoreLink").show(0);
		});
		$("#showHistoryBlockW").click(function(){
			$(".historyHidden").hide(0);
			$("#historyWTable").show(0);
			$("#historyMoreLink").show(0);
		});
		$("#showHistoryBlockG").click(function(){
			$(".historyHidden").hide(0);
			$("#historyGTable").show(0);
			$("#historyMoreLink").show(0);
		});
		$("#showHistoryBlockD").click(function(){
			$(".historyHidden").hide(0);
			$("#historyDTable").show(0);
			$("#historyMoreLink").show(0);
		});
		$("#showHistoryBlockA").click(function(){
			$(".historyHidden").hide(0);
			$("#historyATable").show(0);
			$("#historyMoreLink").show(0);
		});
		$("#showHistoryBlockR").click(function(){
			$(".historyHidden").hide(0);
			$("#historyRTable").show(0);
			$("#historyMoreLink").show(0);
		});
		$("#showHistoryBlockS").click(function(){
			$(".historyHidden").hide(0);
			$("#historySTable").show(0);
			$("#historyMoreLink").show(0);
		});
		$("#historyMoreLink").click(function(){
			$(".historyHidden").hide(0);
			$("#historyMoreLink").hide();
		})
	</script>

	
