<?php 

	include("../../../config.php");
	include($baseURL."css/design.php");
	include($baseURL."header.php");
	
	$imageList = array();
	$imageInfos = array();
	$fileSizes = array();
	foreach(glob('images/*.*') as $file) {
		$imageList[] = $file;
		$imageInfos[] = getimagesize($file);
		$fileSizes[] = round(filesize($file)/1000);
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<title>Edit images</title>
		<?php metaHeader()?>
		<script type="text/javascript" src="scripts/tinyeditor.js"></script>
		<style>

		</style>
	</head>
	<body>
		<div id="main_top">
			<?php bodyHeader()?>
			<?php include($baseURL."menu.php")?>
		</div>
		<div id="main" style="text-align:center">
			<div style="margin:0 auto;width:90%">
			
			<form action="upload.php" method="post" enctype="multipart/form-data">
				<br><br>
				<input type="file" name="fileToUpload" id="fileToUpload" ><br><br>
				Admin Password: <input name="adminPassword" id="adminPass" class="button2"><br><br>
				<input type="submit" value="Upload Image" name="submit" class="button">
			</form>
			<h3>Available images</h3>
			<table class="table">
				<?php
					for($i=0;$i<count($imageList);$i++){
				?>
						<tr>
							<td>
								<img src="<?php echo $imageList[$i]?>" style="max-width:100px;width:100%;padding:2px;">
							</td>
							<td>
								<?php echo $imageInfos[$i][0]?>x<?php echo $imageInfos[$i][1]?>
							</td>
							<td>
								<?php echo $fileSizes[$i]?> kB
							</td>
							<td>
								<a href="#"><span class="deleteImg" id="<?php echo $imageList[$i]?>">Delete</span></a>
							</td>
						</tr>
				<?php
					}
				?>
			</table>
			
			</div>
		</div>
		<?php include($baseURL."footer.php")?>
		<script>
			$(".deleteImg").click(function(){
				pass = $("#adminPass").val();
				if(pass==""){
					alert("Fill in your admin password");
					return false;
				}
				var r = confirm("Do you really want to delete the image?");
				if(r){
					imageID = encodeURIComponent($(this).attr('id'));
					window.location = "delete.php?id="+imageID+"&password="+pass;
				}
			})
		</script>
	</body>
</html>