<?php
	
	# 		Meteor showers block
	# 		Namespace:		meteors
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	# 		v2.0 - Mar 19, 2017
	# 			- added possibility to add block heading
	# 			- CSS tweaks

	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	include("../../../config.php");
	include("../../../scripts/functions.php");

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$from = strtotime((date("Y")-1)."/12/21 00:00:00");
	$to = strtotime((date("Y")-1)."/12/22 23:59:59");
	$name = lang("Ursids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/1/3 00:00:00");
	$to = strtotime(date("Y")."/1/4 23:59:59");
	$name = lang("Quadrantids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/4/22 00:00:00");
	$to = strtotime(date("Y")."/4/23 23:59:59");
	$name = lang("Lyrids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/5/6 00:00:00");
	$to = strtotime(date("Y")."/5/7 23:59:59");
	$name = lang("Eta Aquarids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/7/29 00:00:00");
	$to = strtotime(date("Y")."/7/29 23:59:59");
	$name = lang("Delta Aquarids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/7/27 00:00:00");
	$to = strtotime(date("Y")."/7/28 23:59:59");
	$name = lang("Alpha Capricornids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/8/12 00:00:00");
	$to = strtotime(date("Y")."/8/13 23:59:59");
	$name = lang("Perseids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/10/21 00:00:00");
	$to = strtotime(date("Y")."/10/22 23:59:59");
	$name = lang("Orionids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/11/5 00:00:00");
	$to = strtotime(date("Y")."/11/6 23:59:59");
	$name = lang("South Taurids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/11/11 00:00:00");
	$to = strtotime(date("Y")."/11/12 23:59:59");
	$name = lang("North Taurids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/11/17 00:00:00");
	$to = strtotime(date("Y")."/11/18 23:59:59");
	$name = lang("Leonids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime(date("Y")."/12/13 00:00:00");
	$to = strtotime(date("Y")."/12/14 23:59:59");
	$name = lang("Geminids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/12/21 00:00:00");
	$to = strtotime(date("Y")."/12/22 23:59:59");
	$name = lang("Ursids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/1/3 00:00:00");
	$to = strtotime((date("Y")+1)."/1/4 23:59:59");
	$name = lang("Quadrantids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/4/22 00:00:00");
	$to = strtotime((date("Y")+1)."/4/23 23:59:59");
	$name = lang("Lyrids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/5/6 00:00:00");
	$to = strtotime((date("Y")+1)."/5/7 23:59:59");
	$name = lang("Eta Aquarids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/7/29 00:00:00");
	$to = strtotime((date("Y")+1)."/7/29 23:59:59");
	$name = lang("Delta Aquarids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/7/27 00:00:00");
	$to = strtotime((date("Y")+1)."/7/28 23:59:59");
	$name = lang("Alpha Capricornids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/8/12 00:00:00");
	$to = strtotime((date("Y")+1)."/8/13 23:59:59");
	$name = lang("Perseids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/10/21 00:00:00");
	$to = strtotime((date("Y")+1)."/10/22 23:59:59");
	$name = lang("Orionids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/11/5 00:00:00");
	$to = strtotime((date("Y")+1)."/11/6 23:59:59");
	$name = lang("South Taurids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/11/11 00:00:00");
	$to = strtotime((date("Y")+1)."/11/12 23:59:59");
	$name = lang("North Taurids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/11/17 00:00:00");
	$to = strtotime((date("Y")+1)."/11/18 23:59:59");
	$name = lang("Leonids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	$from = strtotime((date("Y")+1)."/12/13 00:00:00");
	$to = strtotime((date("Y")+1)."/12/14 23:59:59");
	$name = lang("Geminids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime((date("Y")+1)."/12/21 00:00:00");
	$to = strtotime((date("Y")+1)."/12/22 23:59:59");
	$name = lang("Ursids",'c');
	$meteorShowers[] = array($from, $to, $name);
	
	// get current and only save future ones
	foreach($meteorShowers as $showers){
		if($showers[1]>=time()){
			$meteorShowersArr[] = $showers;
		}
		if(($showers[0]<time())&&($showers[1]>time())){
			$currentMeteor = $showers[2];
		}
	}
	
	$output['meteorShowers'] = $meteorShowersArr;

?>
	<div style="width:98%;margin:0 auto;text-align:center">
		<img src="homepage/blocks/meteors/icons/<?php echo $theme?>/meteor.png" style="width:40px">
		<?php
			if($meteorsHeading){
		?>
				<h2><?php echo lang('meteor showers','c')?></h2>
		<?php
			}
		?>
	</div>
	<?php 
		echo "<span style='font-weight:bold;font-variant:small-caps;font-size:1.2em'>".$output['meteorShowers'][0][2]."</span><br>";
		echo date("d",$output['meteorShowers'][0][0])." ".lang('month'.date("n",$output['meteorShowers'][0][0]),'c')." ".lang('to','l')." ".date("d",$output['meteorShowers'][0][1])." ".lang('month'.date("n",$output['meteorShowers'][0][1]),'c');
	?>
	<br>
	<div id="meteorDetails" class="details" style="text-align:left">
		<?php
			for($i=1;$i<12;$i++){
				echo "<span style='font-weight:bold;font-variant:small-caps'>".$output['meteorShowers'][$i][2]."</span><br>";
				echo date("d",$output['meteorShowers'][$i][0])." ".lang('month'.date("n",$output['meteorShowers'][$i][0]),'c')." ".lang('to','l')." ".date("d",$output['meteorShowers'][$i][1])." ".lang('month'.date("n",$output['meteorShowers'][$i][1]),'c')."<br><br>";
			}
		?>
	</div>
	<span class="more" onclick="txt = $('#meteorDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#meteorDetails').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>