<?php

	# 		Snow Summary
	# 		Namespace:		snow
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	#		v1.2 - Jul 12, 2016
	#			- fixed units and decimal places
	#		v1.3 - Dec 2, 2016 
	#			- bug fixes
	# 		v2.0 - Nov 8, 2017
	# 			- added comments for latest/yesterday
	# 			- optimization
	# 		v2.1 - Nov 22, 2017
	# 			- CSS tweaks
	
	
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	include("../../../plugins/snow/settings.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}
	
	//error_reporting(E_ALL);
	$month = date('m');
	$year = date('Y'); 
	$yearLast = $year - 1;
	
	if($stationLat>=0){
		$north = true;
	}
	else{
		$north = false;
	}
	
	// current
	$latestNew = "";
	$latestGround = "";
	$result = mysqli_query($con,"
		SELECT DateTime, New, Ground, Comment
		FROM snow 
		ORDER BY DateTime DESC
		LIMIT 1
		"
	);
	while($row = mysqli_fetch_array($result)){
		$latestNew = round($row['New'],$snowDecimals);
		$latestGround = round($row['Ground'],$snowDecimals);
		$latestDate = date($dateFormat,strtotime($row['DateTime']));
		$latestComment = $row['Comment'];
	}
	
	// this month
	$monthNew = "";
	$monthMaxGround = "";
	$result = mysqli_query($con,"
		SELECT Day(DateTime), Sum(New), max(Ground)
		FROM snow 
		WHERE Month(DateTime)=$month AND YEAR(DateTime)=$year
		GROUP BY YEAR(DateTime), MONTH(DateTime)
		ORDER BY DateTime
		"
	);
	while($row = mysqli_fetch_array($result)){
		$monthNew = round($row['Sum(New)'],$snowDecimals);
		$monthMaxGround = round($row['max(Ground)'],$snowDecimals);
	}
	
	// yesterday
	$yesterdayNew = "";
	$yesterdayGround = "";
	$result = mysqli_query($con,"
		SELECT Day(DateTime), New, Ground, Comment
		FROM snow 
		WHERE DATE(DateTime) = CURDATE() - INTERVAL 1 DAY
		ORDER BY DateTime
		"
	);
	while($row = mysqli_fetch_array($result)){
		$yesterdayNew = round($row['New'],$snowDecimals);
		$yesterdayGround = round($row['Ground'],$snowDecimals);
		$yesterdayComment = $row['Comment'];
	}
	
	// winter
	$winterNew = "";
	$winterGroundMax = "";
	
	// Southern Hemisphere
	if($north==false){
		$result = mysqli_query($con,"
			SELECT Sum(New), max(Ground)
			FROM snow 
			WHERE YEAR(DateTime)=$year
			GROUP BY YEAR(DateTime)
			ORDER BY DateTime
			"
		);
		while($row = mysqli_fetch_array($result)){
			$winterNew = round($row['Sum(New)'],$snowDecimals);
			$winterGroundMax = round($row['max(Ground)'],$snowDecimals);
		}
	}
	
	// Northern Hemisphere
	if($north==true){
		if($month>=$winterStart){
			$result = mysqli_query($con,"
				SELECT Sum(New), max(Ground)
				FROM snow 
				WHERE MONTH(DateTime)>=$winterStart AND YEAR(DateTime)=$year
				ORDER BY DateTime
				"
			);
			while($row = mysqli_fetch_array($result)){
				$winterNew = round($row['Sum(New)'],$snowDecimals);
				$winterGroundMax = round($row['max(Ground)'],$snowDecimals);
			}
		}
		else{
			$result = mysqli_query($con,"
				SELECT Sum(New), max(Ground)
				FROM snow 
				WHERE (MONTH(DateTime)>=$winterStart AND YEAR(DateTime)=$yearLast) OR (MONTH(DateTime)<=$winterEnd AND YEAR(DateTime)=$year)
				ORDER BY DateTime
				"
			);
			while($row = mysqli_fetch_array($result)){
				$winterNew = round($row['Sum(New)'],$snowDecimals);
				$winterGroundMax = round($row['max(Ground)'],$snowDecimals);
			}
		}
	}
	
?>
	<style>
		
	</style>
	
	<span class="mticon-snow" style="font-size:2.5em"></span>
	<table style="font-variant:small-caps;width:98%;margin:0 auto;border-spacing:0px;" class="table">
		<tbody>
			<tr>
				<td rowspan="2" style="text-align:left;padding-left:2px">
					<?php echo lang('current','c')?><br><span style="font-size:0.8em"><?php echo $latestDate?></span>
				</td>
				<td>
					<span class="mticon-snowfall" style="font-size:1.7em"></span>
				</td>
				<td style="text-align:center">
					<?php
						if($latestNew!==""){
					?>
							<?php echo $latestNew?><br><?php echo $snowUnits?>
					<?php
						}
						else{
							echo "N/A";
						}
					?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-snowdepth" style="font-size:1.7em"></span>
				</td>
				<td style="text-align:center">
					<?php
						if($latestGround!==""){
					?>
							<?php echo $latestGround?><br><?php echo $snowUnits?>
					<?php
						}
						else{
							echo "N/A";
						}
					?>
					<?php
						if($latestComment!=""){
							echo "<br>".$latestComment;
						}
					?>
				</td>
			</tr>
			<tr>
				<td rowspan="2" style="text-align:left;padding-left:2px">
					<?php echo lang('yesterday','c')?>
				</td>
				<td>
					<span class="mticon-snowfall" style="font-size:1.7em"></span>
				</td>
				<td style="text-align:center">
					<?php
						if($yesterdayNew!==""){
					?>
							<?php echo $yesterdayNew?><br><?php echo $snowUnits?>
					<?php
						}
						else{
							echo "N/A";
						}
					?>
					<?php
						if($yesterdayComment!=""){
							echo "<br>".$yesterdayComment;
						}
					?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-snowdepth" style="font-size:1.7em"></span>
				</td>
				<td style="text-align:center">
					<?php
						if($yesterdayGround!==""){
					?>
							<?php echo $yesterdayGround?><br><?php echo $snowUnits?>
					<?php
						}
						else{
							echo "N/A";
						}
					?>
				</td>
			</tr>
			<tr>
				<td rowspan="2" style="text-align:left;padding-left:2px">
					<?php echo lang('this month','c')?>
				</td>
				<td>
					<span class="mticon-snowfall" style="font-size:1.7em"></span>
				</td>
				<td style="text-align:center">
					<?php
						if($monthNew!==""){
					?>
							<?php echo $monthNew." ".$snowUnits?>
					<?php
						}
						else{
							echo "N/A";
						}
					?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-snowdepth" style="font-size:1.7em"></span><br><span style="font-size:0.8em">max</span>
				</td>
				<td style="text-align:center">
					<?php
						if($monthMaxGround!==""){
					?>
							<?php echo $monthMaxGround." ".$snowUnits?>
					<?php
						}
						else{
							echo "N/A";
						}
					?>
				</td>
			</tr>
			<tr>
				<td rowspan="2" style="text-align:left;padding-left:2px">
					<?php echo lang('this','c')." ".lang('winter','l')?>
				</td>
				<td>
					<img src="homepage/blocks/snow/icons/<?php echo $theme?>/snowfall.png" alt='' style="max-width:25px;width:100%">
				</td>
				<td style="text-align:center">
					<?php
						if($winterNew!==""){
					?>
							<?php echo $winterNew." ".$snowUnits?>
					<?php
						}
						else{
							echo "N/A";
						}
					?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-snowdepth" style="font-size:1.7em"></span><br><span style="font-size:0.8em">max</span>
				</td>
				<td style="text-align:center">
					<?php
						if($winterGroundMax!==""){
					?>
							<?php echo $winterGroundMax." ".$snowUnits?>
					<?php
						}
						else{
							echo "N/A";
						}
					?>
				</td>
			</tr>
		</tbody>
	</table>
