<?php

	# 		Solar Eclipses
	# 		Namespace:		solarEclipses
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	# 		v2.0 - Mar 19, 2017
	# 			- possibility to show block heading
	# 			- CSS tweaks
	
	include("settings.php");
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$solarEclipses = array();
	if(file_exists("files/solarEclipses.txt")){
		$solarsFile = fopen("files/solarEclipses.txt", "r");
		while(!feof($solarsFile)) {
			$solarArray = array();
			$solarRaw = explode(";",fgets($solarsFile));
			$solarArray['date'] = strtotime($solarRaw[2]."/".$solarRaw[3]."/".$solarRaw[4]." ".$solarRaw[5]);
			$type = $solarRaw[9];
				if($type[0]=="P"){
					$type = lang("Partial",'c');
					$typeImg = "partial.png";
				}
				if($type[0]=="A"){
					$type = lang("Annular",'c');
					$typeImg = "annular.png";
				}
				if($type[0]=="T"){
					$type = lang("Total",'c');
					$typeImg = "total.png";
				}
				if($type[0]=="H"){
					$type = lang("Hybrid",'c');
					$typeImg = "hybrid";
				}
			$solarArray['type'] = $type;
			$solarArray['lat'] = $solarRaw[12];
			$solarArray['lng'] = $solarRaw[13];
			$solarArray['altitude'] = $solarRaw[14];
			$solarArray['azimuth'] = $solarRaw[15];
			$solarArray['width'] = $solarRaw[16];
			$durationRaw = $solarRaw[17];
			$durationM = substr($durationRaw,0,2);
			$durationS = substr($durationRaw,3,2);
			$solarArray['duration'] = $durationM * 60 + $durationS;
			
			// generate image link
			$yearDown = floor($solarRaw[2]/100)*100+1;
			if($solarRaw[2]<$yearDown){
				$yearDown = $yearDown - 100;
			}
			$yearUp = $yearDown + 99;
			if($solarRaw[3]<10){
				$monthZero = "0".$solarRaw[3];
			}
			else{
				$monthZero = $solarRaw[3];
			}
			if($solarRaw[4]<10){
				$dayZero = "0".$solarRaw[4];
			}
			else{
				$dayZero = $solarRaw[4];
			}
			$solarArray['imgLink'] = "http://eclipse.gsfc.nasa.gov/5MCSEmap/".formatYear($yearDown)."-".formatYear($yearUp)."/".$solarRaw[2]."-".$monthZero."-".$dayZero.".gif";
			
			if($solarArray['date']>=time()){
				$solarEclipses[] = $solarArray;
			}
			
			if(date("Ymd",$solarArray['date']) == date("Ymd")){ // check if it is today
				$solarToday = $solarArray;
			}
		}
		fclose($solarsFile);
	}
	$output['solarEclipses'] = $solarEclipses;
	
	function formatYear($value){
		if($value>=0){
			$result = sprintf('%04d', $value);
		}
		else{
			$result = "-".sprintf('%04d', abs($value));
		}
		return $result;
	}
?>
	<div style="width:98%;margin:0 auto;text-align:center">
		<img src="homepage/blocks/solarEclipses/icons/<?php echo $theme?>/solar.png" style="width:40px">
		<?php
			if($solarEclipsesHeading){
		?>
				<h2><?php echo lang('solar eclipses','c')?></h2>
		<?php
			}
		?>
	</div>
	<table style="width:98%;margin:0 auto">
		<tr>
			<td style="text-align:left;padding-left: 3%;width:50%">
				<?php echo date($dateTimeFormat,$output['solarEclipses'][0]['date'])?>
			</td>
			<td>
				<span style="font-variant:small-caps;font-weight:bold;font-size:1.1em"><?php echo $output['solarEclipses'][0]['type']?></span>
			</td>
		</tr>
	</table>
	<div id="solarDetails" class="details">
		<table style="width:98%;margin:0 auto">
			<tr>
				<td style="text-align:left;padding-left: 3%;width:50%">
					Azimuth
				</td>
				<td>
					<?php echo $output['solarEclipses'][0]['azimuth']?>
				</td>
				<td rowspan="3">
					<img src='<?php echo $output['solarEclipses'][0]['imgLink']?>' style="max-width:100px;width:100%" class="zoom" alt=''>
				</td>
			</tr>
			<tr>
				<td style="text-align:left;padding-left: 3%">
					Altitude
				</td>
				<td>
					<?php echo $output['solarEclipses'][0]['altitude']?>
				</td>
			</tr>
			<tr>
				<td style="text-align:left;padding-left: 3%">
					Duration
				</td>
				<td>
					<?php echo $output['solarEclipses'][0]['duration']?> s
				</td>
			</tr>
		</table>
		<table style="width:98%;margin:0 auto">
			<?php 
				for($i=1;$i<=$upcomingSolar;$i++){
			?>
					<tr>
						<td style="text-align:left;padding-left: 3%;width:50%">
							<?php echo date($dateTimeFormat,$output['solarEclipses'][$i]['date'])?>
						</td>
						<td>
							<span style="font-variant:small-caps;font-weight:bold;font-size:1.1em"><?php echo $output['solarEclipses'][$i]['type']?></span>
						</td>
					</tr>
			<?php
				}
			?>
		</table>
	</div>
	<span class="more" onclick="txt = $('#solarDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#solarDetails').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>