<?php
	include("../../../config.php");
	include("../../../scripts/functions.php");

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}

	// error_reporting(E_ALL);
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$ID = $_GET['id'];

	if($ID=="T"){
		$parameterMax = "Tmax";
		$parameterMin = "Tmin";
		$parameterAvg = "T";
		$units = unitFormatter($displayTempUnits);
		$dp = 1;
	}
	if($ID=="H"){
		$parameterMax = "H";
		$parameterMin = "H";
		$parameterAvg = "H";
		$units = "%";
		$dp = 1;
	}
	if($ID=="A"){
		$parameterMax = "A";
		$parameterMin = "A";
		$parameterAvg = "A";
		$units = unitFormatter($displayTempUnits);
		$dp = 1;
	}
	if($ID=="D"){
		$parameterMax = "D";
		$parameterMin = "D";
		$parameterAvg = "D";
		$units = unitFormatter($displayTempUnits);
		$dp = 1;
	}
	if($ID=="P"){
		$parameterMax = "P";
		$parameterMin = "P";
		$parameterAvg = "P";
		$units = unitFormatter($displayPressUnits);
		$dp = $displayPressUnits=="inHg" ? 2 : 1;
	}
	if($ID=="W"){
		$parameterMax = "W";
		$parameterMin = "W";
		$parameterAvg = "W";
		$units = unitFormatter($displayWindUnits);
		$dp = 1;
	}
	if($ID=="G"){
		$parameterMax = "G";
		$parameterMin = "G";
		$parameterAvg = "G";
		$units = unitFormatter($displayWindUnits);
		$dp = 1;
	}
	if($ID=="R"){
		$units = unitFormatter($displayRainUnits);
		$dp = $displayRainUnits=="in" ? 2 : 1;
	}

	if($ID!="R"){
		// today - we always have this
		$result = mysqli_query($con,
			"
			SELECT ".$parameterMax.", ".$parameterMin.", ".$parameterAvg.", Datetime
			FROM alldata
			WHERE DAY(Datetime)=".date("d")." AND MONTH(Datetime)=".date("m")."
			ORDER BY Datetime
			"
		);
		while($row = mysqli_fetch_array($result)){
			if(!isset($todayAbsMax)){
				$todayAbsMaxYear = array();
				$todayAbsMax = $row[$parameterMax];
				$todayAbsMaxYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMax]>$todayAbsMax){
				$todayAbsMaxYear = array();
				$todayAbsMax = $row[$parameterMax];
				$todayAbsMaxYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMax]==$todayAbsMax){
				$todayAbsMaxYear[] = date("Y",strtotime($row['Datetime']));
			}
			if(!isset($todayAbsMin)){
				$todayAbsMinYear = array();
				$todayAbsMin = $row[$parameterMin];
				$todayAbsMinYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMin]<$todayAbsMin){
				$todayAbsMinYear = array();
				$todayAbsMin = $row[$parameterMin];
				$todayAbsMinYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMin]==$todayAbsMin){
				$todayAbsMinYear[] = date("Y",strtotime($row['Datetime']));
			}
			$today[] = $row[$parameterAvg];
		}

		// yesterday
		$result = mysqli_query($con,
			"
			SELECT ".$parameterMax.", ".$parameterMin.", ".$parameterAvg.", Datetime
			FROM alldata
			WHERE DAY(Datetime)=".date("d",strtotime("yesterday"))." AND MONTH(Datetime)=".date("m",strtotime("yesterday"))."
			ORDER BY Datetime
			"
		);
		while($row = mysqli_fetch_array($result)){
			if(!isset($yesterdayAbsMax)){
				$yesterdayAbsMaxYear = array();
				$yesterdayAbsMax = $row[$parameterMax];
				$yesterdayAbsMaxYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMax]>$yesterdayAbsMax){
				$yesterdayAbsMaxYear = array();
				$yesterdayAbsMax = $row[$parameterMax];
				$yesterdayAbsMaxYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMax]==$yesterdayAbsMax){
				$yesterdayAbsMaxYear[] = date("Y",strtotime($row['Datetime']));
			}
			if(!isset($yesterdayAbsMin)){
				$yesterdayAbsMinYear = array();
				$yesterdayAbsMin = $row[$parameterMin];
				$yesterdayAbsMinYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMin]<$yesterdayAbsMin){
				$yesterdayAbsMinYear = array();
				$yesterdayAbsMin = $row[$parameterMin];
				$yesterdayAbsMinYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMin]==$yesterdayAbsMin){
				$yesterdayAbsMinYear[] = date("Y",strtotime($row['Datetime']));
			}
			$yesterday[] = $row[$parameterAvg];
		}

		// tomorrow
		$result = mysqli_query($con,
			"
			SELECT ".$parameterMax.", ".$parameterMin.", ".$parameterAvg.", Datetime
			FROM alldata
			WHERE DAY(Datetime)=".date("d",strtotime("tomorrow"))." AND MONTH(Datetime)=".date("m",strtotime("tomorrow"))."
			ORDER BY Datetime
			"
		);
		while($row = mysqli_fetch_array($result)){
			if(!isset($tomorrowAbsMax)){
				$tomorrowAbsMaxYear = array();
				$tomorrowAbsMax = $row[$parameterMax];
				$tomorrowAbsMaxYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMax]>$tomorrowAbsMax){
				$tomorrowAbsMaxYear = array();
				$tomorrowAbsMax = $row[$parameterMax];
				$tomorrowAbsMaxYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMax]==$tomorrowAbsMax){
				$tomorrowAbsMaxYear[] = date("Y",strtotime($row['Datetime']));
			}
			if(!isset($tomorrowAbsMin)){
				$tomorrowAbsMinYear = array();
				$tomorrowAbsMin = $row[$parameterMin];
				$tomorrowAbsMinYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMin]<$tomorrowAbsMin){
				$tomorrowAbsMinYear = array();
				$tomorrowAbsMin = $row[$parameterMin];
				$tomorrowAbsMinYear[] = date("Y",strtotime($row['Datetime']));
			}
			if($row[$parameterMin]==$tomorrowAbsMin){
				$tomorrowAbsMinYear[] = date("Y",strtotime($row['Datetime']));
			}
			$tomorrow[] = $row[$parameterAvg];
		}

		$todayAbsMaxYear = array_unique($todayAbsMaxYear);
		sort($todayAbsMaxYear);

		$todayAbsMinYear = array_unique($todayAbsMinYear);
		sort($todayAbsMinYear);

		if(isset($yesterdayAbsMaxYear)){
			$yesterdayAbsMaxYear = array_unique($yesterdayAbsMaxYear);
			sort($yesterdayAbsMaxYear);
		}

		if(isset($yesterdayAbsMinYear)){
			$yesterdayAbsMinYear = array_unique($yesterdayAbsMinYear);
			sort($yesterdayAbsMinYear);
		}

		if(isset($tomorrowAbsMaxYear)){
			$tomorrowAbsMaxYear = array_unique($tomorrowAbsMaxYear);
			sort($tomorrowAbsMaxYear);
		}

		if(isset($tomorrowAbsMinYear)){
			$tomorrowAbsMinYear = array_unique($tomorrowAbsMinYear);
			sort($tomorrowAbsMinYear);
		}
	}
	else{
		// today rains
		$result = mysqli_query($con,
			"
			SELECT max(R), Datetime
			FROM alldata
			WHERE DAY(Datetime)=".date("d")." AND MONTH(Datetime)=".date("m")."
			GROUP BY YEAR(Datetime), MONTH(Datetime), DAY(Datetime)
			ORDER BY Datetime
			"
		);
		while($row = mysqli_fetch_array($result)){
			$year = date("Y",strtotime($row['Datetime']));
			$todayRains[$year] = convertR($row['max(R)']);
		}
		// yesterday rains
		$result = mysqli_query($con,
			"
			SELECT max(R), Datetime
			FROM alldata
			WHERE DAY(Datetime)=".date("d",strtotime("yesterday"))." AND MONTH(Datetime)=".date("m",strtotime("yesterday"))."
			GROUP BY YEAR(Datetime), MONTH(Datetime), DAY(Datetime)
			ORDER BY Datetime
			"
		);
		while($row = mysqli_fetch_array($result)){
			$year = date("Y",strtotime($row['Datetime']));
			$yesterdayRains[$year] = convertR($row['max(R)']);
		}
		// tomorrow rains
		$result = mysqli_query($con,
			"
			SELECT max(R), Datetime
			FROM alldata
			WHERE DAY(Datetime)=".date("d",strtotime("tomorrow"))." AND MONTH(Datetime)=".date("m",strtotime("tomorrow"))."
			GROUP BY YEAR(Datetime), MONTH(Datetime), DAY(Datetime)
			ORDER BY Datetime
			"
		);
		while($row = mysqli_fetch_array($result)){
			$year = date("Y",strtotime($row['Datetime']));
			$tomorrowRains[$year] = convertR($row['max(R)']);
		}
	}

	function thisConvert($value){
		global $ID;
		if($ID=="T" || $ID=="A" || $ID=="D"){
			return convertT($value);
		}
		if($ID=="H"){
			return ($value);
		}
		if($ID=="W" || $ID=="G"){
			return convertW($value);
		}
		if($ID=="P"){
			return convertP($value);
		}
		if($ID=="R"){
			return convertR($value);
		}
	}
	function analyzeYear($arr){
		if(count($arr)>3){
			return lang('more than 3 years','l');
		}
		else{
			return implode(", ",$arr);
		}
	}
	function analyzeYearR($arr,$aggregation){
		if($aggregation=="max"){
			$years = array_keys($arr,max($arr));
		}
		if($aggregation=="min"){
			$years = array_keys($arr,min($arr));
		}
		if(count($years)>3){
			return lang('more than 3 years','l');
		}
		else{
			return implode(", ",$years);
		}
	}
?>
<div class="details" id="stationRecordsYesterday" style="width:100%">
	<?php 
		if(isset($yesterdayAbsMax)){
	?>
			<table style="width:98%;margin:0 auto">
				<tr>
					<td colspan="3" style="font-size:1.2em;font-weight:bold">
						<?php echo date($dayMonthFormat,strtotime("yesterday"))?>
					</td>
				</tr>
				<tr>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('avgAbbr','c')?>
					</td>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('maximumAbbr','c')?>
					</td>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('minimumAbbr','c')?>
					</td>
				</tr>
				<tr>
					<td>
						<?php echo number_format(thisConvert(array_sum($yesterday)/count($yesterday)),$dp,".","")." ".$units?>
					</td>
					<td>
						<?php echo number_format(thisConvert($yesterdayAbsMax),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYear($yesterdayAbsMaxYear)?></span>
					</td>
					<td>
						<?php echo number_format(thisConvert($yesterdayAbsMin),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYear($yesterdayAbsMinYear)?></span>
					</td>
				</tr>
			</table>
	<?php
		}
	?>
	<?php 
		if(isset($yesterdayRains)){
	?>
			<table style="width:98%;margin:0 auto">
				<tr>
					<td colspan="3" style="font-size:1.2em;font-weight:bold">
						<?php echo date($dayMonthFormat,strtotime("yesterday"))?>
					</td>
				</tr>
				<tr>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('avgAbbr','c')?>
					</td>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('maximumAbbr','c')?>
					</td>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('minimumAbbr','c')?>
					</td>
				</tr>
				<tr>
					<td>
						<?php echo number_format(thisConvert(array_sum($yesterdayRains)/count($yesterdayRains)),$dp,".","")." ".$units?>
					</td>
					<td>
						<?php echo number_format(thisConvert(max($yesterdayRains)),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYearR($yesterdayRains,'max')?></span>
					</td>
					<td>
						<?php echo number_format(thisConvert(min($yesterdayRains)),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYearR($yesterdayRains,'min')?></span>
					</td>
				</tr>
			</table>
	<?php
		}
	?>
	<br>
</div>
<?php 
	if($ID!="R"){
?>
	<table style="width:98%;margin:0 auto">
		<tr>
			<td colspan="3" style="font-size:1.2em;font-weight:bold">
				<?php echo date($dayMonthFormat)?>
			</td>
		</tr>
		<tr>
			<td style="width:33%;font-weight:bold;font-variant:small-caps">
				<?php echo lang('avgAbbr','c')?>
			</td>
			<td style="width:33%;font-weight:bold;font-variant:small-caps">
				<?php echo lang('maximumAbbr','c')?>
			</td>
			<td style="width:33%;font-weight:bold;font-variant:small-caps">
				<?php echo lang('minimumAbbr','c')?>
			</td>
		</tr>
		<tr>
			<td>
				<?php echo number_format(thisConvert(array_sum($today)/count($today)),$dp,".","")." ".$units?>
			</td>
			<td>
				<?php echo number_format(thisConvert($todayAbsMax),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYear($todayAbsMaxYear)?></span>
			</td>
			<td>
				<?php echo number_format(thisConvert($todayAbsMin),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYear($todayAbsMinYear)?></span>
			</td>
		</tr>
	</table>
<?php 
	}
?>
<?php 
	if($ID=="R"){
?>
		<table style="width:98%;margin:0 auto">
			<tr>
				<td colspan="3" style="font-size:1.2em;font-weight:bold">
					<?php echo date($dayMonthFormat,strtotime("today"))?>
				</td>
			</tr>
			<tr>
				<td style="width:33%;font-weight:bold;font-variant:small-caps">
					<?php echo lang('avgAbbr','c')?>
				</td>
				<td style="width:33%;font-weight:bold;font-variant:small-caps">
					<?php echo lang('maximumAbbr','c')?>
				</td>
				<td style="width:33%;font-weight:bold;font-variant:small-caps">
					<?php echo lang('minimumAbbr','c')?>
				</td>
			</tr>
			<tr>
				<td>
					<?php echo number_format(thisConvert(array_sum($todayRains)/count($todayRains)),$dp,".","")." ".$units?>
				</td>
				<td>
					<?php echo number_format(thisConvert(max($todayRains)),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYearR($todayRains,'max')?></span>
				</td>
				<td>
					<?php echo number_format(thisConvert(min($todayRains)),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYearR($todayRains,'min')?></span>
				</td>
			</tr>
		</table>
<?php
	}
?>
<div class="details" id="stationRecordsTomorrow" style="width:100%">
	<br>
	<?php 
		if(isset($tomorrowAbsMax)){
	?>
			<table style="width:98%;margin:0 auto">
				<tr>
					<td colspan="3" style="font-size:1.2em;font-weight:bold">
						<?php echo date($dayMonthFormat,strtotime("tomorrow"))?>
					</td>
				</tr>
				<tr>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('avgAbbr','c')?>
					</td>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('maximumAbbr','c')?>
					</td>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('minimumAbbr','c')?>
					</td>
				</tr>
				<tr>
					<td>
						<?php echo number_format(thisConvert(array_sum($tomorrow)/count($tomorrow)),$dp,".","")." ".$units?>
					</td>
					<td>
						<?php echo number_format(thisConvert($tomorrowAbsMax),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYear($tomorrowAbsMaxYear)?></span>
					</td>
					<td>
						<?php echo number_format(thisConvert($tomorrowAbsMin),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYear($tomorrowAbsMinYear)?></span>
					</td>
				</tr>
			</table>
	<?php
		}
	?>
	<?php 
		if(isset($tomorrowRains)){
	?>
			<table style="width:98%;margin:0 auto">
				<tr>
					<td colspan="3" style="font-size:1.2em;font-weight:bold">
						<?php echo date($dayMonthFormat,strtotime("tomorrow"))?>
					</td>
				</tr>
				<tr>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('avgAbbr','c')?>
					</td>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('maximumAbbr','c')?>
					</td>
					<td style="width:33%;font-weight:bold;font-variant:small-caps">
						<?php echo lang('minimumAbbr','c')?>
					</td>
				</tr>
				<tr>
					<td>
						<?php echo number_format(thisConvert(array_sum($tomorrowRains)/count($tomorrowRains)),$dp,".","")." ".$units?>
					</td>
					<td>
						<?php echo number_format(thisConvert(max($tomorrowRains)),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYearR($tomorrowRains,'max')?></span>
					</td>
					<td>
						<?php echo number_format(thisConvert(min($tomorrowRains)),$dp,".","")." ".$units;?><br><span style="font-size:0.8em"><?php echo analyzeYearR($tomorrowRains,'min')?></span>
					</td>
				</tr>
			</table>
	<?php
		}
	?>
</div>
<span class="more" onclick="txt = $('#stationRecordsTomorrow').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#stationRecordsTomorrow').slideToggle(800);$('#stationRecordsYesterday').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
</span>