<?php

	# 		Station Records
	# 		Namespace:		stationRecords
	#		Meteotemplate Block
	
	# 		v1.0 - Mar 7, 2017
	# 			- initial release
	# 		v2.0 - Mar 8, 2017
	# 			- added date format setup
	# 		v3.0 - Mar 11, 2017
	# 			- added other variables (in addition to temperature)
	# 		v4.0 - Mar 13, 2017
	# 			- added precipitation
	# 		v4.1 - Mar 14, 2017
	# 			- minor bug fixes
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}
	
?>
	
	<style>
		.recordsSelectorIcon{
			font-size:1.3em;
			opacity:0.8;
			cursor:pointer;
		}
		.recordsSelectorIcon:hover{
			opacity:1;
		}
	</style>
	<span class="mticon-temp recordsSelectorIcon tooltip" data-id="T" title="<?php echo lang('temperature','c')?>"></span>
	<span class="mticon-humidity recordsSelectorIcon tooltip" data-id="H" title="<?php echo lang('humidity','c')?>"></span>
	<span class="mticon-pressure recordsSelectorIcon tooltip" data-id="P" title="<?php echo lang('pressure','c')?>"></span>
	<span class="mticon-wind recordsSelectorIcon tooltip" data-id="W" title="<?php echo lang('wind speed','c')?>"></span>
	<span class="mticon-gust recordsSelectorIcon tooltip" data-id="G" title="<?php echo lang('wind gust','c')?>"></span>
	<span class="mticon-apparent recordsSelectorIcon tooltip" data-id="A" title="<?php echo lang('apparent temperature','c')?>"></span>
	<span class="mticon-dewpoint recordsSelectorIcon tooltip" data-id="D" title="<?php echo lang('dew point','c')?>"></span>
	<span class="mticon-rain recordsSelectorIcon tooltip" data-id="R" title="<?php echo lang('precipitation','c')?>"></span>
	<div id="recordsDiv"><?php echo lang('loading','c')?>...</div>
	<script>
		$("#recordsDiv").load("homepage/blocks/stationRecords/loadData.php?id=T");
		$(".recordsSelectorIcon").click(function(){
			varType = $(this).attr("data-id");
			$("#recordsDiv").html("<?php echo lang('loading','c')?>...");
			$("#recordsDiv").load("homepage/blocks/stationRecords/loadData.php?id="+varType);
		})
	</script>
