<?php
	############################################################################
	# 	
	#	Meteotemplate
	# 	http://www.meteotemplate.com
	# 	Free website template for weather enthusiasts
	# 	Author: Jachym
	#  Brno, Czech Republic
	# 	First release: 2015
	#
	############################################################################
	#
	#	Main Homepage
	#
	############################################################################
	#	Version (change log - http://meteotemplate.com/blog/?page_id=42)
	#
	# 	v5.0 Kiwi	2016-03-28
	#
	############################################################################
	
	include("config.php");
	
	############################################################################
	
	# HOMEPAGE SETTINGS
	
	############################################################################
	# DESIGN
	// Select the design theme. There are two themes: light and dark. You can either set this to one particular or you can make it variable.
	// Options:
	// "dark" - default, sets the theme to dark all the time
	// "light" - light theme all the time
	// "sun" - this will set the theme based on the time of the day - dark theme before sunrise and after sunset, light theme during day time
	// "variable" - if you select this you can define fixed hours when the design should change - i.e. define specific hour in the morning when light theme will appear and specific hour in the evening when it changes to dark again. So it is more or less same thing as the sun option, but this time it does not change during the year.
	$theme = "dark";
		$morningSwitch = 7; // if you selected "variable" above, then here you specify the hour in the morning for the switch. If you used any other option, you can ignore this parameter. The number should be given in the 24h format - in other words a number from 0 to 23
		$eveningSwitch = 19; // if you selected "variable" above, then here you specify the hour in the evening for the switch back to dark theme. If you used any other option, you can ignore this parameter. The number should be given in the 24h format - in other words a number from 0 to 23
	
	$blockColor = $design; // choose whether you want the blocks to have color1 or color2 of your design combination for the template. For color 1 use "design", for color 2 use "design2"
	$blockRadius = 3; // The following parameter sets the "roundedness" (border-radius) of the blocks. You can specify the number of pixels for the radius. 0 means the borders will not be rounded at all, the higher the number, the more rounded the block borders will be.
	############################################################################
	
	# BLOCKS - see documentation at http://www.meteotemplate.com/web/wiki/wikiHomepage.php
	
	// examples: 
	// $column1 = array("logo");
	// $column2 = array("multipleBlock(current,50;stationData,50)");
	
	$columnWidths = array(25,50,25);
	$column1 = array("stationData","info","location","co2","earthquakes","dayNight","cloudHeight","cloudTemp","rain","calendarMonth","indoor","snow","gauges");
	$column2 = array("current","warningsEU","warningsEUregions","forecast","meteogram","radarEU","worldTime","interactiveGraph","webcam","nasaImg","map","logo");
	$column3 = array("greetings","clockDigital","riset","moonPhase","calendar","meteors","solarEclipses","lunarEclipses","astroEvents","baroTrend","weatherNetworks","glossary","stationStatus","uvForecast","regionalUK","ozoneForecast");
	
	$columns = array($column1, $column2, $column3);
	
	############################################################################
	
	$spinnerID = rand(1,11);
	
	include("homepage/css/themeSetter.php");
	include("css/design.php");
	include("header.php");	
?>
<!DOCTYPE html>
<html>
	<head>
		<title><?php echo $pageName?></title>
		<?php metaHeader()?>
		<script src="https://maps.googleapis.com/maps/api/js"></script>
		<script src="homepage/scripts/jquery.elevatezoom.js" type="text/javascript"></script>
		<?php include("homepage/css/style.php")?>
		<style>
			
		</style>
	</head>
	<!--<body style="overflow-x:hidden">-->
	<body>
		<div id="main_top">
			<?php bodyHeader()?>
			<?php include("menu.php")?>
		</div>
		<div id="main" style="text-align:center">
			<table style="width:98%;margin:0 auto">
				<tr>
					<?php
						for($i=0;$i<count($columns);$i++){
					?>
							<td style="width:<?php echo $columnWidths[$i]?>%;vertical-align:top;padding:5px">
								<?php
									for($a=0;$a<count($columns[$i]);$a++){
										if (strpos($columns[$i][$a], 'multipleBlock') !== false) {
											preg_match("/multipleBlock\((.*?)\)/",$columns[$i][$a],$matches);
											$blocksMultiple = explode(";",$matches[1]);
											echo "<table style='width:100%' class='multipleTable'><tr>";
											foreach($blocksMultiple as $blockMultiple){
												$blockMultiple = explode(",",$blockMultiple);
												echo "<td style='width:".$blockMultiple[1]."%;margin:0 auto' class='multipleTD'>";
								?>
													<div class="block" id="<?php echo $blockMultiple[0]?>Block" style="width:98%;padding-left:0px;padding-right:0px;border:0px"><?php include("homepage/css/spinner.php")?></div>
								<?php
												echo "</td>";
											}	
											echo "</tr></table>";
										}
										else{
								?>
											<div class="block" id="<?php echo $columns[$i][$a]?>Block"><?php include("homepage/css/spinner.php")?></div>
								<?php
										}
									}
								?>
							</td>
					<?php
						}
					?>
				</tr>
			</table>
		</div>
		<?php include($baseURL."footer.php")?>
		<script>
			$(document).ready(function(){
				<?php
					for($i=0;$i<count($columns);$i++){
						for($a=0;$a<count($columns[$i]);$a++){
							if (strpos($columns[$i][$a], 'multipleBlock') !== false) {
								preg_match("/multipleBlock\((.*?)\)/",$columns[$i][$a],$matches);
								$blocksMultiple = explode(";",$matches[1]);
								foreach($blocksMultiple as $blockMultiple){
									$blockMultiple = explode(",",$blockMultiple);
				?>
									$("#<?php echo $blockMultiple[0]?>Block").load("homepage/blocks/<?php echo $blockMultiple[0]?>/<?php echo $blockMultiple[0]?>Block.php");
				<?php
								}
							}
							else{
				?>
								$("#<?php echo $columns[$i][$a]?>Block").load("homepage/blocks/<?php echo $columns[$i][$a]?>/<?php echo $columns[$i][$a]?>Block.php");
				<?php
							}
						}
					}
				?>
			})
		</script>
	</body>
</html>