<?php

	# 		Summary
	# 		Namespace:		summary
	#		Meteotemplate Block

	# 		v2.0 - Feb 24, 2016
	#			- minor changes in some of the strings
	#			- fixed issue with too many date/times of occurance
	# 		v2.1 - Apr 1, 2016
	#			- CSS changes
	#		v2.2 - Sep 10, 2016
	#			- bug fixes
	#		v2.3 - Sep 23, 2016
	#			- language corrections
	#		v3.0 - Oct 26, 2016
	#			- localization
	#			- Czech language support
	#		v4.0 - Nov 12, 2016
	#			- added German, Spanish, Italian, French and Norwegian support
	#			- bug fixes
	#		v4.1 - Nov 13, 2016
	#			- added Portuguese
	#		v5.0 - Nov 18, 2016
	#			- updated German translation
	#			- minor bug fixes
	#			- block optimization
	#		v5.1 - Dec 22, 2016
	#			- fixed light theme styling
	#		v5.2 - Feb 7, 2017
	#			- added support for Dutch
	#		v5.3 - Mar 3, 2017
	#			- added support for Swedish
	#		v5.4 - Mar 25, 2017
	#			- optimized capitalization
	#		v5.5 - Jul 7, 2022 (davidefa)
	#			- forecasts: update to yr.no api v2.0
	#		v5.6 - Jul 8, 2022 (davidefa)
	#			- forecasts: corrected temperature

	$thisBlockVersion = "5.6";

	$time = microtime();
	$time = explode(' ', $time);
	$time = $time[1] + $time[0];
	$blockStartTime = $time;

	$errorLog[] = array("","%c Loading Block Summary ".$thisBlockVersion."','font-weight:bold;color:green");


	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");

	include("settings.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if(file_exists("lang/".$lang.".php")){
		include("lang/".$lang.".php");
	}

	// capital letters - months, days of the week
	if($lang=="gb" || $lang=="us" || $lang=="de"){
		$dateCapital = "c";
	}
	else{
		$dateCapital = "l";
	}

	if($displayRainUnits=="mm"){
		$decimalsRain = 1;
	}
	else{
		$decimalsRain = 2;
	}

	if($displayPressUnits=="hpa"){
		$decimalsPressure = 1;
	}
	else{
		$decimalsPressure = 2;
	}

	//$yrNoLocation = "http://www.yr.no/place/".$myLocation."/forecast.xml";
	//$yrNoLocation = "https://api.met.no/weatherapi/locationforecast/2.0/classic?lat=59.93&lon=10.72&altitude=90";
	//$yrNoLocation = "https://api.met.no/weatherapi/locationforecast/2.0/classic?".$myLocation;
	$yrNoLocation = 'https://api.met.no/weatherapi/locationforecast/2.0/compact?'.$myLocation;

	$errorLog[] = array("","Yr.no location for forecast: ".$yrNoLocation);

	$sunRiseToday = date_sunrise(time(),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	$sunSetToday = date_sunset(time(),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	$dayLengthToday = round(($sunSetToday - $sunRiseToday)/60);

	$sunRiseYesterday = date_sunrise(strtotime('yesterday'),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	$sunSetYesterday = date_sunset(strtotime('yesterday'),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	$dayLengthYesterday = round(($sunSetYesterday - $sunRiseYesterday)/60);

	$sunRiseTomorrow = date_sunrise(strtotime('tomorrow'),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	$sunSetTomorrow = date_sunset(strtotime('tomorrow'),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	$dayLengthTomorrow = round(($sunSetTomorrow - $sunRiseTomorrow)/60);

	$dayLengthDiff = $dayLengthToday - $dayLengthYesterday;
	$dayLengthDiffTomorrow = $dayLengthTomorrow - $dayLengthToday;

	if($dayLengthDiff>1){
		$dayLengthDiffString = $dayLengthDiff." ".lang("minutes longer than","-")." ".lang("yesterday",'l');
	}
	else if($dayLengthDiff==1){
		$dayLengthDiffString = " ".lang("a minute longer than",'-')." ".lang("yesterday",'l');
	}
	else if($dayLengthDiff==0){
		$dayLengthDiffString = " ".lang("the same length as",'-')." ".lang("yesterday",'l');
	}
	else if($dayLengthDiff==-1){
		$dayLengthDiffString = " ".lang("a minute shorter than","-")." ".lang("yesterday",'l');
	}
	else if($dayLengthDiff<-1){
		$dayLengthDiffString = abs($dayLengthDiff)." ".lang("minutes shorter than","-")." ".lang("yesterday",'l');
	}
	else{

	}

	if($dayLengthDiffTomorrow>1){
		$dayLengthDiffStringTomorrow = $dayLengthDiffTomorrow." ".lang("minutes longer than","-")." ".lang("today",'l');
	}
	else if($dayLengthDiffTomorrow==1){
		$dayLengthDiffStringTomorrow = " ".lang("a minute longer than","-")." ".lang("today",'l');
	}
	else if($dayLengthDiffTomorrow==0){
		$dayLengthDiffStringTomorrow = " ".lang("the same length as","-")." ".lang("today",'l');
	}
	else if($dayLengthDiffTomorrow==-1){
		$dayLengthDiffStringTomorrow = " ".lang("a minute shorter than","-")." ".lang("today",'l');
	}
	else if($dayLengthDiffTomorrow<-1){
		$dayLengthDiffStringTomorrow = abs($dayLengthDiffTomorrow)." ".lang("minutes shorter than","-")." ".lang("today",'l');
	}
	else{}

	$mp = new moonPhase(time());
	$moonIllumination = $mp->getPercentOfIllumination();

	$moontimesToday = new MoonRiSet($stationLat, $stationLon, $stationTZ);
	$moontimesToday->setDate(date("Y"), date("m"), date("d"));
	$moonRiseToday = $moontimesToday->rise["timestamp"];
	$moonSetToday = $moontimesToday->set["timestamp"];
	$moonTransitToday = $moontimesToday->transit["timestamp"];

	$moonRisetString = "";
	if($moonRiseToday!="" && $moonSetToday!=""){
		$moonRisetString = lang("Moon rise is at","-")." ".date($timeFormat,$moonRiseToday).", ".lang("set at","-")." ".date($timeFormat,$moonSetToday).".";
	}
	if($moonRiseToday==""){
		$moonRisetString = lang("Moon set today is at","-")." ".date($timeFormat,$moonSetToday)." ".lang("and the Moon does not rise today","-").".";
	}
	if($moonSetToday==""){
		$moonRisetString = lang("Moon rise today is at","-")." ".date($timeFormat,$moonRiseToday)." ".lang("and the Moon does not set today","-").".";
	}

	$moontimesTomorrow = new MoonRiSet($stationLat, $stationLon, $stationTZ);
	$moontimesTomorrow->setDate(date("Y",strtotime('tomorrow')), date("m",strtotime('tomorrow')), date("d",strtotime('tomorrow')));
	$moonRiseTomorrow = $moontimesTomorrow->rise["timestamp"];
	$moonSetTomorrow = $moontimesTomorrow->set["timestamp"];
	$moonTransitTomorrow = $moontimesTomorrow->transit["timestamp"];

	$moonRisetStringTomorrow = "";
	if($moonRiseToday!="" && $moonSetToday!=""){
		$moonRisetStringTomorrow = lang("Moon rise tomorrow is at","-")." ".date($timeFormat,$moonRiseTomorrow)." ".lang("and set at","-")." ".date($timeFormat,$moonSetTomorrow).".";
	}
	if($moonRiseToday==""){
		$moonRisetStringTomorrow = lang("Moon set tomorrow is at","-")." ".date($timeFormat,$moonSetTomorrow)." ".lang("and the Moon does not rise","-").".";
	}
	if($moonSetToday==""){
		$moonRisetStringTomorrow = lang("Moon rise tomorrow is at","-")." ".date($timeFormat,$moonRiseTomorrow)." ".lang("and the Moon does not set","-").".";
	}

	$stationTimezone = new DateTimeZone($stationTZ);
	$stationOffset  = $stationTimezone->getOffset(new DateTime)/3600;

	$moonFile = fopen("files/moons.txt", "r"); // load the Moon data
	while(!feof($moonFile)) {
		$newRecord = explode(",",fgets($moonFile)); // process line
		$phase = $newRecord[3]; // get phase
		$timestamp = $newRecord[5]; // get timestamp
		if($timestamp>=time()){ // fetch only records in the future
			if($phase==3){
				$fullMoons[] = date("d-m-Y",$timestamp);
			}
			if($phase==2){
				$firstQuarters[] = date("d-m-Y",$timestamp);
			}
			if($phase==4){
				$lastQuarters[] = date("d-m-Y",$timestamp);
			}
			if($phase==1){
				$newMoons[] = date("d-m-Y",$timestamp);
			}
		}
		if(date("Ymd",$timestamp) == date("Ymd",strtotime('today'))){
			$moonToday = array($phase,$timestamp);
		}
		if(date("Ymd",$timestamp) == date("Ymd",strtotime('tomorrow'))){
			$moonTomorrow = array($phase,$timestamp);
		}
		for($c=2;$c<8;$c++){
			if(date("Ymd",$timestamp) == date("Ymd",strtotime('+'.$c.' days'))){
				${"moon".$c."day"} = array($phase,$timestamp);
			}
		}
	}
	fclose($moonFile);

	$moonString = "";

	if(isset($moonToday)){
		if($moonToday[0]==1){
			$moonString = lang("At","-")." ".date($timeFormat,$moonToday[1])." ".lang("today will be New Moon","-").". ";
		}
		if($moonToday[0]==2){
			$moonString = lang("At","-")." ".date($timeFormat,$moonToday[1])." ".lang("today the Moon will be in its first quarter","-").". ";
		}
		if($moonToday[0]==3){
			$moonString = lang("At","-")." ".date($timeFormat,$moonToday[1])." ".lang("today will be Full Moon","-").". ";
		}
		if($moonToday[0]==4){
			$moonString = lang("At","-")." ".date($timeFormat,$moonToday[1])." ".lang("today the Moon will be in its last quarter","-").". ";
		}
	}
	$moonString .= lang("The current Moon illumination is","-")." ".$moonIllumination." (".lang($mp->getPhaseName(),"l")."). ";

	$moonStringTomorrow = "";

	if(isset($moonTomorrow)){
		if($moonTomorrow[0]==1){
			$moonStringTomorrow = lang("At","-")." ".date($timeFormat,$moonTomorrow[1])." ".lang("tomorrow will be New Moon","-").". ";
		}
		if($moonTomorrow[0]==2){
			$moonStringTomorrow = lang("At","-")." ".date($timeFormat,$moonTomorrow[1])." ".lang("tomorrow the Moon will be in its first quarter","-").". ";
		}
		if($moonTomorrow[0]==3){
			$moonStringTomorrow = lang("At","-")." ".date($timeFormat,$moonTomorrow[1])." ".lang("tomorrow will be Full Moon","-").". ";
		}
		if($moonToday[0]==4){
			$moonStringTomorrow = lang("At","-")." ".date($timeFormat,$moonTomorrow[1])." ".lang("tomorrow the Moon will be in its last quarter","-").". ";
		}
	}

	$moonOutlook = "";

	for($c=2;$c<8;$c++){
		if(isset(${"moon".$c."day"})){
			if(${"moon".$c."day"}[0]==1){
				$moonOutlook .= lang("The upcoming","-")." ".formatLanguageDate(${"moon".$c."day"}[1])." ".lang("at","l")." ".date($timeFormat,${"moon".$c."day"}[1])." ".lang("will be a New Moon","-").". ";
			}
			if(${"moon".$c."day"}[0]==2){
				$moonOutlook .= lang("The upcoming","-")." ".formatLanguageDate(${"moon".$c."day"}[1])." ".lang("at","l")." ".date($timeFormat,${"moon".$c."day"}[1])." ".lang("the Moon will be in its first quarter","-").". ";
			}
			if(${"moon".$c."day"}[0]==3){
				$moonOutlook .= lang("The upcoming","-")." ".formatLanguageDate(${"moon".$c."day"}[1])." ".lang("at","l")." ".date($timeFormat,${"moon".$c."day"}[1])." ".lang("will be a Full Moon","-").". ";
			}
			if(${"moon".$c."day"}[0]==4){
				$moonOutlook .= lang("The upcoming","-")." ".formatLanguageDate(${"moon".$c."day"}[1])." ".lang("at","l")." ".date($timeFormat,${"moon".$c."day"}[1])." ".lang("the Moon will be in its last quarter","-").". ";
			}
		}
	}

	// seasons
	$seasonsToday = "";
	$seasonsTomorrow = "";
	$seasonsOutlook = "";
	$seasonsArray = array();

	$seasonsFile = fopen("files/seasons.txt", "r");
	while(!feof($seasonsFile)) {
		$currentSeasonDate = strtotime(fgets($seasonsFile));
		if($stationLat>=0){
			if(date('m',$currentSeasonDate)==3){
				$seasonsArray[] = array($currentSeasonDate + $stationOffset*3600,lang('Astronomical spring',"-"));
			}
			if(date('m',$currentSeasonDate)==6){
				$seasonsArray[] = array($currentSeasonDate + $stationOffset*3600,lang('Astronomical summer',"-"));
			}
			if(date('m',$currentSeasonDate)==9){
				$seasonsArray[] = array($currentSeasonDate + $stationOffset*3600,lang('Astronomical autumn',"-"));
			}
			if(date('m',$currentSeasonDate)==12){
				$seasonsArray[] = array($currentSeasonDate + $stationOffset*3600,lang('Astronomical winter',"-"));
			}
		}
		else{
			if(date('m',$currentSeasonDate)==9){
				$seasonsArray[] = array($currentSeasonDate + $stationOffset*3600,lang('Astronomical spring',"-"));
			}
			if(date('m',$currentSeasonDate)==12){
				$seasonsArray[] = array($currentSeasonDate + $stationOffset*3600,lang('Astronomical summer',"-"));
			}
			if(date('m',$currentSeasonDate)==3){
				$seasonsArray[] = array($currentSeasonDate + $stationOffset*3600,lang('Astronomical autumn',"-"));
			}
			if(date('m',$currentSeasonDate)==6){
				$seasonsArray[] = array($currentSeasonDate + $stationOffset*3600,lang('Astronomical winter',"-"));
			}
		}
	}
	fclose($seasonsFile);

	foreach($seasonsArray as $newSeason){
		if(date('Ymd',$newSeason[0])==date('Ymd')){
			$seasonsToday = ucfirst($newSeason[1])." ".lang("begins today at","-")." ".date($timeFormat,$newSeason[0]).". ";
		}
		if(date('Ymd',$newSeason[0])==date('Ymd')){
			$seasonsTomorrow = ucfirst($newSeason[1])." ".lang("begins tomorrow at",'-')." ".date($timeFormat,$newSeason[0]).". ";
		}
		for($c=2;$c<8;$c++){
			if(date('Ymd',$newSeason[0])==date('Ymd',strtotime('+'.$c.' days'))){
				$seasonsOutlook = ucfirst($newSeason[1])." ".lang("begins on the upcoming","-")." ".formatLanguageDate(strtotime('+'.$c.' days'))." ".lang("at","l")." ".date($timeFormat,$newSeason[0]).". ";
			}
		}
	}

	// meteor showers

	$from = strtotime(date("Y")."/1/3 00:00:00");
	$to = strtotime(date("Y")."/1/4 23:59:59");
	$name = lang("Quadrantids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/4/22 00:00:00");
	$to = strtotime(date("Y")."/4/23 23:59:59");
	$name = lang("Lyrids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/5/6 00:00:00");
	$to = strtotime(date("Y")."/5/7 23:59:59");
	$name = lang("Eta Aquarids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/7/29 00:00:00");
	$to = strtotime(date("Y")."/7/29 23:59:59");
	$name = lang("Delta Aquarids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/7/27 00:00:00");
	$to = strtotime(date("Y")."/7/28 23:59:59");
	$name = lang("Alpha Capricornids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/8/12 00:00:00");
	$to = strtotime(date("Y")."/8/13 23:59:59");
	$name = lang("Perseids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/10/21 00:00:00");
	$to = strtotime(date("Y")."/10/22 23:59:59");
	$name = lang("Orionids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/11/5 00:00:00");
	$to = strtotime(date("Y")."/11/6 23:59:59");
	$name = lang("South Taurids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/11/11 00:00:00");
	$to = strtotime(date("Y")."/11/12 23:59:59");
	$name = lang("North Taurids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/11/17 00:00:00");
	$to = strtotime(date("Y")."/11/18 23:59:59");
	$name = lang("Leonids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/12/13 00:00:00");
	$to = strtotime(date("Y")."/12/14 23:59:59");
	$name = lang("Geminids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime(date("Y")."/12/21 00:00:00");
	$to = strtotime(date("Y")."/12/22 23:59:59");
	$name = lang("Ursids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$from = strtotime((date("Y")+1)."/1/3 00:00:00");
	$to = strtotime((date("Y")+1)."/1/4 23:59:59");
	$name = lang("Quadrantids",'c');
	$meteorShowers[] = array($from, $to, $name);

	$meteorsToday = "";
	$meteorsTomorrow = "";
	$meteorsOutlook = "";
	foreach($meteorShowers as $showers){
		if(($showers[0]<time())&&($showers[1]>time())){
			$meteorsToday .= lang("It is currently possible to watch the","-")." ".$showers[2]." ".lang("meteor showers, which can be observed from","-")." ".formatLanguageDate($showers[0])." ".lang("until",'l')." ".formatLanguageDate($showers[1]).". ";
		}
		if(($showers[0]<strtotime('tomorrow'))&&($showers[1]>strtotime('tomorrow'))){
			$meteorsTomorrow .= lang("It will be possible tomorrow to watch the","-")." ".$showers[2]." ".lang("meteor showers, which can be observed from","-")." ".formatLanguageDate($showers[0])." ".lang("until",'l')." ".formatLanguageDate($showers[1]).". ";
		}
		for($c=2;$c<8;$c++){
			if(date('Ymd',$showers[0])==date('Ymd',strtotime('+'.$c.' days'))){
				$meteorsOutlook .= lang("It will be possible to watch the","-")." ".$showers[2]." ".lang("meteor showers, which can be observed from","-")." ".formatLanguageDate($showers[0])." ".lang("until",'l')." ".formatLanguageDate($showers[1]).". ";
			}
		}
	}

	function formatLanguageDate($varDate){
		global $dateCapital;
		return lang(strtolower(date("l",$varDate)),$dateCapital)." ".date("j",$varDate)." ".lang(strtolower("month".date("n",$varDate)),$dateCapital);
	}

	// lunar eclipses
	$lunarEclipseToday = "";
	$lunarEclipseTomorrow = "";
	$lunarEclipseOutlook = "";

	$lunarsFile = fopen("files/lunarEclipses.txt", "r");
	while(!feof($lunarsFile)) {
		$lunarArray = array();
		$lunarRaw = explode(";",fgets($lunarsFile));
		$lunarArray['date'] = strtotime($lunarRaw[1]."/".$lunarRaw[2]."/".$lunarRaw[3]." ".$lunarRaw[4]) + $stationOffset*60*60;
		$lunarArray['dateUTC'] = strtotime($lunarRaw[1]."/".$lunarRaw[2]."/".$lunarRaw[3]." ".$lunarRaw[4]);
		$lunarType = $lunarRaw[8];
			if($lunarType=="T"){
				$lunarArray['type'] = lang("a total eclipse","-");
			}
			if($lunarType=="P"){
				$lunarArray['type'] = lang("a partial eclipse","-");
			}
			if($lunarType=="N"){
				$lunarArray['type'] = lang("a penumbral eclipse","-");
			}
			if($lunarType=="Tm"){
				$lunarArray['type'] = lang("a total middle eclipse of Saros series","-");
			}
			if($lunarType=="Pm"){
				$lunarArray['type'] = lang("a partial middle eclipse of Saros series","-");
			}
			if($lunarType=="Nm"){
				$lunarArray['type'] = lang("a penumbral middle eclipse of Saros series","-");
			}
			if($lunarType=="T+"){
				$lunarArray['type'] = lang("a total central total eclipse<br>Moon\'s center passes north of the shadow axis","-");
			}
			if($lunarType=="T-"){
				$lunarArray['type'] = lang("a central total eclipse, where Moon\'s center passes south of the shadow axis","-");
			}
			if($lunarType=="Tx"){
				$lunarArray['type'] = lang("a total penumbral lunar eclipse","-");
			}
			if($lunarType=="Nb"){
				$lunarArray['type'] = lang("the first penumbral eclipse in series","-");
			}
			if($lunarType=="Ne"){
				$lunarArray['type'] = lang("the last penumbral eclipse in series","-");
			}
		$lunarArray['penPhaseLength'] = $lunarRaw[12];
		$lunarArray['parPhaseLength'] = $lunarRaw[13];
		$lunarArray['totalPhaseLength'] = $lunarRaw[14];

		if($lunarArray['date']>=time()){
			$lunarEclipses[] = $lunarArray;
		}
	}
	fclose($lunarsFile);

	foreach($lunarEclipses as $eclipseLunar){
		if(date('Ymd',$eclipseLunar['date'])==date('Ymd')){
			$lunarEclipseToday .= lang("Today at","-")." ".date($timeFormat,$eclipseLunar['date'])." (".date("d-m-Y",$eclipseLunar['dateUTC'])." UTC) ".lang("is a lunar eclipse. It is","-")." ".$eclipseLunar['type'].". ";
			if($eclipseLunar['penPhaseLength']>0){
				$lunarEclipseToday .= lang("The penumbral phase length is","-")." ".$eclipseLunar['penPhaseLength']." ".lang("minutes","-").". ";
			}
			if($eclipseLunar['parPhaseLength']>0){
				$lunarEclipseToday .= lang("The partial phase length is","-")." ".$eclipseLunar['parPhaseLength']." ".lang("minutes","-").". ";
			}
			if($eclipseLunar['totalPhaseLength']>0){
				$lunarEclipseToday .= lang("The total phase length is","-")." ".$eclipseLunar['totalPhaseLength']." ".lang("minutes","-").". ";
			}
		}
		if(date('Ymd',$eclipseLunar['date'])==date('Ymd',strtotime('tomorrow'))){
			$lunarEclipseTomorrow .= lang("Tomorrow at","-")." ".date($timeFormat,$eclipseLunar['date'])." (".date("d-m-Y",$eclipseLunar['dateUTC'])." UTC) ".lang("will be a lunar eclipse. It will be","-")." ".$eclipseLunar['type'].". ";
			if($eclipseLunar['penPhaseLength']>0){
				$lunarEclipseTomorrow .= lang("The penumbral phase length will be","-")." ".$eclipseLunar['penPhaseLength']." ".lang("minutes","-").". ";
			}
			if($eclipseLunar['parPhaseLength']>0){
				$lunarEclipseTomorrow .= lang("The partial phase length will be","-")." ".$eclipseLunar['parPhaseLength']." ".lang("minutes","-").". ";
			}
			if($eclipseLunar['totalPhaseLength']>0){
				$lunarEclipseTomorrow .= lang("The total phase length will be","-")." ".$eclipseLunar['totalPhaseLength']." ".lang("minutes","-").". ";
			}
		}
		for($c=2;$c<8;$c++){
			if(date('Ymd',$eclipseLunar['date'])==date('Ymd',strtotime('+'.$c.' days'))){
				$lunarEclipseOutlook .= lang("The upcoming","-")." ".date('l, F j',strtotime('+'.$c.' days'))." ".lang("at","-")." ".date($timeFormat,$eclipseLunar['date'])." (".date("d-m-Y",$eclipseLunar['dateUTC'])." UTC) ".lang("will be a lunar eclipse. It is","-")." ".$eclipseLunar['type'].". ";
				if($eclipseLunar['penPhaseLength']>0){
					$lunarEclipseOutlook .= lang("The penumbral phase length will be","-")." ".$eclipseLunar['penPhaseLength']." ".lang("minutes","-").". ";
				}
				if($eclipseLunar['parPhaseLength']>0){
					$lunarEclipseOutlook .= lang("The partial phase length will be","-")." ".$eclipseLunar['parPhaseLength']." ".lang("minutes","-").". ";
				}
				if($eclipseLunar['totalPhaseLength']>0){
					$lunarEclipseOutlook .= lang("The total phase length will be","-")." ".$eclipseLunar['totalPhaseLength']." ".lang("minutes","-").". ";
				}
			}
		}
	}

	// solar eclipses
	$solarEclipseToday = "";
	$solarEclipseTomorrow = "";
	$solarEclipseOutlook = "";

	$solarsFile = fopen("files/solarEclipses.txt", "r");
	while(!feof($solarsFile)) {
		$solarArray = array();
		$solarRaw = explode(";",fgets($solarsFile));
		$solarArray['date'] = strtotime($solarRaw[2]."/".$solarRaw[3]."/".$solarRaw[4]." ".$solarRaw[5]) + $stationOffset*60*60;
		$solarArray['dateUTC'] = strtotime($solarRaw[2]."/".$solarRaw[3]."/".$solarRaw[4]." ".$solarRaw[5]);
		$type = $solarRaw[9];
			if($type[0]=="P"){
				$type = lang("a partial","-");
			}
			if($type[0]=="A"){
				$type = lang("an annular","-");
			}
			if($type[0]=="T"){
				$type = lang("a total","-");
			}
			if($type[0]=="H"){
				$type = lang("a hybrid","-");
			}
		$solarArray['type'] = $type;
		$solarArray['lat'] = $solarRaw[12];
		$solarArray['lng'] = $solarRaw[13];
		$solarArray['altitude'] = $solarRaw[14];
		$solarArray['azimuth'] = $solarRaw[15];
		$solarArray['width'] = $solarRaw[16];
		$durationRaw = $solarRaw[17];
		$durationM = substr($durationRaw,0,2);
		$durationS = substr($durationRaw,3,2);
		$solarArray['duration'] = $durationM * 60 + $durationS;

		if($solarArray['date']>=time()){
			$solarEclipses[] = $solarArray;
		}

		if(date("Ymd",$solarArray['date']) == date("Ymd")){ // check if it is today
			$solarToday = $solarArray;
		}
	}
	fclose($solarsFile);

	foreach($solarEclipses as $eclipseSolar){
		if(date('Ymd',$eclipseSolar['date'])==date('Ymd')){
			$solarEclipseToday .= lang("Today at","-")." ".date($timeFormat,$eclipseSolar['date'])." (".date("d-m-Y",$eclipseSolar['dateUTC'])." UTC) ".lang("is a solar eclipse. It is","-")." ".$eclipseSolar['type']." ".lang("eclipse, with a duration of ","-")." ".$eclipseSolar['duration'].lang("sAbbr","-").". ".lang("The central path coordinates are","-")." ".$eclipseSolar['lat']." ".lang("and","-")." ".$eclipseSolar['lng'].", ".lang("azimuth","-")." ".$eclipseSolar['azimuth']."° ".lang("and","l")." ".lang("altitude","l")." ".$eclipseSolar['altitude']."°. ";
		}
		if(date('Ymd',$eclipseSolar['date'])==date('Ymd',strtotime('tomorrow'))){
			$solarEclipseTomorrow .= lang("Tomorrow at","-")." ".date($timeFormat,$eclipseSolar['date'])." (".date("d-m-Y",$eclipseSolar['dateUTC'])." UTC) ".lang("will be a solar eclipse. It is","-")." ".$eclipseSolar['type']." ".lang("eclipse, with a duration of","-")." ".$eclipseSolar['duration'].lang("sAbbr","-").". ".lang("The central path coordinates are","-")." ".$eclipseSolar['lat']." ".lang("and","l")." ".$eclipseSolar['lng'].", ".lang("azimuth","l")." ".$eclipseSolar['azimuth']."° ".lang("and","l")." ".lang("altitude","l")." ".$eclipseSolar['altitude']."°. ";
		}
		for($c=2;$c<8;$c++){
			if(date('Ymd',$eclipseSolar['date'])==date('Ymd',strtotime('+'.$c.' days'))){
				$solarEclipseOutlook .= lang("The upcoming","-")." ".date('l, F j',strtotime('+'.$c.' days'))." ".lang("at","-")." ".date($timeFormat,$eclipseSolar['date'])." (".date("d-m-Y",$eclipseSolar['dateUTC'])." UTC) ".lang("will be a solar eclipse. It is","-")." ".$eclipseSolar['type']." ".lang("eclipse, with a duration of","-")." ".$eclipseSolar['duration'].lang("sAbbr","-").". ".lang("The central path coordinates are","-")." ".$eclipseSolar['lat']." ".lang("and","l")." ".$eclipseSolar['lng'].", ".lang("azimuth","l")." ".$eclipseSolar['azimuth']."° ".lang("and","l")." ".lang("altitude","l")." ".$eclipseSolar['altitude']."°. ";
			}
		}
	}

	// astro events
	$astroEventsToday = "";
	$astroEventsTomorrow = "";
	$astroEventsOutlook = "";

	$astroEvents = array();
	$astroEventsFile = fopen("files/astroEvents.txt", "r");
	while(!feof($astroEventsFile)) {
		$row = fgets($astroEventsFile);
		$rowData = explode(";",$row);
		if(time()<strtotime($rowData[0])){
			$event['date'] = strtotime($rowData[0]);
			$event['type'] = $rowData[1];
			$event['title'] = $rowData[2];
			$event['text'] = $rowData[3];
			$astroEvents[] = $event;
		}
	}
	foreach($astroEvents as $event){
		if(date('Ymd',$event['date'])==date('Ymd')){
			$astroEventsToday.= "There is be an interesting astronomy event - ".$event['title']." ".$event['text'];
		}
		if(date('Ymd',$event['date'])==date('Ymd',strtotime('tomorrow'))){
			$astroEventsTomorrow.= "There will be an interesting astronomy event - ".$event['title']." ".$event['text'];
		}
		for($c=2;$c<8;$c++){
			if(date('Ymd',$event['date'])==date('Ymd',strtotime('+'.$c.' days'))){
				$astroEventsOutlook.= "There will be an interesting astronomy event on ".date('l, F j',strtotime('+'.$c.' days'))." - ".$event['title'].". ".$event['text']." ";
			}
		}
	}

	// days
	$interestingDaysToday = array();
	$interestingDaysToday[] = array('0323','<p>Today is the World Meteorological Day.</p>');
	$interestingDaysToday[] = array('1231','<p>It is the last day of the year '.date("Y").' today.</p>');
	$interestingDaysToday[] = array('0101','<p>Today is the first day of the year '.date("Y").'.</p>');
	$interestingDaysToday[] = array('0710','<p>'.(date("Y")-1913).' years ago on Jul 10, 1913, the highest officially measured temperature on Earth was measured in Furnace Creek Ranch, Death Valley, California. The recorded value was 56.7°C (134.1°F).</p>');
	$interestingDaysToday[] = array('0721','<p>On Jul 21, 1983 ('.(date('Y')-1983).' years ago), the temperature at the Vostok station in Antarctica dropped as low as -89.2°C (-128.6°F), which is currently the lowest ever measured temperature (not including remote sensing).</p>');
	$interestingDaysToday[] = array('0623','<p>On Jun 23, 1982, the temperature at the South Pole fell to -82.8°C (-117.0°F), which is currently the lowest ever recorded temperature there.</p>');
	$interestingDaysToday[] = array('1126','<p>On 26th November 1970, the amount of precipitation in one minute in Barot, Guadeloupe was measured to be 38mm (1.5in), which is currently the world record for most rain in one minute.</p>');
	$interestingDaysToday[] = array('0622','<p>On this day in 1947, the hourly precipitation in Holt, Missouri (US) was measured to be 305mm (12.0 in), which is the most rain in one hour ever recorded.</p>');
	$interestingDaysToday[] = array('0108','<p>8th January 1966 was when 1144mm (45.0 in) of rain within 12 hours was observed in Cilaos, Reunion during the tropical cyclone Denise. It is the most rain recorded in just 12 hours ever.</p>');
	$interestingDaysToday[] = array('0107','<p>In 1966, during the tropical cyclone Denis in Cilaos, Reunion, the 24h precipitation amount was an unbelievable 1825mm (71.9in), currently the world record for most rain in just one day.</p>');
	$interestingDaysToday[] = array('0224','<p>Between 24 and 26 February 2007, the amount of precipitation in Commerson, Reunion reached a value of 3929mm (154.7in), the most rain in 72h ever recorded.</p>');
	$interestingDaysToday[] = array('0305','<p>On March 5, 2015, the amount of snow fallen in Italian Capracotta was measured to be 256cm (100.8in), currently the world record for most snow in 24-hour period.</p>');
	$interestingDaysToday[] = array('0503','<p>On May 3, 1999, the wind speed observed by a DOW radar unit in a tornado between Oklahoma City and Moore, Oklahoma was 484+/-32 km/h (302+/-20mph), the fastest ever recorded wind speed.</p>');
	$interestingDaysToday[] = array('0410','<p>On April 10, 1996 during the Cyclone Olivia in Barrow Island, Australia, the measured wind speed was 407km/h (253mph), the fastest recorded wind speed with an anemometer. It was one of the extreme gusts during a series of 5-min time periods.</p>');
	$interestingDaysToday[] = array('0412','<p>The sustained 1-minute average wind speed at Mount Washington, New Hampshire on 12 April 1934 was 372km/h (231mph), which is the fastest recorded wind speed with an anemometer outside a tropical cyclone.</p>');
	$interestingDaysToday[] = array('0321','<p>In the 24-hour period from March 21 to March 22, 1951, the daily average wind speed measured at the Port Martin in Antarctica was 174km/h (108mph), which is the highest daily average wind speed ever recorded.</p>');
	$interestingDaysToday[] = array('0426','<p>A major tornado hit the Manikganj District in Bangladesh on April 26, 1989. The estimated number of casualties is 1300, making it the deadliest tornado in modern history.</p>');
	$interestingDaysToday[] = array('0318','<p>The so-called Tri-State Tornado in the American states Missouri, Illinois and Indiana on 18 March 1925 is currently the deadliest tornado in North America, with 695 deaths.</p>');
	$interestingDaysToday[] = array('0923','<p>The Grand Harbour Tornado on 23 September 1551 in Valletta, Malta, is still the deadliest tornado in Europe, with over 600 deaths in total.</p>');
	$interestingDaysToday[] = array('1012','<p>On October 12, 1979 the surface air pressure measured in the eye of the Super Typhoon Tip over the Pacific Ocean was 870hPa (25.63 inHg), making it the most intense ever recorded tropical cyclone by minimum surface air pressure.</p>');
	$interestingDaysToday[] = array('0902','<p>The most intense tropical cyclone ever recorded on land by minimum surface air pressure was the eye of the Labor Day Hurricane in Craig\'s Key, Florida on 2 September 1935. The surface air pressure was measured to be 892hPa (26.35 inHg).</p>');
	$interestingDaysToday[] = array('0414','<p>The heaviest officially recorded hail fell on 14 April 1986 in the Gopalganj District, Bangladesh. Its weight was 1.02kg (2.25lb).</p>');
	$interestingDaysToday[] = array('0723','<p>On Jul 23, 2010, a hail with a diameter of 20cm (8.0in) fell in Vivian, South Dakota. This is currently the largest diameter of hail officially measured.</p>');
	$interestingDaysToday[] = array('0622','<p>A hail with largest circumference oficially measured fell on Jun 22, 2003 in Aurora, Nebraska. Its circumference was 47.6cm (18.75in).</p>');
	$interestingDaysToday[] = array('1229','<p>On December 29, 2003, a world-record UV index of 43.3 was detected at the Licancabur volcano in Bolivia.</p>');
	$interestingDaysToday[] = array('0211','<p>A temperature of just -23.9°C (-11.0°F) was measured on February 11, 1931 in Infrane, Morocco. This is the lowest ever recorded temperature in Africa.</p>');
	$interestingDaysToday[] = array('0203','<p>A temperature of just -63.0°C (-81.4°F) was measured on February 3, 1947 in Snag, Yukon, Canada. This is the lowest ever recorded temperature in North America.</p>');
	$interestingDaysToday[] = array('0629','<p>A temperature of just -23°C (-9°F) was measured on June 29, 1994 in Charlotte Pass, New South Wales, Australia. This is the lowest ever recorded temperature in Australia and entire Oceania.</p>');
	$interestingDaysToday[] = array('0102','<p>Temperature as high as 50.7°C (123.3°F) was measured in Oodnadatta, South Australia on 2 January 1960, currently the highest ever recorded temperature in Australia and entire Oceania.</p>');
	$interestingDaysToday[] = array('0710','<p>Temperature as high as 48.0°C (118.4°F) was measured in Athens, Greece on Jul 10, 1977, currently the officially highest ever recorded temperature in Europe.</p>');

	$interestingDaysToday[] = array('0122','<p>On 22nd January 1943 in Spearfish, South Dakota, the temperature rose 27°C (49°F) in just two minutes, which is the fastest temperature increase ever measured.</p>');
	$interestingDaysToday[] = array('0110','<p>On 10nd January 1911 in Rapid City, South Dakota, the temperature dropped 27.2°C (49°F) in a matter of just 5 minutes - the fastest temperature drop ever recorded.</p>');
	$interestingDaysToday[] = array('0820','<p>The eye of the Typhoon Carmen in northwest Pacific ocean had a diameter of 370 km (230 mi) on 20th August 1960, the largest eye of a tropical cyclone ever recorded.</p>');
	$interestingDaysToday[] = array('1112','<p>The 1970 Bhola cyclone was a devastating tropical cyclone that struck East Pakistan (now Bangladesh) and India\'s West Bengal on 12 November 1970. It remains the deadliest tropical cyclone ever recorded, and one of the deadliest natural disasters in modern times. Up to 500,000 people lost their lives in the storm, primarily as a result of the storm surge that flooded much of the low-lying islands of the Ganges Delta.</p>');
	$interestingDaysToday[] = array('1125','<p>On 25 November 1839, an enormous cyclone caused a 40-foot storm surge that hit Coringa, Andhra Pradesh, wiped out the harbor city, destroyed 25,000 ships and vessels in its bay, and killed 300,000 people.</p>');
	$interestingDaysToday[] = array('1007','<p>On 7 October 1737, a natural disaster struck the city of Calcutta (modern-day Kolkata) in India. For a long time this was believed in Europe to have been the result of an earthquake, but it is now believed to have been a tropical cyclone destroying 20,000 ships in the harbor and killing 300,000 people.</p>');
	$interestingDaysToday[] = array('1029','<p>The Great Backerganj Cyclone of 1876 (October 29 – November 1, 1876) was one of the deadliest cyclones in history. It hit the coast of Backerganj (near Meghna estuary) in present-day Barisal, Bangladesh, killing about 200,000 people.');
	$interestingDaysToday[] = array('1008','<p>The 1881 Haiphong Typhoon was a typhoon that struck Haiphong, in what is now Vietnam, and the northern part of the Philippines on 8 October 1881. Up to 300,000 people were killed by the typhoon, 20,000 of which were in the Philippines, making it the deadliest Philippine typhoon ever recorded.');
	$interestingDaysToday[] = array('0429','<p>The 1991 Bangladesh cyclone was among the deadliest tropical cyclones on record. On the night of 29 April 1991 a powerful tropical cyclone struck the Chittagong district of southeastern Bangladesh with winds of around 250 km/h (155 mph). The storm forced a 6 metre (20 ft) storm surge inland over a wide area, killing at least 138,000 people and leaving as many as 10 million homeless.</p>');
	$interestingDaysToday[] = array('0502','<p>Cyclone Nargis caused the worst natural disaster in the recorded history of Myanmar during early May 2008. The cyclone made landfall in Myanmar on Friday, 2 May 2008, sending a storm surge 40 kilometres up the densely populated Irrawaddy delta, causing catastrophic destruction and at least 138,000 fatalities.');
	$interestingDaysToday[] = array('0606','<p>The 1882 Bombay cyclone hit Mumbai (then Bombay) on June 6, 1882. The cyclone is known to have caused floods that killed at least 100,000 people in Mumbai alone.</p>');
	$interestingDaysToday[] = array('0123','<p>The 1556 Shaanxi earthquake or Jiajing earthquake was a catastrophic earthquake and is also the deadliest earthquake on record, killing approximately 830,000 people. It occurred on the morning of 23 January 1556 in Shaanxi, during the Ming Dynasty.</p>');
	$interestingDaysToday[] = array('0728','<p>The Tangshan earthquake, also known as the Great Tangshan earthquake, was a natural disaster that occurred on July 27, 1976. It is believed to be the largest earthquake of the 20th century by death toll. The epicenter of the earthquake was near Tangshan in Hebei, People\'s Republic of China, an industrial city with approximately one million inhabitants. The number of deaths initially reported by the Chinese government was 655,000, but this number has since been stated to be around 240,000 to 255,000. Another report indicates that the actual death toll was much higher, at approximately 650,000.</p>');
	$interestingDaysToday[] = array('1226','<p>The 2004 Indian Ocean earthquake occurred at 00:58:53 UTC on 26 December with an epicentre off the west coast of Sumatra, Indonesia. The undersea megathrust earthquake was caused when the Indian Plate was subducted by the Burma Plate and triggered a series of devastating tsunamis along the coasts of most landmasses bordering the Indian Ocean, killing 230,000 people in 14 countries, and inundating coastal communities with waves up to 30 metres (100 ft) high. It was one of the deadliest natural disasters in recorded history. Indonesia was the hardest-hit country, followed by Sri Lanka, India, and Thailand. With a magnitude of Mw 9.1–9.3, it is the third-largest earthquake ever recorded on a seismograph.</p>');
	$interestingDaysToday[] = array('1011','<p>The 1138 Aleppo earthquake was among the deadliest earthquakes in history. Its name was taken from the city of Aleppo, in northern Syria, where the most casualties were sustained. The quake occurred on 11 October 1138 and was preceded by a smaller quake on the 10th. It is frequently listed as the third deadliest earthquake in history.</p>');
	$interestingDaysToday[] = array('0917','<p>A deadly earthquake in Hongdong, now China, then Mongol Empire, ocurred on Sep 17, 1303. Approximate death toll is 200,000.</p>');
	$interestingDaysToday[] = array('0108','<p>On Jan 8, 1780, a major earthquake hit near Tabriz (today the most populated city in the northwest of Iran, one of the historical capitals of Iran, and the present capital of East Azerbaijan Province) killing over 200,000 people.</p>');
	$interestingDaysToday[] = array('0112','<p>A catastrophic magnitude 7.0 Mw earthquake, with an epicenter near the town of Léogâne (Ouest Department), approximately 25 kilometres (16 mi) west of Port-au-Prince, Haiti\'s capital, occurred at 16:53 local time (21:53 UTC) on Tuesday, 12 January 2010. An estimated three million people were affected by the quake. Death toll estimates range from 100,000 to about 160,000.</p>');
	$interestingDaysToday[] = array('1228','<p>The 1908 Messina earthquake occurred on December 28 in Sicily and Calabria, southern Italy with a moment magnitude of 7.1 and a maximum Mercalli Intensity of XI (Extreme). The cities of Messina and Reggio Calabria were almost completely destroyed and between 75,000 and 200,000 lives were lost.</p>');
	$interestingDaysToday[] = array('0531','<p>The 1970 Ancash earthquake (also known as the Great Peruvian earthquake) occurred on May 31 off the coast of Peru in the Pacific Ocean at 15:23:29 local time. Combined with a resultant landslide, it was the worst catastrophic natural disaster ever recorded in the history of Peru. Due to the large amounts of snow and ice included in the landslide and its estimated 66,794 to 70,000 casualties, it is also considered to be the world\'s deadliest avalanche.</p>');
	$interestingDaysToday[] = array('0512','<p>The 2008 Sichuan earthquake or the Great Sichuan earthquake, measured at 8.0 Ms and 7.9 Mw, and occurred at 02:28:01 PM China Standard Time at epicenter (06:28:01 UTC) on Monday, May 12 in Sichuan province, killed 69,197 people and left 18,222 missing.</p>');
	$interestingDaysToday[] = array('0410','<p>The 1815 eruption of Mount Tambora, on the island of Sumbawa in Indonesia on April 4, 1815, was one of the most powerful in recorded history. The eruption resulted in a brief period of significant climate change that consistently led to various cases of extreme weather. Several climate forcings coincided and interacted in a systematic manner that has not been observed since, despite other large eruptions that have occurred since the early 20th century.</p>');
	$interestingDaysToday[] = array('0826','<p>The 1883 eruption of Krakatoa in the Dutch East Indies (now Indonesia) began in the afternoon of August 26, 1883 (with origins as early as May of that year), and culminated with several destructive eruptions of the remaining caldera. It was one of the deadliest and most destructive volcanic events in recorded history, with at least 36,417 deaths being attributed to the eruption itself and the tsunamis it created. Significant additional effects were also felt around the world.</p>');
	$interestingDaysToday[] = array('1113','<p>The Armero tragedy was one of the major consequences of the eruption of the Nevado del Ruiz stratovolcano in Tolima, Colombia, on November 13, 1985. After 69 years of dormancy, the volcano\'s eruption caught nearby towns unaware, even though the government had received warnings from multiple volcanological organizations to evacuate the area when volcanic activity had been detected in September 1985. The lahars picked up speed in gullies and coursed into the six major rivers at the base of the volcano; they engulfed the town of Armero, killing more than 20,000 of its almost 29,000 inhabitants.</p>');
	$interestingDaysToday[] = array('0521','<p>1792 Unzen earthquake and tsunami resulted from the volcanic activities of Mount Unzen (in the Shimabara Peninsula of Nagasaki Prefecture, Japan) on 21 May. This caused the collapse of the southern flank of the Mayuyama dome in front of Mount Unzen, resulting in a tremendous tsunami, killing 15,000 people altogether.</p>');
	$interestingDaysToday[] = array('0818','<p>The 2012 Chios forest fire was a wildfire that broke out in the southern half of the Greek island of Chios shortly after 2 a.m. on Saturday 18 August 2012. By Monday 20 August local authorities reported that 7000 hectares (16,000 acres) of forest and farmland had been destroyed. The Greek government had asked for the help of aircraft from Spain and Italy to help not only with this but six other forest fires that broke out elsewhere in Greece on 19 August and five more on 20 August. Already on 18 August smoke from the fire was visible as far south as Crete, 350 kilometers (230 miles) away.</p>');
	$interestingDaysToday[] = array('1225','<p>The 2001 Warragamba bushfires occurred Christmas Day, 25 December 2001 in the small New South Wales town of Warragamba, leaving 30 homes and businesses destroyed. The bushfires in Warragamba were part of the longest official continuous bushfire emergency in NSW taking place between 21 December 2001 and 13 January 2002 and spreading across the state. Most of these fires were caused by lightning or arsonists. The fire behaviour was unusual in many areas due to extreme dryness of fuel and variable winds.</p>');
	$interestingDaysToday[] = array('0118','<p>The 2003 Canberra bushfires involved several deaths, over 490 injured, and caused severe damage to the outskirts of Canberra, the capital city of Australia, during 18–22 January 2003. Almost 70% of the Australian Capital Territory\'s (ACT) pastures, forests (pine plantations), and nature parks were severely damaged, and most of the renowned Mount Stromlo Observatory was destroyed. After burning for a week around the edges of the ACT, the fires entered the suburbs of Canberra on 18 January 2003. Over the next ten hours, four people died and more than 500 homes were destroyed or severely damaged, requiring a significant relief and reconstruction effort.</p>');
	$interestingDaysToday[] = array('0207','<p>The Black Saturday bushfires were a series of bushfires that ignited or were burning across the Australian state of Victoria on and around Saturday, 7 February 2009 and were Australia\'s all-time worst bushfire disasters. The fires occurred during extreme bushfire-weather conditions and resulted in Australia\'s highest ever loss of life from a bushfire; 173 people died and 414 were injured as a result of the fires.</p>');
	$interestingDaysToday[] = array('0216','<p>The Ash Wednesday bushfires, known in South Australia as Ash Wednesday II, were a series of bushfires that occurred in south-eastern Australia on 16 February 1983, which was Ash Wednesday in the Christian calendar. Within twelve hours, more than 180 fires fanned by winds of up to 110 km/h (68 mph) caused widespread destruction across the states of Victoria and South Australia. Years of severe drought and extreme weather combined to create one of Australia\'s worst fire days in a century. The fires became the deadliest bushfire in Australian history, until the Black Saturday bushfires in 2009.In Victoria, 47 people died, while in South Australia there were 28 deaths.</p>');
	$interestingDaysToday[] = array('0207','<p>The 1967 Tasmanian fires were an Australian natural disaster which occurred on 7 February 1967, an event which became known as the Black Tuesday bushfires. They were the most deadly bushfires that Tasmania has ever experienced, leaving 62 people dead, 900 injured and over seven thousand homeless.</p>');
	$interestingDaysToday[] = array('1008','<p>The Peshtigo Fire was a forest fire that took place on October 8, 1871 in and around Peshtigo, Wisconsin. It was a firestorm that caused the most deaths by fire in United States history, with estimated deaths of around 1,500 people, possibly as many as 2,500.</p>');
	$interestingDaysToday[] = array('0820','<p>The Great Fire of 1910 (also commonly referred to as the Big Blowup, the Big Burn, or the Devil\'s Broom fire) was a wildfire that burned about three million acres (1,214,057 ha), approximately the size of Connecticut) in northeast Washington, northern Idaho (the panhandle), and western Montana. The firestorm burned over two days (August 20–21, 1910), and killed 87 people, mostly firefighters. It is believed to be the largest, although not the deadliest, forest fire in U.S. history.</p>');
	$interestingDaysToday[] = array('1007','<p>A massive forest fire (or series of fires) which devastated forests and communities throughout much of northern New Brunswick in October 1825. It ranks among the three largest forest fires ever recorded in North America. About 1/3 of the homes in Fredericton were destroyed, but the main devastation was 100 miles (160 km) to the northeast. The preceding summer was a particularity hot one, with bush fires common. On the evening of October 7, 1825, the firestorm roared through Newcastle, New Brunswick (now part of the City of Miramichi), and in less than 3 hours reduced the town of 1,000 people to ruins - of 260 original buildings, only 12 remained.</p>');
	$interestingDaysToday[] = array('1105','<p>On November 5, 1530,  The St. Felix’s Flood destroyed the city of Reimerswaal in the Netherlands and killed over 100,000 people, making it the fifth deadliest flood in human history.</p>');
	$interestingDaysToday[] = array('0426','<p>The Chernobyl disaster was a catastrophic nuclear accident that occurred on 26 April 1986 at the Chernobyl Nuclear Power Plant in Ukraine (then officially the Ukrainian SSR). An explosion and fire released large quantities of radioactive particles into the atmosphere, which spread over much of the western USSR and Europe.</p><p>The Chernobyl disaster was the worst nuclear power plant accident in history in terms of cost and casualties. It is one of only two classified as a level 7 event (the maximum classification) on the International Nuclear Event Scale, the other being the Fukushima Daiichi nuclear disaster in 2011. The battle to contain the contamination and avert a greater catastrophe ultimately involved over 500,000 workers and cost an estimated 18 billion rubles. During the accident itself, 31 people died, and long-term effects such as cancers are still being investigated.</p>');
	$interestingDaysToday[] = array('0311','<p>The Fukushima Daiichi nuclear disaster was an energy accident at the Fukushima I Nuclear Power Plant, initiated primarily by the tsunami of the Tōhoku earthquake and tsunami on 11 March 2011. The damage caused by the tsunami produced equipment failures, and without this equipment a loss-of-coolant accident followed with three nuclear meltdowns and releases of radioactive materials beginning on 12 March. It is the largest nuclear disaster since the Chernobyl disaster of 1986 and the second disaster (after Chernobyl) to be given the Level 7 event classification of the International Nuclear Event Scale.</p><p>The largest wave in the tsunami arrived some 50 minutes after the initial earthquake. The 13 meter tall wave overwhelmed the plant\'s seawall.</p>');
	$interestingDaysToday[] = array('0929','<p>The Kyshtym disaster was a radiological contamination accident that occurred on 29 September 1957 at Mayak, a plutonium production site for nuclear weapons and nuclear fuel reprocessing plant in the Soviet Union. It measured as a Level 6 disaster on the International Nuclear Event Scale, making it the third most serious nuclear accident ever recorded.</p>');
	$interestingDaysToday[] = array('1010','<p>The Windscale fire of 10 October 1957 was the worst nuclear accident in Great Britain\'s history, ranked in severity at level 5 on the 7-point International Nuclear Event Scale. The fire burned for three days and there was a release of radioactive contamination that spread across the UK and Europe. Of particular concern at the time was the radioactive isotope iodine-131, which may lead to cancer of the thyroid, and it has been estimated that the incident caused 240 additional cancer cases. No one was evacuated from the surrounding area, but there was a worry that milk might be dangerously contaminated. Milk from about 500 km2 of nearby countryside was diluted and destroyed for about a month.</p>');
	$interestingDaysToday[] = array('0103','<p>On January 3, 1961, the only fatal nuclear reactor incident in the U.S. occurred at the NRTS. An experimental reactor called SL-1 (Stationary Low-Power Plant Number 1) was destroyed when a control rod was pulled too far out of the reactor, leading to core meltdown and a steam explosion. The reactor vessel jumped up 9 feet 1 inch (2.77 m). The concussion and blast killed all three military enlisted personnel working on the reactor. Due to the extensive radioactive isotope contamination, all three were buried in lead coffins.</p>');
	$interestingDaysToday[] = array('0311','<p>The Great Blizzard of 1888 was one of the most severe recorded blizzards in the history of the United States of America, beginning on March 11, 1888. Snowfalls of 20–60 inches (51–152 cm) fell in parts of New Jersey, New York, Massachusetts, Rhode Island, and Connecticut, and sustained winds of more than 45 miles per hour (72 km/h) produced snowdrifts in excess of 50 feet (15 m). Railroads were shut down and people were confined to their houses for up to a week. The storm, referred to as the Great White Hurricane, paralyzed the East Coast from the Chesapeake Bay to Maine, as well as the Atlantic provinces of Canada. Telegraph infrastructure was disabled, isolating Montreal and most of the large northeastern U.S. cities from Washington, D.C. to Boston for days.</p>');
	$interestingDaysToday[] = array('0312','<p>The 1993 Storm of the Century, also known as the \'93 Super Storm, the Great Blizzard of 1993, or the No Name Storm, was a large cyclonic storm that formed over the Gulf of Mexico on March 12, 1993. It was unique for its intensity, massive size, and wide-reaching effects, particularly in the southeastern United States. At its height, the storm stretched from Canada to Central America, but it impacted mainly the eastern United States and Cuba. The cyclone moved through the Gulf of Mexico and then through the eastern United States before moving onto Canada. Areas as far south as central Alabama and Georgia received 6 to 8 inches (15 to 20 cm) of snow. </p>');
	$interestingDaysToday[] = array('0112','<p>The Schoolhouse Blizzard, also known as the Schoolchildren\'s Blizzard, hit the U.S. plains states on January 12, 1888. The blizzard came unexpectedly on a relatively warm day, and many people were caught unaware, including children in one-room schoolhouses. The blizzard was preceded by a snowstorm on January 5 and 6, which dropped powdery snow on the northern and central plains, and was followed by an outbreak of brutally cold temperatures from January 7 to 11. What made the storm so deadly was the timing (during work and school hours), the suddenness, and the brief spell of warmer weather that preceded it. In addition, the very strong wind fields behind the cold front and the powdery nature of the snow reduced visibilities on the open plains to zero.</p>');
	$interestingDaysToday[] = array('0123','<p>The Hakkōda Mountains incident occurred on January 23, 1902, when a group of Imperial Japanese Army soldiers became lost in a blizzard on the Hakkōda Mountains in Aomori Prefecture in northern Honshu, Japan, en route to Tashiro Hot Spring located in the Hakkōda Mountains. The 199 deaths during a single ascent make it the world\'s largest mountaineering disaster in the modern history of mountain climbing.</p>');

	$interestingDaysTomorrow = array();
	$interestingDaysTomorrow[] = array('0323','<p>Tomorrow is the World Meteorological Day.</p>');
	$interestingDaysTomorrow[] = array('1231','<p>Tomorrow is the last day of the year '.date("Y").'.</p>');
	$interestingDaysTomorrow[] = array('0101','<p>Tomorrow is the first day of the year '.(date("Y")+1).'.</p>');
	$interestingDaysTomorrow[] = array('0710','<p>On Jul 10, 1913, the highest officially measured temperature on Earth was measured in Furnace Creek Ranch, Death Valley, California. The recorded value was 56.7°C (134.1°F).</p>');
	$interestingDaysTomorrow[] = array('0721','<p>On Jul 21, 1983 the temperature at the Vostok station in Antarctica dropped as low as -89.2°C (-128.6°F), which is currently the lowest ever measured temperature (not including remote sensing).</p>');
	$interestingDaysTomorrow[] = array('0623','<p>On Jun 23, 1982, the temperature at the South Pole fell to -82.8°C (-117.0°F), which is currently the lowest ever recorded temperature there.');
	$interestingDaysTomorrow[] = array('1126','<p>On 26th November 1970, the amount of precipitation in one minute in Barot, Guadeloupe was measured to be 38mm (1.5in), which is currently the world record for most rain in one minute.</p>');
	$interestingDaysTomorrow[] = array('0622','<p>On this day in 1947, the hourly precipitation in Holt, Missouri (US) was measured to be 305mm (12.0 in), which is the most rain in one hour ever recorded.</p>');
	$interestingDaysTomorrow[] = array('0108','<p>8th January 1966 was when 1144mm (45.0 in) of rain within 12 hours was observed in Cilaos, Reunion during the tropical cyclone Denise. It is the most rain recorded in just 12 hours ever.</p>');
	$interestingDaysTomorrow[] = array('0107','<p>In 1966, during the tropical cyclone Denis in Cilaos, Reunion, the 24h precipitation amount was an unbelievable 1825mm (71.9in), currently the world record for most rain in just one day.</p>');
	$interestingDaysTomorrow[] = array('0224','<p>Between 24 and 26 February 2007, the amount of precipitation in Commerson, Reunion reached a value of 3929mm (154.7in), the most rain in 72h ever recorded.</p>');
	$interestingDaysTomorrow[] = array('0305','<p>On March 5, 2015, the amount of snow fallen in Italian Capracotta was measured to be 256cm (100.8in), currently the world record for most snow in 24-hour period.</p>');
	$interestingDaysTomorrow[] = array('0503','<p>On May 3, 1999, the wind speed observed by a DOW radar unit in a tornado between Oklahoma City and Moore, Oklahoma was 484+/-32 km/h (302+/-20mph), the fastest ever recorded wind speed.</p>');
	$interestingDaysTomorrow[] = array('0410','<p>On April 10, 1996 during the Cyclone Olivia in Barrow Island, Australia, the measured wind speed was 407km/h (253mph), the fastest recorded wind speed with an anemometer. It was one of the extreme gusts during a series of 5-min time periods.</p>');
	$interestingDaysTomorrow[] = array('0412','<p>The sustained 1-minute average wind speed at Mount Washington, New Hampshire on 12 April 1934 was 372km/h (231mph), which is the fastest recorded wind speed with an anemometer outside a tropical cyclone.</p>');
	$interestingDaysTomorrow[] = array('0321','<p>In the 24-hour period from March 21 to March 22, 1951, the daily average wind speed measured at the Port Martin in Antarctica was 174km/h (108mph), which is the highest daily average wind speed ever recorded.</p>');
	$interestingDaysTomorrow[] = array('0426','<p>A major tornado hit the Manikganj District in Bangladesh on April 26, 1989. The estimated number of casualties is 1300, making it the deadliest tornado in modern history.</p>');
	$interestingDaysTomorrow[] = array('0318','<p>The so-called Tri-State Tornado in the American states Missouri, Illinois and Indiana on 18 March 1925 is currently the deadliest tornado in North America, with 695 deaths.</p>');
	$interestingDaysTomorrow[] = array('0923','<p>The Grand Harbour Tornado on 23 September 1551 in Valletta, Malta, is still the deadliest tornado in Europe, with over 600 deaths in total.</p>');
	$interestingDaysTomorrow[] = array('1012','<p>On October 12, 1979 the surface air pressure measured in the eye of the Super Typhoon Tip over the Pacific Ocean was 870hPa (25.63 inHg), making it the most intense ever recorded tropical cyclone by minimum surface air pressure.</p>');
	$interestingDaysTomorrow[] = array('0902','<p>The most intense tropical cyclone ever recorded on land by minimum surface air pressure was the eye of the Labor Day Hurricane in Craig\'s Key, Florida on 2 September 1935. The surface air pressure was measured to be 892hPa (26.35 inHg).</p>');
	$interestingDaysTomorrow[] = array('0414','<p>The heaviest officially recorded hail fell on 14 April 1986 in the Gopalganj District, Bangladesh. Its weight was 1.02kg (2.25lb).</p>');
	$interestingDaysTomorrow[] = array('0723','<p>On Jul 23, 2010, a hail with a diameter of 20cm (8.0in) fell in Vivian, South Dakota. This is currently the largest diameter of hail officially measured.</p>');
	$interestingDaysTomorrow[] = array('0622','<p>A hail with largest circumference oficially measured fell on Jun 22, 2003 in Aurora, Nebraska. Its circumference was 47.6cm (18.75in).</p>');
	$interestingDaysTomorrow[] = array('1229','<p>On December 29, 2003, a world-record UV index of 43.3 was detected at the Licancabur volcano in Bolivia.</p>');
	$interestingDaysTomorrow[] = array('0211','<p>A temperature of just -23.9°C (-11.0°F) was measured on February 11, 1931 in Infrane, Morocco. This is the lowest ever recorded temperature in Africa.</p>');
	$interestingDaysTomorrow[] = array('0203','<p>A temperature of just -63.0°C (-81.4°F) was measured on February 3, 1947 in Snag, Yukon, Canada. This is the lowest ever recorded temperature in North America.</p>');
	$interestingDaysTomorrow[] = array('0629','<p>A temperature of just -23°C (-9°F) was measured on June 29, 1994 in Charlotte Pass, New South Wales, Australia. This is the lowest ever recorded temperature in Australia and entire Oceania.</p>');
	$interestingDaysTomorrow[] = array('0102','<p>Temperature as high as 50.7°C (123.3°F) was measured in Oodnadatta, South Australia on 2 January 1960, currently the highest ever recorded temperature in Australia and entire Oceania.</p>');
	$interestingDaysTomorrow[] = array('0710','<p>Temperature as high as 48.0°C (118.4°F) was measured in Athens, Greece on Jul 10, 1977, currently the officially highest ever recorded temperature in Europe.</p>');
	$interestingDaysTomorrow[] = array('0122','<p>On 22nd January 1943 in Spearfish, South Dakota, the temperature rose 27°C (49°F) in just two minutes, which is the fastest temperature increase ever measured.</p>');
	$interestingDaysTomorrow[] = array('0110','<p>On 10nd January 1911 in Rapid City, South Dakota, the temperature dropped 27.2°C (49°F) in a matter of just 5 minutes - the fastest temperature drop ever recorded.</p>');
	$interestingDaysTomorrow[] = array('0820','<p>The eye of the Typhoon Carmen in northwest Pacific ocean had a diameter of 370 km (230 mi) on 20th August 1960, the largest eye of a tropical cyclone ever recorded.</p>');
	$interestingDaysTomorrow[] = array('1112','<p>The 1970 Bhola cyclone was a devastating tropical cyclone that struck East Pakistan (now Bangladesh) and India\'s West Bengal on 12 November 1970. It remains the deadliest tropical cyclone ever recorded, and one of the deadliest natural disasters in modern times. Up to 500,000 people lost their lives in the storm, primarily as a result of the storm surge that flooded much of the low-lying islands of the Ganges Delta.</p>');
	$interestingDaysTomorrow[] = array('1125','<p>On 25 November 1839, an enormous cyclone caused a 40-foot storm surge that hit Coringa, Andhra Pradesh, wiped out the harbor city, destroyed 25,000 ships and vessels in its bay, and killed 300,000 people.</p>');
	$interestingDaysTomorrow[] = array('1007','<p>On 7 October 1737, a natural disaster struck the city of Calcutta (modern-day Kolkata) in India. For a long time this was believed in Europe to have been the result of an earthquake, but it is now believed to have been a tropical cyclone destroying 20,000 ships in the harbor and killing 300,000 people.</p>');
	$interestingDaysTomorrow[] = array('1029','<p>The Great Backerganj Cyclone of 1876 (October 29 – November 1, 1876) was one of the deadliest cyclones in history. It hit the coast of Backerganj (near Meghna estuary) in present-day Barisal, Bangladesh, killing about 200,000 people.');
	$interestingDaysTomorrow[] = array('1008','<p>The 1881 Haiphong Typhoon was a typhoon that struck Haiphong, in what is now Vietnam, and the northern part of the Philippines on 8 October 1881. Up to 300,000 people were killed by the typhoon, 20,000 of which were in the Philippines, making it the deadliest Philippine typhoon ever recorded.');
	$interestingDaysTomorrow[] = array('0429','<p>The 1991 Bangladesh cyclone was among the deadliest tropical cyclones on record. On the night of 29 April 1991 a powerful tropical cyclone struck the Chittagong district of southeastern Bangladesh with winds of around 250 km/h (155 mph). The storm forced a 6 metre (20 ft) storm surge inland over a wide area, killing at least 138,000 people and leaving as many as 10 million homeless.</p>');
	$interestingDaysTomorrow[] = array('0502','<p>Cyclone Nargis caused the worst natural disaster in the recorded history of Myanmar during early May 2008. The cyclone made landfall in Myanmar on Friday, 2 May 2008, sending a storm surge 40 kilometres up the densely populated Irrawaddy delta, causing catastrophic destruction and at least 138,000 fatalities.');
	$interestingDaysTomorrow[] = array('0606','<p>The 1882 Bombay cyclone hit Mumbai (then Bombay) on June 6, 1882. The cyclone is known to have caused floods that killed at least 100,000 people in Mumbai alone.</p>');
	$interestingDaysTomorrow[] = array('0123','<p>The 1556 Shaanxi earthquake or Jiajing earthquake was a catastrophic earthquake and is also the deadliest earthquake on record, killing approximately 830,000 people. It occurred on the morning of 23 January 1556 in Shaanxi, during the Ming Dynasty.</p>');
	$interestingDaysTomorrow[] = array('0728','<p>The Tangshan earthquake, also known as the Great Tangshan earthquake, was a natural disaster that occurred on July 27, 1976. It is believed to be the largest earthquake of the 20th century by death toll. The epicenter of the earthquake was near Tangshan in Hebei, People\'s Republic of China, an industrial city with approximately one million inhabitants. The number of deaths initially reported by the Chinese government was 655,000, but this number has since been stated to be around 240,000 to 255,000. Another report indicates that the actual death toll was much higher, at approximately 650,000.</p>');
	$interestingDaysTomorrow[] = array('1226','<p>The 2004 Indian Ocean earthquake occurred at 00:58:53 UTC on 26 December with an epicentre off the west coast of Sumatra, Indonesia. The undersea megathrust earthquake was caused when the Indian Plate was subducted by the Burma Plate and triggered a series of devastating tsunamis along the coasts of most landmasses bordering the Indian Ocean, killing 230,000 people in 14 countries, and inundating coastal communities with waves up to 30 metres (100 ft) high. It was one of the deadliest natural disasters in recorded history. Indonesia was the hardest-hit country, followed by Sri Lanka, India, and Thailand. With a magnitude of Mw 9.1–9.3, it is the third-largest earthquake ever recorded on a seismograph.</p>');
	$interestingDaysTomorrow[] = array('1011','<p>The 1138 Aleppo earthquake was among the deadliest earthquakes in history. Its name was taken from the city of Aleppo, in northern Syria, where the most casualties were sustained. The quake occurred on 11 October 1138 and was preceded by a smaller quake on the 10th. It is frequently listed as the third deadliest earthquake in history.</p>');
	$interestingDaysTomorrow[] = array('0917','<p>A deadly earthquake in Hongdong, now China, then Mongol Empire, ocurred on Sep 17, 1303. Approximate death toll is 200,000.</p>');
	$interestingDaysTomorrow[] = array('0108','<p>On Jan 8, 1780, a major earthquake hit near Tabriz (today the most populated city in the northwest of Iran, one of the historical capitals of Iran, and the present capital of East Azerbaijan Province) killing over 200,000 people.</p>');
	$interestingDaysTomorrow[] = array('0112','<p>A catastrophic magnitude 7.0 Mw earthquake, with an epicenter near the town of Léogâne (Ouest Department), approximately 25 kilometres (16 mi) west of Port-au-Prince, Haiti\'s capital, occurred at 16:53 local time (21:53 UTC) on Tuesday, 12 January 2010. An estimated three million people were affected by the quake. Death toll estimates range from 100,000 to about 160,000.</p>');
	$interestingDaysTomorrow[] = array('1228','<p>The 1908 Messina earthquake occurred on December 28 in Sicily and Calabria, southern Italy with a moment magnitude of 7.1 and a maximum Mercalli Intensity of XI (Extreme). The cities of Messina and Reggio Calabria were almost completely destroyed and between 75,000 and 200,000 lives were lost.</p>');
	$interestingDaysTomorrow[] = array('0531','<p>The 1970 Ancash earthquake (also known as the Great Peruvian earthquake) occurred on May 31 off the coast of Peru in the Pacific Ocean at 15:23:29 local time. Combined with a resultant landslide, it was the worst catastrophic natural disaster ever recorded in the history of Peru. Due to the large amounts of snow and ice included in the landslide and its estimated 66,794 to 70,000 casualties, it is also considered to be the world\'s deadliest avalanche.</p>');
	$interestingDaysTomorrow[] = array('0512','<p>The 2008 Sichuan earthquake or the Great Sichuan earthquake, measured at 8.0 Ms and 7.9 Mw, and occurred at 02:28:01 PM China Standard Time at epicenter (06:28:01 UTC) on Monday, May 12 in Sichuan province, killed 69,197 people and left 18,222 missing.</p>');
	$interestingDaysTomorrow[] = array('0410','<p>The 1815 eruption of Mount Tambora, on the island of Sumbawa in Indonesia on April 4, 1815, was one of the most powerful in recorded history. The eruption resulted in a brief period of significant climate change that consistently led to various cases of extreme weather. Several climate forcings coincided and interacted in a systematic manner that has not been observed since, despite other large eruptions that have occurred since the early 20th century.</p>');
	$interestingDaysTomorrow[] = array('0826','<p>The 1883 eruption of Krakatoa in the Dutch East Indies (now Indonesia) began in the afternoon of August 26, 1883 (with origins as early as May of that year), and culminated with several destructive eruptions of the remaining caldera. It was one of the deadliest and most destructive volcanic events in recorded history, with at least 36,417 deaths being attributed to the eruption itself and the tsunamis it created. Significant additional effects were also felt around the world.</p>');
	$interestingDaysTomorrow[] = array('1113','<p>The Armero tragedy was one of the major consequences of the eruption of the Nevado del Ruiz stratovolcano in Tolima, Colombia, on November 13, 1985. After 69 years of dormancy, the volcano\'s eruption caught nearby towns unaware, even though the government had received warnings from multiple volcanological organizations to evacuate the area when volcanic activity had been detected in September 1985. The lahars picked up speed in gullies and coursed into the six major rivers at the base of the volcano; they engulfed the town of Armero, killing more than 20,000 of its almost 29,000 inhabitants.</p>');
	$interestingDaysTomorrow[] = array('0521','<p>1792 Unzen earthquake and tsunami resulted from the volcanic activities of Mount Unzen (in the Shimabara Peninsula of Nagasaki Prefecture, Japan) on 21 May. This caused the collapse of the southern flank of the Mayuyama dome in front of Mount Unzen, resulting in a tremendous tsunami, killing 15,000 people altogether.</p>');
	$interestingDaysTomorrow[] = array('0818','<p>The 2012 Chios forest fire was a wildfire that broke out in the southern half of the Greek island of Chios shortly after 2 a.m. on Saturday 18 August 2012. By Monday 20 August local authorities reported that 7000 hectares (16,000 acres) of forest and farmland had been destroyed. The Greek government had asked for the help of aircraft from Spain and Italy to help not only with this but six other forest fires that broke out elsewhere in Greece on 19 August and five more on 20 August. Already on 18 August smoke from the fire was visible as far south as Crete, 350 kilometers (230 miles) away.</p>');
	$interestingDaysTomorrow[] = array('1225','<p>The 2001 Warragamba bushfires occurred Christmas Day, 25 December 2001 in the small New South Wales town of Warragamba, leaving 30 homes and businesses destroyed. The bushfires in Warragamba were part of the longest official continuous bushfire emergency in NSW taking place between 21 December 2001 and 13 January 2002 and spreading across the state. Most of these fires were caused by lightning or arsonists. The fire behaviour was unusual in many areas due to extreme dryness of fuel and variable winds.</p>');
	$interestingDaysTomorrow[] = array('0118','<p>The 2003 Canberra bushfires involved several deaths, over 490 injured, and caused severe damage to the outskirts of Canberra, the capital city of Australia, during 18–22 January 2003. Almost 70% of the Australian Capital Territory\'s (ACT) pastures, forests (pine plantations), and nature parks were severely damaged, and most of the renowned Mount Stromlo Observatory was destroyed. After burning for a week around the edges of the ACT, the fires entered the suburbs of Canberra on 18 January 2003. Over the next ten hours, four people died and more than 500 homes were destroyed or severely damaged, requiring a significant relief and reconstruction effort.</p>');
	$interestingDaysTomorrow[] = array('0207','<p>The Black Saturday bushfires were a series of bushfires that ignited or were burning across the Australian state of Victoria on and around Saturday, 7 February 2009 and were Australia\'s all-time worst bushfire disasters. The fires occurred during extreme bushfire-weather conditions and resulted in Australia\'s highest ever loss of life from a bushfire; 173 people died and 414 were injured as a result of the fires.</p>');
	$interestingDaysTomorrow[] = array('0216','<p>The Ash Wednesday bushfires, known in South Australia as Ash Wednesday II, were a series of bushfires that occurred in south-eastern Australia on 16 February 1983, which was Ash Wednesday in the Christian calendar. Within twelve hours, more than 180 fires fanned by winds of up to 110 km/h (68 mph) caused widespread destruction across the states of Victoria and South Australia. Years of severe drought and extreme weather combined to create one of Australia\'s worst fire days in a century. The fires became the deadliest bushfire in Australian history, until the Black Saturday bushfires in 2009.In Victoria, 47 people died, while in South Australia there were 28 deaths.</p>');
	$interestingDaysTomorrow[] = array('0207','<p>The 1967 Tasmanian fires were an Australian natural disaster which occurred on 7 February 1967, an event which became known as the Black Tuesday bushfires. They were the most deadly bushfires that Tasmania has ever experienced, leaving 62 people dead, 900 injured and over seven thousand homeless.</p>');
	$interestingDaysTomorrow[] = array('1008','<p>The Peshtigo Fire was a forest fire that took place on October 8, 1871 in and around Peshtigo, Wisconsin. It was a firestorm that caused the most deaths by fire in United States history, with estimated deaths of around 1,500 people, possibly as many as 2,500.</p>');
	$interestingDaysTomorrow[] = array('0820','<p>The Great Fire of 1910 (also commonly referred to as the Big Blowup, the Big Burn, or the Devil\'s Broom fire) was a wildfire that burned about three million acres (1,214,057 ha), approximately the size of Connecticut) in northeast Washington, northern Idaho (the panhandle), and western Montana. The firestorm burned over two days (August 20–21, 1910), and killed 87 people, mostly firefighters. It is believed to be the largest, although not the deadliest, forest fire in U.S. history.</p>');
	$interestingDaysTomorrow[] = array('1007','<p>A massive forest fire (or series of fires) which devastated forests and communities throughout much of northern New Brunswick in October 1825. It ranks among the three largest forest fires ever recorded in North America. About 1/3 of the homes in Fredericton were destroyed, but the main devastation was 100 miles (160 km) to the northeast. The preceding summer was a particularity hot one, with bush fires common. On the evening of October 7, 1825, the firestorm roared through Newcastle, New Brunswick (now part of the City of Miramichi), and in less than 3 hours reduced the town of 1,000 people to ruins - of 260 original buildings, only 12 remained.</p>');
	$interestingDaysTomorrow[] = array('1105','<p>On November 5, 1530,  The St. Felix’s Flood destroyed the city of Reimerswaal in the Netherlands and killed over 100,000 people, making it the fifth deadliest flood in human history.</p>');
	$interestingDaysTomorrow[] = array('0426','<p>The Chernobyl disaster was a catastrophic nuclear accident that occurred on 26 April 1986 at the Chernobyl Nuclear Power Plant in Ukraine (then officially the Ukrainian SSR). An explosion and fire released large quantities of radioactive particles into the atmosphere, which spread over much of the western USSR and Europe.</p><p>The Chernobyl disaster was the worst nuclear power plant accident in history in terms of cost and casualties. It is one of only two classified as a level 7 event (the maximum classification) on the International Nuclear Event Scale, the other being the Fukushima Daiichi nuclear disaster in 2011. The battle to contain the contamination and avert a greater catastrophe ultimately involved over 500,000 workers and cost an estimated 18 billion rubles. During the accident itself, 31 people died, and long-term effects such as cancers are still being investigated.</p>');
	$interestingDaysTomorrow[] = array('0311','<p>The Fukushima Daiichi nuclear disaster was an energy accident at the Fukushima I Nuclear Power Plant, initiated primarily by the tsunami of the Tōhoku earthquake and tsunami on 11 March 2011. The damage caused by the tsunami produced equipment failures, and without this equipment a loss-of-coolant accident followed with three nuclear meltdowns and releases of radioactive materials beginning on 12 March. It is the largest nuclear disaster since the Chernobyl disaster of 1986 and the second disaster (after Chernobyl) to be given the Level 7 event classification of the International Nuclear Event Scale.</p><p>The largest wave in the tsunami arrived some 50 minutes after the initial earthquake. The 13 meter tall wave overwhelmed the plant\'s seawall.</p>');
	$interestingDaysTomorrow[] = array('0929','<p>The Kyshtym disaster was a radiological contamination accident that occurred on 29 September 1957 at Mayak, a plutonium production site for nuclear weapons and nuclear fuel reprocessing plant in the Soviet Union. It measured as a Level 6 disaster on the International Nuclear Event Scale, making it the third most serious nuclear accident ever recorded.</p>');
	$interestingDaysTomorrow[] = array('1010','<p>The Windscale fire of 10 October 1957 was the worst nuclear accident in Great Britain\'s history, ranked in severity at level 5 on the 7-point International Nuclear Event Scale. The fire burned for three days and there was a release of radioactive contamination that spread across the UK and Europe. Of particular concern at the time was the radioactive isotope iodine-131, which may lead to cancer of the thyroid, and it has been estimated that the incident caused 240 additional cancer cases. No one was evacuated from the surrounding area, but there was a worry that milk might be dangerously contaminated. Milk from about 500 km2 of nearby countryside was diluted and destroyed for about a month.</p>');
	$interestingDaysTomorrow[] = array('0103','<p>On January 3, 1961, the only fatal nuclear reactor incident in the U.S. occurred at the NRTS. An experimental reactor called SL-1 (Stationary Low-Power Plant Number 1) was destroyed when a control rod was pulled too far out of the reactor, leading to core meltdown and a steam explosion. The reactor vessel jumped up 9 feet 1 inch (2.77 m). The concussion and blast killed all three military enlisted personnel working on the reactor. Due to the extensive radioactive isotope contamination, all three were buried in lead coffins.</p>');
	$interestingDaysTomorrow[] = array('0311','<p>The Great Blizzard of 1888 was one of the most severe recorded blizzards in the history of the United States of America, beginning on March 11, 1888. Snowfalls of 20–60 inches (51–152 cm) fell in parts of New Jersey, New York, Massachusetts, Rhode Island, and Connecticut, and sustained winds of more than 45 miles per hour (72 km/h) produced snowdrifts in excess of 50 feet (15 m). Railroads were shut down and people were confined to their houses for up to a week. The storm, referred to as the Great White Hurricane, paralyzed the East Coast from the Chesapeake Bay to Maine, as well as the Atlantic provinces of Canada. Telegraph infrastructure was disabled, isolating Montreal and most of the large northeastern U.S. cities from Washington, D.C. to Boston for days.</p>');
	$interestingDaysTomorrow[] = array('0312','<p>The 1993 Storm of the Century, also known as the \'93 Super Storm, the Great Blizzard of 1993, or the No Name Storm, was a large cyclonic storm that formed over the Gulf of Mexico on March 12, 1993. It was unique for its intensity, massive size, and wide-reaching effects, particularly in the southeastern United States. At its height, the storm stretched from Canada to Central America, but it impacted mainly the eastern United States and Cuba. The cyclone moved through the Gulf of Mexico and then through the eastern United States before moving onto Canada. Areas as far south as central Alabama and Georgia received 6 to 8 inches (15 to 20 cm) of snow. </p>');
	$interestingDaysTomorrow[] = array('0112','<p>The Schoolhouse Blizzard, also known as the Schoolchildren\'s Blizzard, hit the U.S. plains states on January 12, 1888. The blizzard came unexpectedly on a relatively warm day, and many people were caught unaware, including children in one-room schoolhouses. The blizzard was preceded by a snowstorm on January 5 and 6, which dropped powdery snow on the northern and central plains, and was followed by an outbreak of brutally cold temperatures from January 7 to 11. What made the storm so deadly was the timing (during work and school hours), the suddenness, and the brief spell of warmer weather that preceded it. In addition, the very strong wind fields behind the cold front and the powdery nature of the snow reduced visibilities on the open plains to zero.</p>');
	$interestingDaysTomorrow[] = array('0123','<p>The Hakkōda Mountains incident occurred on January 23, 1902, when a group of Imperial Japanese Army soldiers became lost in a blizzard on the Hakkōda Mountains in Aomori Prefecture in northern Honshu, Japan, en route to Tashiro Hot Spring located in the Hakkōda Mountains. The 199 deaths during a single ascent make it the world\'s largest mountaineering disaster in the modern history of mountain climbing.</p>');

	$interestingDayToday = "";
	$interestingDayTomorrow = "";

	foreach($interestingDaysToday as $item){
		if($item[0]==date('md')){
			$interestingDayToday = $item[1];
		}
	}
	foreach($interestingDaysTomorrow as $item){
		if($item[0]==date('md',strtotime('tomorrow'))){
			$interestingDayTomorrow = $item[1];
		}
	}

	// station DATA
	$errorLog[] = array("","Loading station data.");
	$result = mysqli_query($con, "
			SELECT  T, H, P, W, G, D, A, R, B, S
			FROM  alldata
			ORDER BY DateTime DESC
			LIMIT 1
			"
	);
	while ($row = mysqli_fetch_array($result)) {
		$currentT = convertT($row['T']);
		$currentB = $row['B'];
		$currentW = convertW($row['W']);
		$currentG = convertW($row['G']);
		$currentR = convertR($row['R']);
		$currentP = convertP($row['P']);
		$currentH = $row['H'];
		$currentD = convertT($row['D']);
		$currentA = convertT($row['A']);
	}

	if($currentR==0){
		$currentPrecipitation = lang("So far no precipitation has been observed today","-");
	}
	else{
		$currentPrecipitation = lang("The total rainfall amount since midnight is","-")." ".number_format($currentR,$decimalsRain,".","").$displayRainUnits;
	}

	$resultSQLBaro = mysqli_query($con, "
			SELECT  DateTime, P
			FROM  alldata
			WHERE DateTime <= now() - interval 3 hour
			ORDER BY DateTime DESC
			LIMIT 1
			"
	);
	while($row = mysqli_fetch_array($resultSQLBaro)){
		$pressure3h = convertP($row['P']);
	}

	$pressureDifference3h = $currentP - $pressure3h;

	function pressureTrend($pressureDifference){
		global $displayPressUnits;
		if($displayPressUnits=='hpa'){
			if(abs($pressureDifference)<=0.6){
				$barTrend = lang("Steady","-");
			}
			else if($pressureDifference>0.6 && $pressureDifference<2){
				$barTrend = lang("Rising Slowly","-");
			}
			else if($pressureDifference >= 2){
				$barTrend = lang("Rising Rapidly","-");
			}
			else if($pressureDifference<-0.6 && $pressureDifference>-2){
				$barTrend = lang("Falling Slowly","-");
			}
			else if($pressureDifference <= -2){
				$barTrend = lang("Falling Rapidly","-");
			}
			else{
			}
		}
		if($displayPressUnits=='inhg'){
			if(abs($pressureDifference)<=0.02){
				$barTrend = lang("Steady","-");
			}
			else if($pressureDifference>0.02 && $pressureDifference<0.06){
				$barTrend = lang("Rising Slowly","-");
			}
			else if($pressureDifference >= 0.06){
				$barTrend = lang("Rising Rapidly","-");
			}
			else if($pressureDifference<-0.02 && $pressureDifference>-0.06){
				$barTrend = lang("Falling Slowly","-");
			}
			else if($pressureDifference <= -0.06){
				$barTrend = lang("Falling Rapidly","-");
			}
			else{
			}
		}
		if($displayPressUnits=='mmhg'){
			if(abs($pressureDifference)<=0.5){
				$barTrend = lang("Steady","-");
			}
			else if($pressureDifference>0.5 && $pressureDifference<1.5){
				$barTrend = lang("Rising Slowly","-");
			}
			else if($pressureDifference >= 1.5){
				$barTrend = lang("Rising Rapidly","-");
			}
			else if($pressureDifference<-0.5 && $pressureDifference>-1.5){
				$barTrend = lang("Falling Slowly","-");
			}
			else if($pressureDifference <= -1.5){
				$barTrend = lang("Falling Rapidly","-");
			}
			else{
			}
		}
		return $barTrend;
	}
	$today = array();
	// Today's current data
	$result = mysqli_query($con, "
			SELECT  max(Tmax), min(Tmin), avg(T), avg(H), max(H), min(H), avg(P), max(P), min(P), avg(A), max(A), min(A), avg(D), max(D), min(D), avg(W), max(W), avg(G), max(G), max(R)
			FROM  alldata
			WHERE DATE(DateTime) = CURDATE()
			"
	);
	while ($row = mysqli_fetch_array($result)) {
		$today['avgT'] = convertT($row['avg(T)']);
		$today['maxT'] = convertT($row['max(Tmax)']);
		$today['minT'] = convertT($row['min(Tmin)']);

		$today['avgH'] = $row['avg(H)'];
		$today['maxH'] = $row['max(H)'];
		$today['minH'] = $row['min(H)'];

		$today['avgP'] = convertP($row['avg(P)']);
		$today['maxP'] = convertP($row['max(P)']);
		$today['minP'] = convertP($row['min(P)']);

		$today['avgW'] = convertW($row['avg(W)']);
		$today['maxW'] = convertW($row['max(W)']);

		$today['avgG'] = convertW($row['avg(G)']);
		$today['maxG'] = convertW($row['max(G)']);
		$today['maxGoriginal'] = $row['max(G)'];

		$today['totalR'] = convertR($row['max(R)']);

		$today['avgA'] = convertT($row['avg(A)']);
		$today['maxA'] = convertT($row['max(A)']);
		$today['minA'] = convertT($row['min(A)']);

		$today['avgD'] = convertT($row['avg(D)']);
		$today['maxD'] = convertT($row['max(D)']);
		$today['minD'] = convertT($row['min(D)']);

	}

	if(isset($today['maxGoriginal'])){ // fallback if no data so far today
		$result = mysqli_query($con, "
				SELECT  DateTime
				FROM  alldata
				WHERE DATE(DateTime) = CURDATE() AND G=".$today['maxGoriginal']
		);
		while ($row = mysqli_fetch_array($result)) {
			$todayMaxGTime = date($timeFormat,strtotime($row['DateTime']));
		}
	}

	// YESTERDAY
	// check if yesterday's data is available in cache, if not or if it is outdated, delete the cache
	if(file_exists("cache/yesterday.txt")){
		$errorLog[] = array("","Loading yesterday\'s data from cache file.");
		$yesterdayCache = file_get_contents("cache/yesterday.txt");
		$yesterdayCache = json_decode($yesterdayCache,true);
		if($yesterdayCache['date']!=date('Ymd',strtotime('yesterday'))){
			unlink("cache/yesterday.txt");
			$errorLog[] = array("","Cache file for yesterday outdated, deleting...");
			if(file_exists("cache/yesterday.txt")){
				$errorLog[] = array("w","Cache file for yesterday was not deleted, likely permission problem. Cache file cannot be refreshed and data is outdated.");
			}
		}
	}

	// if cached data available, load yesterday from cache
	if(file_exists("cache/yesterday.txt")){
		$yesterday = file_get_contents("cache/yesterday.txt");
		$errorLog[] = array("","Loading yesterday\'s data from cache file.");
		$yesterday = json_decode($yesterday,true);
	}
	// if not, load data from database and create new cache file
	else{
		$yesterday = array();

		$result = mysqli_query($con, "
			SELECT  max(Tmax), min(Tmin), avg(T), avg(H), max(H), min(H), avg(P), max(P), min(P),avg(A), max(A), min(A), avg(D), max(D), min(D), avg(W), max(W), avg(G), max(G),max(R)
			FROM  alldata
			WHERE DATE(DateTime) = CURDATE() - INTERVAL 1 DAY
			"
		);
		while ($row = mysqli_fetch_array($result)) {
			$yesterday['avgT'] = convertT($row['avg(T)']);
			$yesterday['maxT'] = convertT($row['max(Tmax)']);
			$yesterday['minT'] = convertT($row['min(Tmin)']);

			$yesterday['avgH'] = $row['avg(H)'];
			$yesterday['maxH'] = $row['max(H)'];
			$yesterday['minH'] = $row['min(H)'];

			$yesterday['avgP'] = convertP($row['avg(P)']);
			$yesterday['maxP'] = convertP($row['max(P)']);
			$yesterday['minP'] = convertP($row['min(P)']);

			$yesterday['avgW'] = convertW($row['avg(W)']);
			$yesterday['maxW'] = convertW($row['max(W)']);

			$yesterday['avgG'] = convertW($row['avg(G)']);
			$yesterday['maxG'] = convertW($row['max(G)']);

			$yesterday['totalR'] = convertR($row['max(R)']);

			$yesterday['avgA'] = convertT($row['avg(A)']);
			$yesterday['maxA'] = convertT($row['max(A)']);
			$yesterday['minA'] = convertT($row['min(A)']);

			$yesterday['avgD'] = convertT($row['avg(D)']);
			$yesterday['maxD'] = convertT($row['max(D)']);
			$yesterday['minD'] = convertT($row['min(D)']);

			$yesterday['date'] = date('Ymd',strtotime('yesterday'));
		}
		$saveYesterday = file_put_contents("cache/yesterday.txt",json_encode($yesterday));
		$errorLog[] = array("","Saving cache file for yesterday\'s data.");
		if(!file_exists("cache/yesterday.txt")){
			$errorLog[] = array("w","Unable to save cache file. Check permissions for Summary block folder.");
		}
	}

	// TOMORROW
	$tomorrow['available'] = false;
	$tomorrowDate = strtotime("tomorrow");
	// check if tomorrow's data is available in cache, if not or if it is outdated, delete the cache
	if(file_exists("cache/tomorrow.txt")){
		$tomorrowCache = file_get_contents("cache/tomorrow.txt");
		$tomorrowCache = json_decode($tomorrowCache,true);
		if($tomorrowCache['date']!=date('Ymd',strtotime('tomorrow'))){
			unlink("cache/tomorrow.txt");
			$errorLog[] = array("","Cache file for tomorrow outdated, deleting...");
			if(file_exists("cache/tomorrow.txt")){
				$errorLog[] = array("w","Cache file for tomorrow was not deleted, likely permission problem. Cache file cannot be refreshed and data is outdated.");
			}
		}
	}

	// if cached data available, load tomorrow from cache
	if(file_exists("cache/tomorrow.txt")){
		$tomorrow = file_get_contents("cache/tomorrow.txt");
		$tomorrow = json_decode($tomorrow,true);
		$errorLog[] = array("","Loading tomorrow\'s data from cache file.");
	}
	// if not, load data from database and create new cache file
	else{
		$tomorrow = array();

		$result = mysqli_query($con, "
			SELECT  max(Tmax), min(Tmin), avg(T), avg(H), max(H), min(H), avg(P), max(P), min(P),avg(A), max(A), min(A), avg(D), max(D), min(D), avg(W), max(W), avg(G), max(G)
			FROM  alldata
			WHERE MONTH(DateTime) = ".date("m",$tomorrowDate)." AND DAY(DateTime) = ".date("d",$tomorrowDate)."
			"
		);
		while ($row = mysqli_fetch_array($result)) {
			$tomorrow['available'] = true;
			$tomorrow['avgT'] = convertT($row['avg(T)']);
			$tomorrow['maxT'] = convertT($row['max(Tmax)']);
			$tomorrow['minT'] = convertT($row['min(Tmin)']);
			$tomorrow['maxToriginal'] = $row['max(Tmax)'];
			$tomorrow['minToriginal'] = $row['min(Tmin)'];

			$tomorrow['avgH'] = $row['avg(H)'];
			$tomorrow['maxH'] = $row['max(H)'];
			$tomorrow['minH'] = $row['min(H)'];

			$tomorrow['avgP'] = convertP($row['avg(P)']);
			$tomorrow['maxP'] = convertP($row['max(P)']);
			$tomorrow['minP'] = convertP($row['min(P)']);

			$tomorrow['avgW'] = convertW($row['avg(W)']);
			$tomorrow['maxW'] = convertW($row['max(W)']);

			$tomorrow['avgG'] = convertW($row['avg(G)']);
			$tomorrow['maxG'] = convertW($row['max(G)']);

			$tomorrow['avgA'] = convertT($row['avg(A)']);
			$tomorrow['maxA'] = convertT($row['max(A)']);
			$tomorrow['minA'] = convertT($row['min(A)']);

			$tomorrow['avgD'] = convertT($row['avg(D)']);
			$tomorrow['maxD'] = convertT($row['max(D)']);
			$tomorrow['minD'] = convertT($row['min(D)']);

			$tomorrow['date'] = date('Ymd',strtotime('tomorrow'));
		}
		if(isset($tomorrow['maxToriginal'])){ // fallback if no data so far today
			$tomorrow['maxTTime'] = array();
			$result = mysqli_query($con, "
					SELECT  DateTime
					FROM  alldata
					WHERE MONTH(DateTime) = ".date("m",$tomorrowDate)." AND DAY(DateTime) = ".date("d",$tomorrowDate)." AND Tmax=".$tomorrow['maxToriginal']
			);
			while ($row = mysqli_fetch_array($result)) {
				$tomorrow['maxTTime'][] = date("d-m-Y",strtotime($row['DateTime']));
			}
		}
		if(isset($tomorrow['minToriginal'])){ // fallback if no data so far today
			$tomorrow['minTTime'] = array();
			$result = mysqli_query($con, "
					SELECT  DateTime
					FROM  alldata
					WHERE MONTH(DateTime) = ".date("m",$tomorrowDate)." AND DAY(DateTime) = ".date("d",$tomorrowDate)." AND Tmax=".$tomorrow['minToriginal']
			);
			while ($row = mysqli_fetch_array($result)) {
				$tomorrow['minTTime'][] = date("d-m-Y",strtotime($row['DateTime']));
			}
		}
		$tomorrowRains = array();
		$result = mysqli_query($con, "
			SELECT  max(R), YEAR(DateTime)
			FROM  alldata
			WHERE MONTH(DateTime) = ".date("m",$tomorrowDate)." AND DAY(DateTime) = ".date("d",$tomorrowDate)."
			GROUP BY YEAR(DateTime), MONTH(DateTime), DAY(DateTime)
			ORDER BY DateTime
			"
		);
		while ($row = mysqli_fetch_array($result)) {
			$tomorrowRains[$row['YEAR(DateTime)']] = convertR($row['max(R)']);
		}
		$tomorrow['maxR'] = max($tomorrowRains);
		$tomorrow['maxRTime'] = array();
		$tomorrow['minR'] = min($tomorrowRains);
		$tomorrow['minRTime'] = array();
		foreach($tomorrowRains as $key=>$rain){
			if($rain==$tomorrow['maxR']){
				$tomorrow['maxRTime'][] = $key;
			}
			if($rain==$tomorrow['minR']){
				$tomorrow['minRTime'][] = $key;
			}
		}
		$tomorrow['avgR'] = array_sum($tomorrowRains)/count($tomorrowRains);
		$savetomorrow = file_put_contents("cache/tomorrow.txt",json_encode($tomorrow));
		$errorLog[] = array("","Saving cache file for tomorrow\'s data.");
		if(!file_exists("cache/tomorrow.txt")){
			$errorLog[] = array("w","Unable to save cache file. Check permissions for Summary block folder.");
		}
	}

	// UPCOMING WEEK
	$week['available'] = false;
	$tomorrowDate = strtotime('tomorrow');
	if(file_exists("cache/week.txt")){
		$weekCache = file_get_contents("cache/week.txt");
		$weekCache = json_decode($weekCache,true);
		if($weekCache['date']!=date('Ymd',strtotime('tomorrow'))){
			unlink("cache/week.txt");
			$errorLog[] = array("","Cache file for the week outdated, deleting...");
			if(file_exists("cache/week.txt")){
				$errorLog[] = array("w","Cache file for next week was not deleted, likely permission problem. Cache file cannot be refreshed and data is outdated.");
			}
		}
	}
	if(file_exists("cache/week.txt")){
		$week = file_get_contents("cache/week.txt");
		$week = json_decode($week,true);
		$errorLog[] = array("","Loading week\'s data from cache file.");
	}
	else{
		$week = array();

		$result = mysqli_query($con, "
			SELECT  max(Tmax), min(Tmin), avg(T), avg(H), max(H), min(H), avg(P), max(P), min(P),avg(A), max(A), min(A), avg(D), max(D), min(D), avg(W), max(W), avg(G), max(G)
			FROM  alldata
			WHERE
				(MONTH(DateTime) = ".date("m",strtotime('tomorrow'))." AND DAY(DateTime) = ".date("d",strtotime('tomorrow')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+2 days'))." AND DAY(DateTime) = ".date("d",strtotime('+2 days')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+3 days'))." AND DAY(DateTime) = ".date("d",strtotime('+3 days')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+4 days'))." AND DAY(DateTime) = ".date("d",strtotime('+4 days')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+5 days'))." AND DAY(DateTime) = ".date("d",strtotime('+5 days')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+6 days'))." AND DAY(DateTime) = ".date("d",strtotime('+6 days')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+7 days'))." AND DAY(DateTime) = ".date("d",strtotime('+7 days')).")
			"
		);
		while ($row = mysqli_fetch_array($result)) {
			$week['available'] = true;
			$week['avgT'] = convertT($row['avg(T)']);
			$week['maxT'] = convertT($row['max(Tmax)']);
			$week['minT'] = convertT($row['min(Tmin)']);
			$week['maxToriginal'] = $row['max(Tmax)'];
			$week['minToriginal'] = $row['min(Tmin)'];

			$week['avgH'] = $row['avg(H)'];
			$week['maxH'] = $row['max(H)'];
			$week['minH'] = $row['min(H)'];

			$week['avgP'] = convertP($row['avg(P)']);
			$week['maxP'] = convertP($row['max(P)']);
			$week['minP'] = convertP($row['min(P)']);

			$week['avgW'] = convertW($row['avg(W)']);
			$week['maxW'] = convertW($row['max(W)']);

			$week['avgG'] = convertW($row['avg(G)']);
			$week['maxG'] = convertW($row['max(G)']);

			$week['avgA'] = convertT($row['avg(A)']);
			$week['maxA'] = convertT($row['max(A)']);
			$week['minA'] = convertT($row['min(A)']);

			$week['avgD'] = convertT($row['avg(D)']);
			$week['maxD'] = convertT($row['max(D)']);
			$week['minD'] = convertT($row['min(D)']);

			$week['date'] = date('Ymd',strtotime('tomorrow'));
		}
		if(isset($week['maxToriginal'])){
			$week['maxTTime'] = array();
			$result = mysqli_query($con, "
					SELECT  DateTime
					FROM  alldata
					WHERE
						(
							(MONTH(DateTime) = ".date("m",strtotime('tomorrow'))." AND DAY(DateTime) = ".date("d",strtotime('tomorrow')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+2 days'))." AND DAY(DateTime) = ".date("d",strtotime('+2 days')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+3 days'))." AND DAY(DateTime) = ".date("d",strtotime('+3 days')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+4 days'))." AND DAY(DateTime) = ".date("d",strtotime('+4 days')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+5 days'))." AND DAY(DateTime) = ".date("d",strtotime('+5 days')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+6 days'))." AND DAY(DateTime) = ".date("d",strtotime('+6 days')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+7 days'))." AND DAY(DateTime) = ".date("d",strtotime('+7 days')).")
						) AND (Tmax= ".$week['maxToriginal'].")
					"
			);
			while ($row = mysqli_fetch_array($result)) {
				$week['maxTTime'][] = date("d-m-Y",strtotime($row['DateTime']));
			}
		}
		if(isset($week['minToriginal'])){
			$week['minTTime'] = array();
			$result = mysqli_query($con, "
					SELECT  DateTime
					FROM  alldata
					WHERE
						(
							(MONTH(DateTime) = ".date("m",strtotime('tomorrow'))." AND DAY(DateTime) = ".date("d",strtotime('tomorrow')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+2 days'))." AND DAY(DateTime) = ".date("d",strtotime('+2 days')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+3 days'))." AND DAY(DateTime) = ".date("d",strtotime('+3 days')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+4 days'))." AND DAY(DateTime) = ".date("d",strtotime('+4 days')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+5 days'))." AND DAY(DateTime) = ".date("d",strtotime('+5 days')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+6 days'))." AND DAY(DateTime) = ".date("d",strtotime('+6 days')).") OR
							(MONTH(DateTime) = ".date("m",strtotime('+7 days'))." AND DAY(DateTime) = ".date("d",strtotime('+7 days')).")
						) AND (Tmin= ".$week['minToriginal'].")
					"
			);
			while ($row = mysqli_fetch_array($result)) {
				$week['minTTime'][] = date("d-m-Y",strtotime($row['DateTime']));
			}
		}
		$weekRains = array();
		$result = mysqli_query($con, "
			SELECT  max(R), DateTime
			FROM  alldata
			WHERE
				(MONTH(DateTime) = ".date("m",strtotime('tomorrow'))." AND DAY(DateTime) = ".date("d",strtotime('tomorrow')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+2 days'))." AND DAY(DateTime) = ".date("d",strtotime('+2 days')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+3 days'))." AND DAY(DateTime) = ".date("d",strtotime('+3 days')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+4 days'))." AND DAY(DateTime) = ".date("d",strtotime('+4 days')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+5 days'))." AND DAY(DateTime) = ".date("d",strtotime('+5 days')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+6 days'))." AND DAY(DateTime) = ".date("d",strtotime('+6 days')).") OR
				(MONTH(DateTime) = ".date("m",strtotime('+7 days'))." AND DAY(DateTime) = ".date("d",strtotime('+7 days')).")
			GROUP BY YEAR(DateTime), MONTH(DateTime), DAY(DateTime)
			ORDER BY DateTime
			"
		);
		while ($row = mysqli_fetch_array($result)) {
			$weekRains[strtotime($row['DateTime'])] = convertR($row['max(R)']);
		}
		$week['maxR'] = max($weekRains);
		$week['maxRTime'] = array();
		$week['minR'] = min($weekRains);
		$week['minRTime'] = array();
		foreach($weekRains as $key=>$rain){
			if($rain==$week['maxR']){
				$week['maxRTime'][] = date($dateFormat,$key);
			}
			if($rain==$week['minR']){
				$week['minRTime'][] = date($dateFormat,$key);
			}
		}
		$week['avgR'] = array_sum($weekRains)/count($weekRains);
		$saveWeek = file_put_contents("cache/week.txt",json_encode($week));
		$errorLog[] = array("","Saving cache file for week\'s data.");
		if(!file_exists("cache/week.txt")){
			$errorLog[] = array("w","Unable to save cache file. Check permissions for Summary block folder.");
		}
	}

	// THIS MONTH

	$month = array();

	$result = mysqli_query($con, "
		SELECT  max(Tmax), min(Tmin), avg(T), avg(H), max(H), min(H), avg(P), max(P), min(P),avg(A), max(A), min(A), avg(D), max(D), min(D), avg(W), max(W), avg(G), max(G)
		FROM  alldata
		WHERE MONTH(DateTime) = ".date('m')." AND YEAR(DateTime) = ".date("Y")."
		"
	);
	while ($row = mysqli_fetch_array($result)) {
		$month['avgT'] = convertT($row['avg(T)']);
		$month['maxT'] = convertT($row['max(Tmax)']);
		$month['maxToriginal'] = $row['max(Tmax)'];
		$month['minT'] = convertT($row['min(Tmin)']);
		$month['minToriginal'] = $row['min(Tmin)'];

		$month['avgH'] = $row['avg(H)'];
		$month['maxH'] = $row['max(H)'];
		$month['minH'] = $row['min(H)'];

		$month['avgP'] = convertP($row['avg(P)']);
		$month['maxP'] = convertP($row['max(P)']);
		$month['minP'] = convertP($row['min(P)']);

		$month['avgW'] = convertW($row['avg(W)']);
		$month['maxW'] = convertW($row['max(W)']);

		$month['avgG'] = convertW($row['avg(G)']);
		$month['maxG'] = convertW($row['max(G)']);
		$month['maxGoriginal'] = $row['max(G)'];

		$month['avgA'] = convertT($row['avg(A)']);
		$month['maxA'] = convertT($row['max(A)']);
		$month['minA'] = convertT($row['min(A)']);

		$month['avgD'] = convertT($row['avg(D)']);
		$month['maxD'] = convertT($row['max(D)']);
		$month['minD'] = convertT($row['min(D)']);
	}

	$result = mysqli_query($con, "
		SELECT  DateTime
		FROM  alldata
		WHERE MONTH(DateTime) = ".date('m')." AND YEAR(DateTime) = ".date("Y")." AND G=".$month['maxGoriginal']
	);
	while ($row = mysqli_fetch_array($result)) {
		$monthMaxGTime = strtotime($row['DateTime']);
	}

	$result = mysqli_query($con, "
		SELECT  DateTime
		FROM  alldata
		WHERE MONTH(DateTime) = ".date('m')." AND YEAR(DateTime) = ".date("Y")." AND Tmax= ".$month['maxToriginal']."
		"
	);
	while ($row = mysqli_fetch_array($result)) {
		$month['maxTTime'] = strtotime($row['DateTime']);
	}
	$result = mysqli_query($con, "
		SELECT  DateTime
		FROM  alldata
		WHERE MONTH(DateTime) = ".date('m')." AND YEAR(DateTime) = ".date("Y")." AND Tmin= ".$month['minToriginal']."
		"
	);
	while ($row = mysqli_fetch_array($result)) {
		$month['minTTime'] = strtotime($row['DateTime']);
	}

	if($today['maxT']>=$month['maxT']){
		$maxMonthString = lang("Today's maximum temperature of","-")." ".number_format($today['maxT'],1,".","")."° ".lang("is also the highest temperature overall measured this month","-").".";
	}
	else{
		$maxMonthString = lang("Overall monthly maximum temperature so far was","-")." ".number_format($month['maxT'],1,".","")."°, ".lang("measured on the","-")." ".date("j",$month['maxTTime'])." ".lang("at","l")." ".date($timeFormat,$month['maxTTime']).".";
	}

	if($today['minT']<=$month['minT']){
		$minMonthString = lang("The minimum temperature for","-")." ".lang("month".date("n"),$dateCapital)." ".date('Y',time())." ".lang("is today's minimum of","-")." ".number_format($today['minT'],1,".","")."°.";
	}
	else{
		$minMonthString = lang("The minimum temperature for","-")." ".lang("month".date("n"),$dateCapital)." ".date('Y')." ".lang("is","l")." ".number_format($month['minT'],1,".","")."°, ".lang("observed on the","-")." ".date("j",$month['minTTime'])." ".lang("at","-")." ".date($timeFormat,$month['minTTime']).".";
	}

	$yesterdayTDiff = round($today['avgT'] - $yesterday['avgT'],1);
	if($yesterdayTDiff < 0){
		$yesterdayTDiffString = number_format(abs($yesterdayTDiff),1,".","")."°".$displayTempUnits." ".lang("less than yesterday, when the average was","-")." ".number_format($yesterday['avgT'],1,".","")."°".$displayTempUnits." (".lang("maximumAbbr","l")." ".number_format($yesterday['maxT'],1,".","")."° ".lang("and","l")." ".lang("minimumAbbr","l")." ".number_format($yesterday['minT'],1,".","")."°".$displayTempUnits.")";
	}
	else if($yesterdayTDiff == 0){
		$yesterdayTDiffString = number_format($yesterdayTDiff,1,".","")."°".$displayTempUnits." ".lang("exactly the same average temperature as yesterday","-")." ".number_format($yesterday['avgT'],1,".","")."°".$displayTempUnits." (".lang("maximumAbbr","l")." ".number_format($yesterday['maxT'],1,".","")."° ".lang("and","l")." ".lang("minimumAbbr","l")." ".number_format($yesterday['minT'],1,".","")." °".$displayTempUnits.")";
	}
	else if($yesterdayTDiff > 0){
		$yesterdayTDiffString = number_format($yesterdayTDiff,1,".","")."°".$displayTempUnits." ".lang("more than yesterday, when the average was","-")." ".number_format($yesterday['avgT'],1,".","")."°".$displayTempUnits." (".lang("maximumAbbr","-")." ".number_format($yesterday['maxT'],1,".","")."° ".lang("and","l")." ".lang("minimumAbbr","l")." ".number_format($yesterday['minT'],1,".","")."°".$displayTempUnits.")";
	}
	else{}

	// LONG TERM AVERAGE FOR TODAY
	$thisDay = array();
	$result = mysqli_query($con, "
		SELECT avg(T), avg(H), avg(P), avg(W), avg(G)
		FROM  alldata
		WHERE Month(DateTime) = ".date('m')." AND Day(DateTime) = ".date('d')."
		ORDER BY DateTime
	"
	);
	while ($row = mysqli_fetch_array($result)) {
		$thisDay['avgT'] = convertT($row['avg(T)']);
		$thisDay['avgH'] = round($row['avg(H)']);
		$thisDay['avgP'] = convertP($row['avg(P)']);
		$thisDay['avgW'] = convertW($row['avg(W)']);
		$thisDay['avgG'] = convertW($row['avg(G)']);
	}

	$thisDay['maxT'] = -999;
	$thisDay['minT'] = 999;
	$thisDay['maxTYear'] = array();
	$thisDay['minTYear'] = array();

	$result = mysqli_query($con, "
		SELECT T, Year(DateTime)
		FROM  alldata
		WHERE Month(DateTime) = ".date('m')." AND Day(DateTime) = ".date('d')."
		ORDER BY DateTime
	"
	);
	while ($row = mysqli_fetch_array($result)) {
		if(convertT($row['T'])>$thisDay['maxT']){
			$thisDay['maxT'] = convertT($row['T']);
			$thisDay['maxTYear'] = array();
			$thisDay['maxTYear'][] = $row['Year(DateTime)'];
		}
		if(convertT($row['T'])==$thisDay['maxT']){
			$thisDay['maxT'] = convertT($row['T']);
			$thisDay['maxTYear'][] = $row['Year(DateTime)'];
		}
		if(convertT($row['T'])<$thisDay['minT']){
			$thisDay['minT'] = convertT($row['T']);
			$thisDay['minTYear'] = array();
			$thisDay['minTYear'][] = $row['Year(DateTime)'];
		}
		if(convertT($row['T'])==$thisDay['minT']){
			$thisDay['minT'] = convertT($row['T']);
			$thisDay['minTYear'][] = $row['Year(DateTime)'];
		}
	}
	$thisDay['maxTYear'] = array_unique($thisDay['maxTYear']);
	$thisDay['minTYear'] = array_unique($thisDay['minTYear']);

	$todayThisDayDiff = round($today['avgT'] - $thisDay['avgT'],1);
	if($todayThisDayDiff < 0){
		$todayThisDayDiffString = " ".lang("below the long-term average for","-")." ".date('d')." ".lang("month".date("n"),$dateCapital);
	}
	else if($todayThisDayDiff == 0){
		$todayThisDayDiffString = " ".lang("exactly the same as the long-term average for","-")." ".date('d')." ".lang("month".date("n"),$dateCapital);
	}
	else if($todayThisDayDiff > 0){
		$todayThisDayDiffString = " ".lang("above the long-term average for","-")." ".date('d')." ".lang("month".date("n"),$dateCapital);
	}
	else{}

	// LONG TERM AVERAGE FOR THIS MONTH
	$thisMonth = array();
	$result = mysqli_query($con, "
		SELECT avg(T), avg(H), avg(P), avg(W), avg(G), max(G)
		FROM  alldata
		WHERE Month(DateTime) = ".date('m')."
		ORDER BY DateTime
	"
	);
	while ($row = mysqli_fetch_array($result)) {
		$thisMonth['avgT'] = convertT($row['avg(T)']);
		$thisMonth['avgH'] = round($row['avg(H)'],1);
		$thisMonth['avgP'] = convertP($row['avg(P)']);
		$thisMonth['avgW'] = convertW($row['avg(W)']);
		$thisMonth['avgG'] = convertW($row['avg(G)']);
		$thisMonth['maxG'] = convertW($row['max(G)']);
		$thisMonth['maxGoriginal'] = $row['max(G)'];
	}

	$result = mysqli_query($con, "
		SELECT  DateTime
		FROM  alldata
		WHERE MONTH(DateTime) = ".date('m')."  AND G=".$thisMonth['maxGoriginal']
	);
	while ($row = mysqli_fetch_array($result)) {
		$thisMonthMaxGTime = strtotime($row['DateTime']);
	}

	$thisMonth['maxT'] = -999;
	$thisMonth['minT'] = 999;
	$thisMonth['maxTYear'] = array();
	$thisMonth['minTYear'] = array();

	$result = mysqli_query($con, "
		SELECT T, Year(DateTime)
		FROM  alldata
		WHERE Month(DateTime) = ".date('m')."
		ORDER BY DateTime
	"
	);
	while ($row = mysqli_fetch_array($result)) {
		if(convertT($row['T'])>$thisMonth['maxT']){
			$thisMonth['maxT'] = convertT($row['T']);
			$thisMonth['maxTYear'] = array();
			$thisMonth['maxTYear'][] = $row['Year(DateTime)'];
		}
		if(convertT($row['T'])==$thisMonth['maxT']){
			$thisMonth['maxT'] = convertT($row['T']);
			$thisMonth['maxTYear'][] = $row['Year(DateTime)'];
		}
		if(convertT($row['T'])<$thisMonth['minT']){
			$thisMonth['minT'] = convertT($row['T']);
			$thisMonth['minTYear'] = array();
			$thisMonth['minTYear'][] = $row['Year(DateTime)'];
		}
		if(convertT($row['T'])==$thisMonth['minT']){
			$thisMonth['minT'] = convertT($row['T']);
			$thisMonth['minTYear'][] = $row['Year(DateTime)'];
		}
	}
	$thisMonth['maxTYear'] = array_unique($thisMonth['maxTYear']);
	$thisMonth['minTYear'] = array_unique($thisMonth['minTYear']);

	$monthThisMonthDiff = round($month['avgT'] - $thisMonth['avgT'],1);
	if($monthThisMonthDiff < 0){
		$monthThisMonthDiffString = " ".lang("below the long-term average for","-")." ".lang("month".date("n"),$dateCapital);
	}
	else if($monthThisMonthDiff == 0){
		$monthThisMonthDiffString = " ".lang("exactly the same as the long-term average for","-")." ".lang("month".date("n"),$dateCapital);
	}
	else if($monthThisMonthDiff > 0){
		$monthThisMonthDiffString = " ".lang("above the long-term average for","-")." ".lang("month".date("n"),$dateCapital);
	}
	else{}

	$twoDayRain = "";
	if($today['totalR']==0 && $yesterday['totalR']==0){
		$twoDayRain = lang("Neither today nor yesterday there was any rain observed","-").".";
	}
	if($today['totalR']==0 && $yesterday['totalR']>0){
		$twoDayRain = lang("No rain has been observed today, however yesterday there was","-")." ".number_format($yesterday['totalR'],$decimalsRain,".","")." ".$displayRainUnits.". ";
	}
	if($today['totalR']>0 && $yesterday['totalR']==0){
		$twoDayRain = lang("There was no precipitation observed yesterday, however today the rainfall since midnight has already been","-")." ".number_format($today['totalR'],$decimalsRain,".","")." ".$displayRainUnits.". ";
	}
	if($today['totalR']>0 && $yesterday['totalR']>0){
		$twoDayRain = lang("Both today and yesterday there was some rain observed. While yesterday there was a total of","-")." ".number_format($yesterday['totalR'],$decimalsRain,".","")." ".$displayRainUnits.", ".lang("today it has been","-")." ".number_format($today['totalR'],$decimalsRain,".","")." ".$displayRainUnits." ".lang("so far since midnight","-").". ";
	}

	$month['R'] = array();
	$month['maxRdays'] = array();
	$monthMaxR = -999;
	$result = mysqli_query($con, "
			SELECT  max(R), DateTime
			FROM  alldata
			WHERE YEAR(DateTime) = YEAR(CURDATE()) AND MONTH(DateTime) = MONTH(CURDATE())
			GROUP BY YEAR(DateTime), MONTH(DateTime), DAY(DateTime)
			"
	);
	while ($row = mysqli_fetch_array($result)) {
		array_push($month['R'], convertR($row['max(R)']));
		if(convertR($row['max(R)'])>$monthMaxR){
			$month['maxRdays'] = array();
			array_push($month['maxRdays'], date('j',strtotime($row['DateTime'])));
			$monthMaxR = convertR($row['max(R)']);
		}
		else if	(convertR($row['max(R)'])==$monthMaxR){
			array_push($month['maxRdays'], date('j',strtotime($row['DateTime'])));
		}
		else{}
	}

	$thisMonth['R'] = array();
	$thisMonth['Rall'] = array();
	$thisMonth['RallDays'] = array();
	$result = mysqli_query($con, "
			SELECT  max(R), DateTime, Year(DateTime)
			FROM  alldata
			WHERE MONTH(DateTime) = MONTH(CURDATE())
			GROUP BY YEAR(DateTime), MONTH(DateTime), DAY(DateTime)
			"
	);
	while ($row = mysqli_fetch_array($result)) {
		$thisMonth['R'][$row['Year(DateTime)']][] = convertR($row['max(R)']);
		array_push($thisMonth['Rall'], convertR($row['max(R)']));
		array_push($thisMonth['RallDays'], strtotime($row['DateTime']));
	}

	$thisMonthAvgDayR = round(array_sum($thisMonth['Rall'])/count($thisMonth['Rall']),$decimalsRain);

	// general month average
	$monthlyRAvgs = array();

	foreach($thisMonth['R'] as $key => $monthlyRain){
		$monthlyRAvgs[] = array_sum($monthlyRain);
	}

	// maximum for this month in general
	$thisMonthTotalMaxR = -999;
	$thisMonthTotalMinR = +999;
	$thisMonthTotalMaxRYears = array();
	$thisMonthTotalMinRYears = array();
	foreach($thisMonth['R'] as $key => $monthlyRain){
		if(array_sum($monthlyRain)>$thisMonthTotalMaxR){
			$thisMonthTotalMaxRYears = array();
			array_push($thisMonthTotalMaxRYears, $key);
			$thisMonthTotalMaxR = array_sum($monthlyRain);
		}
		else if	(array_sum($monthlyRain)==$thisMonthTotalMaxR){
			array_push($thisMonthTotalMaxRYears, $key);
		}
		else{}
	}
	foreach($thisMonth['R'] as $key => $monthlyRain){
		if(array_sum($monthlyRain)<$thisMonthTotalMinR){
			$thisMonthTotalMinRYears = array();
			array_push($thisMonthTotalMinRYears, $key);
			$thisMonthTotalMinR = array_sum($monthlyRain);
		}
		else if	(array_sum($monthlyRain)==$thisMonthTotalMinR){
			array_push($thisMonthTotalMinRYears, $key);
		}
		else{}
	}

	$absoluteMaxRDay = max($thisMonth['Rall']);
	$absoluteMaxRDayDate = array();
	for($b=0;$b<count($thisMonth['Rall']);$b++){
		if($thisMonth['Rall'][$b]==$absoluteMaxRDay){
			$absoluteMaxRDayDate[] = date($dateFormat,$thisMonth['RallDays'][$b]);
		}
	}


	$monthRainString = lang("Since the 1st of this month, the cumulative rainfall is","-")." ".number_format(array_sum($month['R']),$decimalsRain,".","")." ".$displayRainUnits.". ";
	$monthRainString .= lang("The maximum daily precipitation in","-")." ".lang("month".date("n"),$dateCapital)." ".date("Y")." ".lang("is","l")." ".number_format(max($month['R']),$decimalsRain,".","")." ".$displayRainUnits.", ".lang("measured on the","-")." ".implode(",",$month['maxRdays']).". ";
	$monthRainString .= lang("In general, the average daily precipitation in","-")." ".lang("month".date("n"),$dateCapital)." ".lang("is","-")." ".$thisMonthAvgDayR." ".$displayRainUnits." ".lang("and overall","-")." ".lang("month".date("n"),$dateCapital)." ".lang("average","l")."	".lang("total","l")." ".lang("precipitation",'l')." ".lang("is","l")." ".number_format((array_sum($monthlyRAvgs)/count($monthlyRAvgs)),$decimalsRain,".","")." ".$displayRainUnits.". ";

	if((array_sum($thisMonth['Rall'])/count($thisMonth['Rall']))>(array_sum($month['R'])/count($month['R']))){
		$monthRainString .= lang("This month's daily average of","-")." ".number_format((array_sum($month['R'])/count($month['R'])),$decimalsRain,".","")." ".$displayRainUnits." ".lang("is therefore below the daily average","-")." ".number_format((array_sum($thisMonth['Rall'])/count($thisMonth['Rall'])),$decimalsRain,".","")." ".lang("for","l")." ".lang("month".date("n"),$dateCapital).". ";
	}
	if((array_sum($thisMonth['Rall'])/count($thisMonth['Rall']))<(array_sum($month['R'])/count($month['R']))){
		$monthRainString .= lang("This month's daily average of","-")." ".number_format((array_sum($month['R'])/count($month['R'])),$decimalsRain,".","")." ".$displayRainUnits." ".lang("is therefore above the daily average","-")." ".number_format((array_sum($thisMonth['Rall'])/count($thisMonth['Rall'])),$decimalsRain,".","")." ".lang("for","l")." ".lang("month".date("n"),$dateCapital).". ";
	}
	if((array_sum($thisMonth['Rall'])/count($thisMonth['Rall']))==(array_sum($month['R'])/count($month['R']))){
		$monthRainString .= lang("This month's daily average of","-")." ".number_format((array_sum($month['R'])/count($month['R'])),$decimalsRain,".","")." ".$displayRainUnits." ".lang("is therefore the same as the daily average","-")." ".number_format((array_sum($thisMonth['Rall'])/count($thisMonth['Rall'])),$decimalsRain,".","")." ".$displayRainUnits." ".lang("for","-")." ".lang("month".date("n"),$dateCapital).". ";
	}
	$monthRainString .= lang("Highest measured total rainfall in","-")." ".lang("month".date("n"),$dateCapital)." ".lang("is","l")." ".number_format($thisMonthTotalMaxR,$decimalsRain,".","")." ".$displayRainUnits.", ".lang("which was in","-")." ".implode(",",$thisMonthTotalMaxRYears).". ".lang("In contrast, the lowest total","-")." ".lang("month".date("n"),$dateCapital)." ".lang("precipitation was measured in","-")." ".implode(",",$thisMonthTotalMinRYears)." ".lang("when it was only","-")." ".number_format($thisMonthTotalMinR,$decimalsRain,".","")." ".$displayRainUnits.". ";
	$monthRainString .= lang("Maximum daily precipitation for this month is currently","-")." ".number_format(max($thisMonth['Rall']),$decimalsRain,".","")." ".$displayRainUnits.", ".lang("a value measured on","-")." ".implode(",",$absoluteMaxRDayDate).". ";

	// FORECAST
	$todayNameFile = date("Ymd",time());
	if(file_exists("cache/".$todayNameFile.".txt")){
		if (time()-filemtime("cache/".$todayNameFile.".txt") > 60) {
			unlink("cache/".$todayNameFile.".txt");
			$errorLog[] = array("","Deleting outdated cache file cache/".$todayNameFile.".txt");
			if(file_exists("cache/".$todayNameFile.".txt")){
				$errorLog[] = array("w","Cache file was not deleted, likely permission problem. Cache file cannot be refreshed and data is outdated.");
			}
		}
	}
	if(file_exists("cache/".$todayNameFile.".txt")){
		$cached = fopen("cache/".$todayNameFile.".txt", "r");
		$forecast = fread($cached,filesize("cache/".$todayNameFile.".txt"));
		fclose($cached);
		$errorLog[] = array("","Data loaded from cache/".$todayNameFile.".txt");
	}
	else {
		//$forecast = file_get_contents($yrNoLocation);
		$forecast = loadContentSummary($yrNoLocation,5);
		$cached = fopen("cache/".$todayNameFile.".txt", "w");
		fwrite($cached, $forecast);
		fclose($cached);
		$errorLog[] = array("","Creating cache file cache/".$todayNameFile.".txt");
		if(!file_exists("cache/".$todayNameFile.".txt")){
			$errorLog[] = array("w","Cache file was not created, likely permission problem. Cache file cannot be refreshed and data is outdated.");
		}
		if(file_exists("cache/".date("Ymd",strtotime('yesterday')).".txt")){
			unlink("cache/".date("Ymd",strtotime('yesterday')).".txt");
		}
	}
	//$xmlYrNo = json_decode(json_encode((array) simplexml_load_string($forecast)),1);
	$xmlYrNo = json_decode($forecast,1);
	//print_r($xmlYrNo); echo "<br>";
	$numberItems = count($xmlYrNo['properties']['timeseries']);
	$tempUnitsYrNo = $xmlYrNo['properties']['meta']['units']['air_temperature'];
	$stationTimezone = new DateTimeZone($stationTZ);
	//$UTCoffset = $stationTimezone->getOffset(new DateTime);
	$UTCoffset = 0;
	//echo "UTCoffset=$UTCoffset<br>";
	for($i=0;$i<$numberItems;$i++){
		$yrNoDataRow = array();
		$time = $xmlYrNo['properties']['timeseries'][$i]['time'];
		$time = str_replace("T"," ",$time);
		$time = str_replace("-","/",$time);
		$time = str_replace("Z","",$time);
		$yrNoDataRow['date'] = strtotime($time)+$UTCoffset;
        if (!isset($xmlYrNo['properties']['timeseries'][$i]['data']['next_6_hours'])) continue;
		if ( ($i == 0) || (date("H",strtotime($time)+$UTCoffset) % 6) == 0 ) {} else continue;
		$yrNoDataRow['period'] = intval(date("H",strtotime($time)+$UTCoffset) / 6);
		$yrNoDataRow['humanDate'] = date("d-m-Y",strtotime($time)+$UTCoffset);
		//echo "time=$time date=".$yrNoDataRow['date']." human=".date("d-m-Y H",strtotime($time)+$UTCoffset)."<br>";
		$yrNoDataRow['condition'] = (string)$xmlYrNo['properties']['timeseries'][$i]['data']['next_6_hours']['summary']['symbol_code'];
		$yrNoDataRow['condition'] = convertConditions($yrNoDataRow['condition']);
		if(array_key_exists(strtolower($yrNoDataRow['condition']),$language[$lang])){
			$yrNoDataRow['condition'] = lang(strtolower($yrNoDataRow['condition']),"l");
		}
		if(array_key_exists(ucfirst($yrNoDataRow['condition']),$language[$lang])){
			$yrNoDataRow['condition'] = lang(ucfirst($yrNoDataRow['condition']),"l");
		}
		if(array_key_exists(ucwords($yrNoDataRow['condition']),$language[$lang])){
			$yrNoDataRow['condition'] = lang(ucwords($yrNoDataRow['condition']),"l");
		}
		$precipitation = $xmlYrNo['properties']['timeseries'][$i]['data']['next_1_hours']['details']['precipitation_amount'];
		if($displayRainUnits=="mm"){
			$yrNoDataRow['precipitation'] = $precipitation;
		}
		if($displayRainUnits=="in"){
			$yrNoDataRow['precipitation'] = number_format(($precipitation * 0.039370),2,".","");
		}
		$temperature = $xmlYrNo['properties']['timeseries'][$i]['data']['instant']['details']['air_temperature'];
		if($tempUnitsYrNo=="celsius" && $displayTempUnits=="C"){
			 $yrNoDataRow['temperature'] = number_format($temperature,0,".","");
		}
		if($tempUnitsYrNo!="celsius" && $displayTempUnits=="F"){
			 $yrNoDataRow['temperature'] = number_format($temperature,0,".","");
		}
		if($tempUnitsYrNo=="celsius" && $displayTempUnits=="F"){
			$temperature = $temperature*1.8 + 32;
			$yrNoDataRow['temperature'] = number_format($temperature,0,".","");
		}
		if($tempUnitsYrNo!="celsius" && $displayTempUnits=="C"){
			$temperature = ($temperature-32)/1.8;
			$yrNoDataRow['temperature'] = number_format($temperature,0,".","");
		}
		$yrNoDataRow['windDirection'] = $xmlYrNo['properties']['timeseries'][$i]['data']['instant']['details']['wind_from_direction'];
		$yrNoDataRow['windDirectionCode'] = getWindDirection($yrNoDataRow['windDirection']);
		$yrNoDataRow['windDirectionCode'] = trim($yrNoDataRow['windDirectionCode']);
		$yrNoDataRow['windDirectionCode'] = lang("direction".strtoupper($yrNoDataRow['windDirectionCode']),"u");
		$yrNoDataRow['windSpeed'] = $xmlYrNo['properties']['timeseries'][$i]['data']['instant']['details']['wind_speed'];
		if($displayWindUnits=="mph"){
			$yrNoDataRow['windSpeed'] = round($yrNoDataRow['windSpeed'] * 2.23694,0);
		}
		if($displayWindUnits=="kt"){
			$yrNoDataRow['windSpeed'] = round($yrNoDataRow['windSpeed'] * 1.943844,0);
		}
		if($displayWindUnits=="kmh"){
			$yrNoDataRow['windSpeed'] = round($yrNoDataRow['windSpeed'] * 3.6,0);
		}
		else{
			$yrNoDataRow['windSpeed'] = round($yrNoDataRow['windSpeed'] * 1,0);
		}
		$yrNoDataRow['windName'] = '';
		if(array_key_exists(strtolower($yrNoDataRow['windName']),$language[$lang])){
			$yrNoDataRow['windName'] = lang(strtolower($yrNoDataRow['windName']),"l");
		}
		if(array_key_exists(ucfirst($yrNoDataRow['windName']),$language[$lang])){
			$yrNoDataRow['windName'] = lang(ucfirst($yrNoDataRow['windName']),"l");
		}
		if(array_key_exists(ucwords($yrNoDataRow['windName']),$language[$lang])){
			$yrNoDataRow['windName'] = lang(ucwords($yrNoDataRow['windName']),"l");
		}
		$hourForecast = date("H",$yrNoDataRow['date'])*1;
		$forecasts[date("Ymd",$yrNoDataRow['date'])][] = $yrNoDataRow;
	}
	if(count($forecasts)==0){
		unlink("cache/".$todayNameFile.".txt");
		$forecastAvailable = false;
	}
	else{
		$forecastAvailable = true;
		$forecastString = "";
		$wordsApproximately = array(lang('about',"-"),lang('approximately',"-"),lang('around',"-"),lang('roughly',"-"),'');
		$firstStrings = array(lang('in the first half of the day',"-"),lang('early in the day',"-"),lang('in the morning',"-"));
		$laterStrings = array(lang('in the second half of the day',"-"),lang('later in the day',"-"),lang('towards the end of the day',"-"),lang('in the afternoon and evening',"-"));
		$precipitationStrings = array(lang('rainfall amount',"-"),lang('precipitation amount',"-"),lang('rainfall',"-"),lang('precipitation',"-"));
		$measurementStrings = array(lang('recorded',"-"),lang('measured',"-"),lang('observed',"-"));
		$expectedStrings = array(lang('forecasted',"-"),lang('expected',"-"));
		// for today
		if(array_key_exists(date('Ymd',time()),$forecasts)){
			for($a=0;$a<count($forecasts[date('Ymd',time())]);$a++){
				$currentForecastRow = $forecasts[date('Ymd',time())][$a];
				if($currentForecastRow['period']==0){
					$forecastString = $forecastString . lang("Today early in the morning we expect","-")." ".strtolower($currentForecastRow['condition'])." ".lang("and temperatures around","-")." ".$currentForecastRow['temperature']."°".$displayTempUnits.". ";
					if($currentForecastRow['precipitation']>0){
						$forecastString = $forecastString . lang("The amount of rainfall should be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['precipitation'].$displayRainUnits.". ";
					}
					$forecastString = $forecastString . $currentForecastRow['windName']." ".lang("fromDir","-")." ".$currentForecastRow['windDirectionCode']." ".lang("with a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['windSpeed']." ".unitFormatter($displayWindUnits).". ";
				}
				if($currentForecastRow['period']==1){
					$forecastString = $forecastString . lang("Later in the morning today, the temperatures are going to be approximately","-")." ".$currentForecastRow['temperature']."°".$displayTempUnits." ".lang("and","l")." ".strtolower($currentForecastRow['condition']).". ";
					if($currentForecastRow['precipitation']>0){
						$forecastString = $forecastString . lang("The","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("precipitation amount is","-")." ".$currentForecastRow['precipitation'].$displayRainUnits.". ";
					}
					$forecastString = $forecastString . $currentForecastRow['windName']." ".lang("fromDir","-")." ".$currentForecastRow['windDirectionCode']." ".lang("with a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['windSpeed']." ".unitFormatter($displayWindUnits).". ";
				}
				if($currentForecastRow['period']==2){
					$forecastString = $forecastString . lang("Temperatures this afternoon will be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['temperature']."°".$displayTempUnits." ".lang("and","l")." ".strtolower($currentForecastRow['condition']).". ";
					if($currentForecastRow['precipitation']>0){
						$forecastString = $forecastString . lang("The","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("precipitation amount is","-")." ".$currentForecastRow['precipitation'].$displayRainUnits.". ";
					}
					$forecastString = $forecastString . $currentForecastRow['windName']." ".lang("fromDir","l")." ".$currentForecastRow['windDirectionCode']." ".lang("with a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['windSpeed']." ".unitFormatter($displayWindUnits).". ";
				}
				if($currentForecastRow['period']==3){
					$forecastString = $forecastString . lang("In the evening today we expect","-")." ".strtolower($currentForecastRow['condition'])." ".lang("and temperatures around","-")." ".$currentForecastRow['temperature']."°".$displayTempUnits.". ";
					if($currentForecastRow['precipitation']>0){
						$forecastString = $forecastString . lang("The precipitation amount should be approximately","-")." ".$currentForecastRow['precipitation'].$displayRainUnits.". ";
					}
					$forecastString = $forecastString . $currentForecastRow['windName']." ".lang("fromDir","-")." ".$currentForecastRow['windDirectionCode']." ".lang("at","l")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['windSpeed']." ".unitFormatter($displayWindUnits).". ";
				}
			}
			$forecastString = $forecastString . "</p>";
		}
		// for tomorrow
		if(array_key_exists(date('Ymd',strtotime('tomorrow')),$forecasts)){
			$forecastString .= "<p>";
			for($a=0;$a<count($forecasts[date('Ymd',strtotime('tomorrow'))]);$a++){
				$currentForecastRow = $forecasts[date('Ymd',strtotime('tomorrow'))][$a];
				if($currentForecastRow['period']==0){
					$forecastString = $forecastString . lang("Tomorrow morning the","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("weather condition is","-")." ".strtolower($currentForecastRow['condition'])." ".lang("and temperatures around","-")." ".$currentForecastRow['temperature']."°".$displayTempUnits.". ";
					if($currentForecastRow['precipitation']>0){
						$forecastString = $forecastString .lang("The","-")." ".$precipitationStrings[array_rand($precipitationStrings)]." ".lang("should be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['precipitation'].$displayRainUnits.". ";
					}
					$forecastString = $forecastString . $currentForecastRow['windName']." ".lang("fromDir","-")." ".$currentForecastRow['windDirectionCode']." ".lang("with a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['windSpeed']." ".unitFormatter($displayWindUnits).". ";
					$previousTemp = $currentForecastRow['temperature'];
				}
				if($currentForecastRow['period']==1){
					$forecastString = $forecastString . lang("Later in the morning tomorrow, the temperatures","-")." ".compareTwoT($previousTemp,$currentForecastRow['temperature']).". ";
					if($currentForecastRow['precipitation']>0){
						$forecastString = $forecastString . lang("The","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$precipitationStrings[array_rand($precipitationStrings)]." is ".$currentForecastRow['precipitation'].$displayRainUnits.". ";
					}
					$forecastString = $forecastString . $currentForecastRow['windName']." ".lang("fromDir","-")." ".$currentForecastRow['windDirectionCode']." with a speed of ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['windSpeed']." ".unitFormatter($displayWindUnits).". ";
					$previousTemp = $currentForecastRow['temperature'];
				}
				if($currentForecastRow['period']==2){
					$forecastString = $forecastString . lang("The temperatures in the afternoon","-")." ".compareTwoT($previousTemp,$currentForecastRow['temperature'])." ".lang("and","-")." ".strtolower($currentForecastRow['condition']).". ";
					if($currentForecastRow['precipitation']>0){
						$forecastString = $forecastString . lang("The","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$precipitationStrings[array_rand($precipitationStrings)]." ".lang("is","-")." ".$currentForecastRow['precipitation'].$displayRainUnits.". ";
					}
					$forecastString = $forecastString . $currentForecastRow['windName']." ".lang("fromDir","-")." ".$currentForecastRow['windDirectionCode']." ".lang("with a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['windSpeed']." ".unitFormatter($displayWindUnits).". ";
					$previousTemp = $currentForecastRow['temperature'];
				}
				if($currentForecastRow['period']==3){
					$forecastString = $forecastString . lang("Tomorrow evening and night we expect","-")." ".strtolower($currentForecastRow['condition'])." ".lang("and temperatures","-")." ".compareTwoT($previousTemp,$currentForecastRow['temperature']).". ";
					if($currentForecastRow['precipitation']>0){
						$forecastString = $forecastString . lang("The","-")." ".$precipitationStrings[array_rand($precipitationStrings)]." ".lang("should be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['precipitation'].$displayRainUnits.". ";
					}
					$forecastString = $forecastString . $currentForecastRow['windName']." ".lang("fromDir","-")." ".$currentForecastRow['windDirectionCode']." ".lang("at","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$currentForecastRow['windSpeed']." ".unitFormatter($displayWindUnits).". ";
					$previousTemp = $currentForecastRow['temperature'];
				}
			}
			$forecastString = $forecastString . "</p>";
		}
		// for next days
		if(array_key_exists(date('Ymd',strtotime('+2 days')),$forecasts)){
			$forecastString .= "<p>";
			$temperaturesTemporary = array();
			$precipitationsTemporary = array();
			$windsTemporary = array();
			$windNamesTemporary = array();
			$windDirectionsTemporary = array();
			$conditionsTemporary = array();
			foreach($forecasts[date('Ymd',strtotime('+2 days'))] as $period){
				$temperaturesTemporary[] = $period['temperature'];
				$precipitationsTemporary[] = $period['precipitation'];
				$windsTemporary[] = $period['windSpeed'];
				$conditionsTemporary[] = $period['condition'];
				$windNamesTemporary[] = $period['windName'];
				$windDirectionsTemporary[] = $period['windDirectionCode'];
			}
			$dailyMaxT = round(max($temperaturesTemporary));
			$dailyMinT = round(min($temperaturesTemporary));
			$dailyAvgTDay2 = round(array_sum($temperaturesTemporary)/count($temperaturesTemporary));
			$dailyAvgW = round(array_sum($windsTemporary)/count($windsTemporary));
			$forecastString = $forecastString . lang("On","-")." ".lang(strtolower(date('l',strtotime('+2 days'))),"l")." ".lang("temperatures will range between","-")." ".$dailyMinT." ".lang("and","-")." ".$dailyMaxT."°".$displayTempUnits.". ";
			$forecastString = $forecastString . ucfirst($conditionsTemporary[0])." ".lang("early in the morning, then","-")." ".strtolower($conditionsTemporary[1]) . ", " . strtolower($conditionsTemporary[2])." ".lang("later in the afternoon and","-")." ".strtolower($conditionsTemporary[3])." ".lang("towards the end of the day","-").". ";
			$rainSum = array_sum($precipitationsTemporary);
			if($rainSum==0){
				$forecastString = $forecastString . lang("No rain is","-")." ".$expectedStrings[array_rand($expectedStrings)].". ";
			}
			else{
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Rain is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$firstStrings[array_rand($firstStrings)]." (".($precipitationsTemporary[0]+$precipitationsTemporary[1])." ".$displayRainUnits.") ".lang("as well as","-")." ".$laterStrings[array_rand($laterStrings)]." (".($precipitationsTemporary[2]+$precipitationsTemporary[3])." ".$displayRainUnits."). ".lang("Overall there should be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])==0){
					$forecastString = $forecastString . lang("Precipitation is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$firstStrings[array_rand($firstStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])==0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Precipitation is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$laterStrings[array_rand($laterStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
			}
			$forecastString = $forecastString . ucfirst($windNamesTemporary[1])." ".$firstStrings[array_rand($firstStrings)]." ".lang("fromDir","-")." ".$windDirectionsTemporary[1]." ".lang("of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[1])." ".unitFormatter($displayWindUnits).", ".lang("then","-")." ".$laterStrings[array_rand($laterStrings)]." ".strtolower($windNamesTemporary[2])." ".lang("at a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[2])." ".unitFormatter($displayWindUnits)." ".lang("fromDir","-")." ".$windDirectionsTemporary[2].". ";
			$forecastString = $forecastString . "</p>";
		}
		if(array_key_exists(date('Ymd',strtotime('+3 days')),$forecasts)){
			$forecastString .= "<p>";
			$temperaturesTemporary = array();
			$precipitationsTemporary = array();
			$windsTemporary = array();
			$windNamesTemporary = array();
			$windDirectionsTemporary = array();
			$conditionsTemporary = array();
			foreach($forecasts[date('Ymd',strtotime('+3 days'))] as $period){
				$temperaturesTemporary[] = $period['temperature'];
				$precipitationsTemporary[] = $period['precipitation'];
				$windsTemporary[] = $period['windSpeed'];
				$conditionsTemporary[] = $period['condition'];
				$windNamesTemporary[] = $period['windName'];
				$windDirectionsTemporary[] = $period['windDirectionCode'];
			}
			$dailyMaxT = round(max($temperaturesTemporary));
			$dailyMinT = round(min($temperaturesTemporary));
			$dailyAvgTDay3 = round(array_sum($temperaturesTemporary)/count($temperaturesTemporary));
			$dailyAvgW = round(array_sum($windsTemporary)/count($windsTemporary));
			$forecastString = $forecastString . lang("Then on","-")." ".lang(strtolower(date('l',strtotime('+3 days'))),"l").", ".lang("the average temperature","-")." ".compareTwoT($dailyAvgTDay2,$dailyAvgTDay3).". ";
			$forecastString = $forecastString . lang("Expected daily highs of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($dailyMaxT)."°".$displayTempUnits." ".lang("and lows","-")." ".round($dailyMinT)."°".$displayTempUnits.", ".strtolower($conditionsTemporary[1])." ".lang("in the morning","-").", ".strtolower($conditionsTemporary[2])." ".$laterStrings[array_rand($laterStrings)]." ".lang("and then","-")." ".strtolower($conditionsTemporary[3]).". ";
			if($rainSum==0){}
			else{
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Rain is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$firstStrings[array_rand($firstStrings)]." (".($precipitationsTemporary[0]+$precipitationsTemporary[1])." ".$displayRainUnits.") ".lang("as well as","-")." ".$laterStrings[array_rand($laterStrings)]." (".($precipitationsTemporary[2]+$precipitationsTemporary[3])." ".$displayRainUnits."). ".lang("Overall there should be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])==0){
					$forecastString = $forecastString . lang("Precipitation is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$firstStrings[array_rand($firstStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])==0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Precipitation is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$laterStrings[array_rand($laterStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
			}
			$forecastString = $forecastString . ucfirst($windNamesTemporary[1])." ".$firstStrings[array_rand($firstStrings)]." ".lang("fromDir","-")." ".$windDirectionsTemporary[1]." ".lang("of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[1])." ".unitFormatter($displayWindUnits).", ".lang("then","-")." ".$laterStrings[array_rand($laterStrings)]." ".strtolower($windNamesTemporary[2])." ".lang("at a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[2])." ".unitFormatter($displayWindUnits)." ".lang("fromDir","-")." ".$windDirectionsTemporary[2].". ";
			$forecastString = $forecastString . "</p>";
		}
		if(array_key_exists(date('Ymd',strtotime('+4 days')),$forecasts)){
			$forecastString .= "<p>";
			$temperaturesTemporary = array();
			$precipitationsTemporary = array();
			$windsTemporary = array();
			$windNamesTemporary = array();
			$windDirectionsTemporary = array();
			$conditionsTemporary = array();
			foreach($forecasts[date('Ymd',strtotime('+4 days'))] as $period){
				$temperaturesTemporary[] = $period['temperature'];
				$precipitationsTemporary[] = $period['precipitation'];
				$windsTemporary[] = $period['windSpeed'];
				$conditionsTemporary[] = $period['condition'];
				$windNamesTemporary[] = $period['windName'];
				$windDirectionsTemporary[] = $period['windDirectionCode'];
			}
			$dailyMaxT = round(max($temperaturesTemporary));
			$dailyMinT = round(min($temperaturesTemporary));
			$dailyAvgTDay4 = round(array_sum($temperaturesTemporary)/count($temperaturesTemporary));
			$dailyAvgW = round(array_sum($windsTemporary)/count($windsTemporary));
			$forecastString = $forecastString . lang("On","-")." ".lang(strtolower(date('l',strtotime('+4 days'))),"l").", ".lang("the average temperature","-")." ".compareTwoT($dailyAvgTDay3,$dailyAvgTDay4).". ";
			$forecastString = $forecastString . "".ucfirst($expectedStrings[array_rand($expectedStrings)])." ".lang("daily maximum","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($dailyMaxT)."°".$displayTempUnits." ".lang("and minimum","-")." ".round($dailyMinT)."°".$displayTempUnits.", ".strtolower($conditionsTemporary[1])." ".lang("in the morning","-").", ".strtolower($conditionsTemporary[2])." ".$laterStrings[array_rand($laterStrings)]." ".lang("and then","-")." ".strtolower($conditionsTemporary[3]).". ";
			if($rainSum==0){}
			else{
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Rain is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$firstStrings[array_rand($firstStrings)]." (".($precipitationsTemporary[0]+$precipitationsTemporary[1])." ".$displayRainUnits.") ".lang("as well as","-")." ".$laterStrings[array_rand($laterStrings)]." (".($precipitationsTemporary[2]+$precipitationsTemporary[3])." ".$displayRainUnits."). ".lang("Overall there should be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])==0){
					$forecastString = $forecastString . lang("Precipitation is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$firstStrings[array_rand($firstStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])==0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Precipitation is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$laterStrings[array_rand($laterStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
			}
			$forecastString = $forecastString . ucfirst($windNamesTemporary[1])." ".$firstStrings[array_rand($firstStrings)]." ".lang("fromDir","-")." ".$windDirectionsTemporary[1]." ".lang("of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[1])." ".unitFormatter($displayWindUnits).", ".lang("then","-")." ".$laterStrings[array_rand($laterStrings)]." ".strtolower($windNamesTemporary[2])." ".lang("at a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[2])." ".unitFormatter($displayWindUnits)." ".lang("fromDir","-")." ".$windDirectionsTemporary[2].". ";
			$forecastString = $forecastString . "</p>";
		}
		if(array_key_exists(date('Ymd',strtotime('+5 days')),$forecasts)){
			$forecastString .= "<p>";
			$temperaturesTemporary = array();
			$precipitationsTemporary = array();
			$windsTemporary = array();
			$windNamesTemporary = array();
			$windDirectionsTemporary = array();
			$conditionsTemporary = array();
			foreach($forecasts[date('Ymd',strtotime('+5 days'))] as $period){
				$temperaturesTemporary[] = $period['temperature'];
				$precipitationsTemporary[] = $period['precipitation'];
				$windsTemporary[] = $period['windSpeed'];
				$conditionsTemporary[] = $period['condition'];
				$windNamesTemporary[] = $period['windName'];
				$windDirectionsTemporary[] = $period['windDirectionCode'];
			}
			$dailyMaxT = round(max($temperaturesTemporary));
			$dailyMinT = round(min($temperaturesTemporary));
			$dailyAvgTDay5 = round(array_sum($temperaturesTemporary)/count($temperaturesTemporary));
			$dailyAvgW = round(array_sum($windsTemporary)/count($windsTemporary));
			$forecastString = $forecastString . lang("Even later on","-")." ".lang(strtolower(date('l',strtotime('+5 days'))),"l").", ".lang("the average temperature","-")." ".compareTwoT($dailyAvgTDay4,$dailyAvgTDay5).". ";
			$forecastString = $forecastString . lang("Expected daily maximum","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($dailyMaxT)."°".$displayTempUnits." ".lang("and minimum","-")." ".round($dailyMinT)."°".$displayTempUnits.", ".strtolower($conditionsTemporary[1])." ".lang("in the morning","-").", ".strtolower($conditionsTemporary[2])." ".$laterStrings[array_rand($laterStrings)]." ".lang("and then","-")." ".strtolower($conditionsTemporary[3]).". ";
			if($rainSum==0){}
			else{
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Rain is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$firstStrings[array_rand($firstStrings)]." (".($precipitationsTemporary[0]+$precipitationsTemporary[1])." ".$displayRainUnits.") ".lang("as well as","-")." ".$laterStrings[array_rand($laterStrings)]." (".($precipitationsTemporary[2]+$precipitationsTemporary[3])." ".$displayRainUnits."). ".lang("Overall there should be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])==0){
					$forecastString = $forecastString . lang("Precipitation is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$firstStrings[array_rand($firstStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])==0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Precipitation is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$laterStrings[array_rand($laterStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
			}
			$forecastString = $forecastString . ucfirst($windNamesTemporary[1])." ".$firstStrings[array_rand($firstStrings)]." ".lang("fromDir","-")." ".$windDirectionsTemporary[1]." ".lang("of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[1])." ".unitFormatter($displayWindUnits).", ".lang("then","-")." ".$laterStrings[array_rand($laterStrings)]." ".strtolower($windNamesTemporary[2])." ".lang("at a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[2])." ".unitFormatter($displayWindUnits)." ".lang("fromDir","-")." ".$windDirectionsTemporary[2].". ";
			$forecastString = $forecastString . "</p>";
		}
		if(array_key_exists(date('Ymd',strtotime('+6 days')),$forecasts)){
			$forecastString .= "<p>";
			$temperaturesTemporary = array();
			$precipitationsTemporary = array();
			$windsTemporary = array();
			$windNamesTemporary = array();
			$windDirectionsTemporary = array();
			$conditionsTemporary = array();
			foreach($forecasts[date('Ymd',strtotime('+6 days'))] as $period){
				$temperaturesTemporary[] = $period['temperature'];
				$precipitationsTemporary[] = $period['precipitation'];
				$windsTemporary[] = $period['windSpeed'];
				$conditionsTemporary[] = $period['condition'];
				$windNamesTemporary[] = $period['windName'];
				$windDirectionsTemporary[] = $period['windDirectionCode'];
			}
			$dailyMaxT = round(max($temperaturesTemporary));
			$dailyMinT = round(min($temperaturesTemporary));
			$dailyAvgTDay6 = round(array_sum($temperaturesTemporary)/count($temperaturesTemporary));
			$dailyAvgW = round(array_sum($windsTemporary)/count($windsTemporary));
			$forecastString = $forecastString . lang("Almost a week from now on","-")." ".lang(strtolower(date('l',strtotime('+6 days'))),"l").", ".lang("the average temperature","-")." ".compareTwoT($dailyAvgTDay5,$dailyAvgTDay6).". ";
			$forecastString = $forecastString . lang("Expected daily highs of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($dailyMaxT)."°".$displayTempUnits." ".lang("and lows","-")." ".round($dailyMinT)."°".$displayTempUnits.", ".strtolower($conditionsTemporary[1])." ".lang("in the morning","-").", ".strtolower($conditionsTemporary[2])." ".$laterStrings[array_rand($laterStrings)]." ".lang("and then","-")." ".strtolower($conditionsTemporary[3]).". ";
			if($rainSum==0){}
			else{
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Rain is expected","-")." ".$firstStrings[array_rand($firstStrings)]." (".($precipitationsTemporary[0]+$precipitationsTemporary[1])." ".$displayRainUnits.") ".lang("as well as","-")." ".$laterStrings[array_rand($laterStrings)]." (".($precipitationsTemporary[2]+$precipitationsTemporary[3])." ".$displayRainUnits."). ".lang("Overall there should be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])==0){
					$forecastString = $forecastString . lang("Precipitation is expected","-")." ".$firstStrings[array_rand($firstStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])==0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Precipitation is expected","-")." ".$laterStrings[array_rand($laterStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
			}
			$forecastString = $forecastString . ucfirst($windNamesTemporary[1])." ".$firstStrings[array_rand($firstStrings)]." ".lang("fromDir","-")." ".$windDirectionsTemporary[1]." of ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[1])." ".unitFormatter($displayWindUnits).", ".lang("then","-")." ".$laterStrings[array_rand($laterStrings)]." ".strtolower($windNamesTemporary[2])." ".lang("at a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[2])." ".unitFormatter($displayWindUnits)." ".lang("fromDir","-")." ".$windDirectionsTemporary[2].". ";
			$forecastString = $forecastString . "</p>";
		}
		if(array_key_exists(date('Ymd',strtotime('+7 days')),$forecasts)){
			$forecastString .= "<p>";
			$temperaturesTemporary = array();
			$precipitationsTemporary = array();
			$windsTemporary = array();
			$windNamesTemporary = array();
			$windDirectionsTemporary = array();
			$conditionsTemporary = array();
			foreach($forecasts[date('Ymd',strtotime('+7 days'))] as $period){
				$temperaturesTemporary[] = $period['temperature'];
				$precipitationsTemporary[] = $period['precipitation'];
				$windsTemporary[] = $period['windSpeed'];
				$conditionsTemporary[] = $period['condition'];
				$windNamesTemporary[] = $period['windName'];
				$windDirectionsTemporary[] = $period['windDirectionCode'];
			}
			$dailyMaxT = round(max($temperaturesTemporary));
			$dailyMinT = round(min($temperaturesTemporary));
			$dailyAvgTDay7 = round(array_sum($temperaturesTemporary)/count($temperaturesTemporary));
			$dailyAvgW = round(array_sum($windsTemporary)/count($windsTemporary));
			$forecastString = $forecastString . lang("Week from today on","-")." ".lang(strtolower(date('l',strtotime('+7 days'))),"c").", ".lang("the average temperature","-")." ".compareTwoT($dailyAvgTDay6,$dailyAvgTDay7).". ";
			$forecastString = $forecastString . lang("Expected daily highs of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($dailyMaxT)."°".$displayTempUnits." ".lang("and lows","-")." ".round($dailyMinT)."°".$displayTempUnits.", ".strtolower($conditionsTemporary[1])." ".lang("in the morning","-").", ".strtolower($conditionsTemporary[2])." ".$laterStrings[array_rand($laterStrings)]." ".lang("and then","-")." ".strtolower($conditionsTemporary[3]).". ";
			if($rainSum==0){}
			else{
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Rain is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$firstStrings[array_rand($firstStrings)]." (".($precipitationsTemporary[0]+$precipitationsTemporary[1])." ".$displayRainUnits.") ".lang("as well as","-")." ".$laterStrings[array_rand($laterStrings)]." (".($precipitationsTemporary[2]+$precipitationsTemporary[3])." ".$displayRainUnits."). ".lang("Overall there should be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])>0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])==0){
					$forecastString = $forecastString . lang("Precipitation is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$firstStrings[array_rand($firstStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
				if(($precipitationsTemporary[0]+$precipitationsTemporary[1])==0 && ($precipitationsTemporary[2]+$precipitationsTemporary[3])>0){
					$forecastString = $forecastString . lang("Precipitation is","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".$laterStrings[array_rand($laterStrings)].", ".lang("with total rainfall of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".array_sum($precipitationsTemporary)." ".$displayRainUnits.". ";
				}
			}
			$forecastString = $forecastString . ucfirst($windNamesTemporary[1])." ".$firstStrings[array_rand($firstStrings)]." ".lang("fromDir","-")." ".$windDirectionsTemporary[1]." ".lang("of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[1])." ".unitFormatter($displayWindUnits).", ".lang("then","-")." ".$laterStrings[array_rand($laterStrings)]." ".strtolower($windNamesTemporary[2])." ".lang("at a speed of","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($windsTemporary[2])." ".unitFormatter($displayWindUnits)." ".lang("fromDir","-")." ".$windDirectionsTemporary[2].". ";
			$forecastString = $forecastString . "</p>";
		}
	}

	$tomorrowString = "";
	if($tomorrow['available']){
		$tomorrowString = "<p>".lang("The long-term average temperature for","-")." ".date("j",$tomorrowDate)." ".lang("month".date("n",$tomorrowDate),$dateCapital)." ".lang("is","-")." ".number_format($tomorrow['avgT'],1,".","")."°".$displayTempUnits." (".lang("for today it is","-")." ".number_format($thisDay['avgT'],1,".","")."°".$displayTempUnits."). ".lang("The highest temperature ever","-")." ".$measurementStrings[array_rand($measurementStrings)]." ".lang("on this day is","-")." ".number_format($tomorrow['maxT'],1,".","")."°".$displayTempUnits." (".moreDates($tomorrow['maxTTime']).") ".lang("and the absolute minimum","-")." ".$measurementStrings[array_rand($measurementStrings)]." ".lang("since the beginning of measurements has been","-")." ".number_format($tomorrow['minT'],1,".","")."°".$displayTempUnits." (".moreDates($tomorrow['minTTime'])."). ".lang("Apparent temperature ranges between","-")." ".number_format($tomorrow['minA'],1,".","")."°".$displayTempUnits." ".lang("and","-")." ".number_format($tomorrow['maxA'],1,".","")."°".$displayTempUnits.".</p><p>".lang("The average daily precipitation is","-")." ".number_format($tomorrow['avgR'],$decimalsRain,".","")." ".$displayRainUnits.", ".lang("absolute maximum being","-")." ".number_format($tomorrow['maxR'],$decimalsRain,".","")." ".$displayRainUnits." (".moreDates($tomorrow['maxRTime']).") ".lang("and minimum","-")." ".number_format($tomorrow['minR'],$decimalsRain,".","")." ".$displayRainUnits." (".moreDates($tomorrow['minRTime']).").</p><p>".lang("Humidity on","-")." ".date("j")." ".lang("month".date("n"),$dateCapital)." ".lang("in general is on average","-")." ".number_format($tomorrow['avgH'],1,".","")."% ".lang("and dew point","-")." ".number_format($tomorrow['avgD'],1,".","")."°".$displayTempUnits.". ".lang("Wind speed average is","-")." ".number_format($tomorrow['avgW'],1,".","")." ".unitFormatter($displayWindUnits)." ".lang("and highest","-")." ".$measurementStrings[array_rand($measurementStrings)]." ".lang("value for","-")." ".date('j',strtotime('tomorrow'))." ".lang("month".date("n",strtotime('tomorrow')),$dateCapital)." ".lang("is","-")." ".number_format($tomorrow['maxG'],1,".","")." ".unitFormatter($displayWindUnits).".";
	}

	$weekString = "";

	if($week['available']){
		$weekString = "<p>".lang("The long-term average temperature for next week is","-")." ".number_format($week['avgT'],1,".","")."°".$displayTempUnits.". ".lang("The highest temperature ever","-")." ".$measurementStrings[array_rand($measurementStrings)]." ".lang("during this week is","-")." ".number_format($week['maxT'],1,".","")."°".$displayTempUnits." (".moreDates($week['maxTTime']).") ".lang("and the absolute minimum","-")." ".$measurementStrings[array_rand($measurementStrings)]." ".lang("since the beginning of measurements has been","-")." ".number_format($week['minT'],1,".","")."°".$displayTempUnits." (".moreDates($week['minTTime'])."). ".lang("Highest apparent temperature","-")." ".$measurementStrings[array_rand($measurementStrings)]." ".lang("was as high as","-")." ".number_format($week['maxA'],1,".","")."°".$displayTempUnits.", ".lang("on the other end of the scale the feels like temperature can drop down to even","-")." ".number_format($week['minA'],1,".","")."°".$displayTempUnits.".</p><p>".lang("The average daily precipitation is","-")." ".number_format($week['avgR'],$decimalsRain,".","")." ".$displayRainUnits.", ".lang("absolute maximum being","-")." ".number_format($week['maxR'],$decimalsRain,".","")." ".$displayRainUnits." (".moreDates($week['maxRTime']).") ".lang("and minimum","-")." ".number_format($week['minR'],$decimalsRain,".","")." ".$displayRainUnits." (".moreDates($week['minRTime']).").</p><p>".lang("Humidity throughout the following 7 days in general is on average","-")." ".number_format($week['avgH'],1,".","")."% ".lang("and dew point","-")." ".number_format($week['avgD'],1,".","")."°".$displayTempUnits.". ".lang("Average wind speed for this period is","-")." ".number_format($week['avgW'],1,".","")." ".unitFormatter($displayWindUnits)." ".lang("with gusts of up to","-")." ".number_format($week['maxG'],1,".","")." ".unitFormatter($displayWindUnits).". ";
	}

	function compareTwoT($valuePrev,$valueNow){
		global $displayTempUnits;
		$possibilities = array();
		$result = "";
		$wordsApproximately = array(lang('about',"-"),lang('approximately',"-"),lang('around',"-"),lang('roughly',"-"),'');
		$expectedStrings = array(lang('forecasted',"-"),lang('expected',"-"));
		if($valueNow>$valuePrev){
			$possibilities[] = lang("are going to increase by about","-")." ".round($valueNow-$valuePrev)."° ".lang("to approximately","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are going to increase to approximately","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are going to rise about","-")." ".round($valueNow-$valuePrev)."° reaching approximately ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are going to go up and reach approximately","-")." ".$valueNow."°";
			$possibilities[] = lang("are going to go up by about","-")." ".round($valueNow-$valuePrev)."° to ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are going to go up to","-")." ".$valueNow."°";
			$possibilities[] = lang("are going to increase by approximately","-")." ".round($valueNow-$valuePrev)."° to ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("will increase by about","-")." ".round($valueNow-$valuePrev)."° ".lang("to approximately","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("will increase to","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("will rise about","-")." ".round($valueNow-$valuePrev)."° ".lang("reaching approximately","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("will rise to approximately","-")." ".$valueNow."°";
			$possibilities[] = lang("will go up by about","-")." ".round($valueNow-$valuePrev)."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("will go up to","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$valueNow."°";
			$possibilities[] = lang("will increase by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($valueNow-$valuePrev)."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to increase by about","-")." ".round($valueNow-$valuePrev)."° ".lang("to approximately","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to rise about","-")." ".round($valueNow-$valuePrev)."° ".lang("reaching approximately","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to go up by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($valueNow-$valuePrev)."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to increase by about","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".round($valueNow-$valuePrev)."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$result = $possibilities[array_rand($possibilities)];
		}
		if($valueNow==$valuePrev){
			$possibilities[] = lang("should be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".lang("the same at","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("will be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." the same at ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are going to be","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".lang("the same at","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("will not change and stay","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".lang("the same at","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("will not change much and stay at","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$valueNow."°".$displayTempUnits;
			$result = $possibilities[array_rand($possibilities)];
		}
		if($valueNow<$valuePrev){
			$possibilities[] = lang("are going to decrease by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".abs(round($valueNow-$valuePrev))."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are going to drop by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".abs(round($valueNow-$valuePrev))."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are going to go down by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".abs(round($valueNow-$valuePrev))."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("will decrease by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".abs(round($valueNow-$valuePrev))."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("will go down by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".abs(round($valueNow-$valuePrev))."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("should decrease by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".abs(round($valueNow-$valuePrev))."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to decrease by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".abs(round($valueNow-$valuePrev))."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to drop by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".abs(round($valueNow-$valuePrev))."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("decrease to","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$valueNow."°";
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to decrease by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".abs(round($valueNow-$valuePrev))."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to drop by","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".abs(round($valueNow-$valuePrev))."° ".lang("to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to decrease to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to decrease down to","-")." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to drop to","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$valueNow."°".$displayTempUnits;
			$possibilities[] = lang("are","-")." ".$expectedStrings[array_rand($expectedStrings)]." ".lang("to go down to","-")." ".$wordsApproximately[array_rand($wordsApproximately)]." ".$valueNow."°".$displayTempUnits;
			$result = $possibilities[array_rand($possibilities)];
		}
		return $result;
	}

	if($theme=="dark"){
		$color100 = "900";
		$color80 = "700";
	}
	else{
		$color100 = "300";
		$color80 = "100";
	}

	function moreDates($dates){
		if(count($dates)==1){
			return $dates[0];
		}
		else{
			$string = "<span class='moreDatesOpener'>".lang("more occasions",'l')."</span><span class='moreDates'>".implode("<br>",$dates)."</span>";
			return $string;
		}
	}

	function getWindDirection($dir)
	    {
        $dirString = array('N','NNE','NE','ENE','E','ESE','SE','SSE','S','SSW','SW','WSW','W','WNW','NW','NNW','N');
		$a = intval(($dir+11.25)/22.5);
		return $dirString[$a];
     	}

    function convertConditions($cond)
	    {
        $condString = array('lightrainshowers' => 'light rain shower', 'lightrain' => 'light rain', 'partlycloudy' => 'partly cloudy', 'rainshowers' => 'rain shower', 'heavyrainshowers' => 'heavy rain shower', 'heavyrain' => 'heavy rain', 'clearsky' => 'clear sky');
        $cond= str_replace("_night","",$cond);
        $cond= str_replace("_day","",$cond);
		if (isset($condString[$cond]))
		    return $condString[$cond];
		else
		    return $cond;
		}

	function loadContentSummary($url,$timeout){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
		curl_setopt($ch, CURLOPT_USERAGENT,"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36");
		$data = curl_exec($ch);
		curl_close($ch);

		if($data==""){
			$data = file_get_contents($url);
		}

		return $data;
	}
?>
	<style>
		p {
			padding-left: 5px;
			padding-right: 5px;
		}
		.summaryParagraph p{
			text-indent: 20px;
		}
		.summaryDivWrapper{
			width: 100%;
			<?php
				if($theme=="light"){
			?>
					color: black;
					background: #<?php echo $color_schemes[$design]['200'];?>;
			<?php
				}
				else{
			?>
					background: #<?php echo $color_schemes[$design]['700']?>;
			<?php
				}
			?>
		}
		.summaryHeading{
			width: 100%;
			text-align: center;
			font-size: 1.2em;
			font-weight: bold;
			font-variant: small-caps;
			cursor: pointer;
		}
		.summaryHover:hover{

			<?php
				if($theme=="light"){
			?>
					color: #<?php echo $color_schemes[$design]['500']?>;
			<?php
				}
				else{
			?>
					color: #<?php echo $color_schemes[$design]['200']?>;
			<?php
				}
			?>
		}
		.summaryParagraph{
			width:98%;
			margin: 0 auto;
			padding-top: 3px;
			padding-bottom: 3px;
			text-align:justify;
		}
		.summaryPadded{
			padding-top: 3px;
			padding-bottom: 3px;
		}
		.moreDatesOpener{
			cursor: pointer;
			font-variant: small-caps;
		}
		.moreDatesOpener:hover{
			color: #<?php echo $color_schemes[$design2]['300']?>;
		}
		.toast-container{
			width:280px;z-index:9999;
		}
		* html .toast-container{
			position:absolute;
		}
	.toast-item{
		height:auto;
		background:#<?php echo $color_schemes[$design2]['800']?>;
		opacity:0.95;
		-moz-border-radius:10px;
		-webkit-border-radius:10px;
		padding-top:20px;
		padding-bottom:20px;
		padding-left:6px;
		padding-right:6px;
		border:2px solid #999;
		display:block;
		position:relative;
		margin:0 0 12px 0;
	}
	.toast-item p{text-align:left;margin-left:50px;}
	.toast-item-close{
		background:url(http://akquinet.github.io/jquery-toastmessage-plugin/demo/images/close.gif);
		width:22px;
		height:22px;
		position:absolute;
		top:7px;
		right:7px;
		cursor: pointer;
	}
	.toast-item-image{width:32px;height:32px;margin-left:10px;margin-top:10px;margin-right:10px;float:left;}
	.toast-type-notice{color:white;}
	.toast-type-success{color:white;}
	.toast-type-warning{color:white;border-color:#FCBD57;}
	.toast-type-error{color:white;border-color:#B32B2B;}
	.toast-position-top-left{position:fixed;left:20px;top:20px;}
	.toast-position-top-center{position:fixed;top:20px;left:50%;margin-left:-140px;}
	.toast-position-top-right{position:fixed;top:20px;right:20px;}
	.toast-position-middle-left{position:fixed;left:20px;top:50%;margin-top:-40px;}
	.toast-position-middle-center{position:fixed;left:50%;margin-left:-140px;margin-top:-40px;top:50%;}
	.toast-position-middle-right{position:fixed;right:20px;margin-left:-140px;margin-top:-40px;top:50%;}

	</style>

	<div style="width:95%;margin:0 auto;text-align:justify;padding-top:20px">
		<table style="width:100%;background: #<?php echo $color_schemes[$design][$color100]?>;margin-bottom:5px;" id="summaryBlockTable">
			<tr>
				<td style="width:16.66%" class="summaryHover" id="summaryTodayTD">
					<div id="summaryTodayOpener" class="summaryHeading">
						<div class="summaryPadded"><?php echo lang("today","c")?></div>
					</div>
				</td>
				<td style="width:16.66%" class="summaryHover" id="summaryCurrentTD">
					<div id="summaryCurrentOpener" class="summaryHeading">
						<div class="summaryPadded"><?php echo lang("current conditions","c")?></div>
					</div>
				</td>
				<td style="width:16.66%" class="summaryHover" id="summaryForecastTD">
					<div id="summaryForecastOpener" class="summaryHeading" >
						<div class="summaryPadded"><?php echo lang("forecast","c")?></div>
					</div>
				</td>
				<td style="width:16.66%" class="summaryHover" id="summaryStationTD">
					<div id="summaryStationOpener" class="summaryHeading" >
						<div class="summaryPadded"><?php echo lang("station data","c")?></div>
					</div>
				</td>
				<td style="width:16.66%" class="summaryHover" id="summaryTomorrowTD">
					<div id="summaryTomorrowOpener" class="summaryHeading" >
						<div class="summaryPadded"><?php echo lang("tomorrow","c")?></div>
					</div>
				</td>
				<td style="width:16.66%" class="summaryHover" id="summaryOutlookTD">
					<div id="summaryOutlookOpener" class="summaryHeading" >
						<div class="summaryPadded"><?php echo lang("outlook","c")?></div>
					</div>
				</td>
			</tr>
			<tr>
				<td colspan="6">
					<div class="summaryDivWrapper">
						<div id="summaryToday" class="summaryParagraph">
							<p>
								<?php echo lang("Today is","-")?> <?php echo formatLanguageDate(time())?>. <?php echo lang("The Sun rises today at","-")?> <?php echo date($timeFormat,$sunRiseToday)?> <?php echo lang("and sets at","-")?> <?php echo date($timeFormat,$sunSetToday)?>, <?php echo lang("which means the day is","-")?> <?php echo $dayLengthDiffString?>. <?php echo $moonRisetString?> <?php echo $moonString?> <?php echo $seasonsToday?><?php echo $meteorsToday?><?php echo $lunarEclipseToday?><?php echo $solarEclipseToday?><?php echo $astroEventsToday?><?php echo $interestingDayToday?>
							</p>
						</div>
					</div>
					<div class="summaryDivWrapper">
						<div id="summaryCurrent" class="summaryParagraph">
							<p>
								<?php echo lang("It is currently","-")?> <?php echo number_format($currentT,1,".","")."°".$displayTempUnits?> <?php echo lang("with a","-")?> <?php echo lang("direction".windAbb($currentB),"u")?> <?php echo lang("wind blowing at","-")?> <?php echo number_format($currentW, 1, ".", "")." ".unitFormatter($displayWindUnits)?> <?php echo lang("and gusts of","-")?> <?php echo number_format($currentG, 1, ".", "")." ".unitFormatter($displayWindUnits)?>. <?php echo $currentPrecipitation?>. <?php echo lang("The current pressure is","-")?> <?php echo number_format($currentP, $decimalsPressure, ".", "")." ".unitFormatter($displayPressUnits)?> <?php echo lang("and","-")?> <?php echo strtolower(pressureTrend($pressureDifference3h))?>. <?php echo lang("The humidity is now","-")?> <?php echo number_format($currentH,0,".","")?> % <?php echo lang("and dew point and apparent temperature","-")?> <?php echo number_format($currentD,1,".","")."°".$displayTempUnits?> <?php echo lang("and","-")?> <?php echo number_format($currentA,1,".","")."°".$displayTempUnits?>.
							</p>
						</div>
					</div>
					<?php
						if($forecastAvailable){
					?>
							<div class="summaryDivWrapper">
								<div id="summaryForecast" class="summaryParagraph">
									<p>
										<?php echo $forecastString?>
									</p>
								</div>
							</div>
					<?php
						}
					?>
					<div class="summaryDivWrapper">
						<div id="summaryStation" class="summaryParagraph">
							<p>
								<?php echo lang("So far the maximum temperature today has been","-")?> <?php echo number_format($today['maxT'],1,".","")."°".$displayTempUnits?> <?php echo lang("and minimum","-")?> <?php echo number_format($today['minT'],1,".","")."°".$displayTempUnits?>, <?php echo lang("with an average of","-")?> <?php echo number_format($today['avgT'],1,".","")."°".$displayTempUnits?>. <?php echo lang("This is","-")?> <?php echo $yesterdayTDiffString?>. <?php echo lang("The long-term average for the station on this day is","-")?> <?php echo number_format($thisDay['avgT'],1,".","")."°".$displayTempUnits?>. <?php echo lang("Absolute maximum of","-")?> <?php echo number_format($thisDay['maxT'],1,".","")."°".$displayTempUnits?> <?php echo lang("was measured in","-")?> <?php echo implode(', ',$thisDay['maxTYear'])?>, <?php echo lang("while the absolute minimum in","-")?> <?php echo implode(', ',$thisDay['minTYear'])?> (<?php echo number_format($thisDay['minT'],1,".","")."°".$displayTempUnits?>). <?php echo lang("Therefore so far, today is","-")?> <?php echo number_format(abs($todayThisDayDiff),1,".","")."° ".$todayThisDayDiffString?>. <?php echo $maxMonthString?> <?php echo $minMonthString?> <?php echo lang("month".date("n"),$dateCapital)?> <?php echo date('Y',time())?> <?php echo lang("with an average temperature of","-")?> <?php echo number_format($month['avgT'],1,".","")." °".$displayTempUnits?> <?php echo lang("is currently","-")?> <?php echo number_format(abs($monthThisMonthDiff),1,".","")."°".$displayTempUnits?> <?php echo $monthThisMonthDiffString?> (<?php echo number_format($thisMonth['avgT'],1,".","")."°".$displayTempUnits?>). <?php echo lang("The maximum temperature ever","-")?> <?php echo $measurementStrings[array_rand($measurementStrings)]?> <?php echo lang("in","l")?> <?php echo lang("month".date("n"),$dateCapital)?> <?php echo lang("is","l")?> <?php echo number_format($thisMonth['maxT'],1,".","")."°".$displayTempUnits?> <?php echo lang("and this was in","-")?> <?php echo implode(', ',$thisMonth['maxTYear'])?>. <?php echo lang("In contrast, in","-")?> <?php echo implode(', ',$thisMonth['minTYear'])?>, <?php echo lang("the temperature dropped as low as","-")?> <?php echo number_format($thisMonth['minT'],1,".","")."°".$displayTempUnits?>.
							</p>
							<p>
								<?php echo $twoDayRain?> <?php echo $monthRainString?>
							</p>
							<p>
								<?php echo lang("Today's humidity ranges between","-")?> <?php echo $today['minH']?> <?php echo lang("and","-")?> <?php echo $today['maxH']?> %. <?php echo lang("Yesterday's overall minimum was","-")?> <?php echo $yesterday['minH']?> <?php echo lang("and maximum","-")?> <?php echo $yesterday['maxH']?> %. <?php echo lang("The average humidity in","-")?> <?php echo lang("month".date("n"),$dateCapital)?> <?php echo date("Y")?> <?php echo lang("is currently","-")?> <?php echo round($month['avgH'],1)?> %, <?php echo lang("while the average for this month in general is","-")?> <?php echo $thisMonth['avgH']?> %. <?php echo lang("For this day","-")?> (<?php echo date("j")." ".lang("month".date("n"),$dateCapital)?>) <?php echo lang("in particular then, the general average is","-")?> <?php echo $thisDay['avgH']?> % (<?php echo lang("today's average","-")?> <?php echo round($today['avgH'],1)?> %, <?php echo lang("yesterday's","-")?> <?php echo round($yesterday['avgH'],1)?> %).
							</p>
							<p>
								<?php echo lang("Lowest pressure","-")?> <?php echo $measurementStrings[array_rand($measurementStrings)]?> <?php echo lang("today was","-")?> <?php echo number_format($today['minP'],$decimalsPressure,".","")?> <?php echo lang("and highest","-")?> <?php echo number_format($today['maxP'],$decimalsPressure,".","")?> <?php echo unitFormatter($displayPressUnits)?>. <?php echo lang("Yesterday it was between","-")?> <?php echo number_format($yesterday['minP'],$decimalsPressure,".","")?> <?php echo lang("and","l")?> <?php echo number_format($yesterday['maxP'],$decimalsPressure,".","")?> <?php echo unitFormatter($displayPressUnits)?>. <?php echo lang("The average pressure in","-")?> <?php echo lang("month".date("n"),$dateCapital)." ".date("Y")?> <?php echo lang("is currently","-")?> <?php echo number_format($month['avgP'],$decimalsPressure,".","")?> <?php echo unitFormatter($displayPressUnits)?>, <?php echo lang("in general the long-term average for this month is","-")?> <?php echo number_format($thisMonth['avgP'],$decimalsPressure,".","")?> <?php echo unitFormatter($displayPressUnits)?>. <?php echo date("j")?> <?php echo lang("month".date("n"),$dateCapital)?> <?php echo lang("in particular has an average of","-")?> <?php echo number_format($thisDay['avgP'],$decimalsPressure,".","")?> <?php echo unitFormatter($displayPressUnits)?> (<?php echo lang("today's average","-")?> <?php echo number_format($today['avgP'],$decimalsPressure,".","")?> <?php echo unitFormatter($displayPressUnits)?>, <?php echo lang("yesterday's","-")?> <?php echo number_format($yesterday['avgP'],$decimalsPressure,".","")?> <?php echo unitFormatter($displayPressUnits)?>).
							</p>
							<p>
								<?php echo lang("Strongest wind gust today was","-")?> <?php echo number_format($today['maxG'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?>, <?php echo $measurementStrings[array_rand($measurementStrings)]?> <?php echo lang("at","-")?> <?php echo $todayMaxGTime?>. <?php echo lang("Yesterday it was","-")?> <?php echo number_format($yesterday['maxG'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?>. <?php echo lang("The average wind speed in","-")?> <?php echo lang("month".date("n"),$dateCapital)?> <?php echo date("Y")?> <?php echo lang("is currently","-")?> <?php echo number_format($month['avgW'],1,".","")?>, <?php echo lang("with average wind gust being","-")?> <?php echo number_format($month['avgG'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?>, <?php echo lang("in general the long-term average for this month is","-")?> <?php echo number_format($thisMonth['avgW'],1,".","")?> <?php echo lang("in case of the average wind speed, the average wind gust is","-")?> <?php echo number_format($thisMonth['avgG'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?>. <?php echo date("j")?> <?php echo lang("month".date("n"),$dateCapital)?> <?php echo lang("in particular has an average wind speed of","-")?> <?php echo number_format($thisDay['avgW'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?> <?php echo lang("and gust of","-")?> <?php echo number_format($thisDay['avgG'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?> (<?php echo lang("today's average","-")?> <?php echo number_format($today['avgW'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?> <?php echo lang("for wind speed and","-")?> <?php echo number_format($today['avgG'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?> <?php echo lang("for wind gust, yesterday the average wind speed was","-")?> <?php echo number_format($yesterday['avgW'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?> <?php echo lang("and wind gust","-")?> <?php echo number_format($yesterday['avgG'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?>). <?php echo lang("The absolute highest wind gust","-")?> <?php echo $measurementStrings[array_rand($measurementStrings)]?> <?php echo lang("this month so far has been","-")?> <?php echo number_format($month['maxG'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?> <?php echo lang("on","l")?> <?php echo date('j',$monthMaxGTime)?> <?php echo lang("month".date("n",$monthMaxGTime),$dateCapital)?> <?php echo lang("at","-")?> <?php echo date($timeFormat,$monthMaxGTime)?>, <?php echo lang("when looking at","-")?> <?php echo lang("month".date("n"),$dateCapital)?> <?php echo lang("as such, the maximum wind gust","-")?> <?php echo $measurementStrings[array_rand($measurementStrings)]?> <?php echo lang("is","-")?> <?php echo number_format($thisMonth['maxG'],1,".","")?> <?php echo unitFormatter($displayWindUnits)?>, <?php echo lang("value","-")?> <?php echo $measurementStrings[array_rand($measurementStrings)]?> <?php echo lang("at","-")?> <?php echo date($timeFormat,$thisMonthMaxGTime)?> <?php echo lang("on","-")?> <?php echo date('j',$thisMonthMaxGTime)?> <?php echo lang("month".date("n",$thisMonthMaxGTime),$dateCapital)?> <?php echo date("Y",$thisMonthMaxGTime)?>.
							</p>
						</div>
					</div>
					<div class="summaryDivWrapper">
						<div id="summaryTomorrow" class="summaryParagraph">
							<p>
								<?php echo lang("Tomorrow, on","-")?> <?php echo lang(strtolower(date("l",strtotime('tomorrow'))),$dateCapital)." ".date("d",strtotime('tomorrow'))." ".lang(strtolower("month".date("n",strtotime('tomorrow'))),$dateCapital)?>, <?php echo lang("the Sun will rise at","-")?> <?php echo date($timeFormat,$sunRiseTomorrow)?> <?php echo lang("and set at","-")?> <?php echo date($timeFormat,$sunSetTomorrow)?>, <?php echo lang("which means the day is","-")?> <?php echo $dayLengthDiffStringTomorrow?>. <?php echo $moonRisetStringTomorrow?> <?php echo $tomorrowString?><?php echo $seasonsTomorrow?><?php echo $meteorsTomorrow?><?php echo $lunarEclipseTomorrow?><?php echo $solarEclipseTomorrow?><?php echo $astroEventsTomorrow?><?php echo $interestingDayTomorrow?>
							</p>
						</div>
					</div>
					<div class="summaryDivWrapper">
						<div id="summaryOutlook" class="summaryParagraph">
							<p>
								<?php echo $moonOutlook?><?php echo $seasonsOutlook?><?php echo $meteorsOutlook?><?php echo $lunarEclipseOutlook?><?php echo $solarEclipseOutlook?><?php echo $astroEventsOutlook?> <?php echo $weekString?>
							</p>
						</div>
					</div>
				</td>
			</tr>
		</table>
	</div>
	<script>
		(function(c){
			var b={
				inEffect:{
					opacity:"show"
				},
				inEffectDuration:600,
				stayTime:3000,
				text:"",
				sticky:false,
				type:"notice",
				position:"top-right",
				closeText:"",
				close:null
			};
			var a={
				init:function(d){
					if(d){
						c.extend(b,d)
					}
				},
				showToast:function(f){
					var g={};
					c.extend(g,b,f);
					var j,e,d,i,h;
					j=(!c(".toast-container").length)?c("<div></div>").addClass("toast-container").addClass("toast-position-"+g.position).appendTo("body"):c(".toast-container");
					e=c("<div></div>").addClass("toast-item-wrapper");
					d=c("<div></div>").hide().addClass("toast-item toast-type-"+g.type).appendTo(j).html(c("<p>").append(g.text)).animate(g.inEffect,g.inEffectDuration).wrap(e);
					i=c("<div></div>").addClass("toast-item-close").prependTo(d).html(g.closeText).click(function(){
						c().toastmessage("removeToast",d,g)
					});
					h=c("<div></div>").addClass("toast-item-image").addClass("toast-item-image-"+g.type).prependTo(d);
					if(navigator.userAgent.match(/MSIE 6/i)){
						j.css({top:document.documentElement.scrollTop})
					}
					if(!g.sticky){
						setTimeout(function(){
							c().toastmessage("removeToast",d,g)
						},g.stayTime)
					}return d
				},
				showNoticeToast:function(e){var d={
					text:e,type:"notice"};
					return c().toastmessage("showToast",d)
				},
				showSuccessToast:function(e){var d={text:e,type:"success"};
					return c().toastmessage("showToast",d)
				},
				showErrorToast:function(e){var d={text:e,type:"error"};
					return c().toastmessage("showToast",d)
				},
				showWarningToast:function(e){
					var d={
					text:e,type:"warning"
					};
				return c().toastmessage("showToast",d)
				},
				removeToast:function(e,d){
					e.animate({
						opacity:"0"
					},600,function(){
						e.parent().animate({
							height:"0px"
						},300,function(){
							e.parent().remove()
						})
					});
					if(d&&d.close!==null){
						d.close()
					}
				}
			};
			c.fn.toastmessage=function(d){
				if(a[d]){
					return a[d].apply(this,Array.prototype.slice.call(arguments,1))
				}
				else{
					if(typeof d==="object"||!d){
						return a.init.apply(this,arguments)
					}
					else{
						c.error("Method "+d+" does not exist on jQuery.toastmessage")
					}
				}
			}
		})(jQuery);
		function showStickyNoticeToast(text) {
			$().toastmessage('showToast', {
				 text     : text,
				 sticky   : true,
				 position : 'top-right',
				 type     : 'notice',
				 closeText: '',
				 close    : function () {console.log("toast is closed ...");}
			});
		}
	</script>
	<script>
		$(document).ready(function(){
			$(".summaryParagraph").hide();
			$("#summaryToday").show();
			$("#summaryTodayTD").css("background","#<?php echo $color_schemes[$design][$color80]?>");
			$("#summaryTodayOpener").click(function(){
				$(".summaryParagraph").hide();
				$("#summaryToday").show();
				$(".summaryHover").css("background","#<?php echo $color_schemes[$design][$color100]?>");
				$("#summaryTodayTD").css("background","#<?php echo $color_schemes[$design][$color80]?>");
			});
			$("#summaryCurrentOpener").click(function(){
				$(".summaryParagraph").hide();
				$("#summaryCurrent").show();
				$(".summaryHover").css("background","#<?php echo $color_schemes[$design][$color100]?>");
				$("#summaryCurrentTD").css("background","#<?php echo $color_schemes[$design][$color80]?>");
			});
			$("#summaryForecastOpener").click(function(){
				$(".summaryParagraph").hide();
				$("#summaryForecast").show();
				$(".summaryHover").css("background","#<?php echo $color_schemes[$design][$color100]?>");
				$("#summaryForecastTD").css("background","#<?php echo $color_schemes[$design][$color80]?>");
			});
			$("#summaryStationOpener").click(function(){
				$(".summaryParagraph").hide();
				$("#summaryStation").show();
				$(".summaryHover").css("background","#<?php echo $color_schemes[$design][$color100]?>");
				$("#summaryStationTD").css("background","#<?php echo $color_schemes[$design][$color80]?>");
			});
			$("#summaryTomorrowOpener").click(function(){
				$(".summaryParagraph").hide();
				$("#summaryTomorrow").show();
				$(".summaryHover").css("background","#<?php echo $color_schemes[$design][$color100]?>");
				$("#summaryTomorrowTD").css("background","#<?php echo $color_schemes[$design][$color80]?>");
			});
			$("#summaryOutlookOpener").click(function(){
				$(".summaryParagraph").hide();
				$("#summaryOutlook").show();
				$(".summaryHover").css("background","#<?php echo $color_schemes[$design][$color100]?>");
				$("#summaryOutlookTD").css("background","#<?php echo $color_schemes[$design][$color80]?>");
			});
			$(".moreDates").hide();
			$(".moreDatesOpener").click(function(){
				dates = $(this).next(".moreDates").html();
				showStickyNoticeToast(dates);
			})
		})
		</script>

		<?php
			$time = microtime();
			$time = explode(' ', $time);
			$time = $time[1] + $time[0];
			$blockEndTime = $time;
			$blockLoadTime = $blockEndTime - $blockStartTime;
			$blockLoadTime = round($blockLoadTime,4);
			$errorLog[] = array("","Block loaded in ".$blockLoadTime." s.");
			showLog($errorLog);
		?>
