<?php	
	include("../../../config.php");
	include("../../../scripts/functions.php");
	
	$interval = $_GET['interval'];
	
	if($interval=="1h"){
		$interval = "1 hour";
	}
	if($interval=="3h"){
		$interval = "3 hour";
	}
	if($interval=="6h"){
		$interval = "6 hour";
	}
	if($interval=="12h"){
		$interval = "12 hour";
	}
	if($interval=="24h"){
		$interval = "24 hour";
	}
	if($interval=="48h"){
		$interval = "48 hour";
	}
	if($interval=="week"){
		$interval = "1 week";
	}
	if($interval=="month"){
		$interval = "1 month";
	}
	
	$result = mysqli_query($con,"
		SELECT  DateTime, T, H, P, W, G
		FROM  alldata
		WHERE DateTime >= now() - interval $interval
		ORDER BY DateTime
		"
	);
	while($row = mysqli_fetch_array($result)){
		$output['T'][] = number_format(convertT($row['T']),1,".","");
		$output['H'][] = ($row['H']);
		$output['P'][] = number_format(convertP($row['P']),2,".","");
		$output['W'][] = number_format(convertW($row['W']),1,".","");
		$output['G'][] = number_format(convertW($row['G']),1,".","");
	}
	
	function smoothen($arr,$x){
		$arr = array_chunk($arr, count($arr) / $x);
		$arr = array_map('average', $arr);
		return $arr;
	}
	
	function average($arr){
		return number_format(array_sum($arr)/count($arr),2,".","");
	}
	
	function regression($y){
		if(count($y)<2){
			$result = "";
		}
		else{
			$n = count($y);
			$x = array();
			for($i=0;$i<$n;$i++){
				array_push($x,$i);
			}
			$xy = array();
			$x2 = array();
			
			for($i=0;$i<count($x);$i++){
				array_push($xy,($x[$i]*$y[$i]));
				array_push($x2,($x[$i]*$x[$i]));
			}
			
			$sx = array_sum($x);
			$sy = array_sum($y);
			$sxy = array_sum($xy);
			$sx2 = array_sum($x2);
			
			$slope = ($n*$sxy-$sx*$sy)/($n*$sx2-$sx*$sx);
			$intercept = ($sy - $slope*$sx)/$n;
			
			$result = $slope;
		}
		$count = count($y);
		return array($result,$count);
	}
	
	$countT = count($output['T']);
	if($countT>25){
		$countT = 25;
	}
	$countH = count($output['H']);
	if($countH>25){
		$countH = 25;
	}
	$countP = count($output['P']);
	if($countP>25){
		$countP = 25;
	}
	$countW = count($output['W']);
	if($countW>25){
		$countW = 25;
	}
	$countG = count($output['G']);
	if($countG>25){
		$countG = 25;
	}
	$output['T'] = smoothen($output['T'],$countT);
	$output['H'] = smoothen($output['H'],$countH);
	$output['P'] = smoothen($output['P'],$countP);
	$output['W'] = smoothen($output['W'],$countW);
	$output['G'] = smoothen($output['G'],$countG);
	
	$final['data']['T'] = implode(",",$output['T']);
	$final['data']['H'] = implode(",",$output['H']);
	$final['data']['P'] = implode(",",$output['P']);
	$final['data']['W'] = implode(",",$output['W']);
	$final['data']['G'] = implode(",",$output['G']);
	$final['trend']['T'] = regression($output['T']);
	$final['trend']['T'] = $final['trend']['T'][0] *count($output['T']);
	$final['trend']['H'] = regression($output['H']);
	$final['trend']['H'] = $final['trend']['H'][0] *count($output['H']);
	$final['trend']['P'] = regression($output['P']);
	$final['trend']['P'] = $final['trend']['P'][0] *count($output['P']);
	$final['trend']['W'] = regression($output['W']);
	$final['trend']['W'] = $final['trend']['W'][0] *count($output['W']);
	$final['trend']['G'] = regression($output['G']);
	$final['trend']['G'] = $final['trend']['G'][0] *count($output['G']);
	$resultString = json_encode($final);
	echo $resultString;