<?php

	# 		Trends
	# 		Namespace:		trends
	#		Meteotemplate Block
	
	# 		v1.1 - Sep 23, 2016
	#			- CSS tweaks
	#			- bug fixes
	#		v2.0 - Oct 28, 2016
	#			- added tooltips with values to graphs
	#			- added tooltips to icons
	#			- added rounding of numbers
	# 		v2.1 - Jan 26, 2018
	# 			- bug fixes
	
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	include("../../../scripts/stats.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	if($theme=="dark"){
		$sparkTrendColor = "#ffffff";
	}
	else{
		$sparkTrendColor = "#000000";
	}
	
	if($displayPressUnits=="inhg"){
		$decimalsP = 3;
	}
	else{
		$decimalsP = 2;
	}
	
	// calculations finished, units cleanup
	if($displayPressUnits=="hpa"){$displayPressUnits="hPa";}
	if($displayPressUnits=="inhg"){$displayPressUnits="inHg";}
	if($displayWindUnits=="kmh"){$displayWindUnits="km/h";}
	if($displayWindUnits=="ms"){$displayWindUnits="m/s";}
?>
	<script type="text/javascript" src="scripts/jquery.sparkline.min.js"></script>
	<style>
		.trendsSmallIcon, .trendImgIcon{
			width:100%;
			max-width:25px;
		}
		.trendsSmallIcon{
			padding-right: 15px;
		}
		.trendsTimeIcon{
			width: 100%;
			max-width:40px;
			cursor: pointer;
			opacity: 0.8;
			padding: 1px;
			border-radius: 10px;
		}
		.trendsTimeIcon:hover{
			opacity: 1;
		}
	</style>
	<h2 style="padding-bottom:3px"><?php echo lang('trends','c')?></h2>
	<img id="trendImg1h" src="homepage/blocks/trends/icons/<?php echo $theme?>/1h.png" class="trendsTimeIcon" onclick="loadit('1h')"><img id="trendImg3h" src="homepage/blocks/trends/icons/<?php echo $theme?>/3h.png" class="trendsTimeIcon" onclick="loadit('3h')"><img id="trendImg6h" src="homepage/blocks/trends/icons/<?php echo $theme?>/6h.png" class="trendsTimeIcon" onclick="loadit('6h')"><img id="trendImg12h" src="homepage/blocks/trends/icons/<?php echo $theme?>/12h.png" class="trendsTimeIcon" onclick="loadit('12h')"><img id="trendImg24h" src="homepage/blocks/trends/icons/<?php echo $theme?>/24h.png" class="trendsTimeIcon" onclick="loadit('24h')"><img id="trendImg48h" src="homepage/blocks/trends/icons/<?php echo $theme?>/48h.png" class="trendsTimeIcon" onclick="loadit('48h')"><img id="trendImgweek" src="homepage/blocks/trends/icons/<?php echo $theme?>/Week.png" class="trendsTimeIcon" onclick="loadit('week')"><img id="trendImgmonth" src="homepage/blocks/trends/icons/<?php echo $theme?>/calendar_month.png" class="trendsTimeIcon" onclick="loadit('month')">
	<br><div id="trendsSpinner" style="height:30px;width:100%;margin:0 auto;text-align:center"><br><img src="<?php echo $pageURL.$path?>icons/logo.png" class='mtSpinner' id='' style="width:50px"></div>
	<table style="width:98%;margin:0 auto">
		<tr>
			<td style="width:15%;height:30px">
				<img src="homepage/blocks/trends/icons/<?php echo $theme?>/temp.png" class="trendsSmallIcon tooltip" title="<?php echo lang("temperature","c")?>">
			</td>
			<td style="width:50%">
				<div id="trendsTDiv"></div>
			</td>
			<td style="width:10%">
				<div id="trendsTImgDiv"></div>
			</td>
			<td style="text-align:right;width:25%">
				<div id="trendsTNumber"></div>
			</td>
		</tr>
		<tr>
			<td style="height:30px">
				<img src="homepage/blocks/trends/icons/<?php echo $theme?>/humidity.png" class="trendsSmallIcon tooltip" title="<?php echo lang("humidity","c")?>">
			</td>
			<td>
				<div id="trendsHDiv"></div>
			</td>
			<td>
				<div id="trendsHImgDiv"></div>
			</td>
			<td style="text-align:right">
				<div id="trendsHNumber"></div>
			</td>
		</tr>
		<tr>
			<td style="height:30px">
				<img src="homepage/blocks/trends/icons/<?php echo $theme?>/pressure.png" class="trendsSmallIcon tooltip" title="<?php echo lang("pressure","c")?>">
			</td>
			<td>
				<div id="trendsPDiv"></div>
			</td>
			<td>
				<div id="trendsPImgDiv"></div>
			</td>
			<td style="text-align:right">
				<div id="trendsPNumber"></div>
			</td>
		</tr>
		<tr>
			<td style="height:30px">
				<img src="homepage/blocks/trends/icons/<?php echo $theme?>/wind.png" class="trendsSmallIcon tooltip" title="<?php echo lang("wind speed","c")?>">
			</td>
			<td>
				<div id="trendsWDiv"></div>
			</td>
			<td>
				<div id="trendsWImgDiv"></div>
			</td>
			<td style="text-align:right">
				<div id="trendsWNumber"></div>
			</td>
		</tr>
		<tr>
			<td style="height:30px">
				<img src="homepage/blocks/trends/icons/<?php echo $theme?>/gust.png" class="trendsSmallIcon tooltip" title="<?php echo lang("wind gust","c")?>">
			</td>
			<td>
				<div id="trendsGDiv"></div>
			</td>
			<td>
				<div id="trendsGImgDiv"></div>
			</td>
			<td style="text-align:right">
				<div id="trendsGNumber"></div>
			</td>
		</tr>
	</table>
	
	<script>
	loadit('3h');
	function getSign(number){
		if(number>0){
			return "+";
		}
		else{
			return "";
		}
	}
	function getTrendImg(number){
		if(number>0){
			return "trendUp.png";
		}
		else if(number==0){
			return "trendNeutral.png";
		}
		else{
			return "trendDown.png";
		}
	}
	function loadit(interval){
		$("#trendsSpinner").css("visibility","initial");
		$("#trendsTNumber").text("");
		$("#trendsHNumber").text("");
		$("#trendsPNumber").text("");
		$("#trendsWNumber").text("");
		$("#trendsGNumber").text("");
		$("#trendsTImgDiv").text("");
		$("#trendsHImgDiv").text("");
		$("#trendsWImgDiv").text("");
		$("#trendsPImgDiv").text("");
		$("#trendsGImgDiv").text("");
		$("#trendsHDiv").text("");
		$("#trendsPDiv").text("");
		$("#trendsWDiv").text("");
		$("#trendsGDiv").text("");
		$("#trendsTDiv").html("");
		$.ajax({
			url : "homepage/blocks/trends/trendsAjax.php?interval=" + interval,
			dataType : 'json',
			success : function (json) {
				// Temp
				$("#trendsTDiv").text(json['data']['T']);
				trendT = json['trend']['T'];
				trendT = trendT.toFixed(2);
				$("#trendsTNumber").text(getSign(trendT) + trendT + " °<?php echo $displayTempUnits?>");
				$("#trendsTImgDiv").html("<img src='homepage/blocks/trends/icons/<?php echo $theme?>/"+getTrendImg(trendT)+"' class='trendImgIcon'>");
				$('#trendsTDiv').sparkline('html',{
					type: 'line',
					width: '100%',
					height: '30px',
					lineColor: '<?php echo $sparkTrendColor?>',
					fillColor: null,
					lineWidth: 1.5,
					spotColor: false,
					spotRadius: 3,
					minSpotColor: '#56aaff',
					maxSpotColor: '#ff0000',
					highlightSpotColor: null,
					highlightLineColor: null,
					drawNormalOnTop: false,
					disableInteraction: false,
				});
				// Humidity
				$("#trendsHDiv").text(json['data']['H']);
				trendH = json['trend']['H'];
				trendH = trendH.toFixed(2);
				$("#trendsHNumber").text(getSign(trendH) + trendH + " %");
				$("#trendsHImgDiv").html("<img src='homepage/blocks/trends/icons/<?php echo $theme?>/"+getTrendImg(trendH)+"' class='trendImgIcon'>");
				$('#trendsHDiv').sparkline('html',{
					type: 'line',
					width: '100%',
					height: '30px',
					lineColor: '<?php echo $sparkTrendColor?>',
					fillColor: null,
					lineWidth: 1.5,
					spotColor: false,
					spotRadius: 3,
					minSpotColor: '#ffff99',
					maxSpotColor: '#006600',
					highlightSpotColor: null,
					highlightLineColor: null,
					drawNormalOnTop: false,
					disableInteraction: false,
				});
				// Pressure
				$("#trendsPDiv").text(json['data']['P']);
				trendP = json['trend']['P'];
				trendP = trendP.toFixed(<?php echo $decimalsP?>);
				$("#trendsPNumber").text(getSign(trendP) + trendP + " <?php echo $displayPressUnits?>");
				$("#trendsPImgDiv").html("<img src='homepage/blocks/trends/icons/<?php echo $theme?>/"+getTrendImg(trendP)+"' class='trendImgIcon'>");
				$('#trendsPDiv').sparkline('html',{
					type: 'line',
					width: '100%',
					height: '30px',
					lineColor: '<?php echo $sparkTrendColor?>',
					fillColor: null,
					lineWidth: 1.5,
					spotColor: false,
					spotRadius: 3,
					minSpotColor: '#ffcc99',
					maxSpotColor: '#8600b3',
					highlightSpotColor: null,
					highlightLineColor: null,
					drawNormalOnTop: false,
					disableInteraction: false,
				});
				// Wind speed
				$("#trendsWDiv").text(json['data']['W']);
				trendW = json['trend']['W'];
				trendW = trendW.toFixed(2);
				$("#trendsWNumber").text(getSign(trendW) + trendW + " <?php echo $displayWindUnits?>");
				$("#trendsWImgDiv").html("<img src='homepage/blocks/trends/icons/<?php echo $theme?>/"+getTrendImg(trendW)+"' class='trendImgIcon'>");
				$('#trendsWDiv').sparkline('html',{
					type: 'line',
					width: '100%',
					height: '30px',
					lineColor: '<?php echo $sparkTrendColor?>',
					fillColor: null,
					lineWidth: 1.5,
					spotColor: false,
					spotRadius: 3,
					minSpotColor: '#cfbfff',
					maxSpotColor: '#69008c',
					highlightSpotColor: null,
					highlightLineColor: null,
					drawNormalOnTop: false,
					disableInteraction: false,
				});
				// Wind Gust
				$("#trendsGDiv").text(json['data']['G']);
				trendG = json['trend']['G'];
				trendG = trendG.toFixed(2);
				$("#trendsGNumber").text(getSign(trendG) + trendG + " <?php echo $displayWindUnits?>");
				$("#trendsGImgDiv").html("<img src='homepage/blocks/trends/icons/<?php echo $theme?>/"+getTrendImg(trendG)+"' class='trendImgIcon'>");
				$('#trendsGDiv').sparkline('html',{
					type: 'line',
					width: '100%',
					height: '30px',
					lineColor: '<?php echo $sparkTrendColor?>',
					fillColor: null,
					lineWidth: 1.5,
					spotColor: false,
					spotRadius: 3,
					minSpotColor: '#cfbfff',
					maxSpotColor: '#69008c',
					highlightSpotColor: null,
					highlightLineColor: null,
					disableInteraction: false,
				});
				$("#trendsSpinner").css("visibility","hidden");
				
				$(".trendsTimeIcon").css("border","0px solid white");
				$(".trendsTimeIcon").css("background","none");
				$("#trendImg" + interval).css("border","1px solid #<?php echo $color_schemes[$design2]['300']?>");
				$("#trendImg" + interval).css("background","#<?php echo $color_schemes[$design2]['600']?>");
			}
		})
	}
	</script>
	
