<?php

	# 		Upcoming
	# 		Namespace:		upcoming
	#		Meteotemplate Block
	
	# 		v1.0 - Sep 8, 2017
	# 			- initial release
	# 		v1.1 - Sep 12, 2017
	# 			- bug fixes
	# 		v2.0 - Nov 3, 2017
	# 			- added option to set date format
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$decimalsR = $displayRainUnits=="mm" ? 1 : 2;

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}

	// DarkSky
	if($fIOKey==""){
		die("No forecast IO key specified, please get your free API key at darksky.net and insert it in the Main settings.");
	}
	$fIOURL = "https://api.darksky.net/forecast/".$fIOKey."/".$stationLat.",".$stationLon."?units=si&lang=".$fIOLanguage;

	if(file_exists("../../../pages/forecast/cache/current.txt")){ 
		if (time()-filemtime("../../../pages/forecast/cache/current.txt") > 60 * 60) {
			unlink("../../../pages/forecast/cache/current.txt");
		}
	}
	if(file_exists("../../../pages/forecast/cache/current.txt")){
		$forecastData = file_get_contents("../../../pages/forecast/cache/current.txt");
	}
	else{
		// get contents
		$forecastData = file_get_contents($fIOURL);
		if($forecastData!=""){
			file_put_contents("../../../pages/forecast/cache/current.txt",$forecastData);
		}
	}

	$forecastData = json_decode($forecastData, true);

	$todayDate = date("Ymd");
	$tomorrowDate = date("Ymd", strtotime("tomorrow"));

	foreach($forecastData['daily']['data'] as $dayData){
		$thisTime = date("Ymd", $dayData['time']);
		if($thisTime == $todayDate){
			$forecast['today'] = $dayData;
		}
		if($thisTime == $tomorrowDate){
			$forecast['tomorrow'] = $dayData;
		}
	}

	$todayM = date("m");
	$todayD = date("d");
	$tomorrowM = date("m",strtotime("tomorrow"));
	$tomorrowD = date("d",strtotime("tomorrow"));
	// load station data
	// today
	$result = mysqli_query($con, "SELECT YEAR(DateTime), max(R), avg(T), max(Tmax), min(Tmin) FROM alldata WHERE MONTH(DateTime)=$todayM AND DAY(DateTime)=$todayD GROUP BY YEAR(DateTime) ORDER BY DateTime");
	while ($row = mysqli_fetch_array($result)) {
		$year = $row['YEAR(DateTime)'];
		$station['today'][$year]['avgT'] = convertT($row['avg(T)']);
		$station['today'][$year]['maxT'] = convertT($row['max(Tmax)']);
		$station['today'][$year]['minT'] = convertT($row['min(Tmin)']);
		$station['today'][$year]['R'] = convertR($row['max(R)']);
		$station['today']['avgT'][] = convertT($row['avg(T)']);
		$station['today']['maxT'][] = convertT($row['max(Tmax)']);
		$station['today']['minT'][] = convertT($row['min(Tmin)']);
		$station['today']['R'][] = convertR($row['max(R)']);
	}

	// tomorrow
	$result = mysqli_query($con, "SELECT YEAR(DateTime), max(R), avg(T), max(Tmax), min(Tmin) FROM alldata WHERE MONTH(DateTime)=$tomorrowM AND DAY(DateTime)=$tomorrowD GROUP BY YEAR(DateTime) ORDER BY DateTime");
	while ($row = mysqli_fetch_array($result)) {
		$year = $row['YEAR(DateTime)'];
		$station['tomorrow'][$year]['avgT'] = convertT($row['avg(T)']);
		$station['tomorrow'][$year]['maxT'] = convertT($row['max(Tmax)']);
		$station['tomorrow'][$year]['minT'] = convertT($row['min(Tmin)']);
		$station['tomorrow'][$year]['R'] = convertR($row['max(R)']);
		$station['tomorrow']['avgT'][] = convertT($row['avg(T)']);
		$station['tomorrow']['maxT'][] = convertT($row['max(Tmax)']);
		$station['tomorrow']['minT'][] = convertT($row['min(Tmin)']);
		$station['tomorrow']['R'][] = convertR($row['max(R)']);
	}

	$dateOrder = trim(strtolower($dateOrder));
	if($dateOrder == "dm"){
		$thisDayFormat = date("j")." ".lang("month".date("n"),'c');
	}
	else{
		$thisDayFormat = lang("month".date("n"),'c')." ".date("j");
	}

	if($dateOrder == "dm"){
		$tomorrowDayFormat = date("j",strtotime("tomorrow"))." ".lang("month".date("n",strtotime("tomorrow")),'c');
	}
	else{
		$tomorrowDayFormat = lang("month".date("n",strtotime("tomorrow")),'c')." ".date("j",strtotime("tomorrow"));
	}

	
?>
	<style>
		.tdBg{
			background: #<?php echo $theme=="dark" ? $color_schemes[$design2]['900'] : $color_schemes[$design2]['100']?>;
		}
		.tdBg2{
			background: #<?php echo $theme=="dark" ? $color_schemes[$design2]['700'] : $color_schemes[$design2]['300']?>;
			padding-top: 1%;
			padding-bottom: 1%;
			font-weight: bold;
			font-size: 1.2em;
		}
	</style>
	<h3 style="padding-left:2%"><?php echo $thisDayFormat?></h3>
	<div style="width:98%;margin:0 auto;text-align:justify">
		<table style="width:98%;margin:0 auto;table-layout:fixed" cellspacing="2" cellpadding="2">
			<tr>
				<td class="tdBg">
					<span style="font-weight:bold;font-variant:small-caps;font-size:1.2em"><?php echo lang('this year','c')?></span><br>
					<table style="width:98%;margin:0 auto;table-layout:fixed">
						<tr>
							<td>
								<?php echo lang('avgAbbr','c')?><br><?php echo number_format($station['today'][date("Y")]['avgT'],1,".","").unitFormatter($displayTempUnits)?>
							</td>
							<td>
								<?php echo lang('maximumAbbr','c')?><br><?php echo number_format($station['today'][date("Y")]['maxT'],1,".","").unitFormatter($displayTempUnits)?>
							</td>
							<td>
								<?php echo lang('minimumAbbr','c')?><br><?php echo number_format($station['today'][date("Y")]['minT'],1,".","").unitFormatter($displayTempUnits)?>
							</td>
						</tr>
						<tr>
							<td colspan="3">
								<?php echo number_format($station['today'][date("Y")]['R'],$decimalsR,".","").unitFormatter($displayRainUnits)?>
							</td>
						</tr>
					</table>
				</td>
				<?php 
					if(isset($station['today'][date("Y") - 1])){
						$cellWidth = 3;
				?>
						<td class="tdBg">
							<span style="font-weight:bold;font-variant:small-caps;font-size:1.2em"><?php echo lang('last year','c')?></span><br>
							<table style="width:98%;margin:0 auto;table-layout:fixed">
								<tr>
									<td>
										<?php echo lang('avgAbbr','c')?><br><?php echo number_format($station['today'][date("Y") - 1]['avgT'],1,".","").unitFormatter($displayTempUnits)?>
									</td>
									<td>
										<?php echo lang('maximumAbbr','c')?><br><?php echo number_format($station['today'][date("Y") - 1]['maxT'],1,".","").unitFormatter($displayTempUnits)?>
									</td>
									<td>
										<?php echo lang('minimumAbbr','c')?><br><?php echo number_format($station['today'][date("Y") - 1]['minT'],1,".","").unitFormatter($displayTempUnits)?>
									</td>
								</tr>
								<tr>
									<td colspan="3">
										<?php echo number_format($station['today'][date("Y")-1]['R'],$decimalsR,".","").unitFormatter($displayRainUnits)?>
									</td>
								</tr>
							</table>
						</td>
				<?php
					}
					else{
						$cellWidth = 2;
					}
				?>
				<td class="tdBg">
					<span style="font-weight:bold;font-variant:small-caps;font-size:1.2em"><?php echo lang('avgAbbr','c')?> (<?php echo count($station['today']['avgT'])?> <?php echo lang('years','l')?>)</span><br>
					<table style="width:98%;margin:0 auto;table-layout:fixed">
						<tr>
							<td>
								<?php echo lang('avgAbbr','c')?><br><?php echo number_format(array_sum($station['today']['avgT'])/count($station['today']['avgT']),1,".","").unitFormatter($displayTempUnits)?>
							</td>
							<td>
								<?php echo lang('maximumAbbr','c')?><br><?php echo number_format(max($station['today']['maxT']),1,".","").unitFormatter($displayTempUnits)?>
							</td>
							<td>
								<?php echo lang('minimumAbbr','c')?><br><?php echo number_format(min($station['today']['minT']),1,".","").unitFormatter($displayTempUnits)?>
							</td>
						</tr>
						<tr>
							<td colspan="<?php echo $cellWidth?>">
								<?php echo number_format(array_sum($station['today']['R'])/count($station['today']['R']),$decimalsR,".","").unitFormatter($displayRainUnits)?>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
	<h3 style="padding-left:2%"><?php echo $tomorrowDayFormat?></h3>
	<div style="width:98%;margin:0 auto;text-align:justify">
		<table style="width:98%;margin:0 auto;table-layout:fixed">
			<tr>
				<td style="text-align:left" class="tdBg2">
					&nbsp;&nbsp;<?php echo lang('forecast','c')?>:&nbsp;
					<?php 
						if(isset($forecast['today']['temperatureHigh'])){
							echo number_format(convertor($forecast['today']['temperatureHigh'], "C", $displayTempUnits),0,".","").unitFormatter($displayTempUnits);
						}
						else{
							echo "--";
						}
					?>
					/
					<?php 
						if(isset($forecast['today']['temperatureLow'])){
							echo number_format(convertor($forecast['today']['temperatureLow'], "C", $displayTempUnits),0,".","").unitFormatter($displayTempUnits);
						}
						else{
							echo "--";
						}
					?>
				</td>
			</tr>
		</table>
	</div>
	<div style="width:98%;margin:0 auto;text-align:justify">
		<table style="width:98%;margin:0 auto;table-layout:fixed">
			<tr>
				<?php 
					if(isset($station['tomorrow'][date("Y") - 1])){
				?>
						<td class="tdBg">
							<span style="font-weight:bold;font-variant:small-caps;font-size:1.2em"><?php echo lang('last year','c')?></span><br>
							<table style="width:98%;margin:0 auto;table-layout:fixed">
								<tr>
									<td>
										<?php echo lang('avgAbbr','c')?><br><?php echo number_format($station['tomorrow'][date("Y") - 1]['avgT'],1,".","").unitFormatter($displayTempUnits)?>
									</td>
									<td>
										<?php echo lang('maximumAbbr','c')?><br><?php echo number_format($station['tomorrow'][date("Y") - 1]['maxT'],1,".","").unitFormatter($displayTempUnits)?>
									</td>
									<td>
										<?php echo lang('minimumAbbr','c')?><br><?php echo number_format($station['tomorrow'][date("Y") - 1]['minT'],1,".","").unitFormatter($displayTempUnits)?>
									</td>
								</tr>
								<tr>
									<td colspan="3">
										<?php echo number_format($station['tomorrow'][date("Y")-1]['R'],$decimalsR,".","").unitFormatter($displayRainUnits)?>
									</td>
								</tr>
							</table>
						</td>
						<td class="tdBg">
							<span style="font-weight:bold;font-variant:small-caps;font-size:1.2em"><?php echo lang('avgAbbr','c')?> (<?php echo count($station['tomorrow']['avgT'])?> <?php echo lang('years','l')?>)</span><br>
							<table style="width:98%;margin:0 auto;table-layout:fixed">
								<tr>
									<td>
										<?php echo lang('avgAbbr','c')?><br><?php echo number_format(array_sum($station['tomorrow']['avgT'])/count($station['tomorrow']['avgT']),1,".","").unitFormatter($displayTempUnits)?>
									</td>
									<td>
										<?php echo lang('maximumAbbr','c')?><br><?php echo number_format(max($station['tomorrow']['maxT']),1,".","").unitFormatter($displayTempUnits)?>
									</td>
									<td>
										<?php echo lang('minimumAbbr','c')?><br><?php echo number_format(min($station['tomorrow']['minT']),1,".","").unitFormatter($displayTempUnits)?>
									</td>
								</tr>
								<tr>
									<td colspan="3">
										<?php echo number_format(array_sum($station['tomorrow']['R'])/count($station['tomorrow']['R']),$decimalsR,".","").unitFormatter($displayRainUnits)?>
									</td>
								</tr>
							</table>
						</td>
				<?php 
					}
				?>
			</tr>
		</table>
		
	</div>

