<?php

	# 		UV
	# 		Namespace:		uv
	#		Meteotemplate Block

	# 	v1.0 - Jun 17, 2017
	# 		- initial release
	# 	v1.1 - Jun 20, 2017
	# 		- minor tweaks
	# 	v2.0 - Jul 12, 2017
	# 		- added today's maximum
	# 	v2.1 - Jul 13, 2017
	# 		- bug fix - prevent today's max being lower than current
	
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if(file_exists("../../../meteotemplateLive.txt")){
		$apiData = file_get_contents("../../../meteotemplateLive.txt");
		$apiData = json_decode($apiData,true);
		if(isset($apiData['UV'])){
			$UV = $apiData['UV'];
		}
		else{
			die("No UV data found in the current conditions file.");
		}
	}
	else{
		die("Current conditions file not found.");
	}

	$infoArray = array(2,5,7,9,12);
	$infoIntervals = array("1 - 2.9","3 - 5.9","6 - 7.9","8 - 10.9","> 11");

	if($UV<1){
		$exposure = "-";
		$exposureColor = "#fff";
		$exposureFontColor = "#000";
		$borderColor = "#dddddd";
	}
	if($UV>=1 && $UV<3){
		$exposure = lang('low','c');
		$exposureColor = "#008C00";
		$exposureFontColor = "#fff";
		$borderColor = "#004700";
	}
	if($UV>=3 && $UV<6){
		$exposure = lang('moderate','c');
		$exposureColor = "#FFFF00";
		$exposureFontColor = "#000";
		$borderColor = "#c6c623";
	}
	if($UV>=6 && $UV<8){
		$exposure = lang('high','c');
		$exposureColor = "#D96C00";
		$exposureFontColor = "#fff";
		$borderColor = "#844100";
	}
	if($UV>=8 && $UV<11){
		$exposure = lang('very high','c');
		$exposureColor = "#D90000";
		$exposureFontColor = "#fff";
		$borderColor = "#630000";
	}
	if($UV>=11){
		$exposure = lang('extreme','c');
		$exposureColor = "#A300D9";
		$exposureFontColor = "#fff";
		$borderColor = "#580075";
	}

	$iconsUVArr[0] = array('cream15');
	$iconsUVArr[1] = array('cream15','hat');
	$iconsUVArr[2] = array('cream30','hat');
	$iconsUVArr[3] = array('cream30','hat','sunGlasses');
	$iconsUVArr[4] = array('cream30','hat','sunGlasses','clothes');	

	// check if user logs UV in db
	if(file_exists("../../../update/apiSettings.txt")){
		$apiSetup = file_get_contents("../../../update/apiSettings.txt");
		$apiSetup = json_decode($apiSetup,1);
		if($apiSetup['UV'] == 1){
			$result = mysqli_query($con, "
				SELECT max(UV)
				FROM  alldataExtra
				WHERE DATE(DateTime) = CURDATE()
				"
			);
			while ($row = mysqli_fetch_array($result)) {
				$maxUVToday = $row['max(UV)'];
				$maxUVToday = $maxUVToday < $UV ? $UV : $maxUVToday;
			}
		}
	}

	function UVcolors($uv){
		if($uv<3){
			$color = "#008C00";
			$fontColor = "#fff";
		}
		if($uv>=3 && $uv<6){
			$color = "#FFFF00";
			$fontColor = "#000";
		}
		if($uv>=6 && $uv<8){
			$color = "#D96C00";
			$fontColor = "#fff";
		}
		if($uv>=8 && $uv<11){
			$color = "#D90000";
			$fontColor = "#fff";
		}
		if($uv>=11){
			$color = "#A300D9";
			$fontColor = "#fff";
		}
		$colors = array($color,$fontColor);
		return $colors;
	}
	function risk($uv){
		if($uv<3){
			$riskLevel =  lang('uvLow','c');
			$riskDesc = "Wear sunglasses on bright days; use sunscreen if there is snow on the ground, which reflects UV radiation, or if you have particularly fair skin.";
		}
		if($uv>=3 && $uv<6){
			$riskLevel =  lang('uvModerate','c');
			$riskDesc = "Take precautions, such as covering up, if you will be outside. Stay in shade near midday when the sun is strongest.";
		}
		if($uv>=6 && $uv<8){
			$riskLevel =  lang('uvHigh','c');
			$riskDesc = "Cover the body with sun protective clothing, use SPF 30+ sunscreen, wear a hat, reduce time in the sun within three hours of solar noon, and wear sunglasses.";
		}
		if($uv>=8 && $uv<11){
			$riskLevel =  lang('uvVeryHigh','c');
			$riskDesc = "Wear SPF 30+ sunscreen, a shirt, sunglasses, and a wide-brimmed hat. Do not stay in the sun for too long.";
		}
		if($uv>=11){
			$riskLevel =  lang('uvExtreme','c');
			$riskDesc = "Take all precautions: Wear SPF 30+ sunscreen, a long-sleeved shirt and pants, sunglasses, and a very broad hat. Avoid the sun within three hours of solar noon.";
		}
		$risks = array($riskLevel,$riskDesc);
		return $risks;
	}
	
?>
	<style>
		#uvMainDiv{
			background: <?php echo $exposureColor?>;
			color: <?php echo $exposureFontColor?>;
			font-weight:bold;
			padding-left: 15px;
			padding-right: 15px;
			padding-top: 0px;
			padding-bottom: 5px;
			border-radius: 15px;
			margin: 0 auto;
			margin-top: 10px;
			min-width: 50%;
			border: 6px solid <?php echo $borderColor?>;
		}
	</style>
	<table id="uvMainDiv">
		<tr>
			<td style="width:50%;text-align:right">
				<span style="font-size:2.5em;vertical-align:bottom" class="mticon-uv"></span>
			</td>
			<td style="text-align:left">
				<span style="font-size:3em"><?php echo $UV?></span>
			</td>
		</tr>
		<tr>
			<td style="font-weight:bold;font-variant:small-caps;font-size:1.3em" colspan="2">
				<?php echo $exposure?>
			</td>
		</tr>
		<?php 
			if(isset($maxUVToday)){
		?>
				<tr>
					<td colspan="2" style="font-weight:bold">
						<?php echo lang('maximumAbbr','c')." ".lang('today','l')?>: <?php echo number_format($maxUVToday,1,".","");?>
					</td>
				</tr>
		<?php
			}
		?>
	</table>
		
	<div id="uvInfo" class="details">
		<br>
		<table style="width:98%;margin:0 auto;border-spacing:0px;">
			<tr>
				<td style="background:#fff;color:#000;padding:10px;font-weight:bold;font-size:1.2em">
					0
				</td>
				<td style="background:#fff;color:#000;padding:10px;text-align:left;font-size:0.8em">
					<?php echo lang('no risk','c')?>
				</td>
			</tr>
			<?php
				for($i=0;$i<count($infoArray);$i++){
					$colors = UVcolors($infoArray[$i]);
					$risk = risk($infoArray[$i]);
			?>
					<tr>
						<td style="background:<?php echo $colors[0]?>;color:<?php echo $colors[1]?>;padding:10px;font-weight:bold;font-size:1.2em">
							<?php echo $risk[0]?><br><span style="font-size:0.8em;font-variant:small-caps;font-weight:bold"><?php echo $infoIntervals[$i]?></span>
						</td>
						<td style="background:<?php echo $colors[0]?>;color:<?php echo $colors[1]?>;padding:10px;text-align:left;font-size:0.8em">
							<?php echo $risk[1]?><br>
							<?php 
								for($j=0;$j<count($iconsUVArr[$i]);$j++){
							?>
									<img src="homepage/blocks/uv/icons/<?php echo $i==1 ? "light" : "dark";?>/<?php echo $iconsUVArr[$i][$j]?>.png" style="width:25px;padding-left: 5px;padding-right:5px">
							<?php
								}
							?>
						</td>
					</tr>
			<?php
				}
			?>
		</table>
	</div>
	<span class="more" onclick="txt = $('#uvInfo').is(':visible') ? '<?php echo lang('more','l')." ".lang('info','l')?>' : '<?php echo lang('hide','l')." ".lang('info','l')?>';$('#uvInfo').slideToggle(800);$(this).text(txt);"><?php echo lang('more','l')." ".lang('info','l')?></span>

	
