<?php

	# 		UV Forecast
	# 		Namespace:		uvForecast
	#		Meteotemplate Block

	# 	v2.0 - Jun 17, 2017
	# 		- optimization
	# 		- CSS tweaks
	# 	v2.1 - Aug 27, 2017
	# 		- minor tweaks
	# 	v3.0 - Dec 2, 2017
	# 		- added current value (own or Darksky)
	# 	v3.1 - Dec 5, 2017
	# 		- bug fix
	
	$version = 3.1;
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$monthNames = array(0,lang('janAbbr','c'), lang('febAbbr','c'), lang('marAbbr','c'), lang('aprAbbr','c'), lang('mayAbbr','c'), lang('junAbbr','c'), lang('julAbbr','c'), lang('augAbbr','c'), lang('sepAbbr','c'),  lang('octAbbr','c'), lang('novAbbr','c'), lang('decAbbr','c'));
	
	$weekDays = array(lang('sundayAbbr','c'),lang('mondayAbbr','c'),lang('tuesdayAbbr','c'),lang('wednesdayAbbr','c'),lang('thursdayAbbr','c'),lang('fridayAbbr','c'),lang('saturdayAbbr','c'));
	
	$infoArray = array(2,5,7,9,12);
	$infoIntervals = array("0 - 2.9","3 - 5.9","6 - 7.9","8 - 10.9","> 11");
	
	$url = "http://www.temis.nl/uvradiation/nrt/uvindex.php?lon=".$stationLon."&lat=".$stationLat;
	
	if(file_exists("cache/uv.txt")){ 
		if (time()-filemtime("cache/uv.txt") > 60 * 360) {
			unlink("cache/uv.txt");
		}
	}
	if(file_exists("cache/uv.txt")){
		$forecastRaw = file_get_contents("cache/uv.txt");
	}
	else { 
		$forecastRaw = loadContent($url, 5);
		$save = file_put_contents("cache/uv.txt",$forecastRaw);
	}
	
	$forecastRaw = preg_replace("/\n/", "", $forecastRaw);
	$forecastRaw = preg_replace('/\s+/', ' ', $forecastRaw);
	
	preg_match("/<\!-- main body of the page -->(.*?)<\!-- empty separation column -->/",$forecastRaw,$matches);
	if(array_key_exists(1,$matches)){
			$forecastDiv = $matches[1];
			preg_match_all('/(.*?)nowrap>( )?([0-9][0.9]?.[0-9]?)/',$forecastDiv,$matchesUV);	
			if(array_key_exists(3,$matchesUV)){
				$uvForecast = $matchesUV[3];
			}
			else{
				$uvForecast[] = "Forecast N/A";
			}
			preg_match_all('/([0-9][0-9]? [A-Z][a-z][a-z] [0-9][0-9][0-9][0-9])/',$forecastDiv,$matchesDates);	
			if(array_key_exists(1,$matchesDates)){
				$dates = $matchesDates[1];
			}
			else{
				$dates[] = "Forecast N/A";
			}
	}
	function UVcolors($uv){
		if($uv<3){
			$color = "#008C00";
			$fontColor = "#fff";
		}
		if($uv>=3 && $uv<6){
			$color = "#FFFF00";
			$fontColor = "#000";
		}
		if($uv>=6 && $uv<8){
			$color = "#D96C00";
			$fontColor = "#fff";
		}
		if($uv>=8 && $uv<11){
			$color = "#D90000";
			$fontColor = "#fff";
		}
		if($uv>=11){
			$color = "#A300D9";
			$fontColor = "#fff";
		}
		$colors = array($color,$fontColor);
		return $colors;
	}
	function risk($uv){
		if($uv<3){
			$riskLevel =  lang('uvLow','c');
			$riskDesc = "Wear sunglasses on bright days; use sunscreen if there is snow on the ground, which reflects UV radiation, or if you have particularly fair skin.";
		}
		if($uv>=3 && $uv<6){
			$riskLevel =  lang('uvModerate','c');
			$riskDesc = "Take precautions, such as covering up, if you will be outside. Stay in shade near midday when the sun is strongest.";
		}
		if($uv>=6 && $uv<8){
			$riskLevel =  lang('uvHigh','c');
			$riskDesc = "Cover the body with sun protective clothing, use SPF 30+ sunscreen, wear a hat, reduce time in the sun within three hours of solar noon, and wear sunglasses. (Australian slogan: Slip-Slop-Slap-Seek-Slide.)";
		}
		if($uv>=8 && $uv<11){
			$riskLevel =  lang('uvVeryHigh','c');
			$riskDesc = "Wear SPF 30+ sunscreen, a shirt, sunglasses, and a wide-brimmed hat. Do not stay in the sun for too long.";
		}
		if($uv>=11){
			$riskLevel =  lang('uvExtreme','c');
			$riskDesc = "Take all precautions: Wear SPF 30+ sunscreen, a long-sleeved shirt and trousers, sunglasses, and a very broad hat. Avoid the sun within three hours of solar noon.";
		}
		$risks = array($riskLevel,$riskDesc);
		return $risks;
	}

	// try loading from API
	$apiData = file_get_contents("../../../meteotemplateLive.txt");
	$apiData = json_decode($apiData, true);

	if(array_key_exists("UV", $apiData)){
		$uv = $apiData['UV'];
	}
	else{
		$fIOURL = "https://api.darksky.net/forecast/".$fIOKey."/".$stationLat.",".$stationLon."?units=si&lang=".$fIOLanguage;
	
		if(file_exists("../../../pages/forecast/cache/current.txt")){ 
			if (time()-filemtime("../../../pages/forecast/cache/current.txt") > 60 * 15) { // cache every 15 mins
				unlink("../../../pages/forecast/cache/current.txt");
			}
		}
		if(file_exists("../../../pages/forecast/cache/current.txt")){
			$rawData = file_get_contents("../../../pages/forecast/cache/current.txt");
			$forecastLoadedTime = filemtime("../../../pages/forecast/cache/current.txt");
		}
		else{
			// get contents
			$rawData = loadContent($fIOURL,6);
			if($rawData!=""){
				file_put_contents("../../../pages/forecast/cache/current.txt",$rawData);
			}
			$forecastLoadedTime = time();
		}

		$dataString = json_decode($rawData,true);

		$uv = $dataString['currently']['uvIndex'];
	}
	
	
?>
	<style>
		
	</style>
	<div style="width:100%;text-align:center;padding-bottom:5px">
		<span class="mticon-uv" style="font-size:3em"></span>
	</div>
	<?php 
		$colors = UVcolors($uv);
	?>
	<table style="margin:0 auto">
		<tr> 
			<td style="font-variant:small-caps">
				<div style="margin:0 auto;background:<?php echo $colors[0]?>;color:<?php echo $colors[1]?>;font-weight:bold;font-size:1.5em;padding:3px;padding-left:6px;padding-right:6px;border-radius:10px;border:3px solid white"><span style="font-size:0.7em"><?php echo lang('current','c')?></span><br><?php echo $uv?></div>
			</td>
		</tr>
	</table>
	<table style="width:98%;margin:0 auto">
		<tr>
			<?php
				$cellWidth = 100/count($dates);
				for($i=0;$i<count($dates);$i++){
					$date = strtotime($dates[$i]);
					$colors = UVcolors($uvForecast[$i]);
			?>
					<td style="width:<?php echo $cellWidth?>%;font-variant:small-caps">
						<span style="font-weight:bold;font-size:1.5em"><?php echo date("j",$date)?></span><br><?php echo $weekDays[date('w',$date)]?><br><br><span style="margin:0 auto;width:auto;background:<?php echo $colors[0]?>;color:<?php echo $colors[1]?>;font-weight:bold;font-size:1.5em;padding:3px;padding-left:6px;padding-right:6px;border-radius:10px;border:3px solid white"><?php echo floor($uvForecast[$i])?></span>
					</td>
			<?php
				}
			?>
		</tr>
	</table>
	<div id="uvForecastDetails" class="details">
		<br>
		<table style="width:98%;margin:0 auto;border-spacing:0px;">
		<?php
			for($i=0;$i<count($dates);$i++){
				$date = strtotime($dates[$i]);
				$colors = UVcolors($uvForecast[$i]);
				$risk = risk($uvForecast[$i]);
		?>
				<tr>
					<td colspan="3" style="font-variant:small-caps;font-weight:bold;font-size:1.1em;padding-top:10px;padding-bottom:10px">
						<?php echo date($dateFormat,$date)?>
					</td>
				</tr>
				<tr>
					<td style="background:<?php echo $colors[0]?>;color:<?php echo $colors[1]?>;padding:10px">
						<span style="font-weight:bold;font-size:2em"><?php echo ($uvForecast[$i])?></span>
					</td>
					<td style="background:<?php echo $colors[0]?>;color:<?php echo $colors[1]?>;padding:10px;font-weight:bold;text-align:left">
						<?php echo $risk[0]?>
					</td>
					<td style="background:<?php echo $colors[0]?>;color:<?php echo $colors[1]?>;padding:10px;text-align:left;font-size:0.8em">
						<?php echo $risk[1]?>
					</td>
				</tr>
		<?php
			}
		?>
		</table>
		<br>
		<span style="font-size:0.85em;font-variant:small-caps"><?php echo lang("data source","c")?>: temis.nl. Used with permission.</span>
	</div>
	<div id="uvForecastInfo" class="details">
		<br>
		<table style="width:98%;margin:0 auto;border-spacing:0px;">
		<?php
			for($i=0;$i<count($infoArray);$i++){
				$colors = UVcolors($infoArray[$i]);
				$risk = risk($infoArray[$i]);
		?>
				<tr>
					<td style="background:<?php echo $colors[0]?>;color:<?php echo $colors[1]?>;padding:10px;font-weight:bold;font-size:1.2em">
						<?php echo $risk[0]?><br><span style="font-size:0.8em;font-variant:small-caps;font-weight:bold"><?php echo $infoIntervals[$i]?>
					</td>
					<td style="background:<?php echo $colors[0]?>;color:<?php echo $colors[1]?>;padding:10px;text-align:left;font-size:0.8em">
						<?php echo $risk[1]?>
					</td>
				</tr>
		<?php
			}
		?>
		</table>
		<div style="width:98%;margin:0 auto;text-align:left;font-size:0.85em">
			<ul>
				<li>
					UV Index is a number linearly related to the intensity of sunburn-producing UV radiation at a given point on the earth's surface
				</li>
				<li>
					on Dec 29, 2003, a world-record UV index of 43.3 was detected at Bolivia's Licancabur volcano.
				</li>
				<li>
					the intensity of UV radiation reaching the surface of the earth depends on the angle of the sun in the sky.
				</li>
				<li>
					UV intensity can be higher or lower for surfaces at different angles to the horizontal.
				</li>
				<li>
					UV intensity can nearly double with reflection from snow or other bright surfaces like water, sand, or concrete.
				</li>
				<li>
					the recommendations given are for average adults with lightly tanned skin. Those with darker skin are more likely to withstand greater sun exposure, while extra precautions are needed for children, seniors, particularly fair-skinned adults, and those who have greater sun sensitivity for medical reasons or from UV exposure in previous days.
				</li>
				<li>	
					the skin's recovery from UV radiation generally takes two days or more to run its course.
				</li>	
			</ul>
		</div>
	</div>
	<br>
	<table style="width:100%">
		<tr>
			<td style="width:50%;text-align:center">
				<span class="more" onclick="txt = $('#uvForecastDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#uvForecastDetails').slideToggle(800);$(this).text(txt);"><?php echo lang('more','l')?></span>
			</td>
			<td style="width:50%;text-align:center">
				<span class="more" onclick="txt = $('#uvForecastInfo').is(':visible') ? '<?php echo lang('more','l')." ".lang('info','l')?>' : '<?php echo lang('hide','l')." ".lang('info','l')?>';$('#uvForecastInfo').slideToggle(800);$(this).text(txt);"><?php echo lang('more','l')." ".lang('info','l')?></span>
			</td>
		</tr>
	</table>
