<?php

	# 		EU Warnings - regional
	# 		Namespace:		warningsEUregions
	#		Meteotemplate Block
	
	# 		v1.1 - Feb 9, 2016
	#			- bug fixes
	#		v1.2 - Jun 3, 2016
	#			- changes due to changes on the Meteoalarm website
	#		v1.3 - Mar 17, 2017
	#			- minor translation adjusments
	#		v1.4 - Jul 12, 2017
	#			- added "hide" link to the top
	#		v2.0 - Oct 11, 2017
	#			- CSS tweaks
	#   		- optimization
	# 		v2.1 - Apr 28, 2018
	#			- changes due to change in data source
	# 		v2.2 - May 28, 2021
	#			- change in data souce: meteoalarm.org
	#             ( extracts only wanrings marked as 'today', regardless of time... )
	
	include("settings.php");
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	if (isset($regionColor))
	   {$regionColor=';color:'.$regionColor;}
	else
	   {$regionColor='';}
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$language = loadLangs();

	createCacheDir();
	
	$warningTypes = array(0, lang('warningWind','c'), lang('warningSnow','c'), lang('warningStorms','c'), lang('warningFog','c'),lang('warningExtremeHigh','c'), lang('warningExtremeLow','c') ,lang('warningCoastal','c'), lang('warningFire','c'),lang('warningAvalanche','c'),lang('warningRain','c'),11,lang('warningFlood','c'),lang('warningFloodRain','c'));
	$countries = array('at'=>'austria', 'ba'=>'bosnia-herzegovina', 'be'=>'belgium', 'bg'=>'bulgaria', 'ch'=>'switzerland', 'cy'=>'cyprus', 'cz'=>'czechia', 'de'=>'germany', 'dk'=>'denmark', 'ee'=>'estonia', 'es'=>'spain', 'fi'=>'finland', 'fr'=>'france', 'gr'=>'greece', 'hr'=>'croatia', 'hu'=>'hungary', 'ie'=>'ireland', 'il'=>'israel', 'is'=>'iceland', 'it'=>'italy', 'lt'=>'lithuania', 'lu'=>'luxembourg', 'lv'=>'latvia', 'md'=>'moldova', 'me'=>'montenegro', 'mk'=>'republic-of-north-macedonia', 'MT'=>'malta', 'NL'=>'netherlands', 'NO'=>'norway', 'pl'=>'poland', 'pt'=>'portugal', 'ro'=>'romania', 'rs'=>'serbia', 'se'=>'sweden', 'si'=>'slovenia', 'sk'=>'slovakia', 'uk'=>'united-kingdom');

    $cacheFileName = "cache/warningsEURegions.txt";
    $paramFileName = "cache/params.txt";
	if(file_exists($cacheFileName) && ($warningsCache >= 0) )
	    {
		if ( ($warningsCache == 0) || (time()-filemtime($cacheFileName) > 60 * $warningsCache) || (filesize($cacheFileName)<100) )
			{unlink($cacheFileName);}
	    }
	if(file_exists($cacheFileName))
	    {
		$cached = fopen($cacheFileName, "r");
		$warningsEURaw = fread($cached,filesize($cacheFileName));
		fclose($cached);
	    }
	else
	    {
        $opts = array(
                        'http'=>array(
                            'method'=>"GET",
                            'header'=>"Accept-language: en\r\n" .
                            "Cookie: foo=bar\r\n"
                            )
                        );

        $context = stream_context_create($opts);

		$urlWarningsEU = "https://feeds.meteoalarm.org/feeds/meteoalarm-legacy-rss-".$countries[strtolower($country)];
		$warningsEURaw = file_get_contents($urlWarningsEU,false,$context);
		if($warningsEURaw===false)
			{$output['warnings'] = "NA";}
		else
		    {
			$warningsEURaw = str_replace("&","&amp;",$warningsEURaw);
			$cached = fopen($cacheFileName, "w");
			fwrite($cached, $warningsEURaw);
			fclose($cached);
		    }
	    }
	//echo $urlWarningsEU."-".$output['warnings']."-".$warningsEURaw;
	
	$warnings = array();
	$firstTitle = false;
	$imageFound = true;
	$imgLink = $pageURL.$path."homepage/blocks/warningsEUregions/map.php?country=".strtolower($country);
	$xmlWarningsEU = simplexml_load_string($warningsEURaw);
	
	// load items
	foreach($xmlWarningsEU->channel->item as $item)
	    {
		$results = array();
		$title = $item->title->__toString();
		$link = $item->link;
		$id = substr($link, -5); 
		if($firstTitle==false)
			{$firstTitle = true;}
		else
		    {
			$description = $item->description;
			$description = preg_replace("/\n/", "", $description);
			$description = preg_replace('/\s+/', ' ', $description);
			$description = preg_replace('/<b>/', '', $description);
			$description = preg_replace('/<\/b>/', '', $description);
			$description = preg_replace('/<i>/', '', $description);
			/*if(preg_match('/Tomorrow/',$description))
			    {
				preg_match('/(.*?)Tomorrow/',$description,$extractToday);
				$description = $extractToday[1];
			    }*/
            preg_match_all('/From: (.*?)<\\/i> Until/',$description,$from); //echo "from: $from[1]<br>";
			$fromArray = $from[1];
            preg_match_all('/Until: (.*?)<\\/i>/',$description,$until); //echo "until: $until[1]<br>";
            $untilArray = $until[1];
			preg_match_all('/awt:(.*?) level:(.*?)"/',$description,$matches);
			$resultsRaw = $matches[0]; // array_unique($matches[0]);
			$i = 0; 
			$now = time();
			foreach($resultsRaw as $result)
			    {
				preg_match('/awt:(.*?) level:(.*?)"/',$result,$matches2);
				$type = $matches2[1];
				$level = $matches2[2];
				//echo "f=$fromArray[$i] u=$untilArray[$i]<br>";
				if ($activeWarnings)
				    {$roundedFrom = $fromArray[$i];}
				else
				    {$roundedFrom = $fromArray[$i] - ($fromArray[$i] % 86400);}
				//if ( ($type>0 && $level>0) && ( $now>=strtotime($fromArray[$i])) && ( $now<=strtotime($untilArray[$i])) ) // only active warnings
				if ( ($type>0 && $level>0) && ( $now>=strtotime($roundedFrom)) && ( $now<=strtotime($untilArray[$i])) )     // all today's warnings
				    {
				    array_push($results,array($type,$level,$fromArray[$i],$untilArray[$i]));
				    //echo "type=$type level=$level from=$fromArray[$i] until=$untilArray[$i]<br>";    
				    }
				$i++;
			    }
			//echo "id=$id "; print_r($results); echo" title=$title<br>";
			if (count($results)) 
			    {
                merge_duplicates($results);
			    $warnings[] = array($title,$results,$id); 
				$results = array();
			    //echo "id=$id "; print_r($results); echo" title=$title<br>";
			    }
		    }
	    }   // foreach($xmlWarningsEU->channel->item as $item)

	// sort warnings by title
	$title  = array_column($warnings, 0);
	array_multisort($title, SORT_ASC, SORT_STRING, $warnings);

    // save $warnings
	$cached = fopen($paramFileName, "w");
	fwrite($cached, json_encode($warnings));
	fclose($cached);

function merge_duplicates(&$results)
{
$res[] = $results[0];
for ($i=1; $i<count($results); $i++)
    {
    $present = 0;
	for ($p=0; $p<count($res); $p++)
	    {
        if ( ($results[$i][0] == $res[$p][0]) && ($results[$i][1] == $res[$p][1]) )
		    {
            $res[$p][2] .= "<br>".$results[$i][2];
            $res[$p][3] .= "<br>".$results[$i][3];
            $present = 1;
			break;
			}
        else if ( ($results[$i][0] == $res[$p][0]) && ($results[$i][1] > $res[$p][1]) )
		    {
            $res[$p][1] = $results[$i][1];
            $res[$p][2] = $results[$i][2]."<br>".$res[$p][2];
            $res[$p][3] = $results[$i][3]."<br>".$res[$p][3];
            $present = 1;
			break;
			}
        else if ( ($results[$i][0] == $res[$p][0]) && ($results[$i][1] < $res[$p][1]) )
		    {
            $present = 1;
			break;
			}
        }
    if ($present == 0)
	    {$res[] = $results[$i];}
    }
$results = $res;
}

?>
	<style>
		
	</style>

	<table style="width:98%;margin:0 auto">
		<tr>
			<td style="padding-left:2px;text-align:left;width:30%;max-width:40px">
				<img src="<?php echo $pageURL.$path?>/imgs/<?php echo $flagIconShape?>/big/<?php echo strtolower($country)?>.png" style="width:100%;max-width:40px">
			</td>
			<td style="text-align:center">
				<h2>
					<?php echo lang("warnings",'c')?>
				</h2>
			</td>
			<td style="width:30%;max-width:40px">
			</td>
		</tr>
	</table>
	<?php 
		if(count($warnings)==0){
	?>
			<div style="width:98%;margin:0 auto;text-align:center;font-variant:small-caps;font-weight:bold">
				<?php echo lang('no warnings','c')?>
			</div>
			<br>
	<?php
		}
	?>
	<?php 
		if(count($warnings)){ $imgLink = $imgLink."&paramFileName=".$paramFileName; //echo http_build_query(array('warnings'=>$warnings));
	?>
		<div style="width:98%;margin:0 auto;text-align:center;font-variant:small-caps;font-weight:bold">
			<?php echo lang('warnings currently issued in','c')?> <?php echo count($warnings)?> <?php echo lang('regions','l')?>
			<br>			
		</div>
		<div style="width:98%;margin:0 auto;margin-top:10px;" id="warningsEUDetail" class="details">
			<span class="more" onclick="$('#warningsEUDetail').slideToggle(800);$('#warningsEURegionalMoreSpan').text('<?php echo lang('more','l')?>');"><?php echo lang('hide','l')?></span>
		<?php 
			if($imageFound){
		?>	
				<br>
				<img src="<?php echo $imgLink?>" style="width:90%;margin:0 auto;border: 1px solid #<?php echo $color_schemes[$design2]['600']?>;border-radius:20px">
		<?php
			}
		?>
		<table style="width:98%;margin:0 auto;border-spacing:0px">
			<?php
				for($i=0;$i<count($warnings);$i++){
			?>
					<tr style="background:#444444;font-weight:bold;font-variant:small-caps<?php echo $regionColor?>">
						<td style="text-align:left">
							<?php echo $warnings[$i][0]?>
						</td>
						<td style="text-align:right;margin-right: 1em;">
							<?php 
								for($a=0;$a<count($warnings[$i][1]);$a++){
							?>
									<img src="homepage/blocks/warningsEUregions/icons/dark/e<?php echo $warnings[$i][1][$a][0]?>.png" style="width:100%;max-width:25px;padding-left:3px;padding-right:3px">
							<?php
								}
							?>
						</td>
					</tr>
						<?php 
							for($a=0;$a<count($warnings[$i][1]);$a++){
								if($warnings[$i][1][$a][1]==1){
									$bgColor = "#238C00";
									$color = "white";
								}
								else if($warnings[$i][1][$a][1]==2){
									$bgColor = "#FFFF26";
									$color = "black";
								}
								else if($warnings[$i][1][$a][1]==3){
									$bgColor = "#FF8000";
									$color = "black";
								}
								else if($warnings[$i][1][$a][1]==4){
									$bgColor = "#D90000";
									$color = "white";
								}
						?>
								<tr style="background:<?php echo $bgColor?>;font-weight:bold;font-variant:small-caps;font-size:90%">
									<td style="text-align:left;padding-left:15px;color:<?php echo $color?>" colspan="2">
										<?php echo $warningTypes[$warnings[$i][1][$a][0]]?>
									</td>
								</tr>
						<?php
							}
						?>
			<?php
				}
			?>
		</table>
		</div>
		<span id="warningsEURegionalMoreSpan" class="more" onclick="txt = $('#warningsEUDetail').is(':visible') ? '<?php echo lang('more','l');?>' : '<?php echo lang('hide','l')?>';$('#warningsEUDetail').slideToggle(800);$(this).text(txt)"><?php echo lang('more','l')?></span>
		<br>
	<?php
		}
	?>
	<div style='width:98%;margin:0 auto;text-align:center;font-size:0.7em;font-variant:small-caps;padding-top:10px'><?php echo lang('data source','c')?>: <a href="http://www.meteoalarm.org" target="_blank">meteoalarm.org</div></a>