<?php

	# 		U.K. - Warnings
	# 		Namespace:		warningsUK
	#		Meteotemplate Block

	# 		v1.0 - Jun 26, 2017
	# 			- initial release
	# `		v2.0 - Jul 5, 2017
	# 			- redesign
	# 			- possibility to choose region
	# 		v2.1 - Jul 6, 2017
	# 			- improved data retrieval
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}

	$warningsUKRegion = trim($warningsUKRegion);
	if($warningsUKRegion!="UK"){
		$warningsUKRegion = strtolower($warningsUKRegion);
	}

	createCacheDir();

	if(file_exists("cache/data.txt")){ 
		if (time()-filemtime("cache/data.txt") > 60 * 60 * 1) {
			unlink("cache/data.txt");
		}
	}
	if(file_exists("cache/data.txt")){
		$xmlRaw = file_get_contents("cache/data.txt");
	}
	else {
		$xmlRaw = file_get_contents("http://www.metoffice.gov.uk/public/data/PWSCache/WarningsRSS/Region/".$warningsUKRegion);
		file_put_contents("cache/data.txt",$xmlRaw);
	}

    // davidefa 2021-01-20
	//$xmlRaw = preg_replace('~(</?|\s)([a-z0-9_]+):~is', '$1$2_', $xmlRaw);
	$xml =simplexml_load_string($xmlRaw);

	$warnings = array();

	foreach($xml->channel->item as $item){
		/*$desc = (string)$item->description;
		$severity = trim(strtolower((string)$item->{"metadata_warningLevel"}));
		$type = trim(ucfirst((string)$item->{"metadata_warningType"}));
		preg_match("/^.*?:(.*?)valid from(.*?) to (.*?)$/",$desc,$matches);
		$valid = array(trim($matches[2]),trim($matches[3]));
		$areas = trim($matches[1]);
		$warnings[] = array($severity,$type,$valid,$areas);*/
		// davidefa 2021-01-20
		$desc = (string)$item->description;
		preg_match("/(^.*?) (.*?)affecting(.*?):(.*?)valid from(.*?) to (.*?)$/",$desc,$matches);
		$severity = trim(strtolower($matches[1]));
		$type = trim(ucfirst($matches[2]));
		$valid = array(trim($matches[5]),trim($matches[6]));
		$areas = trim($matches[4]);
		$warnings[] = array($severity,$type,$valid,$areas);
		echo $item;
	}

	
	
?>
	<style>
		.warningsUKWarning{
			width:88%;
			margin:0 auto;
			text-align:justify;
			border-radius: 10px;
			padding: 1%;
			margin-bottom: 10px;
		}
	</style>
	<table style="width:90%;margin: 0 auto">
		<tr>
			<td style="text-align:left;width:25%">
				<img src="<?php echo $pageURL.$path?>imgs/<?php echo $flagIconShape?>/big/gb.png" style="width:100%;max-width:60px">
			</td>
			<td style="text-align:center">
				<h2><?php echo lang('warnings','c')?></h2>
			</td>
			<td style="text-align:right;width:25%">
				<span class="mticon-warninggeneral" style="font-size: 2.5em;opacity:0.7"></span>
			</td>
		</tr>
	</table>
	<?php 
		for($i=0;$i<count($warnings);$i++){
			if($warnings[$i][0]=="yellow"){
				$warnings[$i][0] = "yellow";
				$fontColor = "black";
			}
			if($warnings[$i][0]=="amber"){
				$warnings[$i][0] = "#ed6e00";
				$fontColor = "white";
			}
			if($warnings[$i][0]=="red"){
				$warnings[$i][0] = "#cc0000";
				$fontColor = "white";
			}
	?>
		<div style="background:<?php echo $warnings[$i][0]?>;color:<?php echo $fontColor?>" class="warningsUKWarning">
			<h3 style="color:<?php echo $fontColor?>"><?php echo $warnings[$i][1]?></h3>
			<strong>Valid: </strong><?php echo $warnings[$i][2][0]." - ".$warnings[$i][2][1]?><br>
			<strong>Areas: </strong><?php echo $warnings[$i][3]?>
		</div>
		
	<?php
		}
	?>
	<?php 
		if(count($warnings)==0){
	?>
			<h3 style="text-align:center">No warnings currently in effect</h3>
	<?php
		}
		else{
	?>
			<a href="http://www.metoffice.gov.uk/public/weather/warnings" target="_blank"><span class="more"><?php echo lang('more','l')?></span></a>
	<?php
		}
	?>
	<div style="width:90%;margin:0 auto;font-size:0.8em;font-variant:small-caps;margin-top:10px">
		<?php echo lang('data source','c')?>: MetOffice
	</div>
	
