<?php
	# 		Weather Networks block
	# 		Namespace:		weatherNetworks
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes	
	# 		v2.0 - Mar 26, 2016
	#			- design tweaks
	#			- new networks added
	# 		v3.0 - Jul 26, 2016
	#			- added LineaMeteo.it
	# 		v4.0 - Nov 14, 2016
	#			- added Instagram
	# 		v5.0 - Jan 22, 2017
	# 			- block separated into weather networks and social networks
	# 		v6.0 - Apr 11, 2017
	# 			- added weather365.net
	# 		v7.0 - May 7, 2017
	# 			- added HWA

	$thisBlockVersion = "7.0";
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	$time = microtime();
	$time = explode(' ', $time);
	$time = $time[1] + $time[0];
	$blockStartTime = $time;

	$errorLog[] = array("","%c Loading Block Weather Networks ".$thisBlockVersion."','font-weight:bold;color:green");
	
	include("../../../config.php");
	include($baseURL."scripts/functions.php");
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your control panel and go through the settings for this block first.";
		die();
	}	

?>

	<style>
		.logo{
			max-width: 35px;
			width: 100%;
			opacity: 0.7;
			cursor: pointer;
		}
		.logo:hover{
			opacity: 1;
		}
		.networkDivWeather{
			display:inline-block;
			padding: 10px;
		}
	</style>
			<?php
				if($showWU){
			?>	
					<div class="networkDivWeather">	
						<a href="http://www.wunderground.com/personal-weather-station/dashboard?ID=<?php echo $wuStationID?>" target="_blank">
							<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/wu.png" class="logo tooltip" alt="" title="Weather Underground">
						</a>
					</div>
			<?php
				}
				if($showAwekas){
			?>
					<div class="networkDivWeather">
						<a href="http://www.awekas.at/en/instrument.php?id=<?php echo $awekasID?>" target="_blank">
							<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/awekas.png" class="logo tooltip" style="border-radius:5px" alt="" title="Awekas">
						</a>
					</div>
			<?php
				}
				if($showCWOP){
			?>
					<div class="networkDivWeather">
						<a href="http://weather.gladstonefamily.net/site/<?php echo $cwopID?>" target="_blank">
							<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/cwop.png" class="logo tooltip" alt="" title="CWOP">
						</a>
					</div>
			<?php
				}
				if($showWeatherCloud){
			?>
					<div class="networkDivWeather">
						<a href="http://app.weathercloud.net/<?php echo $weathercloudID?>#profile" target="_blank">
							<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/weatherCloud.png" class="logo tooltip" alt="" title="WeatherCloud.net">
						</a>
					</div>
			<?php
				}
				if($showMetoffice){
			?>
					<div class="networkDivWeather">
						<a href="http://wow.metoffice.gov.uk/weather/view?siteID=<?php echo $WOWMetofficeID?>" target="_blank">
							<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/metoffice.png" class="logo tooltip" style="border-radius:5px" alt="" title="MetOffice UK">
						</a>
					</div>
			<?php
				}
				if($showPWS){
			?>
					<div class="networkDivWeather">
						<a href="http://www.pwsweather.com/obs/<?php echo $pwsID?>.html" target="_blank">
							<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/pws.png" class="logo tooltip" style="border-radius:5px" alt="" title="PWS">
						</a>
					</div>
			<?php
			}
			if($showMeteoclimatic){
			?>
					<div class="networkDivWeather">
						<a href="http://www.meteoclimatic.net/perfil/<?php echo $meteoclimaticID?>" target="_blank">
							<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/meteoclimatic.png" class="logo tooltip" style="border-radius:5px" alt="" title="Meteoclimatic">
						</a>
					</div>
			<?php
				}
				if($showNWS){
			?>
					<div class="networkDivWeather">
						<a href="http://forecast.weather.gov/MapClick.php?textField1=<?php echo $stationLat?>&textField2=<?php echo $stationLon?>" target="_blank">
							<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/nws.png" class="logo tooltip" style="border-radius:5px" alt="" title="NWS">
						</a>
					</div>
			<?php
				}	
				if($showSkyWarn){
			?>
						<div class="networkDivWeather">
							<a href="http://www.skywarn.org/" target="_blank">
								<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/skywarn.png" class="logo tooltip" style="border-radius:5px" alt="" title="SkyWarn">
							</a>
						</div>
			<?php
				}	
				if($showCoCoRaHS){
			?>
						<div class="networkDivWeather">
							<a href="http://www.cocorahs.org/" target="_blank">
								<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/cocorahs.png" class="logo tooltip" style="border-radius:5px" alt="" title="CoCoRaHS">
							</a>
						</div>
			<?php
				}	
			?>
			<?php
				if($showLineaMeteo){
			?>
						<div class="networkDivWeather">
							<a href="http://www.lineameteo.it/stazioni.php?id=<?php echo $lineaMeteoID?>" target="_blank">
								<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/lineaMeteo.png" class="logo tooltip" style="border-radius:5px" alt="" title="LineaMeteo.it">
							</a>
						</div>
			<?php
				}	
			?>

			<?php
				if($showWeather365){
			?>
						<div class="networkDivWeather">
							<a href="https://stations.weather365.net/#/<?php echo $weather365ID?>" target="_blank">
								<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/weather365.png" class="logo tooltip" style="border-radius:5px" alt="" title="Weather365.net">
							</a>
						</div>
			<?php
				}	
			?>

			<?php
				if($showHWA){
			?>
						<div class="networkDivWeather">
							<a href="<?php echo $urlHWA?>" target="_blank">
								<img src="homepage/blocks/weatherNetworks/icons/<?php echo $theme?>/hwa.png" class="logo tooltip" style="border-radius:5px" alt="" title="Het Weer Actueel">
							</a>
						</div>
			<?php
				}	
			?>	
	<?php 
		$time = microtime();
		$time = explode(' ', $time);
		$time = $time[1] + $time[0];
		$blockEndTime = $time;
		$blockLoadTime = $blockEndTime - $blockStartTime;
		$blockLoadTime = round($blockLoadTime,4);
		$errorLog[] = array("","Block loaded in ".$blockLoadTime." s.");
		showLog($errorLog);
	?>
				
				