<?php

	# 		World Time
	# 		Namespace:		worldTime
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#		- added responsiveness
	#		- bug fixes
	
	# 		v2.0 - Nov 22, 2016
	#		- added possibility to show digital time
	#		- block optimization
	
	$thisBlockVersion = "2.0";
	
	$time = microtime();
	$time = explode(' ', $time);
	$time = $time[1] + $time[0];
	$blockStartTime = $time;

	$errorLog[] = array("","%c Loading Block World Time ".$thisBlockVersion."','font-weight:bold;color:green");
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}	
	include("settings2.php");
		
	$errorLog[] = array("","Clock style: ".$clockStyle);
	
	$clockStyle = trim(strtolower($clockStyle));
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");
	include("../../../css/design.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	$flagImgSize = 40;

	for($i=0;$i<count($locations);$i++){
		$name = $locations[$i][0];
		$lat = $locations[$i][1];
		$lon = $locations[$i][2];
		$country = $locations[$i][4];
		$timezoneString = $locations[$i][3];
		$errorLog[] = array("","Location: ".$name.", ".$country." - ".$timezoneString);
		$timezone = new DateTimeZone($locations[$i][3]);
		$offset  = $timezone->getOffset(new DateTime)/3600;
		$sunRise = date_sunrise((time()+($offset*60*60)),SUNFUNCS_RET_STRING,$lat,$lon,90.5,($offset));
		$sunSet = date_sunset((time()+($offset*60*60)),SUNFUNCS_RET_STRING,$lat,$lon,90.5,($offset));
		$sunRiseTS = date_sunrise((time()+($offset*60*60)),SUNFUNCS_RET_TIMESTAMP,$lat,$lon,90.5,($offset));
		$sunSetTS = date_sunset((time()+($offset*60*60)),SUNFUNCS_RET_TIMESTAMP,$lat,$lon,90.5,($offset));
		$diff = ($sunSetTS-$sunRiseTS)/60;
		$daylength_hour = floor($diff/60);
		$daylength_min = round(($diff - ($daylength_hour*60)),0);
		if($daylength_min<10){
			$daylength_min = "0".$daylength_min;
		}
		$dayLength = $daylength_hour.":".$daylength_min;
		$nightMin = 60-$daylength_min;
		if($nightMin==60){
			$nightMin = "00";
			$daylength_hour--;
		}
		if($nightMin<10){
			$nightMin = "0".$nightMin;
		}
		$nightLength = floor(23-$daylength_hour).":".$nightMin;

		if($sunRiseTS<time() && $sunSetTS>time()){
			$dayColor = "#FFFFDB";
			$state = "Day";
			$textColor = "black";
			$icon = "Day";
		}
		else{
			$dayColor = "#000000";
			$state = "Night";
			$textColor = "white";
			$icon = "";
		}
		$output['worldTimes'][] = array($name,$offset,$sunRise,$sunSet,$dayColor,$state,$textColor,$country,$dayLength,$nightLength,$icon,$timezoneString);
	}
?>
	<style>
		.worldTimeIcon{
			max-width:20px;
			width:100%;
		}
	</style>
	<?php 
		if($clockStyle=="analog"){
	?>
			<script src="homepage/blocks/worldTime/scripts/coolclock.js" type="text/javascript"></script>
	<?php 
		}
	?>
	<div class="divIcon" style="top:10px;left:10px">
		<img src='homepage/blocks/worldTime/icons/<?php echo $theme?>/time.png' style="max-width:25px;width:100%" alt=''>
	</div>
	<div style="width:98%;margin:0 auto">
			<?php 
				for($i=0;$i<count($output['worldTimes']);$i++){
			?>
				<div style="min-width:105px;display:inline-block">
					<?php 
						if($clockStyle=="analog"){
					?>
							<div>
								<img style="width:<?php echo $flagImgSize?>px" src="<?php echo $pageURL.$path?>imgs/flags/big/<?php echo $output['worldTimes'][$i][7]?>.png" alt=''><br><span style="font-weight:bold;font-variant:small-caps"><?php echo $output['worldTimes'][$i][0]?></span><br><canvas id="clockid<?php echo $i?>" class="CoolClock:worldTimeClock:50::<?php echo $output['worldTimes'][$i][1]?>:showDigital"></canvas>
							</div>
					<?php
						}
					?>
					<?php 
						if($clockStyle=="digital"){
					?>
							<div>
								<img style="width:<?php echo $flagImgSize?>px" src="<?php echo $pageURL.$path?>imgs/flags/big/<?php echo $output['worldTimes'][$i][7]?>.png" alt=''><br><span style="font-weight:bold;font-variant:small-caps"><?php echo $output['worldTimes'][$i][0]?></span><br><div id="clockid<?php echo $i?>" style="font-size:1.2em;font-weight:bold;padding:3px"></div>
							</div>
					<?php
						}
					?>
					<div class="worldTimeDetails details" style="width:100%">
						<table style="width:98%;margin:0 auto">
							<tr>
									<td>
										<img src="homepage/blocks/worldTime/icons/<?php echo $theme?>/sunrise.png" class="worldTimeIcon" alt=""><br><?php echo $output['worldTimes'][$i][2]?>
									</td>
							</tr>
							<tr>
									<td>
										<img src="homepage/blocks/worldTime/icons/<?php echo $theme?>/sunset.png" class="worldTimeIcon" alt=""><br><?php echo $output['worldTimes'][$i][3]?>
									</td>
							</tr>
							<tr>
									<td>
										<img src="homepage/blocks/worldTime/icons/<?php echo $theme?>/sun.png" class="worldTimeIcon" alt=""><br><?php echo $output['worldTimes'][$i][8]?>
									</td>
							</tr>
							<tr>
									<td>
										<img src="homepage/blocks/worldTime/icons/<?php echo $theme?>/moon.png" class="worldTimeIcon" alt=""><br><?php echo $output['worldTimes'][$i][9]?>
									</td>
							</tr>
						</table>
					</div>
				</div>
			<?php
				}
			?>
	</div>
	<span class="more" onclick="txt = $('.worldTimeDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('.worldTimeDetails').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>
	<script>
		<?php 
			if($clockStyle=="analog"){
		?>
			<?php 
				if($theme=="dark"){
			?>
					CoolClock.config.skins = {
						worldTimeClock: {
							outerBorder:      { lineWidth: 185, radius: 1, color: "#<?php echo $color_schemes[$design]['900']?>", alpha: 1 },
							smallIndicator:   { lineWidth: 2, startAt: 89, endAt: 92, color: "#<?php echo $color_schemes[$design2]['200']?>", alpha: 1 },
							largeIndicator:   { lineWidth: 4, startAt: 83, endAt: 92, color: "#<?php echo $color_schemes[$design2]['200']?>", alpha: 1 },
							hourHand:         { lineWidth: 5, startAt: 0, endAt: 60, color: "#<?php echo $color_schemes[$design2]['200']?>", alpha: 1 },
							minuteHand:       { lineWidth: 4, startAt: 0, endAt: 80, color: "#<?php echo $color_schemes[$design2]['200']?>", alpha: 1 },
							secondHand:       { lineWidth: 2, startAt: -20, endAt: 85, color: "#<?php echo $color_schemes[$design2]['300']?>", alpha: .85 },
							secondDecoration: { lineWidth: 3, startAt: 0, radius: 2, fillColor: "#<?php echo $color_schemes[$design2]['500']?>", color: "#<?php echo $color_schemes[$design2]['500']?>", alpha: 1 },
						}
					};
					CoolClock.config.fontType =  '20px Verdana';
					CoolClock.config.showAmPm = <?php echo $AMPM?>;
					CoolClock.config.fontColor =  '#ffffff';
			<?php
				}
			?>
			<?php 
				if($theme=="light"){
			?>
					CoolClock.config.skins = {
						worldTimeClock: {
							outerBorder:      { lineWidth: 185, radius: 1, color: "#<?php echo $color_schemes[$design]['300']?>", alpha: 1 },
							smallIndicator:   { lineWidth: 2, startAt: 89, endAt: 92, color: "#<?php echo $color_schemes[$design2]['700']?>", alpha: 1 },
							largeIndicator:   { lineWidth: 4, startAt: 83, endAt: 92, color: "#<?php echo $color_schemes[$design2]['700']?>", alpha: 1 },
							hourHand:         { lineWidth: 5, startAt: 0, endAt: 60, color: "#<?php echo $color_schemes[$design2]['700']?>", alpha: 1 },
							minuteHand:       { lineWidth: 4, startAt: 0, endAt: 80, color: "#<?php echo $color_schemes[$design2]['700']?>", alpha: 1 },
							secondHand:       { lineWidth: 2, startAt: -20, endAt: 85, color: "#<?php echo $color_schemes[$design2]['600']?>", alpha: .85 },
							secondDecoration: { lineWidth: 3, startAt: 0, radius: 2, fillColor: "#<?php echo $color_schemes[$design2]['300']?>", color: "#<?php echo $color_schemes[$design2]['300']?>", alpha: 1 },
						}
					};
					CoolClock.config.fontType =  '20px Verdana';
					CoolClock.config.showAmPm = <?php echo $AMPM?>;
					CoolClock.config.fontColor =  '#000';
			<?php
				}
			?>
		<?php 
			}
		?>
		<?php 
			if($clockStyle=="digital"){
				for($i=0;$i<count($output['worldTimes']);$i++){
		?>
						now<?php echo $i?> = new Date;
						var current<?php echo $i?> = now<?php echo $i?>.getTime();
						tz<?php echo $i?> = now<?php echo $i?>.getTimezoneOffset()/60;
						current<?php echo $i?> = current<?php echo $i?> + (60*60*1000)*(<?php echo $output['worldTimes'][$i][1]?>+tz<?php echo $i?>);
						var newDate<?php echo $i?> = new Date();
						newDate<?php echo $i?>.setTime(current<?php echo $i?>);
						$('#clockid<?php echo $i?>').html("<span style='font-size:0.8em'>"+newDate<?php echo $i?>.toLocaleDateString()+"</span><br>"+newDate<?php echo $i?>.toLocaleTimeString());
						setInterval( function() {
							now<?php echo $i?> = new Date;
							var current<?php echo $i?> = now<?php echo $i?>.getTime();
							current<?php echo $i?> = current<?php echo $i?> + (60*60*1000)*(<?php echo $output['worldTimes'][$i][1]?>+tz<?php echo $i?>);
							var newDate<?php echo $i?> = new Date();
							newDate<?php echo $i?>.setTime(current<?php echo $i?>);
							$('#clockid<?php echo $i?>').html("<span style='font-size:0.7em'>"+newDate<?php echo $i?>.toLocaleDateString()+"</span><br>"+newDate<?php echo $i?>.toLocaleTimeString());
						},1000);
		<?php
				}
			}
		?>
	</script>
	
	<?php 
		$time = microtime();
		$time = explode(' ', $time);
		$time = $time[1] + $time[0];
		$blockEndTime = $time;
		$blockLoadTime = $blockEndTime - $blockStartTime;
		$blockLoadTime = round($blockLoadTime,4);
		$errorLog[] = array("","Block loaded in ".$blockLoadTime." s.");
		showLog($errorLog);
	?>