<?php

	# 		World Weather
	# 		Namespace:		worldWeather
	#		Meteotemplate Block

	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	# 		v1.2 - Jan 9, 2017
	# 			- optimization
	#			- removed Yahoo pressure nonsense
	# 		v1.3 - Jan 15, 2017
	# 			- Yahoo is very unreliable, fix for showing data when limited info loaded
	# 		v2.0 - Mar 19, 2017
	# 			- added option to enable/disable country flags
	# 		v3.0 - Apr 4, 2017
	# 			- added option to auto-open block

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}

	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	include("../../../config.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$citiesWeatherString = $citiesArr;
	$citiesWeather = array();

	$cityCountries = array();
	$cityCountries['Andorra'] = 'ad';
	$cityCountries['United Arab Emirates'] = 'ae';
	$cityCountries['Afghanistan'] = 'af';
	$cityCountries['Antigua and Barbuda'] = 'ag';
	$cityCountries['Anguilla'] = 'ai';
	$cityCountries['Albania'] = 'al';
	$cityCountries['Armenia'] = 'am';
	$cityCountries['Angola'] = 'ao';
	$cityCountries['Antarctica'] = 'aq';
	$cityCountries['Argentina'] = 'ar';
	$cityCountries['American Samoa'] = 'as';
	$cityCountries['Austria'] = 'at';
	$cityCountries['Australia'] = 'au';
	$cityCountries['Aruba'] = 'aw';
	$cityCountries['Åland Islands'] = 'ax';
	$cityCountries['Azerbaijan'] = 'az';
	$cityCountries['Bosnia and Herzegovina'] = 'ba';
	$cityCountries['Barbados'] = 'bb';
	$cityCountries['Bangladesh'] = 'bd';
	$cityCountries['Belgium'] = 'be';
	$cityCountries['Burkina Faso'] = 'bf';
	$cityCountries['Bulgaria'] = 'bg';
	$cityCountries['Bahrain'] = 'bh';
	$cityCountries['Burundi'] = 'bi';
	$cityCountries['Benin'] = 'bj';
	$cityCountries['Saint Barthélemy'] = 'bl';
	$cityCountries['Bermuda'] = 'bm';
	$cityCountries['Brunei Darussalam'] = 'bn';
	$cityCountries['Bolivia'] = 'bo';
	$cityCountries['Brazil'] = 'br';
	$cityCountries['Bahamas'] = 'bs';
	$cityCountries['Bhutan'] = 'bt';
	$cityCountries['Bouvet Island'] = 'bv';
	$cityCountries['Botswana'] = 'bw';
	$cityCountries['Belarus'] = 'by';
	$cityCountries['Belize'] = 'bz';
	$cityCountries['Canada'] = 'ca';
	$cityCountries['Cocos'] = 'cc';
	$cityCountries['Democratic Republic of Congo'] = 'cd';
	$cityCountries['Central African Republic'] = 'cf';
	$cityCountries['Congo'] = 'cg';
	$cityCountries['Côte d\'Ivoire'] = 'ci';
	$cityCountries['Cook Islands'] = 'ck';
	$cityCountries['Chile'] = 'cl';
	$cityCountries['Cameroon'] = 'cm';
	$cityCountries['China'] = 'cn';
	$cityCountries['Colombia'] = 'co';
	$cityCountries['Costa Rica'] = 'cr';
	$cityCountries['Cuba'] = 'cu';
	$cityCountries['Cabo Verde'] = 'cv';
	$cityCountries['Curacao'] = 'cw';
	$cityCountries['Christmas Island'] = 'cx';
	$cityCountries['Cyprus'] = 'cy';
	$cityCountries['Czech Republic'] = 'cz';
	$cityCountries['Germany'] = 'de';
	$cityCountries['Djibouti'] = 'dj';
	$cityCountries['Denmark'] = 'dk';
	$cityCountries['Dominica'] = 'dm';
	$cityCountries['Dominican Republic'] = 'do';
	$cityCountries['Algeria'] = 'dz';
	$cityCountries['Ecuador'] = 'ec';
	$cityCountries['Estonia'] = 'ee';
	$cityCountries['Egypt'] = 'eg';
	$cityCountries['Western Sahara'] = 'eh';
	$cityCountries['Eritrea'] = 'er';
	$cityCountries['Spain'] = 'es';
	$cityCountries['Ethiopia'] = 'et';
	$cityCountries['Finland'] = 'fi';
	$cityCountries['Fiji'] = 'fj';
	$cityCountries['Falkland Islands'] = 'fk';
	$cityCountries['Micronesia'] = 'fm';
	$cityCountries['Faroe Islands'] = 'fo';
	$cityCountries['France'] = 'fr';
	$cityCountries['Gabon'] = 'ga';
	$cityCountries['United Kingdom'] = 'gb';
	$cityCountries['Grenada'] = 'gd';
	$cityCountries['Georgia'] = 'ge';
	$cityCountries['French Guiana'] = 'gf';
	$cityCountries['Guernsey'] = 'gg';
	$cityCountries['Ghana'] = 'gh';
	$cityCountries['Gibraltar'] = 'gi';
	$cityCountries['Greenland'] = 'gl';
	$cityCountries['The Gambia'] = 'gm';
	$cityCountries['Guinea'] = 'gn';
	$cityCountries['Guadeloupe'] = 'gp';
	$cityCountries['Equatorial Guinea'] = 'gq';
	$cityCountries['Greece'] = 'gr';
	$cityCountries['South Georgia'] = 'gs';
	$cityCountries['Guatemala'] = 'gt';
	$cityCountries['Guam'] = 'gu';
	$cityCountries['Guinea-Bissau'] = 'gw';
	$cityCountries['Guyana'] = 'gy';
	$cityCountries['Hong Kong'] = 'hk';
	$cityCountries['Honduras'] = 'hn';
	$cityCountries['Croatia'] = 'hr';
	$cityCountries['Haiti'] = 'ht';
	$cityCountries['Hungary'] = 'hu';
	$cityCountries['Switzerland'] = 'ch';
	$cityCountries['Indonesia'] = 'id';
	$cityCountries['Ireland'] = 'ie';
	$cityCountries['Israel'] = 'il';
	$cityCountries['Isle of Man'] = 'im';
	$cityCountries['India'] = 'in';
	$cityCountries['British Indian Ocean Territory'] = 'io';
	$cityCountries['Iraq'] = 'iq';
	$cityCountries['Iran'] = 'ir';
	$cityCountries['Iceland'] = 'is';
	$cityCountries['Italy'] = 'it';
	$cityCountries['Jersey'] = 'je';
	$cityCountries['Jamaica'] = 'jm';
	$cityCountries['Jordan'] = 'jo';
	$cityCountries['Japan'] = 'jp';
	$cityCountries['Kenya'] = 'ke';
	$cityCountries['Kyrgyzstan'] = 'kg';
	$cityCountries['Cambodia'] = 'kh';
	$cityCountries['Kiribati'] = 'ki';
	$cityCountries['Comoros'] = 'km';
	$cityCountries['Saint Kitts and Nevis'] = 'kn';
	$cityCountries['North Korea'] = 'kp';
	$cityCountries['South Korea'] = 'kr';
	$cityCountries['Kuwait'] = 'kw';
	$cityCountries['Cayman Islands'] = 'ky';
	$cityCountries['Kazakhstan'] = 'kz';
	$cityCountries['Laos'] = 'la';
	$cityCountries['Lebanon'] = 'lb';
	$cityCountries['Saint Lucia'] = 'lc';
	$cityCountries['Liechtenstein'] = 'li';
	$cityCountries['Sri Lanka'] = 'lk';
	$cityCountries['Liberia'] = 'lr';
	$cityCountries['Lesotho'] = 'ls';
	$cityCountries['Lithuania'] = 'lt';
	$cityCountries['Luxembourg'] = 'lu';
	$cityCountries['Latvia'] = 'lv';
	$cityCountries['Libya'] = 'ly';
	$cityCountries['Morocco'] = 'ma';
	$cityCountries['Monaco'] = 'mc';
	$cityCountries['Moldova'] = 'md';
	$cityCountries['Montenegro'] = 'me';
	$cityCountries['Madagascar'] = 'mg';
	$cityCountries['Marshall Islands'] = 'mh';
	$cityCountries['Macedonia'] = 'mk';
	$cityCountries['Mali'] = 'ml';
	$cityCountries['Myanmar'] = 'mm';
	$cityCountries['Mongolia'] = 'mn';
	$cityCountries['Macao'] = 'mo';
	$cityCountries['Northern Mariana Islands'] = 'mp';
	$cityCountries['Martinique'] = 'mq';
	$cityCountries['Mauritania'] = 'mr';
	$cityCountries['Montserrat'] = 'ms';
	$cityCountries['Malta'] = 'mt';
	$cityCountries['Mauritius'] = 'mu';
	$cityCountries['Maldives'] = 'mv';
	$cityCountries['Malawi'] = 'mw';
	$cityCountries['Mexico'] = 'mx';
	$cityCountries['Malaysia'] = 'my';
	$cityCountries['Mozambique'] = 'mz';
	$cityCountries['Namibia'] = 'na';
	$cityCountries['New Caledonia'] = 'nc';
	$cityCountries['Niger'] = 'ne';
	$cityCountries['Norfolk Island'] = 'nf';
	$cityCountries['Nigeria'] = 'ng';
	$cityCountries['Nicaragua'] = 'ni';
	$cityCountries['Netherlands'] = 'nl';
	$cityCountries['Norway'] = 'no';
	$cityCountries['Nepal'] = 'np';
	$cityCountries['Nauru'] = 'nr';
	$cityCountries['Niue'] = 'nu';
	$cityCountries['New Zealand'] = 'nz';
	$cityCountries['Oman'] = 'om';
	$cityCountries['Panama'] = 'pa';
	$cityCountries['Peru'] = 'pe';
	$cityCountries['French Polynesia'] = 'pf';
	$cityCountries['Papua New Guinea'] = 'pg';
	$cityCountries['Philippines'] = 'ph';
	$cityCountries['Pakistan'] = 'pk';
	$cityCountries['Poland'] = 'pl';
	$cityCountries['Saint Pierre and Miquelon'] = 'pm';
	$cityCountries['Pitcairn'] = 'pn';
	$cityCountries['Puerto Rico'] = 'pr';
	$cityCountries['Palestine'] = 'ps';
	$cityCountries['Portugal'] = 'pt';
	$cityCountries['Palau'] = 'pw';
	$cityCountries['Paraguay'] = 'py';
	$cityCountries['Qatar'] = 'qa';
	$cityCountries['Reunion'] = 're';
	$cityCountries['Romania'] = 'ro';
	$cityCountries['Serbia'] = 'rs';
	$cityCountries['Russia'] = 'ru';
	$cityCountries['Rwanda'] = 'rw';
	$cityCountries['Saudi Arabia'] = 'sa';
	$cityCountries['Solomon Islands'] = 'sb';
	$cityCountries['Seychelles'] = 'sc';
	$cityCountries['Sudan'] = 'sd';
	$cityCountries['Sweden'] = 'se';
	$cityCountries['Singapore'] = 'sg';
	$cityCountries['Saint Helena, Ascension and Tristan da Cunha'] = 'sh';
	$cityCountries['Slovenia'] = 'si';
	$cityCountries['Slovakia'] = 'sk';
	$cityCountries['Sierra Leone'] = 'sl';
	$cityCountries['San Marino'] = 'sm';
	$cityCountries['Senegal'] = 'sn';
	$cityCountries['Somalia'] = 'so';
	$cityCountries['Suriname'] = 'sr';
	$cityCountries['South Sudan'] = 'ss';
	$cityCountries['Sao Tome and Principe'] = 'st';
	$cityCountries['El Salvador'] = 'sv';
	$cityCountries['Syria'] = 'sy';
	$cityCountries['Swaziland'] = 'sz';
	$cityCountries['Turks and Caicos Islands'] = 'tc';
	$cityCountries['Chad'] = 'td';
	$cityCountries['French Southern Territories'] = 'tf';
	$cityCountries['Togo'] = 'tg';
	$cityCountries['Thailand'] = 'th';
	$cityCountries['Tajikistan'] = 'tj';
	$cityCountries['Tokelau'] = 'tk';
	$cityCountries['Timor Leste'] = 'tl';
	$cityCountries['Turkmenistan'] = 'tm';
	$cityCountries['Tunisia'] = 'tn';
	$cityCountries['Tonga'] = 'to';
	$cityCountries['Turkey'] = 'tr';
	$cityCountries['Trinidad and Tobago'] = 'tt';
	$cityCountries['Tuvalu'] = 'tv';
	$cityCountries['Taiwan'] = 'tw';
	$cityCountries['Tanzania'] = 'tz';
	$cityCountries['Ukraine'] = 'ua';
	$cityCountries['Uganda'] = 'ug';
	$cityCountries['United States'] = 'us';
	$cityCountries['Uruguay'] = 'uy';
	$cityCountries['Uzbekistan'] = 'uz';
	$cityCountries['Vatican'] = 'va';
	$cityCountries['Saint Vincent and the Grenadines'] = 'vc';
	$cityCountries['Venezuela'] = 've';
	$cityCountries['British Virgin Islands'] = 'vg';
	$cityCountries['Vietnam'] = 'vn';
	$cityCountries['Vanuatu'] = 'vu';
	$cityCountries['Wallis and Futuna'] = 'wf';
	$cityCountries['Samoa'] = 'ws';
	$cityCountries['Yemen'] = 'ye';
	$cityCountries['Mayotte'] = 'yt';
	$cityCountries['South Africa'] = 'za';
	$cityCountries['Zambia'] = 'zm';
	$cityCountries['Zimbabwe'] = 'zw';

	if(file_exists("cache/worldWeather.txt")){
		if (time()-filemtime("cache/worldWeather.txt") > 60 * $worldWeatherCache) {
			unlink("cache/worldWeather.txt");
		}
	}
	if(file_exists("cache/worldWeather.txt")){
		$cached = fopen("cache/worldWeather.txt", "r");
		$dataRaw = fread($cached,filesize("cache/worldWeather.txt"));
		fclose($cached);
	}
	else {
		$url = "https://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20weather.forecast%20where%20woeid%20IN%20(".$citiesWeatherString.")&format=json";
		$dataRaw = file_get_contents($url);
		if($dataRaw==""){
		}
		else{
			$cached = fopen("cache/worldWeather.txt", "w");
			fwrite($cached, $dataRaw);
			fclose($cached);
		}
	}

	$data = json_decode($dataRaw,true);

	if($data['query']['count']>1){
		foreach($data['query']['results']['channel'] as $location){

			if($location['item']['title'] == "City not found"){
			}
			else{
				$city = array();

				$city['name'] = $location['location']['city'];
				$country = $location['location']['country'];

				$city['country'] = $cityCountries[$country];
				if($city['country'] == ""){
					$city['country'] = "unknown";
				}
				$city['region'] = $location['location']['region'];
				$city['lat'] = $location['item']['lat'];
				$city['lon'] = $location['item']['long'];

				$city['sunrise'] = date_sunrise(time(),SUNFUNCS_RET_STRING,$location['item']['lat'],$location['item']['long'],90,0);
				$city['sunset'] = date_sunset(time(),SUNFUNCS_RET_STRING,$location['item']['lat'],$location['item']['long'],90,0);

				$city['sunrise2'] = date_sunrise(time(),SUNFUNCS_RET_TIMESTAMP,$location['item']['lat'],$location['item']['long'],90,0);
				$city['sunset2'] = date_sunset(time(),SUNFUNCS_RET_TIMESTAMP,$location['item']['lat'],$location['item']['long'],90,0);

				if(time()>$city['sunrise2'] && time()<$city['sunset2']){
					$daynight = "d";
				}
				else{
					$daynight = "n";
				}

				if($location['wind']['direction']!=""){
					$city['bearing'] = windAbb($location['wind']['direction']);
				}
				else{
					$city['bearing'] = "";
				}
				$city['wind'] = $location['wind']['speed'];
					if($location['wind']['speed']!=""){
						if($displayWindUnits=="ms"){
							$city['wind'] = number_format($city['wind']*0.44704,1,".","");
						}
						if($displayWindUnits=="kmh"){
							$city['wind'] = number_format($city['wind']*1.609344,1,".","");
						}
						if($displayWindUnits=="mph"){
							$city['wind'] = number_format($city['wind']*1,1,".","");
						}
						if($displayWindUnits=="kt"){
							$city['wind'] = number_format($city['wind']*0.868976,1,".","");
						}
					}
				$city['temp'] = $location['item']['condition']['temp'];
				$TC = ($city['temp']-32)/1.8;
					if($location['item']['condition']['temp']!=""){
						if($displayTempUnits=="C"){
							$city['temp'] = number_format(($city['temp']-32)/1.8,1,".","");
						}
						if($displayTempUnits=="F"){
							$city['temp'] = number_format($city['temp'],1,".","");
						}
					}
				$city['humidity'] = $location['atmosphere']['humidity'];
				$H = $city['humidity'];
				if($city['humidity']>0 && $city['temp']!=null){
					$CBI = (((110 - 1.373 * $H) - 0.54 * (10.20 - $TC)) * (124 * pow(10,(-0.0142 * $H))))/60;
					if($CBI<0){
						$CBI=0;
					}

					if($CBI<50){
						$city['fire'] = "0";
						$city['fireColor'] = "#ffffff";
					}
					else if($CBI>=50 && $CBI<75){
						$city['fire'] = 1;
						$city['fireColor'] = "#FFFF73";
					}
					else if($CBI>=75 && $CBI<90){
						$city['fire'] = 2;
						$city['fireColor'] = "#FFCC99";
					}
					else if($CBI>=90 && $CBI<97.5){
						$city['fire'] = 3;
						$city['fireColor'] = "#FF9326";
					}
					else{
						$city['fire'] = 4;
						$city['fireColor'] = "#FF2626";
					}
				}
				else{
					$city['fire'] = "";
					$city['fireColor'] = "#666666";
				}
				$city['pressure'] = $location['atmosphere']['pressure'];
					if($location['atmosphere']['pressure']!=""){
						if($displayPressUnits=="hpa"){
							$city['pressure'] = number_format($city['pressure']*33.863881579,1,".","");
						}
						if($displayPressUnits=="inhg"){
							$city['pressure'] = number_format($city['pressure'],2,".","");
						}
						if($displayPressUnits=="mmhg"){
							$city['pressure'] = number_format($city['pressure']*25.400069,1,".","");
						}
					}
				$city['visibility'] = $location['atmosphere']['visibility'];
					if($location['atmosphere']['visibility']!=""){
						if($displayVisibilityUnits=="km"){
							$city['visibility'] = number_format($city['visibility']*1.60934,1,".","");
						}
						if($displayVisibilityUnits=="mi"){
							$city['visibility'] = number_format($city['visibility'],1,".","");
						}
					}

				$city['conditions'] = $location['item']['condition']['text'];
				$city['code'] = $location['item']['condition']['code'];
				$iconCode = $city['code'].$daynight;

				if($iconCode=="0d"){
					$iconCity = "tornadoD";
				}
				if($iconCode=="0n"){
					$iconCity = "tornadoN";
				}
				if($iconCode=="1d"){
					$iconCity = "stormD";
				}
				if($iconCode=="1n"){
					$iconCity = "stormN";
				}
				if($iconCode=="2d"){
					$iconCity = "hurricaneD";
				}
				if($iconCode=="2n"){
					$iconCity = "hurricaneN";
				}
				if($iconCode=="3d" || $iconCode=="4d" || $iconCode=="37d" || $iconCode=="38d" || $iconCode=="39d" || $iconCode=="45d" || $iconCode=="47d"){
					$iconCity = "thunderD";
				}
				if($iconCode=="3n" || $iconCode=="4n" || $iconCode=="37n" || $iconCode=="38n" || $iconCode=="39n" || $iconCode=="45n" || $iconCode=="47n"){
					$iconCity = "thunderN";
				}
				if($iconCode=="5d" || $iconCode=="6d" || $iconCode=="7d"){
					$iconCity = "rainsnowD";
				}
				if($iconCode=="5n" || $iconCode=="6n" || $iconCode=="7n"){
					$iconCity = "rainsnowN";
				}
				if($iconCode=="8d" || $iconCode=="9d" || $iconCode=="18d" || $iconCode=="40d"){
					$iconCity = "rainD";
				}
				if($iconCode=="8n" || $iconCode=="9n" || $iconCode=="18n" || $iconCode=="40n"){
					$iconCity = "rainN";
				}
				if($iconCode=="10d" || $iconCode=="11d" || $iconCode=="12d"){
					$iconCity = "heavyrainD";
				}
				if($iconCode=="10n" || $iconCode=="11n" || $iconCode=="12n"){
					$iconCity = "heavyrainN";
				}
				if($iconCode=="13d" || $iconCode=="14d" || $iconCode=="15d" || $iconCode=="16d" || $iconCode=="41d" || $iconCode=="42d" || $iconCode=="43d" || $iconCode=="46d"){
					$iconCity = "snowD";
				}
				if($iconCode=="13n" || $iconCode=="14n" || $iconCode=="15n" || $iconCode=="16n" || $iconCode=="41n" || $iconCode=="42n" || $iconCode=="43n" || $iconCode=="46n"){
					$iconCity = "snowN";
				}
				if($iconCode=="17d" || $iconCode=="35d"){
					$iconCity = "hailD";
				}
				if($iconCode=="17n" || $iconCode=="35n"){
					$iconCity = "hailN";
				}
				if($iconCode=="19d"){
					$iconCity = "dustD";
				}
				if($iconCode=="19n"){
					$iconCity = "dustN";
				}
				if($iconCode=="20d" || $iconCode=="21d" || $iconCode=="22d" || $iconCode=="23d"){
					$iconCity = "fogD";
				}
				if($iconCode=="20n" || $iconCode=="21n" || $iconCode=="22n" || $iconCode=="23n"){
					$iconCity = "fogN";
				}
				if($iconCode=="24d"){
					$iconCity = "windyD";
				}
				if($iconCode=="24n"){
					$iconCity = "windyN";
				}
				if($iconCode=="25d"){
					$iconCity = "coldD";
				}
				if($iconCode=="25n"){
					$iconCity = "coldN";
				}
				if($iconCode=="26d"){
					$iconCity = "overcastD";
				}
				if($iconCode=="26n"){
					$iconCity = "overcastN";
				}
				if($iconCode=="27d" || $iconCode=="28d"){
					$iconCity = "mostlycloudyD";
				}
				if($iconCode=="27n" || $iconCode=="28n"){
					$iconCity = "mostlycloudyN";
				}
				if($iconCode=="29d" || $iconCode=="30d" || $iconCode=="44d"){
					$iconCity = "cloudyD";
				}
				if($iconCode=="29n" || $iconCode=="30n" || $iconCode=="44n"){
					$iconCity = "cloudyN";
				}
				if($iconCode=="31d" || $iconCode=="32d" || $iconCode=="33d" || $iconCode=="34d"){
					$iconCity = "clearD";
				}
				if($iconCode=="31n" || $iconCode=="32n" || $iconCode=="33n" || $iconCode=="34n"){
					$iconCity = "clearN";
				}
				if($iconCode=="36d"){
					$iconCity = "hotD";
				}
				if($iconCode=="36n"){
					$iconCity = "hotN";
				}
				if($iconCode=="3200d" || $iconCode=="3200n" || $iconCode=="d" || $iconCode=="n"){
					$iconCity = "na";
				}
				$city['icon'] = $iconCity;

				if($city['name']!=""){
					array_push($citiesWeather,$city);
				}
			}
		}
	}
	else{
		$location = $data['query']['results']['channel'];
		if($location['item']['title'] == "City not found"){
		}
		else{
			$city = array();
			$city['name'] = $location['location']['city'];
			$country = $location['location']['country'];

			$city['country'] = $cityCountries[$country];
			if($city['country'] == ""){
				$city['country'] = "unknown";
			}
			$city['region'] = $location['location']['region'];
			$city['lat'] = $location['item']['lat'];
			$city['lon'] = $location['item']['long'];

			$city['sunrise'] = date_sunrise(time(),SUNFUNCS_RET_STRING,$location['item']['lat'],$location['item']['long'],90,0);
			$city['sunset'] = date_sunset(time(),SUNFUNCS_RET_STRING,$location['item']['lat'],$location['item']['long'],90,0);

			$city['sunrise2'] = date_sunrise(time(),SUNFUNCS_RET_TIMESTAMP,$location['item']['lat'],$location['item']['long'],90,0);
			$city['sunset2'] = date_sunset(time(),SUNFUNCS_RET_TIMESTAMP,$location['item']['lat'],$location['item']['long'],90,0);

			if(time()>$city['sunrise2'] && time()<$city['sunset2']){
				$daynight = "d";
			}
			else{
				$daynight = "n";
			}

			if($location['wind']['direction']!=""){
				$city['bearing'] = windAbb($location['wind']['direction']);
			}
			else{
				$city['bearing'] = "";
			}
			$city['wind'] = $location['wind']['speed'];
				if($location['wind']['speed']!=""){
					if($displayWindUnits=="ms"){
						$city['wind'] = number_format($city['wind']*0.44704,1,".","");
					}
					if($displayWindUnits=="kmh"){
						$city['wind'] = number_format($city['wind']*1.609344,1,".","");
					}
					if($displayWindUnits=="mph"){
						$city['wind'] = number_format($city['wind']*1,1,".","");
					}
					if($displayWindUnits=="kt"){
						$city['wind'] = number_format($city['wind']*0.868976,1,".","");
					}
				}
			$city['temp'] = $location['item']['condition']['temp'];
			$TC = ($city['temp']-32)/1.8;
				if($location['item']['condition']['temp']!=""){
					if($displayTempUnits=="C"){
						$city['temp'] = number_format(($city['temp']-32)/1.8,1,".","");
					}
					if($displayTempUnits=="F"){
						$city['temp'] = number_format($city['temp'],1,".","");
					}
				}
			$city['humidity'] = $location['atmosphere']['humidity'];
			$H = $city['humidity'];
			if($city['humidity']>0 && $city['temp']!=null){
				$CBI = (((110 - 1.373 * $H) - 0.54 * (10.20 - $TC)) * (124 * pow(10,(-0.0142 * $H))))/60;
				if($CBI<0){
					$CBI=0;
				}

				if($CBI<50){
					$city['fire'] = "0";
					$city['fireColor'] = "#ffffff";
				}
				else if($CBI>=50 && $CBI<75){
					$city['fire'] = 1;
					$city['fireColor'] = "#FFFF73";
				}
				else if($CBI>=75 && $CBI<90){
					$city['fire'] = 2;
					$city['fireColor'] = "#FFCC99";
				}
				else if($CBI>=90 && $CBI<97.5){
					$city['fire'] = 3;
					$city['fireColor'] = "#FF9326";
				}
				else{
					$city['fire'] = 4;
					$city['fireColor'] = "#FF2626";
				}
			}
			else{
				$city['fire'] = "";
				$city['fireColor'] = "#666666";
			}
			$city['pressure'] = $location['atmosphere']['pressure'];
				if($location['atmosphere']['pressure']!=""){
					if($displayPressUnits=="hpa"){
						$city['pressure'] = number_format($city['pressure']*33.863881579,1,".","");
					}
					if($displayPressUnits=="inhg"){
						$city['pressure'] = number_format($city['pressure'],2,".","");
					}
					if($displayPressUnits=="mmhg"){
						$city['pressure'] = number_format($city['pressure']*25.400069,1,".","");
					}
				}
			$city['visibility'] = $location['atmosphere']['visibility'];
				if($location['atmosphere']['visibility']!=""){
					if($displayVisibilityUnits=="km"){
						$city['visibility'] = number_format($city['visibility']*1.60934,1,".","");
					}
					if($displayVisibilityUnits=="mi"){
						$city['visibility'] = number_format($city['visibility'],1,".","");
					}
				}

			$city['conditions'] = $location['item']['condition']['text'];
			$city['code'] = $location['item']['condition']['code'];
			$iconCode = $city['code'].$daynight;

			if($iconCode=="0d"){
				$iconCity = "tornadoD";
			}
			if($iconCode=="0n"){
				$iconCity = "tornadoN";
			}
			if($iconCode=="1d"){
				$iconCity = "stormD";
			}
			if($iconCode=="1n"){
				$iconCity = "stormN";
			}
			if($iconCode=="2d"){
				$iconCity = "hurricaneD";
			}
			if($iconCode=="2n"){
				$iconCity = "hurricaneN";
			}
			if($iconCode=="3d" || $iconCode=="4d" || $iconCode=="37d" || $iconCode=="38d" || $iconCode=="39d" || $iconCode=="45d" || $iconCode=="47d"){
				$iconCity = "thunderD";
			}
			if($iconCode=="3n" || $iconCode=="4n" || $iconCode=="37n" || $iconCode=="38n" || $iconCode=="39n" || $iconCode=="45n" || $iconCode=="47n"){
				$iconCity = "thunderN";
			}
			if($iconCode=="5d" || $iconCode=="6d" || $iconCode=="7d"){
				$iconCity = "rainsnowD";
			}
			if($iconCode=="5n" || $iconCode=="6n" || $iconCode=="7n"){
				$iconCity = "rainsnowN";
			}
			if($iconCode=="8d" || $iconCode=="9d" || $iconCode=="18d" || $iconCode=="40d"){
				$iconCity = "rainD";
			}
			if($iconCode=="8n" || $iconCode=="9n" || $iconCode=="18n" || $iconCode=="40n"){
				$iconCity = "rainN";
			}
			if($iconCode=="10d" || $iconCode=="11d" || $iconCode=="12d"){
				$iconCity = "heavyrainD";
			}
			if($iconCode=="10n" || $iconCode=="11n" || $iconCode=="12n"){
				$iconCity = "heavyrainN";
			}
			if($iconCode=="13d" || $iconCode=="14d" || $iconCode=="15d" || $iconCode=="16d" || $iconCode=="41d" || $iconCode=="42d" || $iconCode=="43d" || $iconCode=="46d"){
				$iconCity = "snowD";
			}
			if($iconCode=="13n" || $iconCode=="14n" || $iconCode=="15n" || $iconCode=="16n" || $iconCode=="41n" || $iconCode=="42n" || $iconCode=="43n" || $iconCode=="46n"){
				$iconCity = "snowN";
			}
			if($iconCode=="17d" || $iconCode=="35d"){
				$iconCity = "hailD";
			}
			if($iconCode=="17n" || $iconCode=="35n"){
				$iconCity = "hailN";
			}
			if($iconCode=="19d"){
				$iconCity = "dustD";
			}
			if($iconCode=="19n"){
				$iconCity = "dustN";
			}
			if($iconCode=="20d" || $iconCode=="21d" || $iconCode=="22d" || $iconCode=="23d"){
				$iconCity = "fogD";
			}
			if($iconCode=="20n" || $iconCode=="21n" || $iconCode=="22n" || $iconCode=="23n"){
				$iconCity = "fogN";
			}
			if($iconCode=="24d"){
				$iconCity = "windyD";
			}
			if($iconCode=="24n"){
				$iconCity = "windyN";
			}
			if($iconCode=="25d"){
				$iconCity = "coldD";
			}
			if($iconCode=="25n"){
				$iconCity = "coldN";
			}
			if($iconCode=="26d"){
				$iconCity = "overcastD";
			}
			if($iconCode=="26n"){
				$iconCity = "overcastN";
			}
			if($iconCode=="27d" || $iconCode=="28d"){
				$iconCity = "mostlycloudyD";
			}
			if($iconCode=="27n" || $iconCode=="28n"){
				$iconCity = "mostlycloudyN";
			}
			if($iconCode=="29d" || $iconCode=="30d" || $iconCode=="44d"){
				$iconCity = "cloudyD";
			}
			if($iconCode=="29n" || $iconCode=="30n" || $iconCode=="44n"){
				$iconCity = "cloudyN";
			}
			if($iconCode=="31d" || $iconCode=="32d" || $iconCode=="33d" || $iconCode=="34d"){
				$iconCity = "clearD";
			}
			if($iconCode=="31n" || $iconCode=="32n" || $iconCode=="33n" || $iconCode=="34n"){
				$iconCity = "clearN";
			}
			if($iconCode=="36d"){
				$iconCity = "hotD";
			}
			if($iconCode=="36n"){
				$iconCity = "hotN";
			}
			if($iconCode=="3200d" || $iconCode=="3200n" || $iconCode=="d" || $iconCode=="n"){
				$iconCity = "na";
			}
			$city['icon'] = $iconCity;

			if($city['name']!=""){
				array_push($citiesWeather,$city);
			}
		}
	}
	$output['worldWeather'] = $citiesWeather;

	if(!$autoOpenWorldWeather){
		$textInitial = lang('more','c');
	}
	else{
		$textInitial = lang('hide','c');
	}
?>

	<?php
		for($i=0;$i<count($output['worldWeather']);$i=$i+5){
	?>
			<table style="width:98%;margin:0 auto">
				<tr>
					<?php
						for($a=0;$a<5;$a++){
							if(array_key_exists($i+$a,$output['worldWeather'])){
					?>
								<td style="text-align:center;width:20%;vertical-align:top">
									<?php if($worldWeatherShowFlags){?><img style="max-width:30px;width:100%" src="<?php echo $pageURL.$path?>imgs/flags/big/<?php echo $output['worldWeather'][$i+$a]['country']?>.png" alt=''><br><?php }?><span style="font-size:1.2em;font-weight:bold;font-variant:small-caps"><?php echo $output['worldWeather'][$i+$a]['name']?></span><br><img style="max-width:100px;width:100%" src="homepage/blocks/worldWeather/icons/<?php echo $output['worldWeather'][$i+$a]['icon']?>.png" alt=''><br><?php echo $output['worldWeather'][$i+$a]['temp']." °".$displayTempUnits?>
								</td>
					<?php
							}
						}
					?>
				</tr>
			</table>
			<div class="details cityDetails">
				<table style="width:98%;margin:0 auto">
					<tr>
						<?php
							for($a=0;$a<5;$a++){
								if(array_key_exists($i+$a,$output['worldWeather'])){
						?>
									<td style="text-align:center;width:20%">
										<?php echo $output['worldWeather'][$i+$a]['humidity']." %"?><br><?php echo $output['worldWeather'][$i+$a]['wind']." ".$displayWindUnits?>
									</td>
						<?php
								}
							}
						?>
					</tr>
				</table>
			</div>
			<br><br>
	<?php
		}
	?>
	<span class="more" onclick="txt = $('.cityDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('.cityDetails').slideToggle(800);$(this).text(txt)">
		<?php echo $textInitial?>
	</span>

	<script>
		<?php
			if($autoOpenWorldWeather){
		?>

				$('.cityDetails').slideToggle(800);
		<?php
			}
		?>
	</script>
