<?php

	# 		GrLevelX
	# 		Namespace:		grLevelX
	#		Meteotemplate Block

	# 		v2.0 - Mar 9, 2017
	# 			- added possibility to zoom image on click
	# 			- hide product selection when only one selected
	# 			- hide block when no current images available at all
	
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}
	
	$productTypes = explode(';',$productTypesString);
	
	$hideBlock = true;

	foreach(glob($imageDir) as $file) {
		$age = time()-filemtime($file);
		if($age<=($maxImgAge*60)){
			$hideBlock = false;
		}
	}
?>
	<style>
		.grLevelXCSS{
			width:95%;
			margin:0 auto;
			border-radius:10px;
			border: 1px solid #<?php echo $color_schemes[$design]['500']?>;
			margin-bottom: 10px;
			cursor: pointer;
			opacity: 0.85;
			margin-top:5px;
		}
		.grLevelXCSS:hover{
			opacity: 1;
		}
	</style>
	
	<h2>
		GrLevelX
	</h2>
	<?php
		if(count($productTypes)>1){
			for($i=0;$i<count($productTypes);$i++){
	?>
			<input type="button" class="button2" value="<?php echo trim(strtoupper($productTypes[$i]))?>" onclick="$('#grLevelProductType').val('<?php echo trim($productTypes[$i])?>');grLevelXImageUpdater()">
	<?php
			}
		}
	?>
	<div id="grLevelXImageDiv"></div>
	<div id="grLevelXWindow"></div>
	<input type="hidden" id="grLevelProductType" value="<?php echo trim($defaultProduct)?>">
	<script>
		widthGrLevelX = $("#grLevelXImageDiv").width();
		//$("#grLevelXImageDiv").height(widthGrLevelX);
		grLevelXImageUpdater();
		setInterval(function(){ grLevelXImageUpdater(); }, (<?php echo $grLevelXImageUpdateInterval?>*1000));
		function grLevelXImageUpdater(){
			product = $("#grLevelProductType").val();
			$('#grLevelXImageDiv').load('homepage/blocks/grLevelX/grLevelXImageLoader.php?product='+product);
		}
		<?php 
			if($hideBlock){
		?>
				$("#grLevelXBlock").hide();
		<?php
			}
		?>
		
		dialogHeight = screen.height*0.8;
		dialogWidth = screen.width*0.5;
		$("#grLevelXWindow").dialog({
			modal: true,
			autoOpen: false,
			height: dialogHeight,
			width: dialogWidth
		});
	</script>
	
