<?php

	# 		Indoor
	# 		Namespace:		indoor
	#		Meteotemplate Block
	
	# 		v2.0 - Oct 5, 2016
	#			- added support for WeatherCat
	# 		v3.0 - Oct 7, 2016
	#			- added support for WView
	# 		v4.0 - Mar 3, 2017
	#			- added support for WView
	# 		v5.0 - Mar 13, 2017
	#			- added support for Meteotemplate API
	# 		v6.0 - Mar 25, 2017
	#			- added comfortability indicators
	# 			- added possibility to add block heading 
	# 			- CSS optimization and conversion to SVG icons
	# 		v6.1 - Apr 5, 2017 
	# 			- minor tweaks
	# 		v7.0 - Aug 18, 2017
	# 			- added API by default
	# 			- added today's min/max
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	$apiData = file_get_contents("../../../meteotemplateLive.txt");
	$apiData = json_decode($apiData,true);
	$indoorT = number_format(convertor($apiData['TIN'],"C",$displayTempUnits),1,".","");
	$indoorH = number_format($apiData['HIN'],1,".","");

	// indicators
	if($indoorH<25){
		$indicatorHIcon = "frown-o";
		$indicatorHText = lang("very dry",'l');
	}
	if($indoorH>=25 && $indoorH<37){
		$indicatorHIcon = "frown-o";
		$indicatorHText = lang("dry",'l');
	}
	if($indoorH>=37 && $indoorH<55){
		$indicatorHIcon = "smile-o";
		$indicatorHText = lang("comfortable",'l');
	}
	if($indoorH>=55 && $indoorH<63){
		$indicatorHIcon = "frown-o";
		$indicatorHText = lang("humid",'l');
	}
	if($indoorH>63){
		$indicatorHIcon = "frown-o";
		$indicatorHText = lang("very humid",'l');
	}

	if($displayTempUnits=="F"){
		$indoorTempC = convertor($indoorT,"F","C");
	}
	else{
		$indoorTempC = $indoorT;
	}

	if($indoorTempC<17){
		$indicatorTIcon = "frown-o";
		$indicatorTText = lang("very cold",'l');
	}
	if($indoorTempC>=17 && $indoorTempC<20){
		$indicatorTIcon = "meh-o";
		$indicatorTText = lang("cold",'l');
	}
	if($indoorTempC>=20 && $indoorTempC<24){
		$indicatorTIcon = "smile-o";
		$indicatorTText = lang("comfortable",'l');
	}
	if($indoorTempC>=24 && $indoorTempC<26){
		$indicatorTIcon = "meh-o";
		$indicatorTText = lang("hot",'l');
	}
	if($indoorTempC>26){
		$indicatorTIcon = "frown-o";
		$indicatorTText = lang("very hot",'l');
	}

	if(file_exists("../../../update/apiSettings.txt")){
		$apiSetup = file_get_contents("../../../update/apiSettings.txt");
		$apiSetup = json_decode($apiSetup,1);
		if($apiSetup['TIN'] == 1){
			$result = mysqli_query($con, "
				SELECT max(TIN), min(TIN)
				FROM  alldataExtra
				WHERE DATE(DateTime) = CURDATE()
				"
			);
			while ($row = mysqli_fetch_array($result)) {
				$today['maxT'] = convertor($row['max(TIN)'],"C",$displayTempUnits);
				$today['minT'] = convertor($row['min(TIN)'],"C",$displayTempUnits);
			}
		}
		if($apiSetup['HIN'] == 1){
			$result = mysqli_query($con, "
				SELECT max(HIN), min(HIN)
				FROM  alldataExtra
				WHERE DATE(DateTime) = CURDATE()
				"
			);
			while ($row = mysqli_fetch_array($result)) {
				$today['maxH'] = $row['max(HIN)'];
				$today['minH'] = $row['min(HIN)'];
			}
		}
	}
?>
	<style>
		
	</style>
	<?php 
		if($showIndoorTitle){
	?>
			<h2><?php echo lang('indoor conditions','c')?></h2>
	<?php
		}
	?>
	<table style="width:98%;margin:0 auto">
		<tr>
			<td style="width:50%">
				<span class="mticon-indoortemp tooltip" style="font-size:3em" title="<?php echo lang("temperature","c")?>"></span>
			</td>
			<td>
				<span class="mticon-indoorhumidity tooltip" style="font-size:3em" title="<?php echo lang("humidity","c")?>"></span>
			</td>
		</tr>
		<tr>
			<td>
				<span style="font-size:2.3em;font-weight:bold"><?php echo number_format($indoorT,1,".","")?></span> °<?php echo $displayTempUnits?>
			</td>
			<td>
				<span style="font-size:2.3em;font-weight:bold"><?php echo number_format($indoorH,1,".","")?></span> %
			</td>
		</tr>
		<?php 
			if($showIndoorIndices){
		?>
				<tr>
					<td>
						<span class="fa fa-<?php echo $indicatorTIcon?>" style="font-size:1.5em"></span><br><span style="font-variant:small-caps"><?php echo $indicatorTText;?></span>
					</td>
					<td>
						<span class="fa fa-<?php echo $indicatorHIcon?>" style="font-size:1.5em"></span><br><span style="font-variant:small-caps"><?php echo $indicatorHText;?></span>
					</td>
				</tr>
		<?php
			}
		?>
	</table>

	<div id="indoorInfo" class="details">
		<br>
		<h2><?php echo lang('today','c')?></h2>
		<table style="width:98%;margin:0 auto;table-layout:fixed">
			<tr>
				<td>
					<?php echo number_format($today['maxT'],1,".","").unitFormatter($displayTempUnits)?> / <?php echo number_format($today['minT'],1,".","").unitFormatter($displayTempUnits)?>
				</td>
				<td>
				<?php echo number_format($today['maxH'],1,".","")?>% / <?php echo number_format($today['minH'],1,".","")?>%
				</td>
			</tr>
		</table>
	</div>

	<span class="more" onclick="txt = $('#indoorInfo').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#indoorInfo').slideToggle(800);$(this).text(txt);"><?php echo lang('more','l')?></span>
