<?php
	# 		Info block
	# 		Namespace:		info
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	# 		v2.0 - May 7, 2017
	# 			- conversion to SVG
	# 			- use global settings icon
	# 			- optimization
	# 		v3.0 - Jun 25, 2017
	# 			- language tweaks
	# 			- added server info, MySQL info and Meteotemplate info

	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "<span style='color:#".$graphColor."'>Please go to your admin section and go through the settings for this block first.</span>";
		die();
	}

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
?>
	<style>
		.infoIcon{
			font-size:2.5em;
		}
	</style>
	<table style="width:98%;margin:auto;font-size:0.8em;font-variant:small-caps">
		<tr>
			<td style="width:33%;vertical-align:top">
				<span class="mticon-<?php echo $stationIcon?> infoIcon tooltip" title="<?php echo lang('weather station','c')?>">
			</td>
			<td style="width:33%;vertical-align:top">
				<span class="fa fa-desktop infoIcon" title="Software">
			</td>
			<td style="width:33%;vertical-align:top">
				<span class="mticon-logo tooltip infoIcon" title="Meteotemplate">
			</td>
		</tr>
		<tr>
			<td>
				<?php echo $stationModel?>
			</td>
			<td>
				<?php echo $stationSoftware?>
			</td>
			<td>
				<a href="//www.meteotemplate.com" >Meteotemplate</a>
			</td>
		</tr>
	</table>
	<div class="details" style="width:98%;margin:0 auto" id="infoMore">
		<table style="width:98%;margin:0 auto;margin-top:10px">
			<tr>
				<td>
					<span class="fa fa-server infoIcon"></span>
				</td>
				<td style="text-align:left;padding-left:5px">
					PHP <?php echo PHP_VERSION?>,&nbsp;
					<?php echo PHP_OS?>,&nbsp;
					Zend <?php echo zend_version()?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="fa fa-database infoIcon"></span>
				</td>
				<td style="text-align:left;padding-left:5px">
					MySQL <?php echo mysqli_get_server_info($con)?>
				</td>
			</tr>
			<tr>
				<td>
					<span class="mticon-logo infoIcon"></span>
				</td>
				<td style="text-align:left;padding-left:5px">
					Meteotemplate&nbsp;
					<?php echo number_format($templateVersion,1,".","")?>&nbsp;<?php echo $versionName?>
				</td>
			</tr>
		</table>
	</div>
	<span class="more" onclick="txt = $('#infoMore').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#infoMore').slideToggle(400);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>