<?php

	include("../../../config.php");
	include("../../../header.php");
	include("../../../css/design.php");
	//include("../../../scripts/functions.php");
	//include("../../../scripts/stats.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$theme = $_GET['theme'];

	if($theme=="light"){
		$graphColor = $color_schemes[$design2]["900"];
	}
	else{
		$graphColor = "fff";
	}

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "<span style='color:#".$graphColor."'>Please go to your admin section and go through the settings for this block first.</span>";
		die();
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<title><?php echo lang("interactive graph",'c')?></title>
		<?php metaHeader()?>

		<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/highcharts.js"></script>
		<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/highcharts-more.js"></script>
		<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/exporting.js"></script>
		<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/jqxcore.js"></script>
		<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/jqxdatetimeinput.js"></script>
		<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/jqxcalendar.js"></script>
		<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/globalize.js"></script>

		<style>
			body, #main{
				background:none;
			}
			.parameter{
				padding: 3px;
				width: 20px;
				opacity: 0.6;
				cursor: pointer;
			}
			.parameter:hover{
				opacity: 0.9;
			}
			.calendar{
				padding: 3px;
				width: 20px;
				opacity: 0.6;
				cursor: pointer;
			}
			.calendar:hover{
				opacity: 0.9;
			}
			.dates{
				opacity: 0.6;
				cursor: pointer;
				font-variant: small-caps;
			}
			.dates:hover{
				opacity: 0.9;
			}
			.interval{
				text-align: center;
				width: 8%;
			}
			.tooltipster-default {
				border: 2px solid #<?php echo $color_schemes[$design]['900']?>;
				background: #<?php echo $color_schemes[$design2]['700']?>;
				color: #<?php echo $color_schemes[$design2]['font700']?>;
			}
			.jqx-widget-content {
				font-family: "<?php echo $designFont?>",Arial Narrow,Arial,Helvetica,sans-serif!important;
				color: #<?php echo $color_schemes[$design2]['font900']?>!important;
				border-color: #<?php echo $color_schemes[$design2]['900']?>!important;
				background: #<?php echo $color_schemes[$design2]['800']?>!important;
			}
			.jqx-widget-header {
				border-color: #<?php echo $color_schemes[$design]['900']?>!important;
				background: #<?php echo $color_schemes[$design]['300']?>!important;
				color: #<?php echo $color_schemes[$design]['font300']?>!important;
			}
			.jqx-calendar-cell-today{
				color: #<?php echo $color_schemes[$design]['font900']?>!important;
				background-color: #<?php echo $color_schemes[$design]['900']?>!important;
				border: 1px solid #<?php echo $color_schemes[$design]['200']?>!important;
			}
			.ui-widget-header {
				border: 0px solid #<?php echo $color_schemes[$design]['900']?>!important;
				background: transparent;
			}
			.spinner {
				position: relative;
				color: #<?php echo $color_schemes[$design2]['300']?>;
				display: inline-block;
				width:  1em;
				z-index:10;
				height: 1em;
				font-size: 260px;
				border-bottom: 10px solid;
				vertical-align: middle;
				overflow: hidden;
				text-indent: 100%;
				-webkit-animation: 0.9s spinner linear infinite;
				   -moz-animation: 0.9s spinner linear infinite;
						animation: 0.9s spinner linear infinite;
				&,
				&:after {
					border-radius: 100%;
				}
				&:after {
					content: "";
					position: absolute;
					top:    0;
					right:  0;
					bottom: 0;
					left:   0;
					border: 1px solid;
					opacity: 0.5;
				}
			}
			@-webkit-keyframes spinner {
				to {
					-webkit-transform: rotate(360deg);
				}
			}
			@-moz-keyframes spinner {
				to {
					-moz-transform: rotate(360deg);
				}
			}
			@keyframes spinner {

				to {
					transform: rotate(360deg);
				}
			}
			.spinner, .spinner:after {
			  border-radius: 100%;
			}
		</style>
		<link rel="stylesheet" href="<?php echo $pageURL.$path?>css/jqx.base.css" media="screen" />
	</head>
	<body>
		<div id="main" style="max-width:98%!important;margin:0 auto">
		<div style="position:relative;width:100%;margin: 0 auto;">
			<div style="width:100%;text-align:center;position:absolute;top:50;left:0;z-index:10">
				<span class="spinner" id="spinner"><?php echo lang("loading",'c')?>…</span>
			</div>
			<div id="graph" style="min-width: 400px; height: 310px; margin: 0 auto;z-index:5">
			</div>
		</div>
		<br>
		<input type="hidden" id="chosenParameter" value="<?php echo $defaultGraphParameter ?>">
		<input type="hidden" id="chosenValue" value="all">
		<input type="hidden" id="chosenInterval" value="<?php echo $defaultGraphInterval ?>">
		<table style="margin-left:auto;margin-right:auto">
			<tr>
				<td style="width:33%;text-align:center">
					<select class="button" id="parameterSelector">
						<option value="T" <?php if($defaultGraphParameter=="T"){ echo "selected"; }?>><?php echo lang("temperature",'c')?></option>
						<option value="H" <?php if($defaultGraphParameter=="H"){ echo "selected"; }?>><?php echo lang("humidity",'c')?></option>
						<option value="P" <?php if($defaultGraphParameter=="P"){ echo "selected"; }?>><?php echo lang("pressure",'c')?></option>
						<option value="W" <?php if($defaultGraphParameter=="W"){ echo "selected"; }?>><?php echo lang("wind",'c')?></option>
						<option value="R" <?php if($defaultGraphParameter=="R"){ echo "selected"; }?>><?php echo lang("precipitation",'c')?></option>
						<?php if($solarSensor){?>
							<option value="S" <?php if($defaultGraphParameter=="S"){ echo "selected"; }?>><?php echo lang("solar radiation",'c')?></option>
						<?php } ?>
					</select>
				</td>
				<td style="width:33%;text-align:center">
					<select class="button" id="groupingSelector">
						<option value="all"><?php echo lang("all",'c')?></option>
						<option value="h"><?php echo lang("hourly averages",'c')?></option>
						<option value="d"><?php echo lang("daily averages",'c')?></option>
						<option value="m"><?php echo lang("monthly averages",'c')?></option>
					</select>
				</td>
				<td style="width:33%;text-align:center">
					<select class="button" id="intervalSelector">
						<option value="1h" <?php if($defaultGraphInterval=="1h"){ echo "selected"; }?>>1<?php echo lang("hAbbr",'')?></option>
						<option value="24h" <?php if($defaultGraphInterval=="24h"){ echo "selected"; }?>>24<?php echo lang("hAbbr",'')?></option>
						<option value="today" <?php if($defaultGraphInterval=="today"){ echo "selected"; }?>><?php echo lang("today",'c')?></option>
						<option value="yesterday" <?php if($defaultGraphInterval=="yesterday"){ echo "selected"; }?>><?php echo lang("yesterday",'c')?></option>
						<option value="thisweek" <?php if($defaultGraphInterval=="thisweek"){ echo "selected"; }?>><?php echo lang("this",'c')." ".lang("week",'l')?></option>
						<option value="thismonth" <?php if($defaultGraphInterval=="thismonth"){ echo "selected"; }?>><?php echo lang("this",'c')." ".lang("month",'l')?></option>
						<option value="lastweek" <?php if($defaultGraphInterval=="lastweek"){ echo "selected"; }?>><?php echo lang("last",'c')." ".lang("week",'l')?></option>
						<option value="lastmonth" <?php if($defaultGraphInterval=="lastmonth"){ echo "selected"; }?>><?php echo lang("last",'c')." ".lang("month",'l')?></option>
					</select>
				</td>
			</tr>
		</table>
		</div>
		<div id="customDialog" style="text-align:center">
			<?php echo lang("from",'c')?>:
			<div id='customFrom'></div>
			<br>
			<?php echo lang("to",'c')?>:
			<div id='customTo'></div>
			<br>
			<input type="button" class="button" value="<?php echo lang("ok",'u')?>" id="customShow">
		</div>
		<script>
			$("#parameterSelector").change(function(){
				param = $("#parameterSelector").val();
				parameterSet(param);
			})
			$("#groupingSelector").change(function(){
				param = $("#groupingSelector").val();
				valueSet(param);
			})
			$("#intervalSelector").change(function(){
				param = $("#intervalSelector").val();
				intervalSet(param);
			})
			function parameterSet(x){
				$("#chosenParameter").val(x);
				graph();
			}
			function valueSet(x){
				$("#chosenValue").val(x);
				graph();
			}
			function intervalSet(x){
				$("#chosenInterval").val(x);
				graph();
			}
			function graph() {
				$('#spinner').show();
				// Global graph options
				Highcharts.setOptions({
					global: {
						useUTC: true
					},
					lang: {
						months: ['<?php echo lang('january','c')?>', '<?php echo lang('february','c')?>', '<?php echo lang('march','c')?>', '<?php echo lang('april','c')?>', '<?php echo lang('may','c')?>', '<?php echo lang('june','c')?>', '<?php echo lang('july','c')?>', '<?php echo lang('august','c')?>', '<?php echo lang('september','c')?>', '<?php echo lang('october','c')?>', '<?php echo lang('november','c')?>', '<?php echo lang('december','c')?>'],
						shortMonths: ['<?php echo lang('janAbbr','c')?>', '<?php echo lang('febAbbr','c')?>', '<?php echo lang('marAbbr','c')?>', '<?php echo lang('aprAbbr','c')?>', '<?php echo lang('mayAbbr','c')?>', '<?php echo lang('junAbbr','c')?>', '<?php echo lang('julAbbr','c')?>', '<?php echo lang('augAbbr','c')?>', '<?php echo lang('sepAbbr','c')?>', '<?php echo lang('octAbbr','c')?>', '<?php echo lang('novAbbr','c')?>', '<?php echo lang('decAbbr','c')?>'],
						weekdays: ['<?php echo lang('sundayAbbr','c')?>', '<?php echo lang('mondayAbbr','c')?>', '<?php echo lang('tuesdayAbbr','c')?>', '<?php echo lang('wednesdayAbbr','c')?>', '<?php echo lang('thursdayAbbr','c')?>', '<?php echo lang('fridayAbbr','c')?>', '<?php echo lang('saturdayAbbr','c')?>'],
						resetZoom: ['<?php echo lang('default zoom','c')?>']
					}
				});
				Highcharts.theme = {
					title: {
						style: {
							color: "#<?php echo $graphColor?>",
							textTransform: 'uppercase',
							fontSize: '20px'
						}
					},
					xAxis: {
						gridLineColor: '#<?php echo $graphColor?>',
						labels: {
							style: {
								color: '#<?php echo $graphColor?>',
							}
						},
						lineColor: '#<?php echo $graphColor?>',
						minorGridLineColor: '#<?php echo $graphColor?>',
						tickColor: '#<?php echo $graphColor?>',
						title: {
							style: {
								color: '#<?php echo $graphColor?>',
							}
						}
					},
					yAxis: {
						gridLineColor: '#<?php echo $graphColor?>',
						gridLineWidth: 0,
						labels: {
							style: {
								color: '#<?php echo $graphColor?>',
							}
						},
						lineColor: '#<?php echo $graphColor?>',
						minorGridLineColor: '#<?php echo $graphColor?>',
						tickColor: '#<?php echo $graphColor?>',
						tickWidth: 1,
						title: {
							style: {
								color: '#<?php echo $graphColor?>',
							}
						}
					},
					legend: {
						itemStyle: {
							color: '#<?php echo $graphColor?>'
						},
						itemHoverStyle: {
							color: '#<?php echo $color_schemes[$design2]['500']?>'
						},
						itemHiddenStyle: {
							color: '#999999'
						},
					},
				}
				Highcharts.setOptions(Highcharts.theme);
				// Individual graphs options based on parameter
				optionsT = {
					chart : {
						renderTo : 'graph',
						type : 'spline',
						zoomType: 'x',
						backgroundColor: null,
					},
					title: {
						text:  '<?php echo lang('temperature',"c") ?>',

					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang("temperature","c") ?>'
						},
						labels: {
							format: '{value} °<?php echo $displayTempUnits ?>'
						},
						<?php
							if($showFreezing){
						?>
							plotLines: [{
								<?php
									if($showFreezingColor=="default"){
								?>
									color: "#<?php echo $graphColor?>",
								<?php
									}
									else{
								?>
									color: "<?php echo $showFreezingColor?>",
								<?php
									}
								?>
				                width: 2,
								dashStyle: 'Dot',
								<?php
									if($displayTempUnits=="C"){
										echo "value: 0";
									}
									else{
										echo "value: 32";
									}
				                ?>
							}]
						<?php
							}
						?>
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					tooltip: {
						shared: true
					},
					series: [
						{
							name: '',
							data: [],
							<?php
								if($tColor=="default"){
							?>
								color: "#<?php echo $graphColor?>"
							<?php
								}
								else{
							?>
								color: "<?php echo $tColor?>"
							<?php
								}
							?>

						},
						{
							name: '',
							data: [],
							<?php
								if($aColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $aColor?>",
							<?php
								}
							?>
							dashStyle: 'ShortDot'
						},
						{
							type: 'areasplinerange',
							name: '<?php echo lang('range','c')?>',
							<?php
								if($tColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $tColor?>",
							<?php
								}
							?>
							data: []
						}
					]
				};
				optionsH = {
					chart : {
						renderTo : 'graph',
						type : 'spline',
						zoomType: 'x'
					},
					title: {
						text:  '<?php echo lang('humidity','c') ?>'
					},
					legend: {
						enabled: false
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('humidity','c') ?>'
						},
						labels: {
							format: '{value} %'
						},
						max: 100
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					series: [
						{
							name: '<?php echo lang('humidity','c') ?>',
							data: [],
							<?php
								if($hColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $hColor?>",
							<?php
								}
							?>
						},
						{
							type: 'areasplinerange',
							name: '<?php echo lang('range','c')?>',
							<?php
								if($hColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $hColor?>",
							<?php
								}
							?>
							data: []
						}
					]
				};
				optionsP = {
					chart : {
						renderTo : 'graph',
						type : 'spline',
						zoomType: 'x'
					},
					title: {
								text:  '<?php echo lang('pressure','c') ?>'
					},
					legend: {
								enabled: false
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('pressure','c') ?>'
						},
						labels: {
							format: '{value} <?php echo $displayPressUnits ?>'
						}
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					series: [
						{
							name: '<?php echo lang('pressure','c') ?>',
							data: [],
							<?php
								if($pColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $pColor?>",
							<?php
								}
							?>
						},
						{
							type: 'areasplinerange',
							name: '<?php echo lang('range','c')?>',
							<?php
								if($pColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $pColor?>",
							<?php
								}
							?>
							data: []
						}
					]
				};
				optionsS = {
					chart : {
						renderTo : 'graph',
						type : 'spline',
						zoomType: 'x'
					},
					title: {
						text:  '<?php echo lang('solar radiation','c') ?>'
					},
					legend: {
						enabled: false
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('solar radiation','c') ?>'
						},
						labels: {
							format: '{value} W/m2'
						},
						min: 0
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					series: [
						{
							name: '<?php echo lang('solar radiation','c') ?>',
							data: [],
							<?php
								if($sColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $sColor?>",
							<?php
								}
							?>
						},
						{
							type: 'areasplinerange',
							name: '<?php echo lang('range','c')?>',
							<?php
								if($sColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $sColor?>",
							<?php
								}
							?>
							data: []
						}
					]
				};

				optionsW = {
					chart : {
						renderTo : 'graph',
						type : 'spline',
						zoomType: 'x'
					},
					title: {
								text:  '<?php echo lang('wind','c') ?>'
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('wind','c') ?>'
						},
						labels: {
							format: '{value} <?php echo $displayWindUnits ?>'
						},
						min: 0
					},
					tooltip: {
						shared: true
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					series: [
						{
							name: '',
							data: [],
							<?php
								if($wColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $wColor?>",
							<?php
								}
							?>
						},
						{
							name: '',
							data: [],
							<?php
								if($gColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $gColor?>",
							<?php
								}
							?>
							dashStyle: 'ShortDot'
						},
						{
							type: 'areasplinerange',
							name: '<?php echo lang('range','c')?>',
							<?php
								if($wColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $wColor?>",
							<?php
								}
							?>
							data: []
						}
					]
				};

				optionsR = {
				   chart : {
						renderTo : 'graph',
						type : 'area',
						zoomType: 'x'
					},
					title: {
								text:  '<?php echo lang('cumulative daily precipitation','c') ?>'
					},
					legend: {
								enabled: false
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('precipitation','c') ?>'
						},
						labels: {
							format: '{value} <?php echo $displayRainUnits ?>'
						},
						min: 0
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						area: {
							fillOpacity: 0.3
						}
					},
					series: [{
						name: '<?php echo lang('precipitation','c') ?>',
						<?php
								if($rColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $rColor?>",
							<?php
								}
							?>
						data: []
				   }]
				};

				// get selected parameters
				parameter = $("#chosenParameter").val();
				value = $("#chosenValue").val();
				interval = $("#chosenInterval").val();
				from = $("#customFrom").val();
				to = $("#customTo").val();
				$('#spinner').show();
				// get data based on user selection
				if(parameter=="T"){
					$.ajax({
						url : "graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval+"&from="+from+"&to="+to,
						dataType : 'json',
						success : function (json) {

							optionsT.series[0].name = json['name1'];
							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryT = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryT];
								rowDate.push(value);
							}
							optionsT.series[0].data = rowDate;

							optionsT.series[1].name = json['name2'];
							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryT = eval(json['data2'][i][1]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryT];
								rowDate.push(value);
							}
							optionsT.series[1].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data3'].length; i++){
								temporaryT = eval(json['data3'][i][1]);
								temporaryT2 = eval(json['data3'][i][2]);
								temporaryDate = json['data3'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryT,temporaryT2];
								rowDate.push(value);
							}
							optionsT.series[2].data = rowDate;

							chart = new Highcharts.Chart(optionsT);
							$('#spinner').hide();
						}
					});
				}
				if(parameter=="H"){
					$.ajax({
						url : "graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval+"&from="+from+"&to="+to,
						dataType : 'json',
						success : function (json) {
							optionsH.series[0].name = json['name1'];
							optionsH.series[1].name = json['name2'];

							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryH = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryH];
								rowDate.push(value);
							}
							optionsH.series[0].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryH = eval(json['data2'][i][1]);
								temporaryH2 = eval(json['data2'][i][2]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryH,temporaryH2];
								rowDate.push(value);
							}
							optionsH.series[1].data = rowDate;

							chart = new Highcharts.Chart(optionsH);
							$('#spinner').hide();
						}
					});
				}
				if(parameter=="P"){
					$.ajax({
						url : "graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval+"&from="+from+"&to="+to,
						dataType : 'json',
						success : function (json) {
							optionsP.series[0].name = json['name1'];
							optionsP.series[1].name = json['name2'];

							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryP = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryP];
								rowDate.push(value);
							}
							optionsP.series[0].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryP = eval(json['data2'][i][1]);
								temporaryP2 = eval(json['data2'][i][2]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryP,temporaryP2];
								rowDate.push(value);
							}
							optionsP.series[1].data = rowDate;

							chart = new Highcharts.Chart(optionsP);
							$('#spinner').hide();
						}
					});
				}
				if(parameter=="S"){
					$.ajax({
						url : "graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval+"&from="+from+"&to="+to,
						dataType : 'json',
						success : function (json) {
							optionsS.series[0].name = json['name1'];
							optionsS.series[1].name = json['name2'];

							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryS = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryS];
								rowDate.push(value);
							}
							optionsS.series[0].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryS = eval(json['data2'][i][1]);
								temporaryS2 = eval(json['data2'][i][2]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryS,temporaryS2];
								rowDate.push(value);
							}
							optionsS.series[1].data = rowDate;

							chart = new Highcharts.Chart(optionsS);
							$('#spinner').hide();
						}
					});
				}
				if(parameter=="R"){
					$.ajax({
						url : "graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval+"&from="+from+"&to="+to,
						dataType : 'json',
						success : function (json) {
							rowDate = new Array();
							for(i=0; i < json['data'].length; i++){
								temporaryR = eval(json['data'][i][1]);
								temporaryDate = json['data'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryR];
								rowDate.push(value);
							}
							optionsR.series[0].data = rowDate;
							chart = new Highcharts.Chart(optionsR);
							$('#spinner').hide();
						}
					});
				}
				if(parameter=="W"){
					$.ajax({
						url : "graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval+"&from="+from+"&to="+to,
						dataType : 'json',
						success : function (json) {
							optionsW.series[0].name = json['name1'];
							optionsW.series[1].name = json['name2'];

							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryW = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryW];
								rowDate.push(value);
							}
							optionsW.series[0].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryG = eval(json['data2'][i][1]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryG];
								rowDate.push(value);
							}
							optionsW.series[1].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data3'].length; i++){
								temporaryG = eval(json['data3'][i][1]);
								temporaryG2 = eval(json['data3'][i][2]);
								temporaryDate = json['data3'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryG,temporaryG2];
								rowDate.push(value);
							}
							optionsW.series[2].data = rowDate;

							chart = new Highcharts.Chart(optionsW);
							$('#spinner').hide();
						}
					});
				}
			}
			$(document).ready(function() {
				$('#spinner').hide();
				$("#parameter<?php echo $defaultGraphParameter?>").css("opacity","1");
				$("#interval<?php echo $defaultGraphInterval?>").css("opacity","1");
				$("#customFrom").jqxDateTimeInput({
					width: '300px',
					height: '30px',
					formatString: 'yyyy-MM-dd HH:mm'
				});
				$("#customTo").jqxDateTimeInput({
					width: '300px',
					height: '30px',
					formatString: 'yyyy-MM-dd HH:mm'
				});
				$( "#customDialog" ).dialog({
					autoOpen: false,
					show: {
						effect: "puff",
						duration: 500
					},
					hide: {
						effect: "puff",
						duration: 500
					},
					height: 340,
					width: 350,
					position:{
						my: 'top',
						at: 'top+30%'
					}
				});
				$( "#intervalCustom" ).click(function() {$( "#customDialog" ).dialog( "open" );});
				$( "#customShow" ).click(function() {
					graph();
					$( "#customDialog" ).dialog( "close" );
				});
				graph();
			});
		</script>
		<script>
			Highcharts.createElement('link', {
				href: 'http://fonts.googleapis.com/css?family=PT+Sans:400,700&subset=latin,cyrillic-ext,latin-ext',
				rel: 'stylesheet',
				type: 'text/css'
			}, null, document.getElementsByTagName('head')[0]);

			Highcharts.theme = {
				chart: {
					backgroundColor: null,
					color: "#<?php echo $color_schemes[$design]['font900']?>",
					style: {
						fontFamily: "'<?php echo $designFont?> Narrow', sans-serif"
					}
				},
				title: {
					style: {
						color: "#<?php echo $color_schemes[$design]['font700']?>",
						textTransform: 'uppercase',
						fontSize: '20px'
					}
				},
				subtitle: {
					style: {
						color: '#E0E0E3',
						textTransform: 'uppercase'
					}
				},
				xAxis: {
					gridLineColor: "#<?php echo $color_schemes[$design]['font700']?>",
					labels: {
						style: {
							color: "#<?php echo $color_schemes[$design]['font700']?>"
						}
					},
					lineColor: "#<?php echo $color_schemes[$design]['font700']?>",
					minorGridLineColor: "#<?php echo $color_schemes[$design]['font700']?>",
					tickColor: "#<?php echo $color_schemes[$design]['font700']?>",
					title: {
						style: {
							color: "#<?php echo $color_schemes[$design]['font700']?>"

						}
					}
				},
				yAxis: {
					gridLineColor: "#<?php echo $color_schemes[$design]['font700']?>",
					gridLineWidth: 0,
					labels: {
						style: {
							color: "#<?php echo $color_schemes[$design]['font700']?>"
						}
					},
					lineColor: "#<?php echo $color_schemes[$design]['font700']?>",
					minorGridLineColor: "#<?php echo $color_schemes[$design]['font700']?>",
					tickColor: "#<?php echo $color_schemes[$design]['font700']?>",
					tickWidth: 1,
					title: {
						style: {
							color: '#<?php echo $color_schemes[$design]['font700']?>'
						}
					}
				},
				tooltip: {
					backgroundColor: '#<?php echo $color_schemes[$design2]['900']?>',
					style: {
						color: '#<?php echo $color_schemes[$design2]['font900']?>'
					}
				},
				plotOptions: {
					series: {
						dataLabels: {
							color: '#<?php echo $color_schemes[$design2]['900']?>'
						},
						marker: {
							lineColor: '#333'
						}
					}
				},
				legend: {
					itemStyle: {
						color: '#<?php echo $color_schemes[$design]['font700']?>'
					},
					itemHoverStyle: {
						color: '#<?php echo $color_schemes[$design]['500']?>'
					},
					itemHiddenStyle: {
						color: '#<?php echo $color_schemes[$design]['100']?>'
					}
				},
				credits: {
					style: {
						color: '#666'
					}
				},
				labels: {
					style: {
						color: '#707073'
					}
				},

				drilldown: {
					activeAxisLabelStyle: {
						color: '#F0F0F3'
					},
					activeDataLabelStyle: {
						color: '#F0F0F3'
					}
				},

				navigation: {
					buttonOptions: {
						symbolStroke: '#DDDDDD',
						theme: {
							fill: '#505053'
						}
					}
				},

				// scroll charts
				rangeSelector: {
					buttonTheme: {
						fill: '#505053',
						stroke: '#000000',
						style: {
							color: '#CCC'
						},
						states: {
							hover: {
								fill: '#707073',
								stroke: '#000000',
								style: {
									color: 'white'
								}
							},
							select: {
								fill: '#000003',
								stroke: '#000000',
								style: {
									color: 'white'
								}
							}
						}
					},
					inputBoxBorderColor: '#505053',
					inputStyle: {
						backgroundColor: '#333',
						color: 'silver'
					},
					labelStyle: {
						color: 'silver'
					}
				},

				navigator: {
					handles: {
						backgroundColor: '#666',
						borderColor: '#AAA'
					},
					outlineColor: '#CCC',
					maskFill: 'rgba(255,255,255,0.1)',
					series: {
						color: '#7798BF',
						lineColor: '#A6C7ED'
					},
					xAxis: {
						gridLineColor: '#505053'
					}
				},

				scrollbar: {
					barBackgroundColor: '#808083',
					barBorderColor: '#808083',
					buttonArrowColor: '#CCC',
					buttonBackgroundColor: '#606063',
					buttonBorderColor: '#606063',
					rifleColor: '#FFF',
					trackBackgroundColor: '#404043',
					trackBorderColor: '#404043'
				},

				// special colors for some of the
				legendBackgroundColor: 'rgba(0, 0, 0, 0.5)',
				background2: '#505053',
				dataLabelsColor: '#B0B0B3',
				textColor: '#C0C0C0',
				contrastTextColor: '#F0F0F3',
				maskColor: 'rgba(255,255,255,0.3)'
			};

			// Apply the theme
			Highcharts.setOptions(Highcharts.theme);
		</script>
		<script>

		</script>
	</body>
</html>
