<?php

	# 		Interactive Graph
	# 		Namespace:		interactiveGraph
	#		Meteotemplate Block

	#	v1.1
	#		- CSS changes
	#	v2.0
	#		- optimization for light theme
	#	v3.0 - Jul 21, 2016
	#		- added possibility to set graph colors
	#	v4.0 - Jan 10, 2017
	#		- added possibility to add freezing line and set its color
	#	v4.1 - Jan 13, 2017
	#		- CSS tweaks
	#		- fixed default select box value
	# 	v5.0 - May 2, 2017
	# 		- major optimization - removed iFrame, code optimization
	# 	v5.1 - Jun 4, 2017
	# 		- rain units bug fix
	# 	v6.0 - Jun 20, 2017
	# 		- added possibility to add grid lines
	# 	v7.0 - Jul 13, 2017
	# 		- added last 7 days and last 30 days
	# 	v8.0 - Jul 17, 2017
	# 		- added option to select defaults
	# 	v9.0 - Aug 1, 2017
	# 		- added dew point data
	# 	v9.1 - Aug 14, 2017
	# 		- minor tweaks
	# 	v10.0 - Oct 8, 2017
	# 		- added bearing
	# 	v11.0 - Oct 21, 2017
	# 		- added possibility to set graph height
	# 	v11.1 - Jan 20, 2018
	# 		- bug fixes

	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if($theme=="light"){
		$graphColor = "000";
		$gridColor = "666666";
	}
	else{
		$graphColor = "fff";
		$gridColor = "b2b2b2";
	}

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "<span style='color:#".$graphColor."'>Please go to your admin section and go through the settings for this block first.</span>";
		die();
	}

	if(!isset($interactiveGraphDefaultParameter)){
		$interactiveGraphDefaultParameter = "T";
	}
	else{
		$interactiveGraphDefaultParameter = trim($interactiveGraphDefaultParameter);
	}
	
	if(!isset($interactiveGraphDefaultInterval)){
		$interactiveGraphDefaultInterval = "today";
	}
	else{
		$interactiveGraphDefaultInterval = trim($interactiveGraphDefaultInterval);
	}

	if(!isset($interactiveGraphHeight) || !is_numeric($interactiveGraphHeight)){
		$interactiveGraphHeight = 310;
	}

	$offsetArr = explode(":",$offset);
	$offset = $offsetArr[0];

?>
	<style>
	</style>

		<div style="position:relative;width:100%;margin: 0 auto;">
			<div style="width:100%;text-align:center;position:absolute;top:50;left:0;z-index:10">
				<img src="<?php echo $pageURL.$path?>icons/logo.png" style="width:100px;padding-top:50px" class="mtSpinner" id="spinnerInteractiveGraph">
			</div>
			<div id="graphInteractiveGraph" style="width: 98%; height: <?php echo $interactiveGraphHeight?>px; margin: 0 auto;z-index:5">
			</div>
		</div>

		<br>
		<input type="hidden" id="chosenParameterInteractiveGraph" value="<?php echo $interactiveGraphDefaultParameter ?>">
		<input type="hidden" id="chosenValueInteractiveGraph" value="all">
		<input type="hidden" id="chosenIntervalInteractiveGraph" value="<?php echo $interactiveGraphDefaultInterval ?>">
		<table style="margin-left:auto;margin-right:auto">
			<tr>
				<td style="width:33%;text-align:center">
					<select class="button" id="parameterSelectorInteractiveGraph">
						<option value="T" <?php if($interactiveGraphDefaultParameter=="T"){ echo "selected"; }?>><?php echo lang("temperature",'c')?></option>
						<option value="H" <?php if($interactiveGraphDefaultParameter=="H"){ echo "selected"; }?>><?php echo lang("humidity",'c')?></option>
						<option value="D" <?php if($interactiveGraphDefaultParameter=="D"){ echo "selected"; }?>><?php echo lang("dew point",'c')?></option>
						<option value="P" <?php if($interactiveGraphDefaultParameter=="P"){ echo "selected"; }?>><?php echo lang("pressure",'c')?></option>
						<option value="W" <?php if($interactiveGraphDefaultParameter=="W"){ echo "selected"; }?>><?php echo lang("wind",'c')?></option>
						<option value="B" <?php if($interactiveGraphDefaultParameter=="B"){ echo "selected"; }?>><?php echo lang("wind direction",'c')?></option>
						<option value="R" <?php if($interactiveGraphDefaultParameter=="R"){ echo "selected"; }?>><?php echo lang("precipitation",'c')?></option>
						<?php if($solarSensor){?>
							<option value="S" <?php if($interactiveGraphDefaultParameter=="S"){ echo "selected"; }?>><?php echo lang("solar radiation",'c')?></option>
						<?php } ?>
					</select>
				</td>
				<td style="width:33%;text-align:center">
					<select class="button" id="groupingSelectorInteractiveGraph">
						<option value="all"><?php echo lang("all",'c')?></option>
						<option value="h"><?php echo lang("hourly averages",'c')?></option>
						<option value="d"><?php echo lang("daily averages",'c')?></option>
						<option value="m"><?php echo lang("monthly averages",'c')?></option>
					</select>
				</td>
				<td style="width:33%;text-align:center">
					<select class="button" id="intervalSelectorInteractiveGraph">
						<option value="1h" <?php if($interactiveGraphDefaultInterval=="1h"){ echo "selected"; }?>>1<?php echo lang("hAbbr",'')?></option>
						<option value="24h" <?php if($interactiveGraphDefaultInterval=="24h"){ echo "selected"; }?>>24<?php echo lang("hAbbr",'')?></option>
						<option value="today" <?php if($interactiveGraphDefaultInterval=="today"){ echo "selected"; }?>><?php echo lang("today",'c')?></option>
						<option value="yesterday" <?php if($interactiveGraphDefaultInterval=="yesterday"){ echo "selected"; }?>><?php echo lang("yesterday",'c')?></option>
						<option value="thisweek" <?php if($interactiveGraphDefaultInterval=="thisweek"){ echo "selected"; }?>><?php echo lang("this",'c')." ".lang("week",'l')?></option>
						<option value="thismonth" <?php if($interactiveGraphDefaultInterval=="thismonth"){ echo "selected"; }?>><?php echo lang("this",'c')." ".lang("month",'l')?></option>
						<option value="lastweek" <?php if($interactiveGraphDefaultInterval=="lastweek"){ echo "selected"; }?>><?php echo lang("last",'c')." ".lang("week",'l')?></option>
						<option value="last7days" <?php if($interactiveGraphDefaultInterval=="last7days"){ echo "selected"; }?>><?php echo lang("last",'c')." 7 ".lang("days",'l')?></option>
						<option value="lastmonth" <?php if($interactiveGraphDefaultInterval=="lastmonth"){ echo "selected"; }?>><?php echo lang("last",'c')." ".lang("month",'l')?></option>
						<option value="last30days" <?php if($interactiveGraphDefaultInterval=="last30days"){ echo "selected"; }?>><?php echo lang("last",'c')." 30 ".lang("days",'l')?></option>
					</select>
				</td>
			</tr>
		</table>
		<?php 
			$graphHueColor = getColorHue("#".$color_schemes[$design2]["900"],"hex");
		?>
		<script>
			Highcharts.createElement('link', {
				href: 'https://fonts.googleapis.com/css?family=PT+Sans:400,700&subset=latin,cyrillic-ext,latin-ext',
				rel: 'stylesheet',
				type: 'text/css'
			}, null, document.getElementsByTagName('head')[0]);
			Highcharts.theme = {
				chart: {
					backgroundColor: null,
					color: "#<?php echo $color_schemes[$design]['font900']?>",
					style: {
						fontFamily: "'<?php echo $designFont?> Narrow', sans-serif"
					}
				},
				title: {
					style: {
						color: "#<?php echo $graphColor?>",
						textTransform: 'uppercase',
						fontSize: '20px'
					}
				},
				subtitle: {
					style: {
						color: '#E0E0E3',
						textTransform: 'uppercase'
					}
				},
				xAxis: {
					gridLineColor: '#<?php echo $graphColor?>',
					gridLineWidth: <?php echo $xAxisGrid?>,
					gridLineDashStyle: 'shortDash',
					labels: {
						style: {
							color: '#<?php echo $graphColor?>',
						}
					},
					lineColor: '#<?php echo $graphColor?>',
					minorGridLineColor: '#<?php echo $graphColor?>',
					tickColor: '#<?php echo $graphColor?>',
					title: {
						style: {
							color: '#<?php echo $graphColor?>',
						}
					}
				},
				yAxis: {
					gridLineColor: '#<?php echo $gridColor?>',
					gridLineWidth: <?php echo $yAxisGrid?>,
					gridLineDashStyle: 'shortDash',
					labels: {
						style: {
							color: '#<?php echo $graphColor?>',
						}
					},
					lineColor: '#<?php echo $graphColor?>',
					minorGridLineColor: '#<?php echo $graphColor?>',
					tickColor: '#<?php echo $graphColor?>',
					tickWidth: 1,
					title: {
						style: {
							color: '#<?php echo $graphColor?>',
						}
					}
				},
				tooltip: {
					backgroundColor: '#<?php echo $color_schemes[$design2]['900']?>',
					style: {
						color: '#<?php echo $color_schemes[$design2]['font900']?>'
					}
				},
				plotOptions: {
					series: {
						dataLabels: {
							color: '#<?php echo $color_schemes[$design2]['900']?>'
						},
						marker: {
							lineColor: '#333'
						}
					}
				},
				legend: {
					itemStyle: {
						color: '#<?php echo $graphColor?>'
					},
					itemHoverStyle: {
						color: '#<?php echo $color_schemes[$design2]['500']?>'
					},
					itemHiddenStyle: {
						color: '#999999'
					},
				},
				credits: {
					style: {
						color: '#666'
					},
					text: '<?php echo $pageName." @ Meteotemplate"?>',
					href: '<?php echo $pageURL.$path?>'
				},
				labels: {
					style: {
						color: '#707073'
					}
				},
			};

			// Apply the theme
			Highcharts.setOptions(Highcharts.theme);
		</script>
		<script>
			$("#parameterSelectorInteractiveGraph").change(function(){
				param = $("#parameterSelectorInteractiveGraph").val();
				parameterSetInteractiveGraph(param);
				if(param=="B"){
					$("#groupingSelectorInteractiveGraph").val("all");
					$("#groupingSelectorInteractiveGraph").hide();
				}
				else{
					$("#groupingSelectorInteractiveGraph").show();
				}
			})
			$("#groupingSelectorInteractiveGraph").change(function(){
				param = $("#groupingSelectorInteractiveGraph").val();
				valueSetInteractiveGraph(param);
			})
			$("#intervalSelectorInteractiveGraph").change(function(){
				param = $("#intervalSelectorInteractiveGraph").val();
				intervalSetInteractiveGraph(param);
			})
			function parameterSetInteractiveGraph(x){
				$("#chosenParameterInteractiveGraph").val(x);
				graphInteractiveGraph();
			}
			function valueSetInteractiveGraph(x){
				$("#chosenValueInteractiveGraph").val(x);
				graphInteractiveGraph();
			}
			function intervalSetInteractiveGraph(x){
				$("#chosenIntervalInteractiveGraph").val(x);
				graphInteractiveGraph();
			}
			function graphInteractiveGraph() {
				$('#spinnerInteractiveGraph').show();
				// Global graph options
				Highcharts.setOptions({
					global: {
						useUTC: true, 
						timezoneOffset: <?php echo $offset?>
					},
					lang: {
						months: ['<?php echo lang('january','c')?>', '<?php echo lang('february','c')?>', '<?php echo lang('march','c')?>', '<?php echo lang('april','c')?>', '<?php echo lang('may','c')?>', '<?php echo lang('june','c')?>', '<?php echo lang('july','c')?>', '<?php echo lang('august','c')?>', '<?php echo lang('september','c')?>', '<?php echo lang('october','c')?>', '<?php echo lang('november','c')?>', '<?php echo lang('december','c')?>'],
						shortMonths: ['<?php echo lang('janAbbr','c')?>', '<?php echo lang('febAbbr','c')?>', '<?php echo lang('marAbbr','c')?>', '<?php echo lang('aprAbbr','c')?>', '<?php echo lang('mayAbbr','c')?>', '<?php echo lang('junAbbr','c')?>', '<?php echo lang('julAbbr','c')?>', '<?php echo lang('augAbbr','c')?>', '<?php echo lang('sepAbbr','c')?>', '<?php echo lang('octAbbr','c')?>', '<?php echo lang('novAbbr','c')?>', '<?php echo lang('decAbbr','c')?>'],
						weekdays: ['<?php echo lang('sundayAbbr','c')?>', '<?php echo lang('mondayAbbr','c')?>', '<?php echo lang('tuesdayAbbr','c')?>', '<?php echo lang('wednesdayAbbr','c')?>', '<?php echo lang('thursdayAbbr','c')?>', '<?php echo lang('fridayAbbr','c')?>', '<?php echo lang('saturdayAbbr','c')?>'],
						resetZoom: ['<?php echo lang('default zoom','c')?>']
					}
				});
				// Individual graphs options based on parameter
				optionsT = {
					chart : {
						renderTo : 'graphInteractiveGraph',
						type : 'spline',
						zoomType: 'x',
						backgroundColor: null,
					},
					title: {
						text:  '<?php echo lang('temperature',"c") ?>',

					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang("temperature","c") ?>'
						},
						labels: {
							format: '{value} °<?php echo $displayTempUnits ?>'
						},
						<?php
							if($showFreezing){
						?>
							plotLines: [{
								<?php
									if($showFreezingColor=="default"){
								?>
									color: "#<?php echo $graphColor?>",
								<?php
									}
									else{
								?>
									color: "<?php echo $showFreezingColor?>",
								<?php
									}
								?>
				                width: 2,
								dashStyle: 'Dot',
								<?php
									if($displayTempUnits=="C"){
										echo "value: 0";
									}
									else{
										echo "value: 32";
									}
				                ?>
							}]
						<?php
							}
						?>
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					tooltip: {
						shared: true
					},
					series: [
						{
							name: '',
							data: [],
							<?php
								if($tColor=="default"){
							?>
								color: "#<?php echo $graphColor?>"
							<?php
								}
								else{
							?>
								color: "<?php echo $tColor?>"
							<?php
								}
							?>

						},
						{
							name: '',
							data: [],
							<?php
								if($aColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $aColor?>",
							<?php
								}
							?>
							dashStyle: 'ShortDot'
						},
						{
							type: 'areasplinerange',
							name: '<?php echo lang('range','c')?>',
							<?php
								if($tColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $tColor?>",
							<?php
								}
							?>
							data: []
						}
					]
				};
				optionsH = {
					chart : {
						renderTo : 'graphInteractiveGraph',
						type : 'spline',
						zoomType: 'x'
					},
					title: {
						text:  '<?php echo lang('humidity','c') ?>'
					},
					legend: {
						enabled: false
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('humidity','c') ?>'
						},
						labels: {
							format: '{value} %'
						},
						max: 100
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					series: [
						{
							name: '<?php echo lang('humidity','c') ?>',
							data: [],
							<?php
								if($hColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $hColor?>",
							<?php
								}
							?>
						},
						{
							type: 'areasplinerange',
							name: '<?php echo lang('range','c')?>',
							<?php
								if($tColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $tColor?>",
							<?php
								}
							?>
							data: []
						}
					]
				};
				optionsD = {
					chart : {
						renderTo : 'graphInteractiveGraph',
						type : 'spline',
						zoomType: 'x'
					},
					title: {
						text:  '<?php echo lang('dew point','c') ?>'
					},
					legend: {
						enabled: false
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('dew point','c') ?>'
						},
						labels: {
							format: '{value} <?php echo unitFormatter($displayTempUnits)?>'
						},
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					series: [
						{
							name: '<?php echo lang('dew point','c') ?>',
							data: [],
							<?php
								if($tColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $tColor?>",
							<?php
								}
							?>
						},
						{
							type: 'areasplinerange',
							name: '<?php echo lang('range','c')?>',
							<?php
								if($tColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $tColor?>",
							<?php
								}
							?>
							data: []
						}
					]
				};
				optionsP = {
					chart : {
						renderTo : 'graphInteractiveGraph',
						type : 'spline',
						zoomType: 'x'
					},
					title: {
								text:  '<?php echo lang('pressure','c') ?>'
					},
					legend: {
								enabled: false
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('pressure','c') ?>'
						},
						labels: {
							format: '{value} <?php echo $displayPressUnits ?>'
						}
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					series: [
						{
							name: '<?php echo lang('pressure','c') ?>',
							data: [],
							<?php
								if($pColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $pColor?>",
							<?php
								}
							?>
						},
						{
							type: 'areasplinerange',
							name: '<?php echo lang('range','c')?>',
							<?php
								if($pColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $pColor?>",
							<?php
								}
							?>
							data: []
						}
					]
				};
				optionsS = {
					chart : {
						renderTo : 'graphInteractiveGraph',
						type : 'spline',
						zoomType: 'x'
					},
					title: {
						text:  '<?php echo lang('solar radiation','c') ?>'
					},
					legend: {
						enabled: false
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('solar radiation','c') ?>'
						},
						labels: {
							format: '{value} W/m2'
						},
						min: 0
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					series: [
						{
							name: '<?php echo lang('solar radiation','c') ?>',
							data: [],
							<?php
								if($sColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $sColor?>",
							<?php
								}
							?>
						},
						{
							type: 'areasplinerange',
							name: '<?php echo lang('range','c')?>',
							<?php
								if($sColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $sColor?>",
							<?php
								}
							?>
							data: []
						}
					]
				};

				optionsW = {
					chart : {
						renderTo : 'graphInteractiveGraph',
						type : 'spline',
						zoomType: 'x'
					},
					title: {
								text:  '<?php echo lang('wind','c') ?>'
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('wind','c') ?>'
						},
						labels: {
							format: '{value} <?php echo $displayWindUnits ?>'
						},
						min: 0
					},
					tooltip: {
						shared: true
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					series: [
						{
							name: '',
							data: [],
							<?php
								if($wColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $wColor?>",
							<?php
								}
							?>
						},
						{
							name: '',
							data: [],
							<?php
								if($gColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $gColor?>",
							<?php
								}
							?>
							dashStyle: 'ShortDot'
						}
					]
				};

				optionsR = {
				   chart : {
						renderTo : 'graphInteractiveGraph',
						type : 'area',
						zoomType: 'x'
					},
					title: {
								text:  '<?php echo lang('cumulative daily precipitation','c') ?>'
					},
					legend: {
								enabled: false
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						}
					},
					yAxis: {
						title: {
							text: '<?php echo lang('precipitation','c') ?>'
						},
						labels: {
							format: '{value} <?php echo $displayRainUnits ?>'
						},
						min: 0
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: false
							}
						},
						area: {
							fillOpacity: 0.3
						}
					},
					series: [{
						name: '<?php echo lang('precipitation','c') ?>',
						<?php
								if($rColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $rColor?>",
							<?php
								}
							?>
						data: []
				   }]
				};
				optionsB = {
					chart : {
						renderTo : 'graphInteractiveGraph',
						type : 'spline',
						zoomType: 'x'
					},
					title: {
						text:  '<?php echo lang('bearing','c') ?>'
					},
					legend: {
						enabled: false
					},
					xAxis: {
						type: 'datetime',
						title: {
							text: null
						},
						dateTimeLabelFormats: {
							millisecond: '%H:%M:%S.%L',
							second: '%H:%M:%S',
							minute: '%H:%M',
							hour: '<?php echo $graphTimeFormat ?>',
							day: '<?php echo $graphDateFormat ?>',
							week: '<?php echo $graphDateFormat ?>',
							month: '%b / %y',
							year: '%Y'
						},
						
					},
					yAxis: {
						title: {
							text: '<?php echo lang('bearing','c') ?>'
						},
						labels: {
							format: '{value}°'
						},
						min: 0,
						max: 360,
						endOnTick: false,
						tickInterval: 40
					},
					plotOptions: {
						series: {
							animation: {
								duration: 3000
							},
							marker: {
								enabled: true
							}
						},
						areasplinerange:{
							fillOpacity: 0.5
						}
					},
					series: [
						{
							name: '<?php echo lang('dew point','c') ?>',
							data: [],
							lineWidth: 0,
							<?php
								if($tColor=="default"){
							?>
								color: "#<?php echo $graphColor?>",
							<?php
								}
								else{
							?>
								color: "<?php echo $tColor?>",
							<?php
								}
							?>
						}
					]
				};
				// get selected parameters
				parameter = $("#chosenParameterInteractiveGraph").val();
				value = $("#chosenValueInteractiveGraph").val();
				interval = $("#chosenIntervalInteractiveGraph").val();
				$('#spinnerInteractiveGraph').show();
				// get data based on user selection
				if(parameter=="T"){
					$.ajax({
						url : "homepage/blocks/interactiveGraph/graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval,
						dataType : 'json',
						success : function (json) {
							$("#graphInteractiveGraph").html("");
							optionsT.series[0].name = json['name1'];
							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryT = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryT];
								rowDate.push(value);
							}
							optionsT.series[0].data = rowDate;

							optionsT.series[1].name = json['name2'];
							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryT = eval(json['data2'][i][1]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryT];
								rowDate.push(value);
							}
							optionsT.series[1].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data3'].length; i++){
								temporaryT = eval(json['data3'][i][1]);
								temporaryT2 = eval(json['data3'][i][2]);
								temporaryDate = json['data3'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryT,temporaryT2];
								rowDate.push(value);
							}
							optionsT.series[2].data = rowDate;

							chart = new Highcharts.Chart(optionsT);
							$('#spinnerInteractiveGraph').hide();
						}
					});
				}
				if(parameter=="H"){
					$.ajax({
						url : "homepage/blocks/interactiveGraph/graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval,
						dataType : 'json',
						success : function (json) {
							$("#graphInteractiveGraph").html("");
							optionsH.series[0].name = json['name1'];
							optionsH.series[1].name = json['name2'];

							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryH = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryH];
								rowDate.push(value);
							}
							optionsH.series[0].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryH = eval(json['data2'][i][1]);
								temporaryH2 = eval(json['data2'][i][2]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryH,temporaryH2];
								rowDate.push(value);
							}
							optionsH.series[1].data = rowDate;

							chartH = new Highcharts.Chart(optionsH);
							$('#spinnerInteractiveGraph').hide();
						}
					});
				}
				if(parameter=="D"){
					$.ajax({
						url : "homepage/blocks/interactiveGraph/graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval,
						dataType : 'json',
						success : function (json) {
							$("#graphInteractiveGraph").html("");

							optionsD.series[0].name = json['name1'];
							optionsD.series[1].name = json['name2'];

							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryD = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryD];
								rowDate.push(value);
							}
							optionsD.series[0].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryD = eval(json['data2'][i][1]);
								temporaryD2 = eval(json['data2'][i][2]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryD,temporaryD2];
								rowDate.push(value);
							}
							optionsD.series[1].data = rowDate;

							chartD = new Highcharts.Chart(optionsD);
							$('#spinnerInteractiveGraph').hide();
						}
					});
				}
				if(parameter=="P"){
					$.ajax({
						url : "homepage/blocks/interactiveGraph/graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval,
						dataType : 'json',
						success : function (json) {
							$("#graphInteractiveGraph").html("");

							optionsP.series[0].name = json['name1'];
							optionsP.series[1].name = json['name2'];

							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryP = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryP];
								rowDate.push(value);
							}
							optionsP.series[0].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryP = eval(json['data2'][i][1]);
								temporaryP2 = eval(json['data2'][i][2]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryP,temporaryP2];
								rowDate.push(value);
							}
							optionsP.series[1].data = rowDate;

							chartP = new Highcharts.Chart(optionsP);
							$('#spinnerInteractiveGraph').hide();
						}
					});
				}
				if(parameter=="S"){
					$.ajax({
						url : "homepage/blocks/interactiveGraph/graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval,
						dataType : 'json',
						success : function (json) {
							$("#graphInteractiveGraph").html("");

							optionsS.series[0].name = json['name1'];
							optionsS.series[1].name = json['name2'];

							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryS = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryS];
								rowDate.push(value);
							}
							optionsS.series[0].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryS = eval(json['data2'][i][1]);
								temporaryS2 = eval(json['data2'][i][2]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryS,temporaryS2];
								rowDate.push(value);
							}
							optionsS.series[1].data = rowDate;

							chartS = new Highcharts.Chart(optionsS);
							$('#spinnerInteractiveGraph').hide();
						}
					});
				}
				if(parameter=="R"){
					$.ajax({
						url : "homepage/blocks/interactiveGraph/graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval,
						dataType : 'json',
						success : function (json) {
							$("#graphInteractiveGraph").html("");

							rowDate = new Array();
							for(i=0; i < json['data'].length; i++){
								temporaryR = eval(json['data'][i][1]);
								temporaryDate = json['data'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryR];
								rowDate.push(value);
							}
							optionsR.series[0].data = rowDate;
							chartR = new Highcharts.Chart(optionsR);
							$('#spinnerInteractiveGraph').hide();
						}
					});
				}
				if(parameter=="W"){
					$.ajax({
						url : "homepage/blocks/interactiveGraph/graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval,
						dataType : 'json',
						success : function (json) {
							$("#graphInteractiveGraph").html("");

							optionsW.series[0].name = json['name1'];
							optionsW.series[1].name = json['name2'];

							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryW = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryW];
								rowDate.push(value);
							}
							optionsW.series[0].data = rowDate;

							rowDate = new Array();
							for(i=0; i < json['data2'].length; i++){
								temporaryG = eval(json['data2'][i][1]);
								temporaryDate = json['data2'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryG];
								rowDate.push(value);
							}
							optionsW.series[1].data = rowDate;

							chartW = new Highcharts.Chart(optionsW);
							$('#spinnerInteractiveGraph').hide();
						}
					});
				}
				if(parameter=="B"){
					$.ajax({
						url : "homepage/blocks/interactiveGraph/graphAjax.php?parameter="+parameter+"&value="+value+"&interval="+interval,
						dataType : 'json',
						success : function (json) {
							$("#graphInteractiveGraph").html("");

							optionsB.series[0].name = json['name1'];

							rowDate = new Array();
							for(i=0; i < json['data1'].length; i++){
								temporaryW = eval(json['data1'][i][1]);
								temporaryDate = json['data1'][i][0];
								year = temporaryDate[0];
								month = eval(temporaryDate[1]-1);
								day = temporaryDate[2];
								hour = temporaryDate[3];
								minute = temporaryDate[4];
								datum = Date.UTC(year, month, day, hour, minute);
								value = [datum,temporaryW];
								rowDate.push(value);
							}
							optionsB.series[0].data = rowDate;

							chartB = new Highcharts.Chart(optionsB);
							$('#spinnerInteractiveGraph').hide();
						}
					});
				}
			}
			$(document).ready(function() {
				$('#spinnerInteractiveGraph').hide();
				graphInteractiveGraph();
			});
		</script>
		
		
