<?php

	# 		Language Switcher
	# 		Namespace:		langSwitch
	#		Meteotemplate Block

	# 		v1.0 - Oct 26, 2017
	# 			- initial release
	
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "<span style='color:#".$graphColor."'>Please go to your admin section and go through the settings for this block first.</span>";
		die();
	}

	$showLangs = explode(",",$showLangs);
	$showLangs = array_map("trim", $showLangs);
	$showLangs = array_map("strtolower", $showLangs);

	
?>
	<style>
		.langSwitcherFlag{
			width: <?php echo $flagSize?>px;
			opacity: 0.8;
			cursor: pointer;
		}
		.langSwitcherFlag:hover{
			opacity: 1;
		}
	</style>
	<?php 
		if($showTitle){
	?>
			<h2><?php echo lang('language','c')?></h2>
	<?php
		}
	?>
	<?php 
		foreach($showLangs as $thisLang){
	?>
			<img data-id="<?php echo $thisLang?>" src="<?php echo $pageURL.$path."imgs/".$flagIconShape."/big/".$thisLang.".png"?>" class="langSwitcherFlag">
	<?php 
		}
	?>

	
	<script>
		$(".langSwitcherFlag").click(function(){
			lang = $(this).attr("data-id");
			switchLang(lang);
		})
		function switchLang(lang){
			$.ajax({
					url : "homepage/blocks/langSwitch/switch.php?lang=" + lang,
					success : function (x) {
						location = "<?php echo $pageURL.$path."index.php"?>";
					}
			});
		}
	</script>
	
