<?php

	# 		Lightning
	# 		Namespace:		lightning
	#		Meteotemplate Block
	
	# 		v2.0 - Jul 11, 2016
	#	  		- zoom on click
	#			- bug fixes
	# 		v3.0 - Mar 10, 2017
	#	  		- added regional maps
	# 		v3.1 - Mar 18, 2017
	#	  		- added possibility to add heading
	# 		v3.2 - Apr 21, 2017
	#	  		- minor tweaks
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");
	include("../../../css/design.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}
	
	if($defaultZone=="world"){
		$defaultZone = "earth";
	}
	if($defaultZone=="europe"){
		$defaultZone = "eu";
	}
	if($defaultZone=="south_america"){
		$defaultZone = "sa";
	}
	if($defaultZone=="north_america"){
		$defaultZone = "us";
	}
	if($defaultZone=="asia"){
		$defaultZone = "as";
	}
	if($defaultZone=="australia"){
		$defaultZone = "oc";
	}
	if($defaultZone=="africa"){
		$defaultZone = "af";
	}
	if($defaultZone=="cz"){ // LOL
		$defaultZone = "de";
	}
?>
	<style>
		.lightningImageCSS{
			width:95%;
			margin:0 auto;
			border-radius:10px;
			border: 1px solid #<?php echo $color_schemes[$design]['500']?>;
			margin-bottom: 10px;
			cursor: pointer;
			opacity: 0.85;
		}
		.lightningImageCSS:hover{
			opacity:1;
		}
		.lightningSelectorIcons{
			height:30px;
			padding:10px;
			opacity: 0.8;
			cursor: pointer;
		}
		.lightningSelectorIcons:hover{
			opacity:1;
		}
	</style>
	<div style="width:98%;margin:0 auto;text-align:center">
		<img src="homepage/blocks/lightning/icons/<?php echo $theme?>/lightning.png" style="width:40px">
		<?php
			if($lightningHeading){
		?>
				<h2><?php echo lang('lightning','c')?></h2>
		<?php
			}
		?>
	</div>
	<div style="width:98%;text-align:center">
		<img src="homepage/blocks/lightning/icons/<?php echo $theme?>/europe.png" class="lightningSelectorIcons" id="lightningEUselect">
		<img src="homepage/blocks/lightning/icons/<?php echo $theme?>/namerica.png" class="lightningSelectorIcons" id="lightningNAselect">
		<img src="homepage/blocks/lightning/icons/<?php echo $theme?>/australia.png" class="lightningSelectorIcons" id="lightningAUselect">
		<img src="homepage/blocks/lightning/icons/<?php echo $theme?>/world.png" class="lightningSelectorIcons" id="lightningEarthselect">
		<img src="homepage/blocks/lightning/icons/<?php echo $theme?>/asia.png" class="lightningSelectorIcons" id="lightningASselect">
		<img src="homepage/blocks/lightning/icons/<?php echo $theme?>/africa.png" class="lightningSelectorIcons" id="lightningAFselect">
		<img src="homepage/blocks/lightning/icons/<?php echo $theme?>/samerica.png" class="lightningSelectorIcons" id="lightningSAselect">
	</div>
	<input type="hidden" id="locationLightning" value="<?php echo $defaultZone?>">
	<img id="lightningDiv" src="https://www.blitzortung.org/Images/image_b_<?php echo $defaultZone?>.png" class="lightningImageCSS tooltip" alt='' title="" onclick="zoomLightningBlock()">
	<br>
	<select class="button2" id="lightningDetailSelector">
		<option value='' selected>--<?php echo lang('select area','c')?>--</option>
		<optgroup label="<?php echo lang("Europe",'c')?>">
			<option value='uk'><?php echo lang("United Kingdom",'w')?></option>
			<option value='sk'><?php echo lang("scandinavia",'w')?></option>
			<option value='fr'><?php echo lang("southwest europe",'w')?></option>
			<option value='gr'><?php echo lang("southeast europe",'w')?></option>
			<option value='de'><?php echo lang("central europe",'w')?></option>
			<option value='pl'><?php echo lang("eastern europe",'w')?></option>
		</optgroup>
		<optgroup label="<?php echo lang("North America",'c')?>">
			<option value='tx'>Texas</option>
			<option value='fl'>Florida</option>
			<option value='ny'>New York</option>
			<option value='mn'>Minnesota</option>
			<option value='ca'>California</option>
			<option value='dr'><?php echo lang("Dominican Republic",'w')?></option>
		</optgroup>
		<optgroup label="<?php echo lang("Oceania",'c')?>">
			<option value='nz'><?php echo lang("New Zealand",'w')?></option>
			<option value='nsw'>New South Wales</option>
		</optgroup>
		<optgroup label="<?php echo lang("Africa",'c')?>">
			<option value='za'><?php echo lang("South Africa",'c')?></option>
		</optgroup>
		<optgroup label="<?php echo lang("Asia",'c')?>">
			<option value='jp'><?php echo lang("Japan",'c')?></option>
		</optgroup>
	</select>
	<div style="width:90%;margin:0 auto;font-size:0.8em;font-variant:small-caps;text-align:center">
		<?php echo lang('source','c')?>: blitzortung.org
	</div>
	<div id="lightningWindow"></div>
	<script>
		$("#lightningDetailSelector").change(function(){
			locationSelected = $("#lightningDetailSelector").val();
			if(locationSelected==""){
				return false;
			}
			data = "https://www.blitzortung.org/Images/image_b_"+ locationSelected +".png?"+new Date;
			$('#lightningDiv').attr('src', data);
			$("#locationLightning").val(locationSelected);
		})
		$("#lightningEUselect").click(function(){
			$("#locationLightning").val("eu");
			locationSelected = $("#locationLightning").val();
			data = "https://www.blitzortung.org/Images/image_b_"+ locationSelected +".png?"+new Date;
			$('#lightningDiv').attr('src', data);
		});
		$("#lightningEarthselect").click(function(){
			$("#locationLightning").val("earth");
			locationSelected = $("#locationLightning").val();
			data = "https://www.blitzortung.org/Images/image_b_"+ locationSelected +".png?"+new Date;
			$('#lightningDiv').attr('src', data);
		});
		$("#lightningNAselect").click(function(){
			$("#locationLightning").val("us");
			locationSelected = $("#locationLightning").val();
			data = "https://www.blitzortung.org/Images/image_b_"+ locationSelected +".png?"+new Date;
			$('#lightningDiv').attr('src', data);
		});
		$("#lightningASselect").click(function(){
			$("#locationLightning").val("as");
			locationSelected = $("#locationLightning").val();
			data = "https://www.blitzortung.org/Images/image_b_"+ locationSelected +".png?"+new Date;
			$('#lightningDiv').attr('src', data);
		});
		$("#lightningAFselect").click(function(){
			$("#locationLightning").val("af");
			locationSelected = $("#locationLightning").val();
			data = "https://www.blitzortung.org/Images/image_b_"+ locationSelected +".png?"+new Date;
			$('#lightningDiv').attr('src', data);
		});
		$("#lightningSAselect").click(function(){
			$("#locationLightning").val("sa");
			locationSelected = $("#locationLightning").val();
			data = "https://www.blitzortung.org/Images/image_b_"+ locationSelected +".png?"+new Date;
			$('#lightningDiv').attr('src', data);
		});
		$("#lightningAUselect").click(function(){
			$("#locationLightning").val("oc");
			locationSelected = $("#locationLightning").val();
			data = "https://www.blitzortung.org/Images/image_b_"+ locationSelected +".png?"+new Date;
			$('#lightningDiv').attr('src', data);
		});
		setInterval(function(){ lightningImageUpdater(); }, (<?php echo $refreshInterval?>*1000));
		function lightningImageUpdater(){
			locationSelected = $("#locationLightning").val();
			data = "https://www.blitzortung.org/Images/image_b_"+ locationSelected +".png?"+new Date;
			$('#lightningDiv').attr('src', data);
		}
	</script>
	<script>
		function zoomLightningBlock(){
			locationSelected = $("#locationLightning").val();
			data = "https://www.blitzortung.org/Images/image_b_"+ locationSelected +".png?"+new Date;
			$("#lightningWindow").html("<div style='width:98%;margin:0 auto;text-align:center'><img src='"+data+"' style='width:100%'></div>");
			$("#lightningWindow").dialog('open');		
		}
		dialogHeight = screen.height*0.8;
		dialogWidth = screen.width*0.8;
		$("#lightningWindow").dialog({
			modal: true,
			autoOpen: false,
			height: dialogHeight,
			width: dialogWidth
		});
	</script>