<?php
	# 		Location block
	# 		Namespace:		location
	#		Meteotemplate Block
	
	# 		Version 1.1 - Jan 29, 2016
	#		- added responsiveness
	#		- bug fixes
	
	include("settings.php");
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
		
	include("../../../config.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

?>
	<style>
		.locationsIcon{
			max-width: 30px;
			width: 100%;
		}
	</style>
	<table style="width:98%;margin:0 auto">
		<tr>
			<td style="width:33%">
				<img src="homepage/blocks/location/icons/<?php echo $theme?>/lat.png" class="locationsIcon tooltip" alt=''  title="<?php echo lang('latitude','c')?>">
			</td>
			<td style="width:33%">
				<img src="homepage/blocks/location/icons/<?php echo $theme?>/lon.png" class="locationsIcon tooltip" alt='' title="<?php echo lang('longitude','c')?>">
			</td>
			<td style="width:33%">
				<img src="homepage/blocks/location/icons/<?php echo $theme?>/elevation.png" class="locationsIcon tooltip" alt='' title="<?php echo lang('elevation','c')?>">
			</td>
		</tr>
		<tr>
			<td style="width:33%">
				<?php 
					echo number_format(abs($stationLat),2,".",""." ");
					if ($stationLat > 0) {
						echo lang('coordN','u');
					} 
					else {
						echo lang('coordS','u');
					}
				?>
			</td>
			<td style="width:33%">
				<?php 
					echo number_format(abs($stationLon),2,".",""." ");
					if ($stationLon > 0) {
						echo lang('coordE','u');
					} 
					else {
						echo lang('coordW','u');
					}
				?>
			</td>
			<td style="width:33%">
				<?php echo $stationElevation." ".$elevationUnits?>
			</td>
		</tr>
	</table>
	<a href="#" id="stationMap" data-latlng="<?php echo $stationLat?>,<?php echo $stationLon?>"><?php echo lang('map','c')?></a>
	<script src="homepage/blocks/location/scripts/mapit.js"></script>
	<script>
		$('#stationMap').mapit({
		  mapOptions: {
			zoom: <?php echo $mapZoom?>, 
			mapType: '<?php echo $mapType?>',
		  },
		});	
	</script>