<?php

	# 		Lunar eclipses block
	# 		Namespace:		lunarEclipses
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	# 		v2.0 - Mar 19, 2017
	# 			- option to show block title
	# 			- CSS tweaks
	
	include("settings.php");
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$lunarEclipses = array();
	if(file_exists("files/lunarEclipses.txt")){
		$lunarsFile = fopen("files/lunarEclipses.txt", "r");
		while(!feof($lunarsFile)) {
			$lunarArray = array();
			$lunarRaw = explode(";",fgets($lunarsFile));
			$lunarArray['date'] = strtotime($lunarRaw[1]."/".$lunarRaw[2]."/".$lunarRaw[3]." ".$lunarRaw[4]);
			$lunarType = $lunarRaw[8];
				if($lunarType=="T"){
					$lunarArray['type'] = lang("Total",'c');
				}
				if($lunarType=="P"){
					$lunarArray['type'] = lang("Partial",'c');
				}
				if($lunarType=="N"){
					$lunarArray['type'] = lang("Penumbral",'c');
				}
				if($lunarType=="Tm"){
					$lunarArray['type'] = lang("Total<br><span style='font-size:0.8em'>middle eclipse of Saros series</span>",'c');
				}
				if($lunarType=="Pm"){
					$lunarArray['type'] = lang("Partial<br><span style='font-size:0.8em'>middle eclipse of Saros series</span>",'c');
				}
				if($lunarType=="Nm"){
					$lunarArray['type'] = lang("Penumbral<br><span style='font-size:0.8em'>middle eclipse of Saros series</span>",'c');
				}
				if($lunarType=="T+"){
					$lunarArray['type'] = lang("Total<br><span style='font-size:0.8em'>central total eclipse<br>Moon's center passes north of shadow axis</span>",'c');
				}
				if($lunarType=="T-"){
					$lunarArray['type'] = lang("Total<br><span style='font-size:0.8em'>central total eclipse<br>Moon's center passes south of shadow axis</span>",'c');
				}
				if($lunarType=="Tx"){
					$lunarArray['type'] = lang("Total<br><span style='font-size:0.8em'>total penumbral lunar eclipse</span>",'c');
				}
				if($lunarType=="Nb"){
					$lunarArray['type'] = lang("Penumbral<br><span style='font-size:0.8em'>first penumbral eclipse in series</span>",'c');
				}
				if($lunarType=="Ne"){
					$lunarArray['type'] = lang("Penumbral<br><span style='font-size:0.8em'>last penumbral eclipse in series</span>",'c');
				}
			$lunarArray['penPhaseLength'] = $lunarRaw[12];
			$lunarArray['parPhaseLength'] = $lunarRaw[13];
			$lunarArray['totalPhaseLength'] = $lunarRaw[14];
			
			// lunar image link
			$yearDown = floor($lunarRaw[1]/100)*100+1;
			if($lunarRaw[1]<$yearDown){
				$yearDown = $yearDown - 100;
			}
			$yearUp = $yearDown + 99;
			if($lunarRaw[2]<10){
				$monthZero = "0".$lunarRaw[2];
			}
			else{
				$monthZero = $lunarRaw[2];
			}
			if($lunarRaw[3]<10){
				$dayZero = "0".$lunarRaw[3];
			}
			else{
				$dayZero = $lunarRaw[3];
			}
			$lunarArray['imgLink'] = "http://eclipse.gsfc.nasa.gov/5MCLEmap/".formatYear($yearDown)."-".formatYear($yearUp)."/LE".$lunarRaw[1]."-".$monthZero."-".$dayZero.$lunarRaw[8][0].".gif";
			
			if($lunarArray['date']>=time()){
				$lunarEclipses[] = $lunarArray;
			}
			if(date("Ymd",$lunarArray['date']) == date("Ymd")){ // check if it is today
				$lunarToday = $lunarArray;
			}	
		}
		fclose($lunarsFile);
	}
	function formatYear($value){
		if($value>=0){
			$result = sprintf('%04d', $value);
		}
		else{
			$result = "-".sprintf('%04d', abs($value));
		}
		return $result;
	}
	$output['lunarEclipses'] = $lunarEclipses;
?>
	<div style="width:98%;margin:0 auto;text-align:center">
		<img src="homepage/blocks/lunarEclipses/icons/<?php echo $theme?>/lunar.png" style="width:40px">
		<?php
			if($lunarEclipsesHeading){
		?>
				<h2><?php echo lang('lunar eclipses','c')?></h2>
		<?php
			}
		?>
	</div>
	<table style="width:98%;margin:0 auto">
		<tr>
			<td style="text-align:left;padding-left: 15px;width:50%">
				<?php echo date($dateTimeFormat,$output['lunarEclipses'][0]['date'])?>
			</td>
			<td>
				<span style="font-variant:small-caps;font-weight:bold;font-size:1.1em"><?php echo $output['lunarEclipses'][0]['type']?></span>
			</td>
		</tr>
	</table>
	<div class="details" id="lunarDetails">
		<table style="width:98%;margin:0 auto">
			<?php 
				for($i=1;$i<=$upcomingLunar;$i++){
			?>
					<tr>
						<td style="text-align:left;padding-left:3%;max-width:50%;width:100%">
							<?php echo date($dateTimeFormat,$output['lunarEclipses'][$i]['date'])?>
						</td>
						<td>
							<span style="font-variant:small-caps;font-weight:bold;font-size:1.1em">
								<?php echo $output['lunarEclipses'][$i]['type']?>
							</span>
						</td>
					</tr>
			<?php
				}
			?>
		</table>
	</div>
	<span class="more" onclick="txt = $('#lunarDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#lunarDetails').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>