<?php

	# 		Google Map
	# 		Namespace:		map
	#		Meteotemplate Block
	
	include("settings.php");
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
?>
	<script src="homepage/blocks/map/scripts/styles.js"></script>
	<style>
		#mapBlockDiv{
			width: 98%;
			height: <?php echo $mapHeight?>px;
			margin: 20px auto;
			border: 2px solid white;
			border-radius: 10px;
		}
	</style>
	<div id="mapBlockDiv"></div>
	<select id="mapStyleSelector" class="button2" style="width:100%;max-width:100px">
		<option value="dark">Dark</option>
		<option value="grayscale">Greyscale</option>
		<option value="blueWater">Blue Water</option>
		<option value="pale">Pale</option>
		<option value="midnight">Midnight</option>
		<option value="retro">Retro</option>
		<option value="monochrome">Monochrome</option>
		<option value="bw">Black/White</option>
		<option value="darkGrey">Dark grey</option>
		<option value="green">Green</option>
		<option value="bwSimple">Simple black/white</option>
		<option value="bwShapes">Black/white - shapes</option>
		<option value="icy">Icy</option>
		<option value="minimalistic">Minimal</option>
		<option value="natural">Natural</option>
		<option value="red">Red</option>
		<option value="brightGreen">Bright green</option>
		<option value="orangeRed">Orange red</option>
		<option value="greenHighlight">Green highlight</option>
		<option value="simpleLabel">Simple labels</option>
		<option value="aqua">Aqua</option>
		<option value="retroGold">Retro gold</option>
		<option value="rainbow">Rainbow</option>
		<option value="vintage">Vintage</option>
		<option value="pink">Pink</option>
		<option value="simpleBlue">Simple blue</option>
		<option value="hardEdge">Hard Edge</option>
		<option value="highlightDark">Dark highlight</option>
		<option value="brown">Brown</option>
		<option value="colorblindFriendly">Colorblind friendly</option>
		<option value="lightGrey">Light grey</option>
		<option value="darkWater">Dark water</option>
		<option value="vintageYellow">Vintage Yellow</option>
	</select>
	<select id="markerStyleSelector" class="button2" style="width:100%;max-width:100px">
		<option value="<?php echo $stationType?>" selected>Station</option>
		<option value="black">Black</option>
		<option value="white">White</option>
		<option value="red">Red</option>
		<option value="blue">Blue</option>
		<option value="green">Green</option>
		<option value="orange">Orange</option>
		<option value="purple">Purple</option>
		<option value="grey">Grey</option>
		<option value="yellow">Yellow</option>
	</select>
	
	<script>
		function initialize() {
			var mapCanvas = document.getElementById('mapBlockDiv');
			var mapOptions = {
				center: new google.maps.LatLng(<?php echo $stationLat?>, <?php echo $stationLon?>),
				zoom: <?php echo $defaultZoom?>,
				mapTypeId: google.maps.MapTypeId.ROADMAP,
				styles: mapStyleArray.<?php echo $mapDefaultTheme?>
			}
			var map = new google.maps.Map(mapCanvas, mapOptions);
			var marker = new google.maps.Marker({
			  position: new google.maps.LatLng(<?php echo $stationLat?>, <?php echo $stationLon?>),
			  map: map,
			  icon: 'homepage/blocks/map/icons/<?php echo $stationType?>.png'
			});
			$("#mapStyleSelector").change(function(){
				newStyle = $("#mapStyleSelector").val();
				newStyleValues = mapStyleArray[newStyle];
				map.setOptions({styles:newStyleValues});
			});
			$("#markerStyleSelector").change(function(){
				newIcon = $("#markerStyleSelector").val();
				url = 'homepage/blocks/map/icons/'+newIcon+'.png';
				marker.setOptions({icon:url});
			});
		}
		$(document).ready(function(){
			initialize();
		})
		$("#mapStyleSelector").val('<?php echo $mapDefaultTheme?>');
		
	</script>
